/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.layout.editor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.xissweb.data.layout.LocalIndexStandardInfo;
import org.xissweb.gui.XissWebUI;
import org.xissweb.gui.editor.DocumentException;
import org.xissweb.gui.editor.number.IntegerValueChecker;
import org.xissweb.gui.layout.LayoutEditor;
import org.xissweb.gui.layout.editor.AbstractLayoutElementEditor;
import org.xissweb.i18n.TextDisplayManager;

public class LocalIndexStandardEditor
extends AbstractLayoutElementEditor {
    private static final long serialVersionUID = -871604422123479812L;
    private static final String helpTag = "standardindex";
    private LocalIndexStandardInfo localIndexInfo;
    private boolean onWidthError;
    private boolean onHeightError;
    private JLabel widthLabel = null;
    private JTextField widthTextField = null;
    private JLabel heightLabel = null;
    private JTextField heightTextField = null;
    private JCheckBox displayDescription = null;
    private JCheckBox displayExplanation = null;
    private JLabel errorLabel = null;

    public LocalIndexStandardEditor(LayoutEditor mainEditor) {
        super(mainEditor);
        this.textDisplayer = TextDisplayManager.createTextDisplayFor(this.getClass());
        this.initialize();
    }

    private void initialize() {
        GridBagConstraints errorLabelConstraints = new GridBagConstraints();
        errorLabelConstraints.gridx = 1;
        errorLabelConstraints.gridy = 0;
        errorLabelConstraints.gridwidth = 3;
        errorLabelConstraints.anchor = 17;
        errorLabelConstraints.insets = new Insets(35, 0, 0, 0);
        this.errorLabel = new JLabel();
        this.errorLabel.setText("");
        this.errorLabel.setIcon(XissWebUI.getIcon("/images/common/error.png"));
        this.errorLabel.setVisible(false);
        GridBagConstraints displayExplanationConstraints = new GridBagConstraints();
        displayExplanationConstraints.gridx = 2;
        displayExplanationConstraints.gridy = 3;
        displayExplanationConstraints.gridwidth = 2;
        displayExplanationConstraints.anchor = 18;
        displayExplanationConstraints.insets = new Insets(7, 5, 7, 5);
        GridBagConstraints displayDescriptionConstraints = new GridBagConstraints();
        displayDescriptionConstraints.gridx = 0;
        displayDescriptionConstraints.gridy = 3;
        displayDescriptionConstraints.gridwidth = 2;
        displayDescriptionConstraints.weighty = 2000.0;
        displayDescriptionConstraints.insets = new Insets(7, 30, 7, 5);
        displayDescriptionConstraints.anchor = 18;
        GridBagConstraints heightTextFieldConstraints = new GridBagConstraints();
        heightTextFieldConstraints.fill = 0;
        heightTextFieldConstraints.gridx = 3;
        heightTextFieldConstraints.gridy = 1;
        heightTextFieldConstraints.weightx = 3.0;
        heightTextFieldConstraints.anchor = 17;
        heightTextFieldConstraints.insets = new Insets(5, 5, 5, 5);
        GridBagConstraints heightLabelConstraints = new GridBagConstraints();
        heightLabelConstraints.gridx = 2;
        heightLabelConstraints.gridy = 1;
        heightLabelConstraints.insets = new Insets(7, 5, 7, 5);
        heightLabelConstraints.anchor = 17;
        heightLabelConstraints.weightx = 0.0;
        this.heightLabel = new JLabel();
        this.heightLabel.setText("height.label");
        this.textDisplayer.register(this.heightLabel, "height.label");
        GridBagConstraints widthTextFieldConstraints = new GridBagConstraints();
        widthTextFieldConstraints.fill = 0;
        widthTextFieldConstraints.gridx = 1;
        widthTextFieldConstraints.gridy = 1;
        widthTextFieldConstraints.anchor = 17;
        widthTextFieldConstraints.insets = new Insets(5, 5, 5, 5);
        widthTextFieldConstraints.weightx = 1.0;
        GridBagConstraints widthLabelConstraints = new GridBagConstraints();
        widthLabelConstraints.gridx = 0;
        widthLabelConstraints.gridy = 1;
        widthLabelConstraints.insets = new Insets(7, 30, 7, 5);
        widthLabelConstraints.anchor = 17;
        this.widthLabel = new JLabel();
        this.widthLabel.setText("width.label");
        this.textDisplayer.register(this.widthLabel, "width.label");
        GridBagConstraints titleConstraints = new GridBagConstraints();
        titleConstraints.gridx = 0;
        titleConstraints.gridy = 0;
        titleConstraints.gridwidth = 4;
        titleConstraints.insets = new Insets(10, 0, 30, 0);
        titleConstraints.weighty = 1.0;
        this.addTitle(4, helpTag);
        this.add((Component)this.widthLabel, widthLabelConstraints);
        this.add((Component)this.getWidthTextField(), widthTextFieldConstraints);
        this.add((Component)this.heightLabel, heightLabelConstraints);
        this.add((Component)this.getHeightTextField(), heightTextFieldConstraints);
        this.add((Component)this.getDisplayDescription(), displayDescriptionConstraints);
        this.add((Component)this.getDisplayExplanation(), displayExplanationConstraints);
        this.add((Component)this.errorLabel, errorLabelConstraints);
    }

    protected void doSave() {
        this.localIndexInfo.setWidth(this.getWidthValue());
        this.localIndexInfo.setHeight(this.getHeightValue());
        this.localIndexInfo.setDisplayDescription(this.getDisplayDescriptionValue());
        this.localIndexInfo.setDisplayExplanation(this.getDisplayExplanationValue());
    }

    protected void initEdition() {
        this.getWidthTextField().setText(Integer.toString(this.localIndexInfo.getWidth()));
        this.getHeightTextField().setText(Integer.toString(this.localIndexInfo.getHeight()));
        this.getDisplayDescription().setSelected(this.localIndexInfo.isDisplayDescription());
        this.getDisplayExplanation().setSelected(this.localIndexInfo.isDisplayExplanation());
    }

    public void modified(boolean error) {
        if (!this.initializing && this.localIndexInfo != null) {
            if (!error) {
                boolean bl = this.isModified = this.localIndexInfo.getWidth() != this.getWidthValue() || this.localIndexInfo.getHeight() != this.getHeightValue() || this.localIndexInfo.isDisplayDescription() != this.getDisplayDescriptionValue() || this.localIndexInfo.isDisplayExplanation() != this.getDisplayExplanationValue();
                if (this.isModified) {
                    this.save();
                }
            }
            this.onError = error;
        }
    }

    void widthChanged() {
        String text = this.widthTextField.getText();
        int status = IntegerValueChecker.checkValue(text);
        if (status == -1 || status == 0 || status == 1) {
            this.errorLabel.setText(IntegerValueChecker.getMessage(status));
            this.errorLabel.setVisible(true);
            this.onWidthError = true;
            this.modified(true);
        } else {
            this.onWidthError = false;
            this.errorLabel.setVisible(this.onHeightError);
            this.modified(this.onHeightError);
        }
    }

    void heightChanged() {
        String text = this.heightTextField.getText();
        int status = IntegerValueChecker.checkValue(text);
        if (status == -1 || status == 0 || status == 1) {
            this.errorLabel.setText(IntegerValueChecker.getMessage(status));
            this.errorLabel.setVisible(true);
            this.onHeightError = true;
            this.modified(true);
        } else {
            this.onHeightError = false;
            this.errorLabel.setVisible(this.onWidthError);
            this.modified(this.onWidthError);
        }
    }

    private int getWidthValue() {
        return this.onWidthError ? this.localIndexInfo.getWidth() : Integer.parseInt(this.widthTextField.getText());
    }

    private int getHeightValue() {
        return this.onHeightError ? this.localIndexInfo.getHeight() : Integer.parseInt(this.heightTextField.getText());
    }

    private boolean getDisplayDescriptionValue() {
        return this.displayDescription.isSelected();
    }

    private boolean getDisplayExplanationValue() {
        return this.displayExplanation.isSelected();
    }

    public Object getEditedDocument() {
        return this.localIndexInfo;
    }

    public void setEditedDocument(Object document) throws DocumentException {
        this.localIndexInfo = (LocalIndexStandardInfo)document;
    }

    private JTextField getWidthTextField() {
        if (this.widthTextField == null) {
            this.widthTextField = new JTextField();
            this.widthTextField.setColumns(5);
            this.widthTextField.addKeyListener(new KeyAdapter(){

                public void keyTyped(KeyEvent e) {
                    LocalIndexStandardEditor.this.widthChanged();
                }
            });
            this.widthTextField.addCaretListener(new CaretListener(){

                public void caretUpdate(CaretEvent e) {
                    LocalIndexStandardEditor.this.widthChanged();
                }
            });
        }
        return this.widthTextField;
    }

    private JTextField getHeightTextField() {
        if (this.heightTextField == null) {
            this.heightTextField = new JTextField();
            this.heightTextField.setColumns(5);
            this.heightTextField.addKeyListener(new KeyAdapter(){

                public void keyTyped(KeyEvent e) {
                    LocalIndexStandardEditor.this.heightChanged();
                }
            });
            this.heightTextField.addCaretListener(new CaretListener(){

                public void caretUpdate(CaretEvent e) {
                    LocalIndexStandardEditor.this.heightChanged();
                }
            });
        }
        return this.heightTextField;
    }

    private JCheckBox getDisplayDescription() {
        if (this.displayDescription == null) {
            this.displayDescription = new JCheckBox();
            this.displayDescription.setText("display.description");
            this.displayDescription.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    LocalIndexStandardEditor.this.modified(LocalIndexStandardEditor.this.onError);
                }
            });
            this.textDisplayer.register(this.displayDescription, "display.description");
        }
        return this.displayDescription;
    }

    private JCheckBox getDisplayExplanation() {
        if (this.displayExplanation == null) {
            this.displayExplanation = new JCheckBox();
            this.displayExplanation.setText("display.explanation");
            this.displayExplanation.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    LocalIndexStandardEditor.this.modified(LocalIndexStandardEditor.this.onError);
                }
            });
            this.textDisplayer.register(this.displayExplanation, "display.explanation");
        }
        return this.displayExplanation;
    }
}

