/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.layout.editor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.xissweb.data.content.ImageMetaData;
import org.xissweb.data.imetadata.ImageMetadataHelper;
import org.xissweb.data.imetadata.ImageMetadataSchema;
import org.xissweb.data.layout.ImageAreaInfo;
import org.xissweb.gui.Help;
import org.xissweb.gui.XissWebUI;
import org.xissweb.gui.editor.number.IntegerValueChecker;
import org.xissweb.gui.layout.LayoutEditor;
import org.xissweb.gui.layout.editor.AbstractLayoutElementEditor;
import org.xissweb.gui.layout.editor.MetaDataListCellRenderer;
import org.xissweb.gui.layout.editor.MetaDataListSelectionModel;
import org.xissweb.i18n.TextDisplayManager;
import org.xissweb.i18n.TextDisplayer;

public class ImageAreaEditor
extends AbstractLayoutElementEditor
implements ImageMetadataSchema {
    private static final long serialVersionUID = 7561620694370987748L;
    static final int gpsTagsCount = 3;
    private static final int imageTypeCount = ImageMetadataHelper.imageTypeCount();
    private static final Object[] mDataKeys = new Object[ImageMetaData.imageTypeCounts.length];
    private static final String helpNumbering = "number";
    private static final String helpMetaData = "metadata";
    private static final String numberFormatString = "@#";
    private static final String nbFormatString = "%+";
    private static final String imageNumberSample = "5";
    private static final String nbImageSample = "8";
    private static final String[] metaDataTypesLabelKeys = new String[]{"digital.metadata.tab", "film.metadata.tab", "processing.metadata.tab", "unknown.metadata.tab"};
    private static final String[] commentPos = new String[]{"comment.pos.top", "comment.pos.bottom"};
    private static final String[] metaDataPos = new String[]{"meta.data.pos.none", "meta.data.pos.bottom", "meta.data.pos.top"};
    private static final String[] digitalMDataSample = new String[]{"Canon", "Canon DIGITAL IXUS 40", "2005/07/26 14:39:33", "ISO 100", "1/64 sec", "1/60 sec", "F4,5", "5,8 mm", "flash", "auto"};
    private static final String[] filmMDataSample = new String[]{"Minolta", "XGM", "1990/10", "Kodakchrome", "ISO 400", "1/250", "f8", "70 mm", "no flash"};
    private static final String[] processingMDataSample = new String[]{"Canon PhotoStich", "2005/08"};
    private static final String[] timeSpaceMDataSample = new String[]{"2005/07/26 14:39:33"};
    private static final Object[] metadataSamples = new Object[]{digitalMDataSample, filmMDataSample, processingMDataSample, timeSpaceMDataSample};
    private TextDisplayer textDisplayerMetaData = TextDisplayManager.createTextDisplayFor(class$org$xissweb$data$content$ImageMetaData == null ? (class$org$xissweb$data$content$ImageMetaData = ImageAreaEditor.class$("org.xissweb.data.content.ImageMetaData")) : class$org$xissweb$data$content$ImageMetaData);
    private ImageAreaInfo imageArea;
    private boolean onWidthError;
    private boolean onHeightError;
    int numberFormatTextDot;
    private JLabel widthLabel = null;
    private JTextField widthTextField = null;
    private JLabel commentPosLabel = null;
    private JLabel helpLabel = null;
    private JComboBox commentPosComboBox = null;
    private JLabel errorLabel = null;
    private JLabel heightLabel = null;
    private JTextField heightTextField = null;
    private JPanel numberingPanel = null;
    private JTextField numberFormatTextField = null;
    private JButton imageNumButton = null;
    private JButton imageCountButton = null;
    private JPanel[] metaDataPanel = null;
    private JList[] metaDataList = null;
    MetaDataListSelectionModel[] mDataSelModel = null;
    private JButton[] allMetaDataButton = null;
    private JButton[] noMetaDataButton = null;
    private JComboBox metaDataPositionComboBox = null;
    private JTextField sampleMetaDataTextField = null;
    private JLabel sampleNumberingField = null;
    private JLabel helpMetaDataLabel = null;
    private JLabel insertLabel = null;
    private JLabel metadataPositionLabel = null;
    JTabbedPane metadataPanelContainer = null;
    private JPanel metadaMainPanel = null;
    static /* synthetic */ Class class$org$xissweb$data$content$ImageMetaData;

    private static String[] getMetadataSample(int imageType) {
        return (String[])metadataSamples[imageType];
    }

    public ImageAreaEditor(LayoutEditor mainEditor) {
        super(mainEditor);
        this.textDisplayer = TextDisplayManager.createTextDisplayFor(this.getClass());
        this.initialize();
    }

    private String[] getMDataKeys(int imageType) {
        String[] keys = (String[])mDataKeys[imageType];
        if (keys == null) {
            keys = new String[ImageMetaData.imageTypeCounts[imageType] - 3];
            for (int i = 0; i < keys.length; ++i) {
                keys[i] = ImageMetaData.getMetaDataLabelKeys(imageType)[i];
            }
            ImageAreaEditor.mDataKeys[imageType] = keys;
        }
        return keys;
    }

    public void setEditedDocument(Object document) {
        this.imageArea = (ImageAreaInfo)document;
    }

    public Object getEditedDocument() {
        return this.imageArea;
    }

    protected void doSave() {
        this.imageArea.setWidth(IntegerValueChecker.getValue(this.getWidthTextField().getText()));
        this.imageArea.setHeight(IntegerValueChecker.getValue(this.getHeightTextField().getText()));
        this.imageArea.setCommentPosition(this.getCommentPosition(this.getCommentPositionComboBox().getSelectedIndex()));
        this.imageArea.setNumberFormat(this.getNumberFormatTextField().getText());
        this.imageArea.setMetaDataPosition(this.getMetaDataPosValue());
        for (int i = 0; i < imageTypeCount; ++i) {
            boolean[] md = this.getMetaDataValue(i);
            this.imageArea.setMetadata(md, i);
        }
    }

    private int getCommentPositionIndex() {
        int index = 0;
        if (this.imageArea.getCommentPosition() != null) {
            if (this.imageArea.getCommentPosition().equals("top")) {
                index = 0;
            } else if (this.imageArea.getCommentPosition().equals("bottom")) {
                index = 1;
            }
        }
        return index;
    }

    private String getCommentPosition(int index) {
        switch (index) {
            case 1: {
                return "bottom";
            }
        }
        return "top";
    }

    private int getMetaDataPositionIndex() {
        int index = 1;
        if (this.imageArea.getMetaDataPosition().equals("top")) {
            index = 2;
        } else if (this.imageArea.getMetaDataPosition().equals("none")) {
            index = 0;
        }
        return index;
    }

    private String getMetaDataPosition(int index) {
        switch (index) {
            case 0: {
                return "none";
            }
            case 1: {
                return "bottom";
            }
            case 2: {
                return "top";
            }
        }
        return "bottom";
    }

    private int getWidthValue() {
        return this.onWidthError ? this.imageArea.getWidth() : Integer.parseInt(this.widthTextField.getText());
    }

    private int getHeightValue() {
        return this.onHeightError ? this.imageArea.getHeight() : Integer.parseInt(this.heightTextField.getText());
    }

    private String getCommentPosValue() {
        return this.getCommentPosition(this.getCommentPositionComboBox().getSelectedIndex());
    }

    private String getNumberFormatValue() {
        return this.getNumberFormatTextField().getText();
    }

    private String getMetaDataPosValue() {
        return this.getMetaDataPosition(this.getMetaDataPositionComboBox().getSelectedIndex());
    }

    private boolean[] getMetaData(int imageType) {
        return this.imageArea.getMetadata(imageType);
    }

    private MetaDataListSelectionModel getMetaDataListSelectionModel(int imageType) {
        return this.mDataSelModel[imageType];
    }

    private boolean[] getMetaDataValue(int imageType) {
        return this.getMetaDataListSelectionModel(imageType).getCheckedData();
    }

    String buildMetaDataSample(int imageType) {
        boolean[] md = this.getMetaDataValue(imageType);
        int nb = 0;
        for (int i = 0; i < md.length; ++i) {
            if (!md[i]) continue;
            ++nb;
        }
        int nbWroten = 0;
        String[] sampleValues = ImageAreaEditor.getMetadataSample(imageType);
        StringBuffer buff = new StringBuffer();
        buff.append("[ ");
        for (int i = 0; i < sampleValues.length; ++i) {
            if (!md[i]) continue;
            buff.append(sampleValues[i]);
            if (++nbWroten >= nb) continue;
            buff.append(" - ");
        }
        return buff.append(" ]").toString();
    }

    private boolean isMetaDataModified(int imageType) {
        boolean[] current = this.getMetaDataListSelectionModel(imageType).getCheckedData();
        boolean[] mData = this.getMetaData(imageType);
        for (int i = 0; i < current.length; ++i) {
            if (mData[i] == current[i]) continue;
            return false;
        }
        return true;
    }

    protected void initEdition() {
        this.getWidthTextField().setText(Integer.toString(this.imageArea.getWidth()));
        this.getHeightTextField().setText(Integer.toString(this.imageArea.getHeight()));
        this.getCommentPositionComboBox().setSelectedIndex(this.getCommentPositionIndex());
        this.getNumberFormatTextField().setText(this.imageArea.getNumberFormat());
        this.getMetaDataPositionComboBox().setSelectedIndex(this.getMetaDataPositionIndex());
        for (int i = 0; i < imageTypeCount; ++i) {
            this.mDataSelModel[i].setCheckedData(this.getMetaData(i));
            this.getMetaDataPanel(i).validate();
            this.getMetaDataPanel(i).repaint();
        }
        this.getSampleMetaDataTextField().setText(this.buildMetaDataSample(this.getMetadataPanelContainer().getSelectedIndex()));
        this.onWidthError = false;
        this.onHeightError = false;
    }

    public void modified() {
        this.modified(false);
    }

    public void modified(boolean error) {
        if (!this.initializing && this.imageArea != null) {
            if (!error) {
                boolean bl = this.isModified = this.imageArea.getWidth() != this.getWidthValue() || this.imageArea.getHeight() != this.getHeightValue() || !this.imageArea.getCommentPosition().equals(this.getCommentPosValue()) || !this.imageArea.getNumberFormat().equals(this.getNumberFormatValue()) || !this.imageArea.getMetaDataPosition().equals(this.getMetaDataPosValue()) || this.metadataModified();
                if (this.isModified) {
                    this.save();
                }
            }
            this.onError = error;
        }
    }

    private boolean metadataModified() {
        for (int i = 0; i < ImageMetadataHelper.imageTypeCount(); ++i) {
            if (!this.isMetaDataModified(i)) continue;
            return true;
        }
        return false;
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints19 = new GridBagConstraints();
        gridBagConstraints19.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints19.gridy = 5;
        gridBagConstraints19.fill = 2;
        gridBagConstraints19.gridwidth = 4;
        gridBagConstraints19.gridx = 0;
        GridBagConstraints gridBagConstraints61 = new GridBagConstraints();
        gridBagConstraints61.gridx = 0;
        gridBagConstraints61.insets = new Insets(7, 30, 7, 5);
        gridBagConstraints61.anchor = 17;
        gridBagConstraints61.gridy = 2;
        this.errorLabel = new JLabel();
        this.errorLabel.setIcon(XissWebUI.getIcon("/images/common/error.png"));
        this.errorLabel.setVisible(false);
        this.heightLabel = new JLabel();
        this.heightLabel.setText("height.label");
        this.textDisplayer.register(this.heightLabel, "height.label");
        this.widthLabel = new JLabel();
        this.widthLabel.setText("width.labe");
        this.textDisplayer.register(this.widthLabel, "width.label");
        this.commentPosLabel = new JLabel();
        this.commentPosLabel.setText("comment.pos.label");
        this.textDisplayer.register(this.commentPosLabel, "comment.pos.label");
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.fill = 0;
        gridBagConstraints5.gridx = 1;
        gridBagConstraints5.gridy = 2;
        gridBagConstraints5.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints5.anchor = 17;
        gridBagConstraints5.weightx = 0.0;
        GridBagConstraints errorLabelConstraints = new GridBagConstraints();
        errorLabelConstraints.gridx = 1;
        errorLabelConstraints.gridwidth = 3;
        errorLabelConstraints.insets = new Insets(35, 0, 0, 0);
        errorLabelConstraints.anchor = 17;
        errorLabelConstraints.gridy = 0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.insets = new Insets(7, 5, 7, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 1;
        GridBagConstraints gridBagConstraints32 = new GridBagConstraints();
        gridBagConstraints32.fill = 0;
        gridBagConstraints32.gridx = 3;
        gridBagConstraints32.gridy = 1;
        gridBagConstraints32.anchor = 17;
        gridBagConstraints32.weighty = 0.0;
        gridBagConstraints32.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints32.weightx = 200.0;
        GridBagConstraints widthLabelConstraints = new GridBagConstraints();
        widthLabelConstraints.gridx = 0;
        widthLabelConstraints.insets = new Insets(7, 30, 7, 5);
        widthLabelConstraints.anchor = 13;
        widthLabelConstraints.gridy = 1;
        GridBagConstraints gridBagConstraints18 = new GridBagConstraints();
        gridBagConstraints18.fill = 0;
        gridBagConstraints18.gridx = 1;
        gridBagConstraints18.gridy = 1;
        gridBagConstraints18.anchor = 17;
        gridBagConstraints18.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints18.weightx = 0.0;
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridwidth = 4;
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints4.gridy = 4;
        this.addTitle(4);
        this.add((Component)this.widthLabel, widthLabelConstraints);
        this.add((Component)this.getWidthTextField(), gridBagConstraints18);
        this.add((Component)this.heightLabel, gridBagConstraints);
        this.add((Component)this.getHeightTextField(), gridBagConstraints32);
        this.add((Component)this.errorLabel, errorLabelConstraints);
        this.add((Component)this.commentPosLabel, gridBagConstraints61);
        this.add((Component)this.getCommentPositionComboBox(), gridBagConstraints5);
        this.add((Component)this.getNumberingPanel(), gridBagConstraints4);
        this.add((Component)this.getMetadaMainPanel(), gridBagConstraints19);
    }

    private JTextField getWidthTextField() {
        if (this.widthTextField == null) {
            this.widthTextField = new JTextField();
            this.widthTextField.setColumns(5);
            this.widthTextField.addKeyListener(new KeyAdapter(){

                public void keyTyped(KeyEvent e) {
                    ImageAreaEditor.this.widthChanged();
                }
            });
            this.widthTextField.addCaretListener(new CaretListener(){

                public void caretUpdate(CaretEvent e) {
                    ImageAreaEditor.this.widthChanged();
                }
            });
        }
        return this.widthTextField;
    }

    void widthChanged() {
        String text = this.widthTextField.getText();
        int status = IntegerValueChecker.checkValue(text);
        if (status == -1 || status == 0 || status == 1) {
            this.errorLabel.setText(IntegerValueChecker.getMessage(status));
            this.errorLabel.setVisible(true);
            this.onWidthError = true;
            this.modified(true);
        } else {
            this.onWidthError = false;
            this.errorLabel.setVisible(this.onHeightError);
            this.modified(this.onHeightError);
        }
    }

    void heightChanged() {
        String text = this.heightTextField.getText();
        int status = IntegerValueChecker.checkValue(text);
        if (status == -1 || status == 0 || status == 1) {
            this.errorLabel.setText(IntegerValueChecker.getMessage(status));
            this.errorLabel.setVisible(true);
            this.onHeightError = true;
            this.modified(true);
        } else {
            this.onHeightError = false;
            this.errorLabel.setVisible(this.onWidthError);
            this.modified(this.onWidthError);
        }
    }

    private JComboBox getCommentPositionComboBox() {
        if (this.commentPosComboBox == null) {
            this.commentPosComboBox = new JComboBox();
            this.textDisplayer.registerCombo(this.commentPosComboBox, commentPos);
            this.commentPosComboBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent event) {
                    ImageAreaEditor.this.modified(ImageAreaEditor.this.onError);
                }
            });
        }
        return this.commentPosComboBox;
    }

    private JTextField getHeightTextField() {
        if (this.heightTextField == null) {
            this.heightTextField = new JTextField();
            this.heightTextField.setColumns(5);
            this.heightTextField.addKeyListener(new KeyAdapter(){

                public void keyTyped(KeyEvent e) {
                    ImageAreaEditor.this.heightChanged();
                }
            });
            this.heightTextField.addCaretListener(new CaretListener(){

                public void caretUpdate(CaretEvent e) {
                    ImageAreaEditor.this.heightChanged();
                }
            });
        }
        return this.heightTextField;
    }

    private JPanel getNumberingPanel() {
        if (this.numberingPanel == null) {
            GridBagConstraints imageCountButtonConstraints = new GridBagConstraints();
            imageCountButtonConstraints.fill = 2;
            imageCountButtonConstraints.gridx = 2;
            imageCountButtonConstraints.insets = new Insets(2, 2, 2, 2);
            imageCountButtonConstraints.gridy = 0;
            GridBagConstraints imageNumButtonConstraints = new GridBagConstraints();
            imageNumButtonConstraints.fill = 2;
            imageNumButtonConstraints.gridx = 1;
            imageNumButtonConstraints.gridy = 0;
            imageNumButtonConstraints.insets = new Insets(2, 2, 2, 2);
            GridBagConstraints insertLabelConstraint = new GridBagConstraints();
            insertLabelConstraint.gridx = 0;
            insertLabelConstraint.gridy = 0;
            insertLabelConstraint.insets = new Insets(5, 5, 5, 5);
            insertLabelConstraint.weightx = 10.0;
            insertLabelConstraint.anchor = 17;
            this.insertLabel = new JLabel();
            this.insertLabel.setText(helpNumbering);
            this.insertLabel.setText("insert.num.label");
            this.textDisplayer.register(this.insertLabel, "insert.num.label");
            GridBagConstraints helpLabelConstraints = new GridBagConstraints();
            helpLabelConstraints.gridx = 3;
            helpLabelConstraints.gridy = 0;
            helpLabelConstraints.anchor = 13;
            helpLabelConstraints.insets = new Insets(7, 5, 7, 25);
            helpLabelConstraints.gridheight = 2;
            helpLabelConstraints.weightx = 100.0;
            GridBagConstraints numberFormatTexTFieldConstraints = new GridBagConstraints();
            numberFormatTexTFieldConstraints.fill = 2;
            numberFormatTexTFieldConstraints.gridx = 1;
            numberFormatTexTFieldConstraints.gridy = 1;
            numberFormatTexTFieldConstraints.insets = new Insets(5, 2, 5, 2);
            numberFormatTexTFieldConstraints.anchor = 13;
            GridBagConstraints sampleNumberingFieldConstraints = new GridBagConstraints();
            sampleNumberingFieldConstraints.fill = 0;
            sampleNumberingFieldConstraints.gridx = 2;
            sampleNumberingFieldConstraints.gridy = 1;
            sampleNumberingFieldConstraints.insets = new Insets(7, 5, 7, 5);
            sampleNumberingFieldConstraints.anchor = 17;
            this.numberingPanel = new JPanel();
            this.numberingPanel.setLayout(new GridBagLayout());
            TitledBorder b = BorderFactory.createTitledBorder(null, "numbering.panel", 0, 0, XissWebUI.labelPlainFont, XissWebUI.mediumDarkColor);
            this.textDisplayer.registerTitle(b, "numbering.panel");
            this.numberingPanel.setBorder(b);
            this.numberingPanel.add((Component)this.insertLabel, insertLabelConstraint);
            this.numberingPanel.add((Component)this.getImageNumButton(), imageNumButtonConstraints);
            this.numberingPanel.add((Component)this.getImageCountButton(), imageCountButtonConstraints);
            this.numberingPanel.add((Component)this.getHelpLabel(), helpLabelConstraints);
            this.numberingPanel.add((Component)this.getNumberFormatTextField(), numberFormatTexTFieldConstraints);
            this.numberingPanel.add((Component)this.getSampleNumberingField(), sampleNumberingFieldConstraints);
        }
        return this.numberingPanel;
    }

    private JLabel getHelpLabel() {
        if (this.helpLabel == null) {
            this.helpLabel = new JLabel();
            this.helpLabel.setText("");
            this.helpLabel.setIcon(XissWebUI.getIcon("/images/common/help.png"));
            this.helpLabel.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    Help.open(ImageAreaEditor.helpNumbering);
                }
            });
        }
        return this.helpLabel;
    }

    private JTextField getNumberFormatTextField() {
        if (this.numberFormatTextField == null) {
            this.numberFormatTextField = new JTextField();
            this.numberFormatTextField.setColumns(12);
            this.numberFormatTextField.addCaretListener(new CaretListener(){

                public void caretUpdate(CaretEvent e) {
                    ImageAreaEditor.this.numberFormatEdited();
                    ImageAreaEditor.this.numberFormatTextDot = e.getDot();
                }
            });
            this.numberFormatTextField.addKeyListener(new KeyAdapter(){

                public void keyTyped(KeyEvent e) {
                    ImageAreaEditor.this.numberFormatEdited();
                }
            });
        }
        return this.numberFormatTextField;
    }

    void numberFormatEdited() {
        this.modified(this.onError);
        String format = this.numberFormatTextField.getText();
        StringBuffer buff = new StringBuffer();
        buff.append(this.textDisplayer.getString("number.sample")).append(' ');
        int i = 0;
        while (i < format.length()) {
            if (format.startsWith(numberFormatString, i)) {
                buff.append(imageNumberSample);
                i += numberFormatString.length();
                continue;
            }
            if (format.startsWith(nbFormatString, i)) {
                buff.append(nbImageSample);
                i += nbFormatString.length();
                continue;
            }
            buff.append(format.charAt(i));
            ++i;
        }
        this.sampleNumberingField.setText(buff.toString());
    }

    private JButton getImageNumButton() {
        if (this.imageNumButton == null) {
            this.imageNumButton = new JButton();
            this.imageNumButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ImageAreaEditor.this.insertTextNumberFormat(ImageAreaEditor.numberFormatString);
                }
            });
            this.imageNumButton.setMargin(new Insets(2, 2, 2, 2));
            this.imageNumButton.setText("number.image.num");
            this.textDisplayer.register(this.imageNumButton, "number.image.num");
        }
        return this.imageNumButton;
    }

    private JButton getImageCountButton() {
        if (this.imageCountButton == null) {
            this.imageCountButton = new JButton();
            this.imageCountButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ImageAreaEditor.this.insertTextNumberFormat(ImageAreaEditor.nbFormatString);
                }
            });
            this.imageCountButton.setMargin(new Insets(2, 2, 2, 2));
            this.imageCountButton.setText("number.image.nb");
            this.textDisplayer.register(this.imageCountButton, "number.image.nb");
        }
        return this.imageCountButton;
    }

    void insertTextNumberFormat(String text) {
        String selection = this.numberFormatTextField.getSelectedText();
        if (selection != null) {
            this.numberFormatTextField.replaceSelection(text);
        } else {
            String oldText = this.numberFormatTextField.getText();
            String newText = oldText.substring(0, this.numberFormatTextDot);
            newText = newText + text;
            newText = newText + oldText.substring(this.numberFormatTextDot);
            this.numberFormatTextField.setText(newText);
        }
        this.numberFormatEdited();
    }

    private JPanel getMetaDataPanel(int imageType) {
        if (this.metaDataPanel == null) {
            this.metaDataPanel = new JPanel[ImageMetadataHelper.imageTypeCount()];
        }
        if (this.metaDataPanel[imageType] == null) {
            GridBagConstraints listConstraints = new GridBagConstraints();
            listConstraints.anchor = 18;
            listConstraints.fill = 0;
            listConstraints.gridx = 0;
            listConstraints.gridy = 0;
            listConstraints.weightx = 1.0;
            listConstraints.weighty = 1.0;
            listConstraints.gridheight = 2;
            listConstraints.gridwidth = 1;
            listConstraints.insets = new Insets(5, 30, 0, 0);
            GridBagConstraints allConstraints = new GridBagConstraints();
            allConstraints.gridx = 1;
            allConstraints.gridy = 0;
            allConstraints.anchor = 13;
            allConstraints.insets = new Insets(2, 2, 2, 30);
            allConstraints.fill = 0;
            allConstraints.weightx = 10.0;
            allConstraints.weighty = 10.0;
            GridBagConstraints noConstraints = new GridBagConstraints();
            noConstraints.gridx = 1;
            noConstraints.gridy = 1;
            noConstraints.anchor = 13;
            noConstraints.insets = new Insets(2, 2, 2, 30);
            noConstraints.fill = 0;
            noConstraints.weightx = 10.0;
            noConstraints.weighty = 10.0;
            this.metaDataPanel[imageType] = new JPanel();
            this.metaDataPanel[imageType].setLayout(new GridBagLayout());
            this.metaDataPanel[imageType].add((Component)this.getMetaDataList(imageType), listConstraints);
            this.metaDataPanel[imageType].add((Component)this.getAllMetaDataButton(imageType), allConstraints);
            this.metaDataPanel[imageType].add((Component)this.getNoMetaDataButton(imageType), noConstraints);
        }
        return this.metaDataPanel[imageType];
    }

    private JList getMetaDataList(final int imageType) {
        if (this.metaDataList == null) {
            this.metaDataList = new JList[ImageMetadataHelper.imageTypeCount()];
            this.mDataSelModel = new MetaDataListSelectionModel[ImageMetadataHelper.imageTypeCount()];
        }
        if (this.metaDataList[imageType] == null) {
            this.metaDataList[imageType] = new JList();
            this.metaDataList[imageType].setCellRenderer(new MetaDataListCellRenderer());
            this.mDataSelModel[imageType] = new MetaDataListSelectionModel(imageType);
            this.metaDataList[imageType].setSelectionModel(this.mDataSelModel[imageType]);
            this.metaDataList[imageType].addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (e.getModifiers() == 16) {
                        ImageAreaEditor.this.listItemClicked(e, imageType);
                    }
                }
            });
            this.textDisplayerMetaData.registerList(this.metaDataList[imageType], this.getMDataKeys(imageType));
        }
        return this.metaDataList[imageType];
    }

    void listItemClicked(MouseEvent e, int imageType) {
        int data = this.metaDataList[imageType].locationToIndex(e.getPoint());
        if (this.mDataSelModel[imageType].isChecked(data)) {
            this.mDataSelModel[imageType].removeChecked(data);
        } else {
            this.mDataSelModel[imageType].addChecked(data);
        }
        this.mDataSelModel[imageType].setSelectionInterval(data, data);
        this.mDataSelModel[imageType].clearSelection();
        this.getSampleMetaDataTextField().setText(this.buildMetaDataSample(imageType));
        this.modified(false);
    }

    private JButton getAllMetaDataButton(final int imageType) {
        if (this.allMetaDataButton == null) {
            this.allMetaDataButton = new JButton[ImageMetadataHelper.imageTypeCount()];
        }
        if (this.allMetaDataButton[imageType] == null) {
            this.allMetaDataButton[imageType] = new JButton();
            this.allMetaDataButton[imageType].setText("meta.data.all.button");
            this.allMetaDataButton[imageType].addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ImageAreaEditor.this.setAllmetaData(imageType);
                }
            });
            this.textDisplayer.register(this.allMetaDataButton[imageType], "meta.data.all.button");
        }
        return this.allMetaDataButton[imageType];
    }

    void setAllmetaData(int imageType) {
        this.mDataSelModel[imageType].checkAllData();
        this.getSampleMetaDataTextField().setText(this.buildMetaDataSample(imageType));
        this.getMetaDataPanel(imageType).validate();
        this.getMetaDataPanel(imageType).repaint();
        this.modified(this.onError);
    }

    private JButton getNoMetaDataButton(final int imageType) {
        if (this.noMetaDataButton == null) {
            this.noMetaDataButton = new JButton[ImageMetadataHelper.imageTypeCount()];
        }
        if (this.noMetaDataButton[imageType] == null) {
            this.noMetaDataButton[imageType] = new JButton();
            this.noMetaDataButton[imageType].setText("meta.data.no.button");
            this.noMetaDataButton[imageType].addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ImageAreaEditor.this.unsetAllMetaData(imageType);
                }
            });
            this.textDisplayer.register(this.noMetaDataButton[imageType], "meta.data.no.button");
        }
        return this.noMetaDataButton[imageType];
    }

    void unsetAllMetaData(int imageType) {
        this.mDataSelModel[imageType].uncheckAllData();
        this.getSampleMetaDataTextField().setText(this.buildMetaDataSample(imageType));
        this.getMetaDataPanel(imageType).validate();
        this.getMetaDataPanel(imageType).repaint();
        this.modified(this.onError);
    }

    private JComboBox getMetaDataPositionComboBox() {
        if (this.metaDataPositionComboBox == null) {
            this.metaDataPositionComboBox = new JComboBox();
            this.metaDataPositionComboBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    ImageAreaEditor.this.modified(ImageAreaEditor.this.onError);
                }
            });
            this.textDisplayer.registerCombo(this.metaDataPositionComboBox, metaDataPos);
        }
        return this.metaDataPositionComboBox;
    }

    JTextField getSampleMetaDataTextField() {
        if (this.sampleMetaDataTextField == null) {
            this.sampleMetaDataTextField = new JTextField();
            this.sampleMetaDataTextField.setEditable(false);
            this.sampleMetaDataTextField.setEnabled(false);
        }
        return this.sampleMetaDataTextField;
    }

    private JLabel getSampleNumberingField() {
        if (this.sampleNumberingField == null) {
            this.sampleNumberingField = new JLabel();
            this.sampleNumberingField.setFont(XissWebUI.labelPlainFont);
            this.sampleNumberingField.setText("sample");
            this.sampleNumberingField.setForeground(XissWebUI.darkColor);
        }
        return this.sampleNumberingField;
    }

    private JTabbedPane getMetadataPanelContainer() {
        if (this.metadataPanelContainer == null) {
            this.metadataPanelContainer = new JTabbedPane();
            for (int i = 0; i < metaDataTypesLabelKeys.length; ++i) {
                this.metadataPanelContainer.insertTab(null, null, this.getMetaDataPanel(i), null, i);
            }
            this.textDisplayer.registerTabbedPane(this.metadataPanelContainer, metaDataTypesLabelKeys);
            this.metadataPanelContainer.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent arg0) {
                    ImageAreaEditor.this.getSampleMetaDataTextField().setText(ImageAreaEditor.this.buildMetaDataSample(ImageAreaEditor.this.metadataPanelContainer.getSelectedIndex()));
                }
            });
        }
        return this.metadataPanelContainer;
    }

    private JPanel getMetadaMainPanel() {
        if (this.metadaMainPanel == null) {
            GridBagConstraints gridBagConstraints20 = new GridBagConstraints();
            gridBagConstraints20.fill = 2;
            gridBagConstraints20.gridx = 0;
            gridBagConstraints20.gridy = 2;
            gridBagConstraints20.gridwidth = 4;
            gridBagConstraints20.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints20.weightx = 1.0;
            this.helpMetaDataLabel = new JLabel();
            this.helpMetaDataLabel.setText("");
            this.helpMetaDataLabel.setIcon(XissWebUI.getIcon("/images/common/help.png"));
            this.helpMetaDataLabel.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    Help.open(ImageAreaEditor.helpMetaData);
                }
            });
            this.metadataPositionLabel = new JLabel();
            this.metadataPositionLabel.setText("metadata.position");
            this.textDisplayer.register(this.metadataPositionLabel, "metadata.position.label");
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.anchor = 13;
            gridBagConstraints7.gridheight = 1;
            gridBagConstraints7.gridwidth = 1;
            gridBagConstraints7.gridx = 3;
            gridBagConstraints7.gridy = 0;
            gridBagConstraints7.weightx = 1.0;
            gridBagConstraints7.insets = new Insets(7, 5, 7, 25);
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.anchor = 18;
            gridBagConstraints11.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints11.gridheight = 1;
            gridBagConstraints11.gridx = 1;
            gridBagConstraints11.gridy = 0;
            gridBagConstraints11.weightx = 1.0;
            gridBagConstraints11.fill = 0;
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.anchor = 12;
            gridBagConstraints9.gridheight = 1;
            gridBagConstraints9.gridx = 0;
            gridBagConstraints9.gridy = 0;
            gridBagConstraints9.weighty = 0.0;
            gridBagConstraints9.insets = new Insets(7, 5, 7, 5);
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.anchor = 17;
            gridBagConstraints1.insets = new Insets(2, 5, 5, 5);
            gridBagConstraints1.gridwidth = 4;
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 1;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.weighty = 1.0;
            gridBagConstraints1.fill = 1;
            this.metadaMainPanel = new JPanel();
            TitledBorder b = BorderFactory.createTitledBorder(null, "meta.data.panel", 0, 0, XissWebUI.labelPlainFont, XissWebUI.mediumDarkColor);
            this.metadaMainPanel.setBorder(b);
            this.metadaMainPanel.setLayout(new GridBagLayout());
            this.metadaMainPanel.add((Component)this.metadataPositionLabel, gridBagConstraints9);
            this.metadaMainPanel.add((Component)this.getMetaDataPositionComboBox(), gridBagConstraints11);
            this.metadaMainPanel.add((Component)this.helpMetaDataLabel, gridBagConstraints7);
            this.metadaMainPanel.add((Component)this.getMetadataPanelContainer(), gridBagConstraints1);
            this.metadaMainPanel.add((Component)this.getSampleMetaDataTextField(), gridBagConstraints20);
            this.textDisplayer.registerTitle(b, "meta.data.panel");
        }
        return this.metadaMainPanel;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

