/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.layout;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.ImageIcon;
import org.xissweb.data.layout.ArrangementInfo;
import org.xissweb.data.layout.ImageAreaInfo;
import org.xissweb.data.layout.NavigationBarInfo;
import org.xissweb.data.layout.PageDecorationInfo;
import org.xissweb.data.layout.ThumbnailsInfo;
import org.xissweb.gui.XissWebUI;
import org.xissweb.gui.graphic.GraphicElement;
import org.xissweb.gui.graphic.GraphicElementRenderer;
import org.xissweb.gui.graphic.GraphicIconElement;

public class LayoutGraphicElementRenderer
implements GraphicElementRenderer {
    private static final Color foreground = XissWebUI.darkColor;
    private static final Color background = XissWebUI.paleColor;
    private static final Color medium = XissWebUI.mediumColor;
    private static final int navigationMarginFactor = 3;
    private static final int iconRoundedRectArc = 3;

    public void draw(Graphics2D g2d, GraphicElement element, boolean selected) {
        if (element.getUserObject() instanceof ImageAreaInfo) {
            this.drawImageArea(g2d, element, 2, selected);
        } else if (element.getUserObject() instanceof NavigationBarInfo) {
            this.drawNavigationBar(g2d, element, 2, selected);
        } else if (element.getUserObject() instanceof ThumbnailsInfo) {
            this.drawThumbnails(g2d, element, 3, selected);
        } else if (element.getUserObject() instanceof PageDecorationInfo) {
            this.drawPageDecoration(g2d, element, selected);
        } else if (element.getUserObject() instanceof ArrangementInfo) {
            this.drawArrangement(g2d, element, selected);
        } else if (element instanceof GraphicIconElement) {
            this.drawIconElement(g2d, (GraphicIconElement)element, selected);
        }
    }

    private void drawIconElement(Graphics2D g2d, GraphicIconElement element, boolean selected) {
        ImageIcon ic = element.getIcon();
        g2d.setPaint(selected ? foreground : background);
        int arc = 3;
        g2d.fillRoundRect(element.getArea().x, element.getArea().y, element.getArea().width, element.getArea().height, arc, arc);
        g2d.drawImage(ic.getImage(), element.getArea().x + (element.getArea().width - ic.getIconWidth()) / 2, element.getArea().y + (element.getArea().height - ic.getIconHeight()) / 2, null);
    }

    private void drawArrangement(Graphics2D g2d, GraphicElement element, boolean selected) {
        if (!selected) {
            g2d.setPaint(background);
        }
        g2d.draw(element.getArea());
        if (!selected) {
            g2d.setPaint(foreground);
        }
    }

    private void drawPageDecoration(Graphics2D g2d, GraphicElement element, boolean selected) {
        g2d.setPaint(medium);
        g2d.fill(element.getArea());
        if (selected) {
            g2d.setPaint(foreground);
        } else {
            g2d.setPaint(background);
        }
        g2d.draw(element.getArea());
        g2d.setPaint(foreground);
    }

    private void drawImageArea(Graphics2D graphics, GraphicElement elt, int m, boolean selected) {
        if (graphics != null) {
            Rectangle rect = elt.getArea();
            int xCenter = rect.x + rect.width / 2;
            int yCenter = rect.y + rect.height / 2;
            int size = Math.min(rect.width, rect.height) - 3 * m;
            int sizeW = rect.width - size / 10;
            int sizeH = rect.height - size / 10;
            int x = xCenter - sizeW / 2;
            int y = yCenter - sizeH / 2;
            GradientPaint dark2light = !selected ? new GradientPaint(x, y, background, x + sizeW, y + sizeH, medium) : new GradientPaint(x, y, foreground, x + sizeW, y + sizeH, medium);
            graphics.setPaint(dark2light);
            graphics.fillRect(x, y, sizeW, sizeH);
            if (selected) {
                graphics.setPaint(foreground);
                graphics.draw(rect);
            } else {
                graphics.setPaint(medium);
                graphics.draw(rect);
            }
        }
    }

    private void drawNavigationBar(Graphics2D graphics, GraphicElement elt, int m, boolean selected) {
        GraphicElement parent = elt.getParent();
        boolean isVertical = ((ArrangementInfo)parent.getUserObject()).isVertical();
        if (selected) {
            graphics.setPaint(foreground);
        } else {
            graphics.setPaint(background);
        }
        graphics.fill(elt.getArea());
        if (selected) {
            graphics.setPaint(background);
        } else {
            graphics.setPaint(foreground);
        }
        Rectangle rect = elt.getArea();
        NavigationBarInfo navigation = (NavigationBarInfo)elt.getUserObject();
        int size = 0;
        int xCenter = rect.x + rect.width / 2;
        int yCenter = rect.y + rect.height / 2;
        size = Math.min(rect.width, rect.height) / 2;
        int barM = size * 3;
        if (navigation.hasInit()) {
            graphics.drawRect(xCenter - size / 2, yCenter - size / 2, size, size);
        }
        if (isVertical) {
            int x;
            if (navigation.hasPrevious()) {
                x = rect.x + 2 * m;
                this.drawBackwardArrow(graphics, x, yCenter, size);
                this.drawBackwardArrow(graphics, x += 2 * m, yCenter, size);
            }
            if (navigation.hasBackward()) {
                x = xCenter - barM;
                this.drawBackwardArrow(graphics, x, yCenter, size);
            }
            if (navigation.hasForward()) {
                x = xCenter + barM;
                this.drawForwardArrow(graphics, x, yCenter, size);
            }
            if (navigation.hasNext()) {
                x = rect.x + rect.width - 2 * m;
                this.drawForwardArrow(graphics, x, yCenter, size);
                this.drawForwardArrow(graphics, x -= 2 * m, yCenter, size);
            }
        } else {
            int x;
            int y;
            if (navigation.hasPrevious()) {
                y = rect.y + 2 * m;
                x = xCenter - size / 2 - m;
                this.drawBackwardArrow(graphics, x, y, size);
                this.drawBackwardArrow(graphics, x += 2 * m, y, size);
            }
            if (navigation.hasBackward()) {
                y = yCenter - barM;
                x = xCenter - size / 2;
                this.drawBackwardArrow(graphics, x, y, size);
            }
            if (navigation.hasForward()) {
                y = yCenter + barM;
                x = xCenter + size / 2;
                this.drawForwardArrow(graphics, x, y, size);
            }
            if (navigation.hasPrevious()) {
                y = rect.y + rect.height - 2 * m;
                x = xCenter + size / 2 + m;
                this.drawForwardArrow(graphics, x, y, size);
                this.drawForwardArrow(graphics, x += 2 * m, y, size);
            }
        }
    }

    private void drawThumbnails(Graphics2D graphics, GraphicElement elt, int m, boolean selected) {
        GraphicElement parent = elt.getParent();
        boolean isVertical = ((ArrangementInfo)parent.getUserObject()).isVertical();
        if (selected) {
            graphics.setPaint(foreground);
        } else {
            graphics.setPaint(background);
        }
        graphics.fill(elt.getArea());
        if (selected) {
            graphics.setPaint(background);
        } else {
            graphics.setPaint(foreground);
        }
        Rectangle rect = elt.getArea();
        ThumbnailsInfo info = (ThumbnailsInfo)elt.getUserObject();
        int range = info.getRange();
        int size = Math.min(rect.width, rect.height) / range;
        int x = rect.x;
        int y = rect.y;
        if (isVertical) {
            for (int i = 0; i < range; ++i) {
                for (int j = 0; j < 2 * range + 1 - i; ++j) {
                    graphics.fillRect(x + j * size + m, y + i * size + m, size - m, size - m);
                }
            }
        } else {
            for (int i = 0; i < range; ++i) {
                for (int j = 0; j < 2 * range + 1 - i; ++j) {
                    graphics.fillRect(x + i * size + m, y + j * size + m, size - m, size - m);
                }
            }
        }
    }

    private void drawBackwardArrow(Graphics2D graphics, int x, int y, int size) {
        graphics.drawLine(x, y, x + size / 2, y - size / 2);
        graphics.drawLine(x, y, x + size / 2, y + size / 2);
    }

    private void drawForwardArrow(Graphics2D graphics, int x, int y, int size) {
        graphics.drawLine(x, y, x - size / 2, y + size / 2);
        graphics.drawLine(x, y, x - size / 2, y - size / 2);
    }
}

