/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.file;

import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.xissweb.gui.Main;
import org.xissweb.gui.XissWebUI;
import org.xissweb.gui.file.FileManager;
import org.xissweb.gui.util.tree.TreeHelper;
import org.xissweb.gui.util.tree.TreeNodeTransferable;
import org.xissweb.i18n.TextDisplayManager;
import org.xissweb.i18n.TextDisplayer;
import org.xissweb.project.SlideShowProject;

public class FileTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = 4471156613047719799L;
    DataFlavor fileFlavor = DataFlavor.javaFileListFlavor;
    DataFlavor nodesFlavor = TreeNodeTransferable.dataFlavor;
    private FileManager fileManager;
    private JTree source;
    private ArrayList originNodes;
    private int action = 0;
    private TextDisplayer displayer;
    private boolean importDataDone;
    private boolean exportDoneDone;
    private DefaultMutableTreeNode targetNode;

    public FileTransferHandler(FileManager fileManager) {
        this.fileManager = fileManager;
        this.displayer = TextDisplayManager.createTextDisplayFor(this.getClass());
    }

    public int getSourceActions(JComponent c) {
        return 3;
    }

    public boolean importData(JComponent c, Transferable t) {
        if (!this.canImport(c, t.getTransferDataFlavors())) {
            return false;
        }
        JTree tree = (JTree)c;
        TreePath path = tree.getSelectionPath();
        this.targetNode = null;
        if (path != null) {
            this.targetNode = (DefaultMutableTreeNode)path.getLastPathComponent();
        }
        if (this.targetNode == null) {
            return false;
        }
        File targetFile = (File)this.targetNode.getUserObject();
        if (Main.get().getCurrentProject().isInOrigin(targetFile)) {
            XissWebUI.showErrorMessage(this.displayer.getString("import.in.origin"), this.displayer.getString("title.import.data"));
            return false;
        }
        if (Main.get().getCurrentProject().isInRepository(targetFile)) {
            XissWebUI.showErrorMessage(this.displayer.getString("import.in.repository"), this.displayer.getString("title.import.data"));
            return false;
        }
        this.importDataDone = true;
        this.exportDone(this.source, t, this.action);
        return true;
    }

    protected void exportDone(JComponent c, Transferable data, int action) {
        if (!this.importDataDone || this.exportDoneDone) {
            this.action = action;
            return;
        }
        try {
            if (this.hasFlavor(this.nodesFlavor, data.getTransferDataFlavors())) {
                this.importNodes(c, data, this.targetNode, this.isCopyAction(action));
            } else if (this.hasFlavor(this.fileFlavor, data.getTransferDataFlavors())) {
                List files = (List)data.getTransferData(this.fileFlavor);
                this.importFiles(files, this.targetNode, true);
            }
        }
        catch (UnsupportedFlavorException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.source = null;
        this.exportDoneDone = true;
        System.out.println(" DONE\n");
        if (this.importDataDone) {
            this.exportDoneDone = false;
        }
        this.importDataDone = false;
    }

    private boolean isCopyAction(int action) {
        return 1 == action;
    }

    public boolean canImport(JComponent c, DataFlavor[] flavors) {
        boolean can = this.hasFlavor(this.fileFlavor, flavors) || this.hasFlavor(this.nodesFlavor, flavors);
        return can;
    }

    private void importFiles(List files, DefaultMutableTreeNode targetNode, boolean isCopy) {
        File file = (File)targetNode.getUserObject();
        File itself = this.isDorpingToItself(files, file, isCopy);
        if (itself != null) {
            if (itself.isFile()) {
                XissWebUI.showErrorMessage(this.displayer.getString("import.file.to.itself"), this.displayer.getString("title.import.data"));
            } else {
                XissWebUI.showErrorMessage(this.displayer.getString("import.folder.to.itself"), this.displayer.getString("title.import.data"));
            }
            return;
        }
        if (files.size() == 1) {
            try {
                this.fileManager.performTransferFile((File)files.get(0), file, isCopy);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("Can't import more than one file!");
            XissWebUI.showInfoMessage(this.displayer.getString("no.multiple.file.transfer.allowed.message"), this.displayer.getString("no.multiple.file.transfer.allowed.title"));
        }
    }

    private void importNodes(Component c, Transferable data, DefaultMutableTreeNode targetNode, boolean isCopy) throws UnsupportedFlavorException, IOException {
        List nodes = (List)data.getTransferData(this.nodesFlavor);
        ArrayList<Object> files = new ArrayList<Object>();
        Iterator i = nodes.iterator();
        while (i.hasNext()) {
            files.add(((DefaultMutableTreeNode)i.next()).getUserObject());
        }
        this.importFiles(files, targetNode, isCopy);
    }

    private File isDorpingToItself(List nodes, File targetFile, boolean isCopy) {
        Iterator i = nodes.iterator();
        while (i.hasNext()) {
            File file = (File)i.next();
            if (!isCopy && file.equals(targetFile)) {
                return file;
            }
            if (file.isDirectory() && targetFile.getAbsolutePath().startsWith(file.getAbsolutePath())) {
                return file;
            }
            if (isCopy || !file.getParentFile().equals(targetFile)) continue;
            return file;
        }
        return null;
    }

    private boolean hasFlavor(DataFlavor expected, DataFlavor[] flavors) {
        for (int i = 0; i < flavors.length; ++i) {
            if (!expected.equals(flavors[i])) continue;
            return true;
        }
        return false;
    }

    protected Transferable createTransferable(JComponent c) {
        this.importDataDone = false;
        this.exportDoneDone = false;
        TreeNodeTransferable transf = null;
        this.source = (JTree)c;
        this.originNodes = TreeHelper.getSelectedNodes(this.source);
        if (this.originNodes != null) {
            ArrayList<DefaultMutableTreeNode> nodes = new ArrayList<DefaultMutableTreeNode>();
            Iterator i = this.originNodes.iterator();
            while (i.hasNext()) {
                DefaultMutableTreeNode oNode = (DefaultMutableTreeNode)i.next();
                File f = (File)oNode.getUserObject();
                if (Main.get().getCurrentProject().isSrcDirectory(f) || SlideShowProject.isContentFile(f) || SlideShowProject.isSkinFile(f) || SlideShowProject.isSkinsRootDirectory(f) || SlideShowProject.isProjectPropertiesFile(f) || FileManager.isDirectImageDirSlideShow(f) || Main.get().getCurrentProject().isInOrigin(f) || Main.get().getCurrentProject().isInRepository(f)) break;
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(f);
                nodes.add(node);
            }
            if (!nodes.isEmpty()) {
                transf = new TreeNodeTransferable(nodes);
            }
        }
        return transf;
    }
}

