/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.examples.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.apache.xerces.parsers.SAXParser;
import org.xissweb.gui.examples.xml.ExamplesSchema;
import org.xissweb.xml.XMLHelper;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ExamplesDeserializer
extends DefaultHandler
implements ExamplesSchema {
    private HashMap result = null;

    public HashMap deserialize(File file) {
        try {
            FileInputStream in = new FileInputStream(file);
            HashMap result = this.deserialize(in);
            in.close();
            return result;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public HashMap deserialize(InputStream in) {
        this.result = new HashMap();
        try {
            SAXParser parser = XMLHelper.getSAXPerser(this);
            parser.parse(new InputSource(in));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        return this.result;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (localName.equals("latest")) {
            this.result.put(localName, attributes.getValue("examples"));
        }
        if (localName.equals("version")) {
            String[] xissVersions = attributes.getValue("xiss-web").split(",");
            String exVersion = attributes.getValue("examples");
            for (int i = 0; i < xissVersions.length; ++i) {
                this.result.put(xissVersions[i], exVersion);
            }
        }
    }
}

