/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.examples;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import org.xissweb.gui.examples.HttpUploaderObserver;

public class SteppedHttpUploader {
    private static int BUFFER = 2048;
    private URL urlObject;
    private File destination;
    private byte[] data = new byte[BUFFER];
    private int progression = -1;
    private int size = -1;
    private HttpURLConnection cnx = null;
    private InputStream in = null;
    private OutputStream out = null;
    private HttpUploaderObserver observer;

    public SteppedHttpUploader(String url, File destination) throws MalformedURLException {
        this.urlObject = new URL(url);
        this.destination = destination;
    }

    public int getProgression() {
        return this.progression;
    }

    public int getSize() {
        return this.size;
    }

    public double progression() {
        if (this.size == -1 || this.progression == -1) {
            return -1.0;
        }
        return (double)this.progression * 100.0 / (double)this.size;
    }

    public HttpUploaderObserver getObserver() {
        return this.observer;
    }

    public void setObserver(HttpUploaderObserver observer) {
        this.observer = observer;
    }

    public boolean step() throws IOException {
        if (this.cnx == null) {
            this.cnx = (HttpURLConnection)this.urlObject.openConnection();
            this.cnx.setRequestMethod("GET");
            this.cnx.connect();
            this.size = this.cnx.getContentLength();
            this.in = new BufferedInputStream(this.cnx.getInputStream());
            this.out = new BufferedOutputStream(new FileOutputStream(this.destination));
            this.progression = 0;
            this.notifyProgress();
            return true;
        }
        if (this.in != null) {
            if (this.progression < this.size) {
                int read = this.in.read(this.data);
                this.out.write(this.data, 0, read);
                this.progression += read;
                this.notifyProgress();
                return true;
            }
            if (this.progression == this.size) {
                this.out.close();
                this.in.close();
                this.cnx.disconnect();
                this.notifyDone();
                return false;
            }
        }
        return false;
    }

    public synchronized void stop() {
        try {
            if (this.out != null) {
                this.out.close();
                this.out = null;
            }
            if (this.in != null) {
                this.in.close();
                this.in = null;
            }
            this.cnx.disconnect();
            this.notifyInterrupted();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void notifyProgress() {
        if (this.observer != null) {
            this.observer.uploadProgress(this);
        }
    }

    private void notifyDone() {
        if (this.observer != null) {
            this.observer.uploadDone(this);
        }
    }

    private void notifyInterrupted() {
        if (this.observer != null) {
            this.observer.uploadInterrupted(this);
        }
    }
}

