/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.examples;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import java.util.zip.ZipException;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.xissweb.About;
import org.xissweb.file.FileHelper;
import org.xissweb.file.SteppedUnziper;
import org.xissweb.file.UnzipObserver;
import org.xissweb.gui.Main;
import org.xissweb.gui.XissWebUI;
import org.xissweb.gui.examples.FileTransferHandler;
import org.xissweb.gui.examples.HttpUploaderObserver;
import org.xissweb.gui.examples.SteppedHttpUploader;
import org.xissweb.gui.examples.SwingHttpUploader;
import org.xissweb.gui.examples.SwingInstaller;
import org.xissweb.gui.examples.SwingLookingForExamples;
import org.xissweb.gui.util.ActiveLabel;
import org.xissweb.gui.worker.ProcessLauncher;
import org.xissweb.gui.worker.SwingWorker;
import org.xissweb.i18n.TextDisplayManager;
import org.xissweb.i18n.TextDisplayer;
import org.xissweb.prefs.ui.ComponentConfigurator;

public class ExamplesInstallerDialog
extends JDialog
implements UnzipObserver,
HttpUploaderObserver,
ProcessLauncher {
    private static final long serialVersionUID = 1L;
    private static final String WAITING_ANIM_ICON = "/images/common/waitingAnim.gif";
    private static int PROGRESS_MAX = 200;
    private static final String EXAMPLES_ARCHIVE_NAME_BEGIN = "xiss-web";
    private static final String EXAMPLES_ARCHIVE_NAME_END = "-examples.zip";
    private static final String EXAMPLE_ARCHIVE_NAME_VERSION_PATTERN = "@@version@@";
    private static final String EXAMPLE_ERROR_PATTERN = "@@error@@";
    private static final String EXAMPLES_URL_BASE = "http://xissweb.free.fr/version/";
    private static final String EXAMPLES_DONWLOAD_PROPERTIES = "http://xissweb.free.fr/version/examples-download.properties";
    private static final String EXAMPLES_SF_URL_DOWNLOAD_KEY = "url.download";
    private static final String EXAMPLES_VERSION_URL = "http://xissweb.free.fr/version/examples.xml";
    private static final String WARN_ICON = "/images/common/warning.png";
    private static final String START_ICON = "/images/common/start.png";
    private static final String PAUSE_ICON = "/images/common/pause.png";
    private static final String STOP_ICON = "/images/common/stop.png";
    private static boolean internetProblem = false;
    private JPanel jContentPane = null;
    private JPanel controlPanel = null;
    private JButton closeButton = null;
    private JPanel mainPanel = null;
    private JProgressBar progressBar = null;
    private JLabel infoLabel = null;
    private JRadioButton localInstallRadioButton = null;
    private JRadioButton uploadAndInstallRadioButton = null;
    private JTextField archiveTextField = null;
    private JButton openArchiveButton = null;
    private ButtonGroup buttonGroup = null;
    private JPanel progressControlPanel = null;
    private ActiveLabel startButton = null;
    private ActiveLabel pauseButton = null;
    private ActiveLabel stopButton = null;
    private JFileChooser archiveFileChooser = null;
    private TextDisplayer displayer = null;
    private SteppedHttpUploader uploader = null;
    private SwingHttpUploader swingUploader = null;
    private SteppedUnziper unziper = null;
    private SwingInstaller installer = null;
    private String archiveURL = null;
    private File archive = null;
    private SwingWorker worker = null;
    private int httpResponse;
    private JLabel archiveInfoLabel = null;

    private static void loadExemplesVersion() {
        block4: {
            InputStream in = null;
            try {
                URL url = new URL(EXAMPLES_VERSION_URL);
                in = url.openStream();
            }
            catch (IOException e) {
                internetProblem = true;
                if (in == null) break block4;
                try {
                    in.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    private static String getExamplesVersion() {
        return About.getExamplesVersion();
    }

    static String getExamplesArchiveName() {
        String version = ExamplesInstallerDialog.getExamplesVersion();
        if (version == null) {
            return null;
        }
        return EXAMPLES_ARCHIVE_NAME_BEGIN + ExamplesInstallerDialog.getExamplesVersion() + EXAMPLES_ARCHIVE_NAME_END;
    }

    static boolean isExampleArchive(File archive) {
        return archive.getName().equals(ExamplesInstallerDialog.getExamplesArchiveName());
    }

    public ExamplesInstallerDialog(Frame owner) {
        super(owner);
        ExamplesInstallerDialog.loadExemplesVersion();
        this.displayer = TextDisplayManager.createTextDisplayFor(this.getClass());
        this.initialize();
        this.getUploadAndInstallRadioButton().setEnabled(!internetProblem);
        this.getLocalInstallRadioButton().setSelected(internetProblem);
        this.onRadioInstallRadioButtonStateChanged();
        this.displayInfo(null);
        ComponentConfigurator.configure((Component)this);
    }

    public void showDialog() {
        this.setVisible(true);
    }

    public boolean isComplete() {
        return this.unziper != null && this.unziper.archiveProgression() == 100.0;
    }

    private boolean isArchiveUploaded() {
        if (this.archive != null && this.archive.exists()) {
            return this.archive.getParentFile().equals(new File(System.getProperty("java.io.tmpdir")));
        }
        return false;
    }

    boolean getArchiveUrlDownload() {
        this.httpResponse = -1;
        String sfURLpath = null;
        try {
            URL urlProp = new URL(EXAMPLES_DONWLOAD_PROPERTIES);
            Properties props = new Properties();
            props.load(urlProp.openStream());
            sfURLpath = props.getProperty(EXAMPLES_SF_URL_DOWNLOAD_KEY);
            this.archiveURL = sfURLpath.replaceFirst(EXAMPLE_ARCHIVE_NAME_VERSION_PATTERN, ExamplesInstallerDialog.getExamplesVersion());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    private void uploadAndInstall() {
        this.displayInfo("upload.initialize");
        this.infoLabel.setIcon(XissWebUI.getIcon(WAITING_ANIM_ICON));
        this.worker = new SwingLookingForExamples(this);
        this.worker.start();
    }

    private void uploadArchive() {
        try {
            this.displayInfo("upload.start");
            String archiveName = ExamplesInstallerDialog.getExamplesArchiveName();
            this.archive = new File(System.getProperty("java.io.tmpdir"), archiveName);
            this.uploader = new SteppedHttpUploader(this.archiveURL, this.archive);
            this.uploader.setObserver(this);
            this.swingUploader = new SwingHttpUploader(this.uploader);
            this.worker = this.swingUploader;
            this.displayInfo("upload.progress");
            this.swingUploader.start();
            this.startButton.setEnabled(false);
            this.pauseButton.setEnabled(true);
            this.stopButton.setEnabled(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void notifyUserUrlNotFound() {
        String error = "?";
        if (this.httpResponse == -1) {
            error = this.displayer.getString("download.url.not.found.error");
        } else if (this.httpResponse != 200) {
            error = "HTML " + this.httpResponse;
        }
        XissWebUI.showErrorMessage(this.displayer.getString("download.url.not.found.message").replaceFirst(EXAMPLE_ERROR_PATTERN, error), this.displayer.getString("download.url.not.found.title"));
    }

    private void runIntallation() {
        if (this.installer == null) {
            try {
                this.closeButton.setEnabled(false);
                this.displayInfo("install.start");
                this.installArchive();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.installer.interrupt(false);
        }
        if (this.uploader == null) {
            this.progressBar.setMaximum(PROGRESS_MAX / 2);
        }
        this.displayInfo("install.progress");
    }

    private void installArchive() throws ZipException, IOException {
        this.unziper = new SteppedUnziper(this.archive, Main.getExemplesDir());
        this.unziper.setObserver(this);
        this.progressBar.setValue(0);
        this.progressBar.setMaximum(this.unziper.getEntriesCount());
        this.installer = new SwingInstaller(this.unziper);
        this.worker = this.installer;
        this.installer.start();
        this.startButton.setEnabled(false);
        this.pauseButton.setEnabled(true);
        this.stopButton.setEnabled(true);
    }

    private void displayInfo(String key) {
        this.infoLabel.setText(key == null ? "" : this.displayer.getString(key));
    }

    public void uploadDone(SteppedHttpUploader uploader) {
        this.displayInfo("upload.done");
        try {
            this.displayInfo("install.start");
            this.installArchive();
        }
        catch (ZipException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void uploadInterrupted(SteppedHttpUploader uploader) {
        this.displayInfo("upload.stopped");
        this.runIntallation();
    }

    public void uploadProgress(SteppedHttpUploader uploader) {
        if (uploader.getProgression() == 0) {
            this.progressBar.setValue(0);
        } else {
            this.progressBar.setValue((int)uploader.progression());
        }
    }

    public void performPauseRestart() {
    }

    public void performStart() {
    }

    public void performStop() {
    }

    public void processFinished(SwingWorker worker, long time, boolean complete) {
        this.infoLabel.setIcon(null);
        if (this.archiveURL == null) {
            this.notifyUserUrlNotFound();
            this.displayInfo("download.url.not.found.title");
            this.startButton.setEnabled(false);
            return;
        }
        if (complete) {
            this.uploadArchive();
        }
    }

    public void archiveDone(SteppedUnziper unzipStepper) {
        this.displayInfo("install.done");
        this.pauseButton.setEnabled(false);
        this.stopButton.setEnabled(false);
        this.closeButton.setEnabled(true);
        if (this.isArchiveUploaded()) {
            this.archive.delete();
        }
    }

    public void archiveInterrupted(SteppedUnziper unzipStepper) {
        this.displayInfo("install.stopped");
    }

    public void archiveProgress(SteppedUnziper unzipStepper) {
        this.progressBar.setValue(unzipStepper.getEntryNumber());
        this.progressBar.setString(Integer.toString((int)unzipStepper.archiveProgression()) + "%");
    }

    public void entryDone(SteppedUnziper unzipStepper) {
    }

    public void entryProgress(SteppedUnziper unzipStepper) {
    }

    private void initialize() {
        this.setSize(500, 275);
        this.setModal(true);
        StringBuffer buff = new StringBuffer();
        String version = ExamplesInstallerDialog.getExamplesVersion();
        buff.append(this.displayer.getString("title")).append(' ');
        buff.append(version).append(' ').append(this.displayer.getString("title.xissweb.version"));
        buff.append(' ').append(About.getVersion());
        this.setTitle(buff.toString());
        this.setContentPane(this.getJContentPane());
        this.getButtonGroup();
        this.uploadAndInstallRadioButton.setSelected(true);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getControlPanel(), "South");
            this.jContentPane.add((Component)this.getMainPanel(), "Center");
        }
        return this.jContentPane;
    }

    private JPanel getControlPanel() {
        if (this.controlPanel == null) {
            this.controlPanel = new JPanel();
            this.controlPanel.setLayout(new FlowLayout());
            this.controlPanel.add((Component)this.getCloseButton(), null);
        }
        return this.controlPanel;
    }

    private JButton getCloseButton() {
        if (this.closeButton == null) {
            this.closeButton = new JButton();
            this.closeButton.setText("button.close");
            this.closeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ExamplesInstallerDialog.this.performClose();
                }
            });
            this.displayer.register(this.closeButton, "button.close");
        }
        return this.closeButton;
    }

    void performClose() {
        this.setVisible(false);
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
            gridBagConstraints13.gridwidth = 3;
            gridBagConstraints13.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints13.gridx = 0;
            gridBagConstraints13.gridy = 0;
            gridBagConstraints13.weightx = 10.0;
            gridBagConstraints13.fill = 2;
            gridBagConstraints13.anchor = 10;
            this.archiveInfoLabel = new JLabel();
            this.archiveInfoLabel.setFont(XissWebUI.labelPlainFont);
            if (internetProblem) {
                StringBuffer buff = new StringBuffer();
                buff.append("<html>");
                buff.append(this.displayer.getString("archive.info.label")).append(" \"").append(ExamplesInstallerDialog.getExamplesArchiveName());
                buff.append("\".").append("<br><b><i>");
                buff.append(this.displayer.getString("no.internet"));
                buff.append("</i></b></html>");
                this.archiveInfoLabel.setText(buff.toString());
                this.archiveInfoLabel.setIcon(XissWebUI.getIcon(WARN_ICON));
            } else {
                this.archiveInfoLabel.setText(this.displayer.getString("archive.info.label") + " \"" + ExamplesInstallerDialog.getExamplesArchiveName() + "\".");
            }
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridheight = 1;
            gridBagConstraints3.fill = 1;
            gridBagConstraints3.gridwidth = 3;
            gridBagConstraints3.gridy = 3;
            GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
            gridBagConstraints21.gridx = 2;
            gridBagConstraints21.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints21.gridy = 2;
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.fill = 2;
            gridBagConstraints12.gridy = 2;
            gridBagConstraints12.weightx = 1.0;
            gridBagConstraints12.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints12.gridx = 1;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.gridy = 1;
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 0;
            gridBagConstraints11.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints11.anchor = 17;
            gridBagConstraints11.gridy = 2;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints1.gridheight = 1;
            gridBagConstraints1.gridwidth = 3;
            gridBagConstraints1.gridy = 5;
            this.infoLabel = new JLabel();
            this.infoLabel.setText("lable.info");
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.gridy = 4;
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new GridBagLayout());
            this.mainPanel.add((Component)this.archiveInfoLabel, gridBagConstraints13);
            this.mainPanel.add((Component)this.getLocalInstallRadioButton(), gridBagConstraints11);
            this.mainPanel.add((Component)this.getArchiveTextField(), gridBagConstraints12);
            this.mainPanel.add((Component)this.getOpenArchiveButton(), gridBagConstraints21);
            this.mainPanel.add((Component)this.getUploadAndInstallRadioButton(), gridBagConstraints2);
            this.mainPanel.add((Component)this.getProgressControlPanel(), gridBagConstraints3);
            this.mainPanel.add((Component)this.getProgressBar(), gridBagConstraints);
            this.mainPanel.add((Component)this.infoLabel, gridBagConstraints1);
        }
        return this.mainPanel;
    }

    private JProgressBar getProgressBar() {
        if (this.progressBar == null) {
            this.progressBar = new JProgressBar();
            this.progressBar.setMaximum(PROGRESS_MAX);
            this.progressBar.setPreferredSize(new Dimension(250, 14));
        }
        return this.progressBar;
    }

    private JRadioButton getLocalInstallRadioButton() {
        if (this.localInstallRadioButton == null) {
            this.localInstallRadioButton = new JRadioButton();
            this.localInstallRadioButton.setText("radio.local.install");
            this.localInstallRadioButton.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    ExamplesInstallerDialog.this.onRadioInstallRadioButtonStateChanged();
                }
            });
            this.displayer.register(this.localInstallRadioButton, "radio.local.install");
        }
        return this.localInstallRadioButton;
    }

    void onRadioInstallRadioButtonStateChanged() {
        this.archiveTextField.setEnabled(this.localInstallRadioButton.isSelected());
        this.openArchiveButton.setEnabled(this.localInstallRadioButton.isSelected());
    }

    private JRadioButton getUploadAndInstallRadioButton() {
        if (this.uploadAndInstallRadioButton == null) {
            this.uploadAndInstallRadioButton = new JRadioButton();
            this.uploadAndInstallRadioButton.setText("radio.upload.install");
            this.uploadAndInstallRadioButton.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    ExamplesInstallerDialog.this.onUploadAndInstallRadioButtonStateChanged();
                }
            });
            this.displayer.register(this.uploadAndInstallRadioButton, "radio.upload.install");
        }
        return this.uploadAndInstallRadioButton;
    }

    void onUploadAndInstallRadioButtonStateChanged() {
        this.startButton.setEnabled(this.uploadAndInstallRadioButton.isSelected());
    }

    private JTextField getArchiveTextField() {
        if (this.archiveTextField == null) {
            this.archiveTextField = new JTextField();
            this.archiveTextField.setTransferHandler(new FileTransferHandler(this));
        }
        return this.archiveTextField;
    }

    private JButton getOpenArchiveButton() {
        if (this.openArchiveButton == null) {
            this.openArchiveButton = new JButton();
            this.openArchiveButton.setText("...");
            this.openArchiveButton.setMargin(new Insets(2, 2, 2, 2));
            this.openArchiveButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ExamplesInstallerDialog.this.performOpenArchive();
                }
            });
        }
        return this.openArchiveButton;
    }

    void performOpenArchive() {
        int result = this.getArchiveFileChooser().showOpenDialog(this);
        if (result == 0) {
            this.archiveExempleChoosed(this.archiveFileChooser.getSelectedFile());
        }
    }

    void archiveExempleChoosed(File file) {
        this.archive = file;
        this.archiveTextField.setText(this.archive.getAbsolutePath());
        this.startButton.setEnabled(true);
    }

    private ButtonGroup getButtonGroup() {
        if (this.buttonGroup == null) {
            this.buttonGroup = new ButtonGroup();
            this.buttonGroup.add(this.getLocalInstallRadioButton());
            this.buttonGroup.add(this.getUploadAndInstallRadioButton());
        }
        return this.buttonGroup;
    }

    private JPanel getProgressControlPanel() {
        if (this.progressControlPanel == null) {
            this.progressControlPanel = new JPanel();
            this.progressControlPanel.setLayout(new FlowLayout());
            this.progressControlPanel.add((Component)this.getStartButton(), null);
            this.progressControlPanel.add((Component)this.getPauseButton(), null);
            this.progressControlPanel.add((Component)this.getStopButton(), null);
        }
        return this.progressControlPanel;
    }

    private ActiveLabel getStartButton() {
        if (this.startButton == null) {
            this.startButton = new ActiveLabel();
            this.startButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ExamplesInstallerDialog.this.onStartPerformed();
                }
            });
            this.startButton.setEnabled(false);
            this.displayer.registerToolTip(this.startButton, "button.start");
            this.startButton.setIcon(XissWebUI.getIcon(START_ICON));
        }
        return this.startButton;
    }

    void onStartPerformed() {
        this.localInstallRadioButton.setEnabled(false);
        this.uploadAndInstallRadioButton.setEnabled(false);
        if (this.localInstallRadioButton.isSelected()) {
            this.runIntallation();
        } else {
            this.uploadAndInstall();
        }
    }

    private ActiveLabel getPauseButton() {
        if (this.pauseButton == null) {
            this.pauseButton = new ActiveLabel();
            this.pauseButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ExamplesInstallerDialog.this.onPausePerformed();
                }
            });
            this.pauseButton.setEnabled(false);
            this.displayer.registerToolTip(this.pauseButton, "button.pause");
            this.pauseButton.setIcon(XissWebUI.getIcon(PAUSE_ICON));
        }
        return this.pauseButton;
    }

    void onPausePerformed() {
        this.displayInfo("install.pause");
        this.installer.interrupt(false);
        this.pauseButton.setEnabled(false);
        this.startButton.setEnabled(true);
    }

    private ActiveLabel getStopButton() {
        if (this.stopButton == null) {
            this.stopButton = new ActiveLabel();
            this.stopButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ExamplesInstallerDialog.this.onStopPerformed();
                }
            });
            this.stopButton.setEnabled(false);
            this.displayer.registerToolTip(this.stopButton, "button.stop");
            this.stopButton.setIcon(XissWebUI.getIcon(STOP_ICON));
        }
        return this.stopButton;
    }

    void onStopPerformed() {
        this.worker.interrupt(true);
        if (this.worker == this.installer) {
            try {
                this.unziper.stop();
            }
            catch (IOException iOException) {}
        } else if (this.worker == this.swingUploader) {
            this.uploader.stop();
        }
        this.worker = null;
        FileHelper.recursDelete(Main.getExemplesDir());
        this.stopButton.setEnabled(false);
        this.pauseButton.setEnabled(false);
        this.closeButton.setEnabled(true);
    }

    private JFileChooser getArchiveFileChooser() {
        if (this.archiveFileChooser == null) {
            this.archiveFileChooser = new JFileChooser();
            this.archiveFileChooser.setAcceptAllFileFilterUsed(false);
            this.archiveFileChooser.setFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory() || ExamplesInstallerDialog.isExampleArchive(file);
                }

                public String getDescription() {
                    return ExamplesInstallerDialog.getExamplesArchiveName();
                }
            });
        }
        return this.archiveFileChooser;
    }

    public boolean accept(File arg0) {
        return false;
    }
}

