/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.editor.font;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.xissweb.gui.editor.font.CssFontHelper;
import org.xissweb.gui.editor.font.FontTreeCellRenderer;
import org.xissweb.gui.editor.font.FontTreeModel;
import org.xissweb.gui.util.tree.TreeHelper;
import org.xissweb.i18n.TextDisplayManager;
import org.xissweb.i18n.TextDisplayer;
import org.xissweb.prefs.ui.ComponentConfigurator;
import org.xissweb.project.SlideShowProperties;

public class CssFontChooser
extends JDialog
implements TreeSelectionListener {
    private static final long serialVersionUID = 625639074507220132L;
    private FontTreeModel treeModel;
    private String[] names;
    private TextDisplayer textDisplayer;
    private JPanel jContentPane = null;
    private JScrollPane treeScrollPane = null;
    private JTextField sampleTextTextField = null;
    private JTree fontTree = null;
    private JPanel footerPanel = null;
    private JButton okButton = null;
    private JButton abortButton = null;
    private JLabel selectionLabel = null;
    static /* synthetic */ Class class$org$xissweb$gui$editor$font$CssFontChooser;

    public CssFontChooser(Frame owner) {
        super(owner);
        this.setModal(true);
        this.textDisplayer = TextDisplayManager.createTextDisplayFor(class$org$xissweb$gui$editor$font$CssFontChooser == null ? (class$org$xissweb$gui$editor$font$CssFontChooser = CssFontChooser.class$("org.xissweb.gui.editor.font.CssFontChooser")) : class$org$xissweb$gui$editor$font$CssFontChooser);
        this.initialize();
        ComponentConfigurator.configure((Component)this);
    }

    public String[] getNames() {
        return this.names;
    }

    public void setNames(String[] names) {
        this.names = new String[names.length];
        DefaultMutableTreeNode n = null;
        for (int i = 0; i < names.length; ++i) {
            this.names[i] = names[i].charAt(0) == '\"' ? names[i].substring(1, names[i].length() - 1) : names[i];
            if (n != null) continue;
            n = this.treeModel.getNodeFromUserObject(this.names[i]);
        }
        if (n != null) {
            TreeHelper.selectNode(this.fontTree, n);
        }
    }

    public void valueChanged(TreeSelectionEvent event) {
        TreePath path = this.fontTree.getSelectionPath();
        this.names = new String[path.getPathCount() - 1];
        int j = 0;
        for (int i = path.getPathCount() - 1; i > 0; --i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getPath()[i];
            String n = (String)node.getUserObject();
            this.names[j++] = n.indexOf(" ") >= 0 ? '\"' + n + '\"' : n;
        }
        Font f = CssFontHelper.getFont(this.names).deriveFont(0, 14.0f);
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < this.names.length; ++i) {
            buff.append(this.names[i]);
            if (i >= this.names.length - 1) continue;
            buff.append(", ");
        }
        this.selectionLabel.setText(buff.toString());
        this.sampleTextTextField.setFont(f);
        this.sampleTextTextField.repaint();
    }

    private void initialize() {
        this.setSize(300, 200);
        this.setSize(new Dimension(319, 240));
        this.setContentPane(this.getJContentPane());
        this.textDisplayer.registerTitle(this, "title");
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getTreeScrollPane(), "Center");
            this.jContentPane.add((Component)this.getSampleTextTextField(), "North");
            this.jContentPane.add((Component)this.getFooterPanel(), "South");
        }
        return this.jContentPane;
    }

    private JScrollPane getTreeScrollPane() {
        if (this.treeScrollPane == null) {
            this.treeScrollPane = new JScrollPane();
            this.treeScrollPane.setViewportView(this.getFontTree());
        }
        return this.treeScrollPane;
    }

    private JTextField getSampleTextTextField() {
        if (this.sampleTextTextField == null) {
            this.sampleTextTextField = new JTextField();
            this.textDisplayer.register(this.sampleTextTextField, "text.sample");
            this.sampleTextTextField.setPreferredSize(new Dimension(4, 25));
            this.sampleTextTextField.setFont(new Font("Dialog", 0, 14));
        }
        return this.sampleTextTextField;
    }

    private JTree getFontTree() {
        if (this.fontTree == null) {
            this.fontTree = new JTree();
            this.treeModel = new FontTreeModel(new File(SlideShowProperties.getRsrcDir(), "fonts/fonts.xml"));
            this.fontTree.setModel(this.treeModel);
            this.fontTree.setCellRenderer(new FontTreeCellRenderer());
            this.fontTree.setLocation(new Point(2, 2));
            this.fontTree.setRootVisible(false);
            this.fontTree.addTreeSelectionListener(this);
            TreeHelper.expandAll(this.fontTree);
        }
        return this.fontTree;
    }

    private JPanel getFooterPanel() {
        if (this.footerPanel == null) {
            this.selectionLabel = new JLabel();
            this.selectionLabel.setFont(new Font("Dialog", 0, 12));
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setAlignment(2);
            this.footerPanel = new JPanel();
            this.footerPanel.setLayout(flowLayout);
            this.footerPanel.add((Component)this.selectionLabel, null);
            this.footerPanel.add((Component)this.getOkButton(), null);
            this.footerPanel.add((Component)this.getAbortButton(), null);
        }
        return this.footerPanel;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.textDisplayer.register(this.okButton, "ok.button");
            this.okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    CssFontChooser.this.setVisible(false);
                }
            });
        }
        return this.okButton;
    }

    private JButton getAbortButton() {
        if (this.abortButton == null) {
            this.abortButton = new JButton();
            this.textDisplayer.register(this.abortButton, "abort.button");
            this.abortButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    CssFontChooser.this.doAbort();
                }
            });
        }
        return this.abortButton;
    }

    void doAbort() {
        this.names = null;
        this.setVisible(false);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

