/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.content.links;

import java.awt.Component;
import java.io.File;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import org.xissweb.data.layout.SlideShowLayoutInfo;
import org.xissweb.gui.XissWebUI;
import org.xissweb.gui.util.LabelCellRenderer;
import org.xissweb.project.links.LinkedSlideshow;

public class LinkedSlideshowTreeCellRenderer
extends LabelCellRenderer
implements TreeCellRenderer {
    private static final long serialVersionUID = -5723368320180522077L;
    private static final String LAYOUT_ICON = "/images/file/layout.png";
    private static final String LAYOUT_ANIM_ICON = "/images/layout/layoutAnim.png";
    private static final String CONTENT_ICON = "/images/file/content.png";
    private static final String LINK_ICON = "/images/links/next-previous.png";
    private static final String LINKS_WARN_ICON = "/images/links/next-previous-warn.png";

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        this.setText("");
        if (!node.isRoot()) {
            if (node.getUserObject() instanceof LinkedSlideshow) {
                LinkedSlideshow l = (LinkedSlideshow)node.getUserObject();
                this.setIcon(XissWebUI.getIcon(l.isConsistent() ? LINK_ICON : LINKS_WARN_ICON));
            } else if (node.getUserObject() instanceof SlideShowLayoutInfo) {
                SlideShowLayoutInfo lInfo = (SlideShowLayoutInfo)node.getUserObject();
                this.setText(tree.convertValueToText(lInfo.getFile().getParentFile().getName(), sel, expanded, leaf, row, hasFocus));
                this.setIcon(XissWebUI.getIcon(lInfo.getAnimation() != null ? LAYOUT_ANIM_ICON : LAYOUT_ICON));
            } else if (node.getUserObject() instanceof File) {
                File dir = (File)node.getUserObject();
                this.setText(tree.convertValueToText(dir.getName(), sel, expanded, leaf, row, hasFocus));
                this.setIcon(XissWebUI.getIcon(CONTENT_ICON));
            } else {
                this.setText(tree.convertValueToText(node.toString(), sel, expanded, leaf, row, hasFocus));
                this.setIcon(null);
            }
        }
        return this;
    }
}

