/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import org.xissweb.gui.Main;
import org.xissweb.gui.XissEditorManager;
import org.xissweb.gui.XissWeb;
import org.xissweb.gui.editor.Editor;
import org.xissweb.gui.editor.EditorManager;
import org.xissweb.gui.editor.EditorsContainer;
import org.xissweb.gui.tab.CloseTabbedPane;
import org.xissweb.i18n.TextDisplayManager;
import org.xissweb.i18n.TextDisplayer;
import org.xissweb.produce.DirectoryActionEvent;
import org.xissweb.produce.links.LinkChangeEvent;
import org.xissweb.produce.links.LinkChangeListener;
import org.xissweb.produce.sow.SowEventListener;
import org.xissweb.project.SlideShowProject;

public class XissEditorsContainer
implements EditorsContainer,
SowEventListener,
LinkChangeListener {
    private static final String changeMark = "*";
    EditorManager manager;
    private XissWeb guiEditorsContainer;
    private List editors;
    private JMenuItem[] extraItems = null;
    private JPopupMenu editorsContainerPopupMenu = null;
    private JMenuItem closeCurrentMenuItem = null;
    private JMenuItem closeOthersMenuItem = null;
    private JMenuItem closeAllMenuItem = null;
    private JSeparator saveCloseSeparator = null;
    private JMenuItem saveEditorsContainerMenuItem = null;
    private JMenuItem cancelEditorsContainerMenuItem = null;
    private JSeparator currentEditorSeparator = null;
    private TextDisplayer textDisplayer;

    public XissEditorsContainer(EditorManager manager) {
        this.manager = manager;
        this.editors = new ArrayList();
        this.textDisplayer = TextDisplayManager.createTextDisplayFor(this.getClass());
    }

    public Component getGuiComponent() {
        return this.guiEditorsContainer;
    }

    public void setGuiComponent(Component gui) {
        this.guiEditorsContainer = (XissWeb)gui;
    }

    public void addEditor(Editor editor) {
        this.editors.add(editor);
        this.addEditorInternal(editor);
        this.guiEditorsContainer.editorsAdded();
    }

    public void addEditors(Editor[] editors) {
        for (int i = 0; i < editors.length; ++i) {
            this.editors.add(editors[i]);
            this.addEditorInternal(editors[i]);
        }
        this.guiEditorsContainer.editorsAdded();
    }

    public List getEditors() {
        return this.editors;
    }

    public boolean hasEditors() {
        return !this.editors.isEmpty();
    }

    public int editorsCount() {
        return this.editors.size();
    }

    public void removeEditor(Editor editor) {
        this.editors.remove(editor);
        this.guiEditorsContainer.removeEditorInternal(editor);
    }

    public Editor getEditor(Object document) {
        Editor editor = null;
        Iterator i = this.editors.iterator();
        while (i.hasNext() && editor == null) {
            Editor e = (Editor)i.next();
            if (!e.getEditedDocument().equals(document)) continue;
            editor = e;
        }
        return editor;
    }

    public Editor getEditorAt(int index) {
        return (Editor)this.editors.get(index);
    }

    public int getEditorIndex(Editor editor) {
        return this.editors.indexOf(editor);
    }

    public void editorStatusChange(Editor editor, int status) {
        this.editorStatusChangeInternal(editor, status);
    }

    public void setCurrentEditor(Editor editor) {
        int index = this.editors.indexOf(editor);
        if (index >= 0) {
            this.setCurrentEditorInternal(index);
            ((XissEditorManager)Main.get().getEditorManager()).updatePreferences();
        }
    }

    public Editor getCurrentEditor() {
        int index = this.getCurrentEditorInternal();
        if (index >= 0) {
            return (Editor)this.editors.get(index);
        }
        return null;
    }

    public int countModified() {
        int nbModif = 0;
        Iterator i = this.editors.iterator();
        while (i.hasNext()) {
            Editor e = (Editor)i.next();
            if (!e.hasDocumentModified()) continue;
            ++nbModif;
        }
        return nbModif;
    }

    private int getCurrentEditorInternal() {
        return this.guiEditorsContainer.getEditorsTabbedPane().getSelectedIndex();
    }

    private void setCurrentEditorInternal(int editorIndex) {
        this.guiEditorsContainer.getEditorsTabbedPane().setSelectedIndex(editorIndex);
    }

    private int addEditorInternal(Editor editor) {
        CloseTabbedPane tabbedPane = this.guiEditorsContainer.getEditorsTabbedPane();
        String name = editor.getDocumentName();
        if (name.length() > 25) {
            String displayName = this.documentDisplayName(editor);
            Component c = editor.getEditorGuiComponent();
            tabbedPane.addTab(displayName, c, editor.getIcon());
            tabbedPane.setToolTipTextAt(tabbedPane.indexOfComponent(c), name);
        } else {
            tabbedPane.addTab(name, editor.getEditorGuiComponent(), editor.getIcon());
        }
        int edIndex = tabbedPane.indexOfComponent(editor.getEditorGuiComponent());
        tabbedPane.setBackgroundAt(edIndex, Color.white);
        return edIndex;
    }

    private String documentDisplayName(Editor editor) {
        String name;
        String displayName = name = editor.getDocumentName();
        if (name.length() > 25) {
            int indexL = name.lastIndexOf(92);
            if (indexL > 0) {
                int index = name.lastIndexOf(92, indexL - 1);
                if (index > 0 && (index = (displayName = name.substring(index + 1)).lastIndexOf(46)) > 0) {
                    displayName = "..." + displayName.substring(0, index);
                }
            } else {
                displayName = name.substring(0, 11) + "..." + name.substring(name.length() - 11);
            }
        }
        return displayName;
    }

    private void editorStatusChangeInternal(Editor editor, int status) {
        CloseTabbedPane tabbedPane = this.guiEditorsContainer.getEditorsTabbedPane();
        if (status != 4 && status != 0) {
            int index = tabbedPane.indexOfComponent(editor.getEditorGuiComponent());
            if (editor.getEditedDocument() instanceof File) {
                this.guiEditorsContainer.getFileManager().fileInEditionChanged(editor, status);
            }
            if (index >= 0) {
                switch (status) {
                    case 5: 
                    case 6: {
                        tabbedPane.setExtraIconAt(index, editor.getIcon());
                        ((XissEditorManager)this.manager).displayErrorMessage();
                        break;
                    }
                    case 1: {
                        tabbedPane.setTitleAt(index, changeMark + this.documentDisplayName(editor));
                        break;
                    }
                    case 2: 
                    case 3: {
                        File f;
                        tabbedPane.setTitleAt(index, this.documentDisplayName(editor));
                        Object doc = editor.getEditedDocument();
                        if (!(doc instanceof File) || !SlideShowProject.isLayoutFile(f = (File)doc) && !SlideShowProject.isContentFile(f)) break;
                        this.guiEditorsContainer.checkLinksActionEnabled();
                        this.guiEditorsContainer.updateLinkedSlideshowConsistencyStatus();
                        this.guiEditorsContainer.updateSelectedSlideshowDialog();
                    }
                }
            } else {
                System.out.println("Editor no found, status " + status + " " + editor);
            }
        }
        this.menuFileEnabled();
    }

    private void menuFileEnabled() {
        int nbModif = this.countModified();
        this.guiEditorsContainer.getSaveFileMenuItem().setEnabled(nbModif >= 1);
        this.guiEditorsContainer.getSaveAllFileMenuItem().setEnabled(nbModif >= 1);
        this.guiEditorsContainer.getCancelFileMenuItem().setEnabled(nbModif >= 1);
        this.guiEditorsContainer.getCloseFileMenuItem().setEnabled(this.hasEditors());
        this.guiEditorsContainer.getCloseAllFileMenuItem().setEnabled(this.hasEditors());
    }

    public void readingImage(DirectoryActionEvent event) {
    }

    public void imageReaded(DirectoryActionEvent event) {
    }

    public void slideshowContentCreated(DirectoryActionEvent event) {
    }

    public void slideshowContentReaded(DirectoryActionEvent event) {
    }

    public void copyingContentDir(DirectoryActionEvent event) {
    }

    public void writingSlideshowContent(DirectoryActionEvent event) {
    }

    public void slideshowContentWroten(DirectoryActionEvent event) {
        Editor editor = this.getEditor(event.getFileOrDir());
        if (editor != null) {
            editor.reload();
        }
    }

    public void visitingInDirectory(DirectoryActionEvent event) {
    }

    public void inDirectoryVisited(DirectoryActionEvent event) {
    }

    public void visitingOutDirectory(DirectoryActionEvent event) {
    }

    public void outDirectoryVisited(DirectoryActionEvent event) {
    }

    public void copyingImage(DirectoryActionEvent event) {
    }

    public void resizingImage(DirectoryActionEvent event) {
    }

    public void imageResized(DirectoryActionEvent event) {
    }

    public void linkChanged(LinkChangeEvent event) {
    }

    public void contentFileSaved(LinkChangeEvent event) {
        Editor editor = this.getEditor(event.getSlideShowContentFile());
        if (editor != null) {
            editor.reload();
        }
    }

    public JPopupMenu getPopupMenu() {
        return this.getEditorsContainerPopupMenu();
    }

    private JPopupMenu getEditorsContainerPopupMenu() {
        int i;
        Editor e;
        if (this.editorsContainerPopupMenu == null) {
            this.editorsContainerPopupMenu = new JPopupMenu();
            this.editorsContainerPopupMenu.add(this.getSaveEditorsContainerMenuItem());
            this.editorsContainerPopupMenu.add(this.getCancelEditorsContainerMenuItem());
            this.editorsContainerPopupMenu.add(this.getSaveCloseSeparator());
            this.editorsContainerPopupMenu.add(this.getCloseCurrentMenuItem());
            this.editorsContainerPopupMenu.add(this.getCloseOthersMenuItem());
            this.editorsContainerPopupMenu.add(this.getCloseAllMenuItem());
        }
        this.saveEditorsContainerMenuItem.setVisible(!(e = this.getCurrentEditor()).isReadOnly());
        this.saveEditorsContainerMenuItem.setEnabled(e != null && e.hasDocumentModified());
        this.cancelEditorsContainerMenuItem.setVisible(!e.isReadOnly());
        this.cancelEditorsContainerMenuItem.setEnabled(e != null && e.hasDocumentModified());
        this.saveCloseSeparator.setVisible(!e.isReadOnly());
        this.closeCurrentMenuItem.setEnabled(e != null);
        this.closeOthersMenuItem.setEnabled(this.editorsCount() > 1);
        this.closeAllMenuItem.setEnabled(this.hasEditors());
        if (this.extraItems != null) {
            this.editorsContainerPopupMenu.remove(this.getCurrentEditorSeparator());
            for (i = 0; i < this.extraItems.length; ++i) {
                this.editorsContainerPopupMenu.remove(this.extraItems[i]);
            }
        }
        this.extraItems = e.getMenuItems();
        if (this.extraItems != null) {
            this.editorsContainerPopupMenu.add(this.getCurrentEditorSeparator());
            for (i = 0; i < this.extraItems.length; ++i) {
                this.editorsContainerPopupMenu.add(this.extraItems[i]);
            }
        }
        return this.editorsContainerPopupMenu;
    }

    private JMenuItem getSaveEditorsContainerMenuItem() {
        if (this.saveEditorsContainerMenuItem == null) {
            this.saveEditorsContainerMenuItem = new JMenuItem();
            this.textDisplayer.register(this.saveEditorsContainerMenuItem, "menu.editor.save");
            this.saveEditorsContainerMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
            this.saveEditorsContainerMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    XissEditorsContainer.this.manager.saveCurrentEditor();
                }
            });
        }
        return this.saveEditorsContainerMenuItem;
    }

    private JMenuItem getCancelEditorsContainerMenuItem() {
        if (this.cancelEditorsContainerMenuItem == null) {
            this.cancelEditorsContainerMenuItem = new JMenuItem();
            this.textDisplayer.register(this.cancelEditorsContainerMenuItem, "menu.editor.cancel");
            this.cancelEditorsContainerMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    XissEditorsContainer.this.manager.cancelCurrentEditor();
                }
            });
        }
        return this.cancelEditorsContainerMenuItem;
    }

    private JSeparator getSaveCloseSeparator() {
        if (this.saveCloseSeparator == null) {
            this.saveCloseSeparator = new JSeparator();
        }
        return this.saveCloseSeparator;
    }

    private JSeparator getCurrentEditorSeparator() {
        if (this.currentEditorSeparator == null) {
            this.currentEditorSeparator = new JSeparator();
        }
        return this.currentEditorSeparator;
    }

    private JMenuItem getCloseCurrentMenuItem() {
        if (this.closeCurrentMenuItem == null) {
            this.closeCurrentMenuItem = new JMenuItem();
            this.closeCurrentMenuItem.setAccelerator(KeyStroke.getKeyStroke(87, 2));
            this.closeCurrentMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    XissEditorsContainer.this.manager.closeCurrentEditor();
                }
            });
            this.textDisplayer.register(this.closeCurrentMenuItem, "menu.editor.close");
        }
        return this.closeCurrentMenuItem;
    }

    private JMenuItem getCloseOthersMenuItem() {
        if (this.closeOthersMenuItem == null) {
            this.closeOthersMenuItem = new JMenuItem();
            this.closeOthersMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    XissEditorsContainer.this.manager.closeOtherEditors();
                }
            });
            this.textDisplayer.register(this.closeOthersMenuItem, "menu.editor.close.others");
        }
        return this.closeOthersMenuItem;
    }

    private JMenuItem getCloseAllMenuItem() {
        if (this.closeAllMenuItem == null) {
            this.closeAllMenuItem = new JMenuItem();
            this.closeAllMenuItem.setAccelerator(KeyStroke.getKeyStroke(87, 3));
            this.closeAllMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    XissEditorsContainer.this.manager.closeAllEditor();
                }
            });
            this.textDisplayer.register(this.closeAllMenuItem, "menu.editor.close.all");
        }
        return this.closeAllMenuItem;
    }
}

