/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.data.skin.xml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xissweb.data.skin.AnimationLoadInfo;
import org.xissweb.data.skin.ColorInfo;
import org.xissweb.data.skin.ColorsInfo;
import org.xissweb.data.skin.ComponentInfo;
import org.xissweb.data.skin.ComponentStyleInfo;
import org.xissweb.data.skin.FontInfo;
import org.xissweb.data.skin.ImageAreaInfo;
import org.xissweb.data.skin.LineInfo;
import org.xissweb.data.skin.LinkInfo;
import org.xissweb.data.skin.LocalIndexInfo;
import org.xissweb.data.skin.PageInfo;
import org.xissweb.data.skin.SlideShowSkinInfo;
import org.xissweb.data.skin.ThumbnailInfo;
import org.xissweb.data.skin.xml.SkinSchema;
import org.xissweb.xml.XMLHelper;

public class SkinSerializer
implements SkinSchema {
    private String encoding;

    public SkinSerializer() {
        this(null);
    }

    public SkinSerializer(String encoding) {
        this.encoding = encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void serialize(SlideShowSkinInfo skinInfo, String fileName) {
        this.serialize(skinInfo, new File(fileName));
    }

    public void serialize(SlideShowSkinInfo skinInfo, File file) {
        try {
            FileOutputStream out = new FileOutputStream(file);
            this.serialize(skinInfo, out);
            out.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void serialize(SlideShowSkinInfo skinInfo, OutputStream out) {
        Document outDoc = XMLHelper.createDocument();
        outDoc.appendChild(this.serialize(skinInfo, outDoc));
        if (this.encoding == null) {
            XMLHelper.serialize(outDoc, out);
        } else {
            XMLHelper.serialize(outDoc, out, this.encoding);
        }
    }

    public Node serialize(SlideShowSkinInfo skinInfo, Document document) {
        Element root = document.createElement("skin");
        root.setAttribute("name", skinInfo.getName());
        root.appendChild(this.serialize(skinInfo.getColors(), document));
        root.appendChild(this.serialize(skinInfo.getPage(), document));
        root.appendChild(this.serialize(skinInfo.getComponent(), document));
        return root;
    }

    private Node serialize(ComponentInfo componentInfo, Document document) {
        Element elt = document.createElement("component");
        elt.appendChild(this.serialize(componentInfo.getImageArea(), document));
        elt.appendChild(this.serialize(componentInfo.getThumbnail(), document));
        elt.appendChild(this.serialize(componentInfo.getCopyright(), "copyright", document));
        return elt;
    }

    private Node serialize(ComponentStyleInfo componentStyleInfo, String tagName, Document document) {
        Element elt = document.createElement(tagName);
        elt.appendChild(this.serialize(componentStyleInfo.getFont(), document));
        return elt;
    }

    private Node serialize(ThumbnailInfo thumbnailInfo, Document document) {
        Element elt = document.createElement("thumbnail");
        elt.appendChild(this.serialize(thumbnailInfo.getLink(), document));
        elt.appendChild(this.serialize(thumbnailInfo.getCurrent(), "current", document));
        return elt;
    }

    private Node serialize(ImageAreaInfo imageAreaInfo, Document document) {
        Element elt = document.createElement("image-area");
        elt.setAttribute("margin", Integer.toString(imageAreaInfo.getMargin()));
        elt.appendChild(this.serialize(imageAreaInfo.getColor(), "color", document));
        if (imageAreaInfo.getBackground() != null) {
            elt.appendChild(this.serialize(imageAreaInfo.getBackground(), "background", document));
        }
        elt.appendChild(this.serialize(imageAreaInfo.getFont(), document));
        elt.appendChild(this.serialize(imageAreaInfo.getMetadataFont(), document, "meta-data"));
        elt.appendChild(this.serialize(imageAreaInfo.getBorder(), "border", document));
        if (imageAreaInfo.getLocalIndex() != null) {
            elt.appendChild(this.serialize(imageAreaInfo.getLocalIndex(), document));
        }
        elt.appendChild(this.serialize(imageAreaInfo.getAnimationLoad(), document));
        return elt;
    }

    private Node serialize(AnimationLoadInfo animationLoad, Document document) {
        Element elt = document.createElement("animation");
        switch (animationLoad.getBackground()) {
            case 0: {
                elt.setAttribute("background", "white");
                break;
            }
            case 1: {
                elt.setAttribute("background", "black");
            }
        }
        switch (animationLoad.getIconStyle()) {
            case 0: {
                elt.setAttribute("icon-style", "default");
                break;
            }
            case 1: {
                elt.setAttribute("icon-style", "bar");
                break;
            }
            case 2: {
                elt.setAttribute("icon-style", "flower");
                break;
            }
            case 3: {
                elt.setAttribute("icon-style", "pike");
                break;
            }
            case 4: {
                elt.setAttribute("icon-style", "roller");
                break;
            }
            case 5: {
                elt.setAttribute("icon-style", "wheel-sthrobber");
                break;
            }
            case 6: {
                elt.setAttribute("icon-style", "earth");
                break;
            }
            case 7: {
                elt.setAttribute("icon-style", "movie");
            }
        }
        elt.setAttribute("opacity", Float.toString(animationLoad.getOpacity()));
        return elt;
    }

    private Node serialize(PageInfo pageInfo, Document document) {
        Element elt = document.createElement("page");
        elt.setAttribute("center", pageInfo.isCentered() ? "yes" : "no");
        elt.appendChild(this.serialize(pageInfo.getFont(), document));
        elt.appendChild(this.serialize(pageInfo.getLink(), document));
        return elt;
    }

    private Node serialize(LinkInfo linkInfo, Document document) {
        Element elt = document.createElement("link");
        elt.appendChild(this.serialize(linkInfo.getNormal(), "normal", document));
        elt.appendChild(this.serialize(linkInfo.getHover(), "hover", document));
        return elt;
    }

    private Node serialize(LineInfo lineInfo, String tagName, Document document) {
        Element elt = document.createElement(tagName);
        elt.setAttribute("thin", Integer.toString(lineInfo.getThin()));
        elt.setAttribute("line", lineInfo.getType());
        return elt;
    }

    private Node serialize(FontInfo fontInfo, Document document) {
        return this.serialize(fontInfo, document, "font");
    }

    private Node serialize(FontInfo fontInfo, Document document, String fontTag) {
        Element elt = document.createElement(fontTag);
        String[] names = fontInfo.getNames();
        StringBuffer name = new StringBuffer();
        for (int i = 0; i < names.length; ++i) {
            name.append(names[i]);
            if (i >= names.length - 1) continue;
            name.append(',');
        }
        elt.setAttribute("name", name.toString());
        elt.setAttribute("size", Integer.toString(fontInfo.getSize()));
        elt.setAttribute("unit", fontInfo.getUnit());
        elt.setAttribute("style", fontInfo.getStyle());
        elt.setAttribute("weight", fontInfo.getWeight());
        return elt;
    }

    private Node serialize(ColorsInfo colors, Document document) {
        Element elt = document.createElement("colors");
        elt.appendChild(this.serialize(colors.getBodyBackground(), "body-background", document));
        elt.appendChild(this.serialize(colors.getPageBackground(), "page-background", document));
        elt.appendChild(this.serialize(colors.getForeground(), "foreground", document));
        elt.appendChild(this.serialize(colors.getLinkForeground(), "link-foreground", document));
        elt.appendChild(this.serialize(colors.getLinkHover(), "link-hover", document));
        elt.appendChild(this.serialize(colors.getDisabledForeground(), "disabled-foreground", document));
        return elt;
    }

    private Node serialize(ColorInfo color, String tagName, Document document) {
        Element elt = document.createElement(tagName);
        elt.setAttribute("r", Integer.toString(color.getR()));
        elt.setAttribute("g", Integer.toString(color.getG()));
        elt.setAttribute("b", Integer.toString(color.getB()));
        return elt;
    }

    private Node serialize(LocalIndexInfo localIndex, Document document) {
        Element e = document.createElement("local-index");
        e.appendChild(this.serialize(localIndex.getBorderColor(), "border-color", document));
        e.appendChild(this.serialize(localIndex.getBackground(), "background", document));
        return e;
    }
}

