/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.data.layout.xml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xissweb.data.imetadata.ImageMetadataHelper;
import org.xissweb.data.layout.AnimationInfo;
import org.xissweb.data.layout.Arrangeable;
import org.xissweb.data.layout.ArrangementInfo;
import org.xissweb.data.layout.GoogleMapsInfo;
import org.xissweb.data.layout.ImageAreaInfo;
import org.xissweb.data.layout.LocalIndexGoogleMapsInfo;
import org.xissweb.data.layout.LocalIndexInfo;
import org.xissweb.data.layout.LocalIndexStandardInfo;
import org.xissweb.data.layout.LocationOnMapInfo;
import org.xissweb.data.layout.NavigationBarInfo;
import org.xissweb.data.layout.PageDecorationInfo;
import org.xissweb.data.layout.SkinInfo;
import org.xissweb.data.layout.SlideShowLayoutInfo;
import org.xissweb.data.layout.ThumbnailsInfo;
import org.xissweb.data.layout.ThumbnailsInfoInfo;
import org.xissweb.data.layout.TransitionInfo;
import org.xissweb.data.layout.xml.LayoutSchema;
import org.xissweb.xml.XMLHelper;

public class LayoutSerializer
implements LayoutSchema {
    private String encoding;

    public LayoutSerializer() {
        this(null);
    }

    public LayoutSerializer(String encoding) {
        this.encoding = encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void serialize(SlideShowLayoutInfo layoutInfo, String fileName) {
        this.serialize(layoutInfo, new File(fileName));
    }

    public void serialize(SlideShowLayoutInfo layoutInfo, File file) {
        try {
            FileOutputStream out = new FileOutputStream(file);
            this.serialize(layoutInfo, out);
            out.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void serialize(SlideShowLayoutInfo layoutInfo, OutputStream out) {
        Document outDoc = XMLHelper.createDocument();
        outDoc.appendChild(this.serialize(layoutInfo, outDoc));
        if (this.encoding == null) {
            XMLHelper.serialize(outDoc, out);
        } else {
            XMLHelper.serialize(outDoc, out, this.encoding);
        }
    }

    public Node serialize(SlideShowLayoutInfo layoutInfo, Document document) {
        AnimationInfo animation;
        SkinInfo skin;
        Element root = document.createElement("slideshow-layout");
        root.setAttribute("comment", layoutInfo.getComment());
        if (layoutInfo.hasPageWidth()) {
            root.setAttribute("page-width", Integer.toString(layoutInfo.getPageWidth()));
        }
        if ((skin = layoutInfo.getSkin()) != null) {
            root.appendChild(this.serialize(skin, document));
        }
        if ((animation = layoutInfo.getAnimation()) != null) {
            root.appendChild(this.serialize(animation, document));
        }
        root.appendChild(this.serialize(layoutInfo.getThumbnailsInfo(), document));
        PageDecorationInfo decoration = layoutInfo.getHeader();
        if (decoration != null) {
            root.appendChild(XMLHelper.copyDocumentNode(document, decoration.getContent().getDocumentElement()));
        }
        if ((decoration = layoutInfo.getLeftMargin()) != null) {
            root.appendChild(XMLHelper.copyDocumentNode(document, decoration.getContent().getDocumentElement()));
        }
        if ((decoration = layoutInfo.getRightMargin()) != null) {
            root.appendChild(XMLHelper.copyDocumentNode(document, decoration.getContent().getDocumentElement()));
        }
        if ((decoration = layoutInfo.getFooter()) != null) {
            root.appendChild(XMLHelper.copyDocumentNode(document, decoration.getContent().getDocumentElement()));
        }
        root.appendChild(this.serialize(layoutInfo.getArrangement(), document));
        return root;
    }

    private Node serialize(ArrangementInfo arrangement, Document document) {
        Element e = document.createElement("arrangement");
        e.setAttribute("orientation", arrangement.getOrientation());
        if (arrangement.hasWidth()) {
            e.setAttribute("width", Integer.toString(arrangement.getWidth()));
        }
        List l = arrangement.getComponents();
        Iterator i = l.iterator();
        while (i.hasNext()) {
            Arrangeable a = (Arrangeable)i.next();
            Node n = null;
            if (a instanceof NavigationBarInfo) {
                n = this.serialize((NavigationBarInfo)a, document);
            } else if (a instanceof ImageAreaInfo) {
                n = this.serialize((ImageAreaInfo)a, document);
            } else if (a instanceof ThumbnailsInfo) {
                n = this.serialize((ThumbnailsInfo)a, document);
            } else if (a instanceof ArrangementInfo) {
                n = this.serialize((ArrangementInfo)a, document);
            }
            e.appendChild(n);
        }
        return e;
    }

    private Node serialize(NavigationBarInfo a, Document document) {
        Element e = document.createElement("navigation-bar");
        e.setAttribute("type", a.getType());
        if (a.hasPrevious()) {
            e.appendChild(document.createElement("previous"));
        }
        if (a.hasBackward()) {
            e.appendChild(document.createElement("backward"));
        }
        if (a.hasInit()) {
            e.appendChild(document.createElement("init"));
        }
        if (a.hasForward()) {
            e.appendChild(document.createElement("forward"));
        }
        if (a.hasNext()) {
            e.appendChild(document.createElement("next"));
        }
        return e;
    }

    private Node serialize(ImageAreaInfo a, Document document) {
        Element emdata;
        Element e = document.createElement("image-area");
        e.setAttribute("width", Integer.toString(a.getWidth()));
        e.setAttribute("height", Integer.toString(a.getHeight()));
        Element c = document.createElement("comment");
        c.setAttribute("number-format", a.getNumberFormat());
        c.setAttribute("position", a.getCommentPosition());
        e.appendChild(c);
        if (a.hasImageLocationOnMap()) {
            Element child = document.createElement("image-location-on-map");
            this.serailize(a.getLocationOnMap(), child);
            e.appendChild(child);
        }
        if (a.hasLocalIndex()) {
            e.appendChild(this.serialize(a.getLocalIndexInfo(), document));
        }
        if (a.hasMetaData(0)) {
            emdata = document.createElement("meta-data");
            emdata.setAttribute("position", a.getMetaDataPosition());
            e.appendChild(emdata);
            this.serialize(a.getMetadata(0), ImageMetadataHelper.getImageMetaDataKeys(0), emdata, document);
        }
        if (a.hasMetaData(1)) {
            emdata = document.createElement("meta-data-film");
            this.serialize(a.getMetadata(1), ImageMetadataHelper.getImageMetaDataKeys(1), emdata, document);
            e.appendChild(emdata);
        }
        if (a.hasMetaData(2)) {
            emdata = document.createElement("meta-data-processing");
            this.serialize(a.getMetadata(2), ImageMetadataHelper.getImageMetaDataKeys(2), emdata, document);
            e.appendChild(emdata);
        }
        if (a.hasMetaData(3)) {
            emdata = document.createElement("meta-data-unknown");
            this.serialize(a.getMetadata(3), ImageMetadataHelper.getImageMetaDataKeys(3), emdata, document);
            e.appendChild(emdata);
        }
        return e;
    }

    private Node serialize(LocalIndexInfo localIndexInfo, Document document) {
        Element e = null;
        if (localIndexInfo instanceof LocalIndexStandardInfo) {
            LocalIndexStandardInfo iInfo = (LocalIndexStandardInfo)localIndexInfo;
            e = document.createElement("local-index-standard");
            e.setAttribute("description", XMLHelper.serialize(iInfo.isDisplayDescription()));
            e.setAttribute("explanation", XMLHelper.serialize(iInfo.isDisplayExplanation()));
        } else if (localIndexInfo instanceof LocalIndexGoogleMapsInfo) {
            LocalIndexGoogleMapsInfo iInfo = (LocalIndexGoogleMapsInfo)localIndexInfo;
            e = document.createElement("local-index-google-maps");
            this.serailize(iInfo.getGMapsInfo(), e);
        }
        e.setAttribute("width", Integer.toString(localIndexInfo.getWidth()));
        e.setAttribute("height", Integer.toString(localIndexInfo.getHeight()));
        return e;
    }

    private void serailize(LocationOnMapInfo locationOnMapInfo, Element e) {
        this.serialize(locationOnMapInfo.getTransition(), e, "fading");
        e.setAttribute("zoom-level", Integer.toString(locationOnMapInfo.getZoomLevel()));
        this.serailize(locationOnMapInfo.getMapInfo(), e);
    }

    private void serialize(TransitionInfo transition, Element e, String attribute) {
        switch (transition.getTransition()) {
            case 1: {
                e.setAttribute(attribute, "slow");
                break;
            }
            case 2: {
                e.setAttribute(attribute, "fast");
                break;
            }
            case 0: {
                e.setAttribute(attribute, "none");
                break;
            }
            default: {
                e.setAttribute(attribute, "medium");
            }
        }
    }

    private void serailize(GoogleMapsInfo gMapsInfo, Element e) {
        e.setAttribute("thumbnail-marker", XMLHelper.serialize(gMapsInfo.isThumbnailMarker()));
        e.setAttribute("map-type", Integer.toString(gMapsInfo.getMapTypeIndex()));
        e.setAttribute("map-control", XMLHelper.serialize(gMapsInfo.isMapTypeControl()));
        e.setAttribute("zoom-control", XMLHelper.serialize(gMapsInfo.isZoomControl()));
        e.setAttribute("overview-control", XMLHelper.serialize(gMapsInfo.isOverviewControl()));
    }

    private void serialize(boolean[] metadata, String[] keys, Node n, Document document) {
        for (int i = 0; i < metadata.length; ++i) {
            if (!metadata[i]) continue;
            n.appendChild(document.createElement(keys[i]));
        }
    }

    private Node serialize(ThumbnailsInfo a, Document document) {
        Element e = document.createElement("thumbnails");
        e.setAttribute("range", Integer.toString(a.getRange()));
        if (a.hasWidth()) {
            e.setAttribute("width", Integer.toString(a.getWidth()));
        }
        return e;
    }

    private Node serialize(ThumbnailsInfoInfo thumbnailsInfo, Document document) {
        Element e = document.createElement("thumbnails-info");
        e.setAttribute("quality", thumbnailsInfo.getQuality());
        e.setAttribute("shape", thumbnailsInfo.getShape());
        e.setAttribute("size", Integer.toString(thumbnailsInfo.getSize()));
        e.setAttribute("unit", thumbnailsInfo.getUnit());
        return e;
    }

    private Node serialize(AnimationInfo animation, Document document) {
        Element e = document.createElement("animation");
        String kind = "fade";
        switch (animation.getKind()) {
            case 2: {
                kind = "horizontal scroll";
                break;
            }
            case 3: {
                kind = "vertical scroll";
                break;
            }
            case 1: {
                kind = "superimposed fade";
            }
        }
        e.setAttribute("kind", kind);
        String waitScreenSize = "image area";
        switch (animation.getWaitScreenSize()) {
            case 2: {
                waitScreenSize = "full screen";
                break;
            }
            case 0: {
                waitScreenSize = "none";
            }
        }
        e.setAttribute("wait-screen-size", waitScreenSize);
        this.serialize(animation.getTransition(), e, "transition");
        e.setAttribute("control-panel", XMLHelper.serialize(animation.isControlPanel()));
        return e;
    }

    private Node serialize(SkinInfo skin, Document document) {
        Element e = document.createElement("skin");
        e.setAttribute("name", skin.getSkinName());
        if (skin.getPath() != null) {
            e.setAttribute("path", skin.getPath());
        }
        return e;
    }
}

