/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.data.content;

import org.xissweb.data.content.ContentInfoIdentifiable;

public class SlideShowRefInfo
implements ContentInfoIdentifiable {
    public static final String UNKNOWN_LINK = "UNKNOWN";
    public static final String NEXT_LINK = "NEXT";
    public static final String PREVIOUS_LINK = "PREVIOUS";
    private String href;
    private String text;
    private String way;

    public SlideShowRefInfo(String href, String text) {
        this(href, text, UNKNOWN_LINK);
    }

    public SlideShowRefInfo(String href, String text, String way) {
        this.href = href;
        this.text = text;
        this.way = way;
    }

    public boolean equals(Object o) {
        if (!(o instanceof SlideShowRefInfo)) {
            return false;
        }
        if (o == null) {
            return false;
        }
        SlideShowRefInfo link = (SlideShowRefInfo)o;
        return this.href.equals(link.getHref()) && this.text.equals(link.getText()) && this.way == link.getWay();
    }

    public Object getIdentifier() {
        return this.getHref() + ':' + this.way;
    }

    void setWay(String way) {
        this.way = way;
    }

    public String getWay() {
        return this.way;
    }

    public boolean isNextLink() {
        return this.way == NEXT_LINK;
    }

    public boolean isPreviousLink() {
        return this.way == PREVIOUS_LINK;
    }

    public boolean isUnknownLink() {
        return this.way == UNKNOWN_LINK;
    }

    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String toString() {
        return this.isNextLink() ? this.text + "-->\"" + this.href + '\"' : "\"" + this.href + "\"<--" + this.text;
    }
}

