/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.project;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import org.xissweb.file.FileHelper;
import org.xissweb.project.CategoryInfo;
import org.xissweb.project.PropertyInfo;
import org.xissweb.project.SlideShowPropInfo;
import org.xissweb.project.xml.PropertyInfoDeserializer;

public class SlideShowProperties {
    public static final String XISS_WEB_HOME_KEY = "XISSWEB_HOME";
    public static final String KEY_SRC_ROOT_DIR = "src.root.dir";
    public static final String KEY_BUILD_ROOT_DIR = "build.root.dircetory";
    public static final String KEY_IMAGE_DIRECTORY_FILTER = "image.directory.filter";
    public static final String KEY_IMAGE_DIRECTORY_NAME = "image.directory.name";
    public static final String KEY_MAX_IMAGE_SIZE = "max.image.size";
    public static final String KEY_MAX_IMAGE_WIDTH = "max.image.width";
    public static final String KEY_MAX_IMAGE_HEIGHT = "max.image.height";
    public static final String KEY_REPOSITORY_ROOT_DIR = "repository.root.dir";
    public static final String KEY_IMPORT_IMAGE = "import.image";
    public static final String KEY_REDUCTION_QUALITY = "reduction.quality";
    public static final String KEY_DEFAULT_LAYOUT_NAME = "default.layout.name";
    public static final String KEY_ORIGINE_ROOT_DIR = "origin.root.dir";
    public static final String KEY_EXCLUDE_DIRS = "exclude.dirs";
    public static final String KEY_EXCLUDE_FILES = "exclude.files";
    public static final String KEY_HTML_PATH = "html.path";
    public static final String KEY_INFO_FILE_PATH = "info.file.path";
    public static final String KEY_IMAGE_COMMENT_QUERY = "image.comment.query";
    public static final String KEY_SLIDESHOW_THEME_QUERY = "slideshow.theme.query";
    public static final String KEY_SLIDESHOW_TITLE_QUERY = "slideshow.title.query";
    public static final String KEY_SLIDESHOW_FINAL_LOCATION = "slideshow.final.location";
    public static final String KEY_SLIDESHOW_LANG = "slideshow.lang";
    public static final String KEY_SLIDESHOW_CHAR_ENCODING = "slideshow.encoding";
    public static final String KEY_SLIDESHOW_GLOBAL_INDEX = "slideshow.global.index";
    public static final String KEY_SLIDESHOW_INDEXES_SKIN = "slideshow.indexes.skin";
    public static final String KEY_SLIDESHOW_LOCAL_INDEX = "slideshow.local.index";
    public static final String KEY_SKIN_NAME = "skin.name";
    public static final String KEY_SKINS_PATH = "skins.path";
    public static final String KEY_SLIDESHOW_BUILT_WITH = "slideshow.built.with";
    public static final String KEY_SLIDESHOW_BUILT_ICON_WITH = "slideshow.built.with.icon";
    public static final String KEY_IMAGE_DEFAULT_COMMENT = "image.default.comment";
    public static final String KEY_THUMBNAIL_DIRECTORY_NAME = "thumbnail.directory.name";
    public static final String KEY_COPYRIGHT_YEARS = "copyright.years";
    public static final String KEY_COPYRIGHT_ORGANIZATION = "copyright.organization";
    public static final String KEY_GOOGLE_MAPS_KEY = "google.maps.key";
    public static final String KEY_DEFAULT_MAP_TYPE = "default.map.type";
    public static final String CATEGORY_KEY_DIRECTORY_IMAGE_PROPERTIES = "directory.image.properties";
    public static final String CATEGORY_KEY_BUILD_PROPERTIES = "build.properties";
    public static final String CATEGORY_KEY_REVERSE_PROPERTIES = "reverse.properties";
    public static final String ROOT_PROPERTIES = "properties";
    public static final String CATEGORY_KEY_MAIN_PROPERTIES = "main.properties";
    public static final String CATEGORY_KEY_REPOSITORY_PROPERTIES = "repository.properties";
    public static final String PROP_INFO_HTML_DECL = "<html><body style=\"font-family: arial, sans-serif; font-size: 10px; color: rgb(0,56,127); text-align: justify\">";
    public static final String PROP_INFO_HTML_END = "</body></html>";
    public static final String RSRC_DIRECTORY_NAME = "rsrc";
    public static final String XISSWEB_USRER_HOME_DIR = ".xissweb";
    public static final String XISSWEB_USRER_HOME_DIR_OLD = "xissweb";
    public static final String PREFERENCES_FILE_NAME = ".preferences";
    public static final String EXAMPLES_DIR_NAME = "examples";
    public static final String LAYOUTS_DIRECTORY_NAME = "layouts";
    public static final String DEFAULT_LAYOUT_NAME = "default";
    public static final String COMMON_SKIN_NAME = "common";
    public static final String COMMON_SKIN_IMAGES_NAME = "images";
    public static final String SIMPLE_SKIN_DIR_NAME = "simple.css";
    public static final String SIMPLE_SKIN_WAIT_ICONS_DIR_NAME = "wait";
    public static final String SKINS_DIR_NAME = "skins";
    public static final String SKIN_CSS_DIR_NAME = "css";
    public static final String SKIN_CSS_PAGE_FILE_NAME = "page.css";
    public static final String SKIN_CSS_COMP_FILE_NAME = "component.css";
    public static final String SKIN_SIMPLE_TEMPLATE_DIR = "simple.skin.template";
    public static final String SKIN_SIMPLE_XML_SCHEMA_NAME = "slideshow-skin.xsd";
    public static final String SKIN_SIMPLE_XML_FILE_NAME = "skin.xml";
    public static final String SKIN_IMAGE_DIR_NAME = "images";
    public static final String BUILT_WITH_ICON_DIR_NAME = "images";
    public static final String SKIN_XSL_DIR_NAME = "xsl";
    public static final String SKIN_JS_DIR_NAME = "js";
    public static final String TRANSFORMER_NAME = "slideshow2html.xsl";
    public static final String TRANSFORMER_INDEXES_NAME = "indexes2html.xsl";
    public static final String TRANSFORMER_SIMPLE_SKIN_PAGE = "page2css.xsl";
    public static final String TRANSFORMER_SIMPLE_SKIN_COMP = "component2css.xsl";
    public static final String CSS_SKIN_PAGE_FILE_NAME = "page.css";
    public static final String CSS_SKIN_COMP_FILE_NAME = "component.css";
    public static final String XSL_PARAM_ENCODING = "encoding";
    public static final String XSL_PARAM_CONTENT_FILE = "contentFile";
    public static final String XSL_PARAM_CURRENT_IMAGE = "currentImage";
    public static final String XSL_PARAM_LOCAL_INDEX = "localIndex";
    public static final String XSL_PARAM_WEB = "web";
    public static final String XSL_PARAM_PATH_TO_ROOT = "pathToRoot";
    public static final String XSL_PARAM_BUILT_WITH = "builtwith";
    public static final String XSL_PARAM_BUILT_WITH_ICON_PATH = "builtwith-icon-path";
    public static final String XSL_PARAM_BUILT_WITH_ICON_TYPE = "builtwith-icon-type";
    public static final String XSL_PARAM_SKIN_PATH = "skinPath";
    public static final String XSL_PARAM_LANGUAGE = "lang";
    public static final String XSL_PARAM_DATE = "date";
    public static final String XSL_PARAM_COPYRIGHT_YEARS = "copyright-years";
    public static final String XSL_PARAM_COPYRIGHT_ORGANIZATION = "copyright-organization";
    public static final String HTML_INDEX_FILE_NAME = "index.html";
    public static final String HTML_SLIDESHOW_FILE_NAME = "slideshow.html";
    public static final String HTML_EXTENTION = "html";
    public static final String DEFAULT_PROPERTIES_FILE_NAME = "xissweb.properties";
    public static final String CURRENT_IMAGE_LOCAL_INDEX = "index";
    public static final String JQUERY_RSRC_DIR_NAME = "jQuery";
    public static final String JQUERY_JS_FILE_NAME = "jquery.js";
    public static final String JQUERY_JS_FILE_PATH = "js/jquery.js";
    public static final String SLIDESHOW_JS_FILE_PATH = "js/slideshow.js";
    public static final String SLIDESHOW_IMAGES_XML_FILE_NAME = "images.xml";
    public static final String CONTENT_FOR_ANIMATION_XSL_NAME = "content4animation.xsl";
    public static final String CONTENT_FOR_ANIMATION_XSL_PARAM_LAYOUT = "layout";
    public static final String GOOGLE_MAPS_JS_FILE_PATH = "js/gmaps.js";
    public static final String GOOGLE_MAPS_BOX_JS_FILE_PATH = "js/mapBox.js";
    public static final String GOOGLE_MAPS_ICONS_JS_FILE_NAME = "gmapsIcons.js";
    public static final String GOOGLE_MAPS_MARKERS_FILE_NAME = "markers.xml";
    public static final String GOOGLE_MAPS_MARKERS_XSL_NAME = "contentToMarkers.xsl";
    public static final String GOOGLE_MAPS_MAP_ICON_XSL_NAME = "contentToMapIcons.xsl";
    public static final String GOOGLE_MAPS_XSL_ICON_MARKER_PARAM = "icon-marker";
    public static final String GOOGLE_MAPS_XSL_THUMB_DIR_PARAM = "thumbDir";
    public static final String GOOGLE_MAPS_XSL_ANIMATION_PARAM = "animation";
    public static final String GOOGLE_MAPS_RSRC_DIR_NAME = "google-maps";
    public static final String GOOGLE_MAPS_MARKERS_DIR_NAME = "markers";
    public static final String GOOGLE_MAPS_MARKER_H_FILE_NAME = "markerH.png";
    public static final String GOOGLE_MAPS_MARKER_V_FILE_NAME = "markerV.png";
    public static final String GOOGLE_MAPS_MARKER_H_SHADOW_FILE_NAME = "markerHshadow.png";
    public static final String GOOGLE_MAPS_MARKER_V_SHADOW_FILE_NAME = "markerVshadow.png";
    public static final int GOOGLE_MAPS_MARKER_MAX_DIM = 45;
    public static final int GOOGLE_MAPS_MARKER_MIN_DIM = 35;
    public static final int GOOGLE_MAPS_IMAGE_IN_MARKER_MAX = 39;
    public static final int GOOGLE_MAPS_IMAGE_IN_MARKER_MIN = 29;
    public static final String PARAM_GOOGLE_MAP_KEY = "googleMapsKey";
    private static final String LOCAL_INDEX_KEY_TRUE_VALUE = "true";
    public static final String BUILT_WITH_ICON = "BuiltWith.gif";
    public static final String BUILT_WITH_NEG_ICON = "negBuiltWith.gif";
    public static final String XISSWEB_SKINS_LOCATION = "rsrc";
    public static final String HTML_DATE_FORMAT_STRING = "yyyy-MM-dd'T'HH:mm:ssZ";
    public static final String BUILT_WITH_NONE = "none";
    public static final String BUILT_WITH_GLOBAL = "global index";
    public static final String BUILT_WITH_LOCAL = "local index";
    public static final String BUILT_WITH_INDEXES = "indexes";
    public static final String BUILT_WITH_ALL = "all";
    public static final String SLIDESHOW_ENCODING_ISO_8859_1 = "ISO-8859-1";
    public static final String SLIDESHOW_ENCODING_UTF_8 = "UTF-8";
    public static final String SLIDESHOW_ENCODING_DEFAULT = "UTF-8";
    public static final String BUILT_WITH_ICON_NORMAL = "normal";
    public static final String BUILT_WITH_ICON_NEGATIVE = "negative";
    public static final String IMAGE_DIRECTORY_FILTER_ONLY = "only";
    public static final String IMAGE_DIRECTORY_FILTER_EXCEPT = "except";
    public static final String WEB_LOCATION = "web";
    public static final String FILE_LOCATION = "file";
    public static final String SRC_ROOT_DIR = "src";
    public static final String BUILD_ROOT_DIR = "build";
    public static final String IMAGE_DIR_NAME = "photos";
    public static final String DEFAULT_IMPORT_IMAGE = Boolean.TRUE.toString();
    public static final String THUMBNAILS_DIR_NAME = "thumbnails";
    public static final String MARKERS_DIR_NAME = "markers";
    public static final String THUMBNAIL_SIZE = "70";
    public static final String MARKER_SIZE = "40";
    public static final String SLIDESHOW_CONTENT_FILE_NAME = "slideshow.xml";
    public static final String SLIDESHOW_CONTENT_SCHEMA_NAME = "slideshow-content.xsd";
    public static final String SLIDESHOW_LAYOUT_FILE_NAME = "layout.xml";
    public static final String SLIDESHOW_LAYOUT_SCHEMA_NAME = "slideshow-layout.xsd";
    public static final String GLOBAL_INDEX = Boolean.FALSE.toString();
    public static final String LOCAL_INDEX_KEY_DEFAULT_VALUE = Boolean.FALSE.toString();
    public static final String SKIN_NAME = "xissweb";
    public static final String LOW_RESIZE_QUALITY = "low";
    public static final String HIGH_RESIZE_QUALITY = "high";
    private static final String DEFAULT_REDUCTION_QUALITY = "high";
    private static Hashtable propertiesInfo = null;
    private static final Locale defaultLocale = Locale.getDefault();
    private Properties allProperties = new Properties();
    private File propertiesFile;
    static /* synthetic */ Class class$org$xissweb$project$SlideShowProperties;

    public void setValue(String propKey, String value) {
        if (value == null) {
            this.allProperties.remove(propKey);
            if (propKey.equals(KEY_SLIDESHOW_LANG)) {
                Locale.setDefault(defaultLocale);
            }
        } else {
            this.allProperties.put(propKey, value);
            if (propKey.equals(KEY_SLIDESHOW_LANG)) {
                Locale.setDefault(new Locale(value));
            }
        }
    }

    public static String getXissWebHome() {
        String result = System.getProperty(XISS_WEB_HOME_KEY);
        if (result == null) {
            result = ".";
        }
        return result;
    }

    public static File getXissWebHomeDir() {
        String result = System.getProperty(XISS_WEB_HOME_KEY);
        if (result == null) {
            result = System.getProperty("user.dir");
        }
        return new File(result);
    }

    public void loadProperties() {
        this.loadProperties(new File(System.getProperty("user.dir")));
    }

    public static final File getRsrcDir() {
        return new File(SlideShowProperties.getXissWebHome(), "rsrc");
    }

    public static File getDefaultPropertieFile() {
        return new File(SlideShowProperties.getRsrcDir(), DEFAULT_PROPERTIES_FILE_NAME);
    }

    public static void copyPropertiesFileFor(File projectDir) {
        File propFile = SlideShowProperties.getPropertiesFileFor(projectDir);
        FileHelper.copyFile((File)SlideShowProperties.getDefaultPropertieFile(), (File)propFile);
    }

    public static boolean propertiesExist(File projectDir) {
        return SlideShowProperties.getPropertiesFileFor(projectDir).exists();
    }

    private static File getPropertiesFileFor(File projectDir) {
        return new File(projectDir, DEFAULT_PROPERTIES_FILE_NAME);
    }

    public File getPropertiesFile() {
        return this.propertiesFile;
    }

    public void loadProperties(File projectDir) {
        this.propertiesFile = SlideShowProperties.getPropertiesFileFor(projectDir);
        try {
            FileInputStream in = new FileInputStream(this.propertiesFile);
            this.allProperties.load(in);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Locale.setDefault(new Locale(this.getSlideshowLanguage()));
    }

    public void saveProperties() throws FileNotFoundException, IOException {
        this.allProperties.store(new FileOutputStream(this.propertiesFile), "Xiss web project properties");
    }

    public static Hashtable getPropertiesInfo() {
        if (propertiesInfo == null) {
            File propFile = new File(SlideShowProperties.getRsrcDir(), "properties/decl/slideshow-properties.xml");
            propertiesInfo = new PropertyInfoDeserializer().deserialize(propFile);
        }
        return propertiesInfo;
    }

    public static final CategoryInfo getRootCategory() {
        return (CategoryInfo)SlideShowProperties.getPropertiesInfo().get(ROOT_PROPERTIES);
    }

    public static CategoryInfo getCategoryInfo(String prop) {
        return (CategoryInfo)SlideShowProperties.getPropertiesInfo().get(prop);
    }

    public static PropertyInfo getPropertyInfo(String prop) {
        return (PropertyInfo)SlideShowProperties.getPropertiesInfo().get(prop);
    }

    public static String getPropertyLabel(SlideShowPropInfo propInfo) {
        ResourceBundle bundle = ResourceBundle.getBundle((class$org$xissweb$project$SlideShowProperties == null ? (class$org$xissweb$project$SlideShowProperties = SlideShowProperties.class$("org.xissweb.project.SlideShowProperties")) : class$org$xissweb$project$SlideShowProperties).getName());
        return bundle.getString(propInfo.getKey());
    }

    public static final String getPropertyLabelTextInfo(SlideShowPropInfo propInfo) {
        ResourceBundle bundle = ResourceBundle.getBundle((class$org$xissweb$project$SlideShowProperties == null ? (class$org$xissweb$project$SlideShowProperties = SlideShowProperties.class$("org.xissweb.project.SlideShowProperties")) : class$org$xissweb$project$SlideShowProperties).getName() + "Info");
        return PROP_INFO_HTML_DECL + bundle.getString(propInfo.getKey()) + PROP_INFO_HTML_END;
    }

    public String getValue(String propKey) {
        return this.allProperties.getProperty(propKey, SlideShowProperties.getPropertyInfo(propKey).getDefaultValue());
    }

    public String getSrcRootDir() {
        return this.allProperties.getProperty(KEY_SRC_ROOT_DIR, SRC_ROOT_DIR);
    }

    public String getBuildRootDir() {
        return this.allProperties.getProperty(KEY_BUILD_ROOT_DIR, BUILD_ROOT_DIR);
    }

    public String getImageDirFilter() {
        String filter = IMAGE_DIRECTORY_FILTER_ONLY;
        String value = this.allProperties.getProperty(KEY_IMAGE_DIRECTORY_FILTER, IMAGE_DIRECTORY_FILTER_ONLY);
        if (value.equals(IMAGE_DIRECTORY_FILTER_EXCEPT)) {
            filter = IMAGE_DIRECTORY_FILTER_EXCEPT;
        }
        return filter;
    }

    public String getImageDirName() {
        return this.allProperties.getProperty(KEY_IMAGE_DIRECTORY_NAME, IMAGE_DIR_NAME);
    }

    public int getMaxImageSize() {
        String sSize = this.allProperties.getProperty(KEY_MAX_IMAGE_SIZE);
        if (sSize == null || sSize.length() == 0) {
            return 0;
        }
        return Integer.parseInt(sSize);
    }

    public int getMaxImageWidth() {
        String width = this.allProperties.getProperty(KEY_MAX_IMAGE_WIDTH);
        if (width == null || width.length() == 0 || width.equals("0")) {
            return this.getMaxImageSize();
        }
        return Integer.parseInt(width);
    }

    public int getMaxImageHeight() {
        String height = this.allProperties.getProperty(KEY_MAX_IMAGE_HEIGHT);
        if (height == null || height.length() == 0 || height.equals("0")) {
            return this.getMaxImageSize();
        }
        return Integer.parseInt(height);
    }

    public String getOriginalImageRepository() {
        String str = this.allProperties.getProperty(KEY_REPOSITORY_ROOT_DIR);
        if (str == null || str.length() == 0) {
            return null;
        }
        return str;
    }

    public boolean isImportImage() {
        boolean result = true;
        String imp = this.allProperties.getProperty(KEY_IMPORT_IMAGE, DEFAULT_IMPORT_IMAGE);
        if (imp.equals(Boolean.FALSE.toString())) {
            result = false;
        }
        return result;
    }

    public String getReductionQuality() {
        String quality = "high";
        if (this.allProperties.getProperty(KEY_REDUCTION_QUALITY, "high").equals(LOW_RESIZE_QUALITY)) {
            quality = LOW_RESIZE_QUALITY;
        }
        return quality;
    }

    public String getSlideshowContentFileName() {
        return SLIDESHOW_CONTENT_FILE_NAME;
    }

    public String getSlideshowLayoutFileName() {
        return SLIDESHOW_LAYOUT_FILE_NAME;
    }

    public String getDefaultLayoutName() {
        String lName = this.allProperties.getProperty(KEY_DEFAULT_LAYOUT_NAME, DEFAULT_LAYOUT_NAME);
        return lName;
    }

    public String getOriginRootDir() {
        String str = this.allProperties.getProperty(KEY_ORIGINE_ROOT_DIR);
        if (str == null || str.length() == 0) {
            return null;
        }
        return str;
    }

    public String getHtmlPath() {
        return this.allProperties.getProperty(KEY_HTML_PATH);
    }

    public String getInfoFilePath() {
        return this.allProperties.getProperty(KEY_INFO_FILE_PATH);
    }

    public String getImageCommentQuery() {
        return this.allProperties.getProperty(KEY_IMAGE_COMMENT_QUERY);
    }

    public String getSlideshowThemeQuery() {
        return this.allProperties.getProperty(KEY_SLIDESHOW_THEME_QUERY);
    }

    public String getSlideshowTitleQuery() {
        return this.allProperties.getProperty(KEY_SLIDESHOW_TITLE_QUERY);
    }

    public File getLayoutsBaseDir() {
        return new File(SlideShowProperties.getRsrcDir(), LAYOUTS_DIRECTORY_NAME);
    }

    public File getDefaultLayoutDir() {
        return new File(this.getLayoutsBaseDir(), this.getDefaultLayoutName());
    }

    public String getFinalLocation() {
        String location = "web";
        String value = this.allProperties.getProperty(KEY_SLIDESHOW_FINAL_LOCATION);
        if (value.equals(FILE_LOCATION)) {
            location = FILE_LOCATION;
        }
        return location;
    }

    public String getSlideshowLanguage() {
        return this.allProperties.getProperty(KEY_SLIDESHOW_LANG, defaultLocale.getLanguage());
    }

    public String getSlideshowEncoding() {
        return this.allProperties.getProperty(KEY_SLIDESHOW_CHAR_ENCODING, "UTF-8");
    }

    public boolean hasGlobalIndex() {
        boolean global = false;
        String value = this.allProperties.getProperty(KEY_SLIDESHOW_GLOBAL_INDEX, GLOBAL_INDEX);
        if (value.equals(LOCAL_INDEX_KEY_TRUE_VALUE)) {
            global = true;
        }
        return global;
    }

    public String getSlideshowIndexesSkin() {
        return this.allProperties.getProperty(KEY_SLIDESHOW_INDEXES_SKIN, "xissweb");
    }

    public boolean hasLocalIndex() {
        boolean localIndex = true;
        String value = this.allProperties.getProperty(KEY_SLIDESHOW_LOCAL_INDEX, LOCAL_INDEX_KEY_DEFAULT_VALUE);
        if (value.equals(Boolean.FALSE.toString())) {
            localIndex = false;
        }
        return localIndex;
    }

    public String localIndex() {
        String value = this.allProperties.getProperty(KEY_SLIDESHOW_LOCAL_INDEX);
        if (LOCAL_INDEX_KEY_TRUE_VALUE.equals(value)) {
            return CURRENT_IMAGE_LOCAL_INDEX;
        }
        return value;
    }

    public File getJQueryFile() {
        return new File(SlideShowProperties.getRsrcDir(), JQUERY_RSRC_DIR_NAME + File.separator + JQUERY_JS_FILE_NAME);
    }

    public File getMarkersTransformerFile() {
        return new File(SlideShowProperties.getRsrcDir(), GOOGLE_MAPS_RSRC_DIR_NAME + File.separator + GOOGLE_MAPS_MARKERS_XSL_NAME);
    }

    public File getMapIconsTransformerFile() {
        return new File(SlideShowProperties.getRsrcDir(), GOOGLE_MAPS_RSRC_DIR_NAME + File.separator + GOOGLE_MAPS_MAP_ICON_XSL_NAME);
    }

    public File getGoogleMapsJSFile() {
        return new File(SlideShowProperties.getRsrcDir(), GOOGLE_MAPS_RSRC_DIR_NAME + File.separator + GOOGLE_MAPS_JS_FILE_PATH);
    }

    public File getMapBoxJSFile() {
        return new File(SlideShowProperties.getRsrcDir(), GOOGLE_MAPS_RSRC_DIR_NAME + File.separator + GOOGLE_MAPS_BOX_JS_FILE_PATH);
    }

    private File getRsrcGoogleMapsMarkerDir() {
        return new File(SlideShowProperties.getRsrcDir(), GOOGLE_MAPS_RSRC_DIR_NAME + File.separator + "markers");
    }

    public File getMarkerHImageFile() {
        return new File(this.getRsrcGoogleMapsMarkerDir(), GOOGLE_MAPS_MARKER_H_FILE_NAME);
    }

    public File getMarkerVImageFile() {
        return new File(this.getRsrcGoogleMapsMarkerDir(), GOOGLE_MAPS_MARKER_V_FILE_NAME);
    }

    public File getMarkerHshadowImageFile() {
        return new File(this.getRsrcGoogleMapsMarkerDir(), GOOGLE_MAPS_MARKER_H_SHADOW_FILE_NAME);
    }

    public File getMarkerVshadowImageFile() {
        return new File(this.getRsrcGoogleMapsMarkerDir(), GOOGLE_MAPS_MARKER_V_SHADOW_FILE_NAME);
    }

    public String getSkinName() {
        return this.allProperties.getProperty(KEY_SKIN_NAME, "xissweb");
    }

    public String getCommonSkinPath() {
        return this.getDefaultSkinsPath() + File.separator + COMMON_SKIN_NAME;
    }

    public File getCommonImagesSkinDir() {
        return new File(this.getCommonSkinPath() + File.separator + "images");
    }

    public String getDefaultSkinsPath() {
        return SlideShowProperties.getXissWebHome() + File.separator + "rsrc" + File.separator + SKINS_DIR_NAME;
    }

    public String getSimpleSkinTemplatePath() {
        return SlideShowProperties.getXissWebHome() + File.separator + "rsrc" + File.separator + SKIN_SIMPLE_TEMPLATE_DIR;
    }

    public String getSkinsPath() {
        String path = this.allProperties.getProperty(KEY_SKINS_PATH);
        if (path == null) {
            path = this.getDefaultSkinsPath();
        }
        return path;
    }

    public String getBuildWith() {
        String buildWith = BUILT_WITH_NONE;
        String value = this.allProperties.getProperty(KEY_SLIDESHOW_BUILT_WITH, BUILT_WITH_NONE);
        if (value.equals(BUILT_WITH_GLOBAL)) {
            buildWith = BUILT_WITH_GLOBAL;
        } else if (value.equals(BUILT_WITH_LOCAL)) {
            buildWith = BUILT_WITH_LOCAL;
        } else if (value.equals(BUILT_WITH_INDEXES)) {
            buildWith = BUILT_WITH_INDEXES;
        } else if (value.equals(BUILT_WITH_ALL)) {
            buildWith = BUILT_WITH_ALL;
        }
        return buildWith;
    }

    public String getBuiltWithIconType() {
        return this.allProperties.getProperty(KEY_SLIDESHOW_BUILT_ICON_WITH, BUILT_WITH_ICON_NORMAL);
    }

    public String getBuiltWithIconName() {
        String name = BUILT_WITH_ICON;
        if (this.getBuiltWithIconType().equals(BUILT_WITH_ICON_NEGATIVE)) {
            name = BUILT_WITH_NEG_ICON;
        }
        return name;
    }

    public String getDefaultImageComment() {
        return this.allProperties.getProperty(KEY_IMAGE_DEFAULT_COMMENT);
    }

    public String getThumbnailDirName() {
        return this.allProperties.getProperty(KEY_THUMBNAIL_DIRECTORY_NAME);
    }

    public String getCopyrightYears() {
        return this.allProperties.getProperty(KEY_COPYRIGHT_YEARS);
    }

    public String getCopyrightOrganization() {
        return this.allProperties.getProperty(KEY_COPYRIGHT_ORGANIZATION);
    }

    public Set getExcludeDirs() {
        return this.getSetFromStringValue(this.allProperties.getProperty(KEY_EXCLUDE_DIRS));
    }

    public Set getExcludeFiles() {
        return this.getSetFromStringValue(this.allProperties.getProperty(KEY_EXCLUDE_FILES));
    }

    private Set getSetFromStringValue(String value) {
        HashSet<String> result = new HashSet<String>();
        if (value != null) {
            String[] names = value.split(",");
            for (int i = 0; i < names.length; ++i) {
                result.add(names[i]);
            }
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

