/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.project;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.xissweb.data.content.SlideShowContentInfo;
import org.xissweb.data.content.xml.ContentDeserializer;
import org.xissweb.data.layout.AnimationInfo;
import org.xissweb.data.layout.SlideShowLayoutInfo;
import org.xissweb.data.layout.xml.MinimalLayoutDeserializer;
import org.xissweb.file.DirectoryObserver;
import org.xissweb.file.DirectoryVisitor;
import org.xissweb.file.FileHelper;
import org.xissweb.produce.SlideShowDirectory;
import org.xissweb.project.ProjectChangeObserver;
import org.xissweb.project.SlideShowProperties;
import org.xissweb.project.links.LinkedSlideshow;

public class SlideShowProject {
    private File location;
    private SlideShowProperties properties;
    private List linkedSlideshows = new ArrayList();
    private List observers = new ArrayList();

    public static File getLayoutFileInDir(File file) {
        return new File(file, "layout.xml");
    }

    public static File getSkinEditableFile(File skinDir) {
        return new File(skinDir, "skin.xml");
    }

    public static boolean isProjectPropertiesFile(File f) {
        return "xissweb.properties".equals(f.getName());
    }

    public static boolean isSkinsRootDirectory(File f) {
        return f.getName().equals("skins");
    }

    public static boolean isSkinFile(File f) {
        if (f.isDirectory() && SlideShowProject.isSkinsRootDirectory(f.getParentFile())) {
            return SlideShowProject.getSkinEditableFile(f).exists();
        }
        return false;
    }

    public static boolean isLayoutFile(File f) {
        return f.getName().equals("layout.xml");
    }

    public static boolean isContentFile(File f) {
        return f.getName().equals("slideshow.xml");
    }

    public SlideShowProject(File location) {
        this.location = location;
        if (this.isProject()) {
            this.initialize();
        }
    }

    public void initialize() {
        this.properties = new SlideShowProperties();
        this.properties.loadProperties(this.location);
        this.buildSetsOfLinkedSlideShow();
    }

    public boolean isProject() {
        return SlideShowProperties.propertiesExist(this.location);
    }

    public File getLocation() {
        return this.location;
    }

    public String getId() {
        return this.location.getAbsolutePath();
    }

    public List getLinkedSlideshows() {
        return this.linkedSlideshows;
    }

    public boolean hasLinkedSlideshows() {
        return !this.linkedSlideshows.isEmpty();
    }

    public synchronized void addObserver(ProjectChangeObserver observer) {
        this.observers.add(observer);
    }

    public synchronized void removeObserver(ProjectChangeObserver observer) {
        this.observers.remove(observer);
    }

    public boolean isLinkedSlideshowsConsistent() {
        Iterator i = this.linkedSlideshows.iterator();
        while (i.hasNext()) {
            LinkedSlideshow e = (LinkedSlideshow)i.next();
            if (e.isConsistent()) continue;
            return false;
        }
        return true;
    }

    public void reloadProperties() {
        this.properties = new SlideShowProperties();
        this.properties.loadProperties(this.location);
    }

    public SlideShowProperties getProperties() {
        return this.properties;
    }

    public File getSrcDirectory() {
        return new File(this.location, this.properties.getSrcRootDir());
    }

    public boolean isSrcDirectory(File f) {
        return f.getName().equals(this.properties.getSrcRootDir());
    }

    public boolean isBuildDirectory(File f) {
        return f.getName().equals(this.properties.getBuildRootDir());
    }

    public File getBuildDirectory() {
        return new File(this.location, this.properties.getBuildRootDir());
    }

    public boolean isInBuild(File file) {
        return file.getAbsolutePath().startsWith(this.getBuildDirectory().getAbsolutePath());
    }

    public File getProjectSkinsDirectory() {
        return new File(this.location, "skins");
    }

    public boolean isInRepository(File file) {
        if (this.isRepositoryProject()) {
            return file.getAbsolutePath().startsWith(this.getRepositoryDirectory().getAbsolutePath());
        }
        return false;
    }

    public boolean isInOrigin(File file) {
        if (this.isReverseProject()) {
            return file.getAbsolutePath().startsWith(this.getOriginDiretory().getAbsolutePath());
        }
        return false;
    }

    public boolean isInSrc(File file) {
        return file.getAbsolutePath().startsWith(this.getSrcDirectory().getAbsolutePath());
    }

    public boolean hasSlildeShowDirectory() {
        return this.hasSlildeShowDirectory(this.getSrcDirectory());
    }

    public boolean hasSlildeShowDirectory(File directory) {
        int i;
        File[] files = FileHelper.listDirectories((File)directory);
        if (files != null && (i = 0) < files.length) {
            File file;
            if (SlideShowDirectory.isSlideshowDirectory(file = files[i++], this.properties)) {
                return true;
            }
            return this.hasSlildeShowDirectory(file);
        }
        return false;
    }

    public boolean isReverseProject() {
        return this.properties.getOriginRootDir() != null;
    }

    public File getOriginDiretory() {
        String path = this.properties.getOriginRootDir();
        if (path == null) {
            return null;
        }
        File directory = new File(path);
        return directory.exists() ? directory : new File(this.location, path);
    }

    public boolean isRepositoryProject() {
        return this.getProperties().getOriginalImageRepository() != null;
    }

    public File getRepositoryDirectory() {
        String path = this.properties.getOriginalImageRepository();
        if (path == null) {
            return null;
        }
        File directory = new File(path);
        return directory.exists() ? directory : new File(this.location, path);
    }

    public File layoutFileForSlideshow(File dir) {
        if (dir.equals(this.getLocation())) {
            File f = new File(this.getProperties().getDefaultLayoutDir(), "layout.xml");
            return f;
        }
        File f = new File(dir, "layout.xml");
        if (f.exists()) {
            return f;
        }
        return this.layoutFileForSlideshow(dir.getParentFile());
    }

    public LinkedSlideshow checkSlideshowLinksConsistency(Collection files) {
        boolean ok = true;
        HashMap layouts = new HashMap();
        HashMap slideshows4layout = new HashMap();
        MinimalLayoutDeserializer deserializer = new MinimalLayoutDeserializer();
        Iterator i = files.iterator();
        if (i.hasNext()) {
            File dir = (File)i.next();
            File lFile = this.layoutFileForSlideshow(dir);
            SlideShowLayoutInfo lInfo = this.getMinialLatout(lFile, layouts, deserializer);
            AnimationInfo animation = lInfo.getAnimation();
            this.setSlideshows4layout(slideshows4layout, dir, lInfo);
            while (i.hasNext()) {
                dir = (File)i.next();
                lFile = this.layoutFileForSlideshow(dir);
                lInfo = this.getMinialLatout(lFile, layouts, deserializer);
                this.setSlideshows4layout(slideshows4layout, dir, lInfo);
                AnimationInfo aInfo = lInfo.getAnimation();
                ok = (animation == null && aInfo == null || animation != null && aInfo != null) && ok;
            }
        }
        return new LinkedSlideshow(files, ok, slideshows4layout);
    }

    private SlideShowLayoutInfo getMinialLatout(File file, HashMap layouts, MinimalLayoutDeserializer deserializer) {
        SlideShowLayoutInfo lInfo = (SlideShowLayoutInfo)layouts.get(file);
        if (lInfo == null) {
            lInfo = deserializer.deserialize(file);
            layouts.put(file, lInfo);
        }
        return lInfo;
    }

    private void setSlideshows4layout(HashMap slideshows4layout, File slideshow, SlideShowLayoutInfo lInfo) {
        HashSet<File> s = (HashSet<File>)slideshows4layout.get(lInfo);
        if (s == null) {
            s = new HashSet<File>();
            slideshows4layout.put(lInfo, s);
        }
        s.add(slideshow);
    }

    public void buildSetsOfLinkedSlideShow() {
        final ContentDeserializer deserializer = new ContentDeserializer();
        final HashMap slideshowSet = new HashMap();
        final ArrayList allSets = new ArrayList();
        DirectoryVisitor visitor = new DirectoryVisitor(new DirectoryObserver(){

            public boolean inDirectory(File dir) {
                try {
                    File contentFile = new File(dir, "slideshow.xml");
                    if (contentFile.exists()) {
                        Set sNext;
                        Set sPrev;
                        SlideShowContentInfo contentInfo = deserializer.deserialize(contentFile);
                        Set<File> s = (HashSet<File>)slideshowSet.get(dir);
                        File prev = null;
                        File next = null;
                        if (contentInfo.hasPreviousLink()) {
                            prev = new File(dir, contentInfo.getPrevious().getHref()).getCanonicalFile();
                        }
                        if (contentInfo.hasNextLink()) {
                            next = new File(dir, contentInfo.getNext().getHref()).getCanonicalFile();
                        }
                        if (s == null && prev != null && (sPrev = (Set)slideshowSet.get(prev)) != null) {
                            sPrev.add(dir);
                            slideshowSet.put(dir, sPrev);
                            s = sPrev;
                        }
                        if (s == null && next != null && (sNext = (Set)slideshowSet.get(next)) != null) {
                            sNext.add(dir);
                            slideshowSet.put(dir, sNext);
                            s = sNext;
                        }
                        if (s == null) {
                            s = new HashSet<File>();
                            s.add(dir);
                            slideshowSet.put(dir, s);
                            allSets.add(s);
                        }
                        if (prev != null) {
                            this.followLink(s, prev);
                        }
                        if (next != null) {
                            this.followLink(s, next);
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return false;
            }

            public boolean outDirectory(File dir) {
                return false;
            }

            private void followLink(Set s, File dir) throws IOException {
                if (!slideshowSet.containsKey(dir)) {
                    s.add(dir);
                    slideshowSet.put(dir, s);
                    File contentFile = new File(dir, "slideshow.xml");
                    SlideShowContentInfo contentInfo = deserializer.deserialize(contentFile);
                    if (contentInfo.hasPreviousLink()) {
                        this.followLink(s, new File(dir, contentInfo.getPrevious().getHref()).getCanonicalFile());
                    }
                    if (contentInfo.hasNextLink()) {
                        this.followLink(s, new File(dir, contentInfo.getNext().getHref()).getCanonicalFile());
                    }
                }
            }
        });
        visitor.visit(this.location);
        ArrayList<LinkedSlideshow> ll = new ArrayList<LinkedSlideshow>();
        Iterator i = allSets.iterator();
        while (i.hasNext()) {
            Set s = (Set)i.next();
            if (s.size() <= 1) continue;
            ll.add(this.checkSlideshowLinksConsistency(s));
        }
        this.linkedSlideshowsChanged(ll);
    }

    private void linkedSlideshowsChanged(List newValue) {
        if (this.linkedSlideshows.size() != newValue.size()) {
            this.linkedSlideshows = newValue;
            this.notifyLinkedSlideshowsChanged(newValue);
        } else {
            Iterator j = this.linkedSlideshows.iterator();
            Iterator i = newValue.iterator();
            while (i.hasNext()) {
                LinkedSlideshow e2;
                LinkedSlideshow e1 = (LinkedSlideshow)j.next();
                if (e1.equals(e2 = (LinkedSlideshow)i.next())) continue;
                this.linkedSlideshows = newValue;
                this.notifyLinkedSlideshowsChanged(newValue);
                break;
            }
        }
    }

    private void notifyLinkedSlideshowsChanged(List newValue) {
        Iterator i = this.observers.iterator();
        while (i.hasNext()) {
            ProjectChangeObserver o = (ProjectChangeObserver)i.next();
            o.linkedSlideShowsChanged(newValue);
        }
    }
}

