/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.produce.build;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;
import org.xissweb.i18n.TextDisplayManager;
import org.xissweb.i18n.TextDisplayer;
import org.xissweb.produce.AbstractProcess;
import org.xissweb.produce.DirectoryActionEvent;
import org.xissweb.produce.build.BuildEventListener;
import org.xissweb.produce.build.BuildException;
import org.xissweb.produce.build.Builder;
import org.xissweb.project.SlideShowProject;

public class Process
extends AbstractProcess
implements BuildEventListener {
    private static TextDisplayer textDisplayer;
    private int nbVisitedDitectories = 0;
    private int nbCreatedThumbnails = 0;
    private int nbUpdatedContentFiles = 0;
    private int nbCreatedIndexPages = 0;
    private int nbCreatedImagePages = 0;
    private int nbCopiedSkins = 0;
    static /* synthetic */ Class class$org$xissweb$produce$build$Process;

    public static void main(String[] args) {
        textDisplayer = TextDisplayManager.createTextDisplayFor(class$org$xissweb$produce$build$Process == null ? (class$org$xissweb$produce$build$Process = Process.class$("org.xissweb.produce.build.Process")) : class$org$xissweb$produce$build$Process);
        File projectDir = new File(System.getProperty("user.dir"));
        SlideShowProject project = new SlideShowProject(projectDir);
        if (project.isProject()) {
            if (args.length == 1 && (args[0].equals("-version") || args[0].equals("-legal"))) {
                if (args[0].equals("-version")) {
                    Process.printVersion();
                    System.exit(0);
                } else {
                    Process.printLegal();
                    System.exit(0);
                }
            } else if (args.length == 0) {
                new Process().doBuild(project, (Set)null);
            } else if (args.length == 2 && args[0].equals("-select")) {
                new Process().doBuild(project, args[1]);
            } else {
                Process.displayUsage();
            }
        } else {
            Process.displayNotAProjectMessage(projectDir);
        }
    }

    protected static void displayUsage() {
        System.out.println(textDisplayer.getString("usage.intro"));
        AbstractProcess.displayUsage();
        System.out.println("    " + textDisplayer.getString("usage.select"));
        System.out.println("    " + textDisplayer.getString("usage.usage"));
        System.out.println();
    }

    private Process() {
    }

    private void doBuild(SlideShowProject project, String dirs) {
        Set selection = this.buildSelection(project.getSrcDirectory(), dirs);
        if (selection.isEmpty()) {
            Process.displayUsage();
        } else {
            this.doBuild(project, selection);
        }
    }

    private void doBuild(SlideShowProject project, Set selection) {
        Builder builder = new Builder();
        builder.setSelection(selection);
        builder.addListener(this);
        builder.setProject(project);
        System.out.println(textDisplayer.getString("message.build.process"));
        Date d0 = new Date();
        try {
            while (builder.build()) {
            }
            System.out.println();
            this.printStatistics(d0, new Date());
        }
        catch (BuildException e) {
            System.out.println(e);
        }
    }

    private void printStatistics(Date d0, Date d1) {
        SimpleDateFormat df = new SimpleDateFormat("mm:ss.SSS");
        d0.setTime(d1.getTime() - d0.getTime());
        System.out.println(textDisplayer.getString("message.build.done") + " " + df.format(d0));
        System.out.println("   " + this.nbVisitedDitectories + " " + textDisplayer.getString("message.visited.directories"));
        System.out.println("   " + this.nbCopiedSkins + " " + textDisplayer.getString("message.copied.skins"));
        System.out.println("   " + this.nbCreatedThumbnails + " " + textDisplayer.getString("message.created.thumbnails"));
        System.out.println("   " + this.nbUpdatedContentFiles + " " + textDisplayer.getString("message.updated.content.files"));
        System.out.println("   " + this.nbCreatedIndexPages + " " + textDisplayer.getString("message.created.index.pages"));
        System.out.println("   " + this.nbCreatedImagePages + " " + textDisplayer.getString("message.created.image.pages"));
        System.out.println();
    }

    public void visitingInDirectory(DirectoryActionEvent event) {
        if (event.isSelected()) {
            File dir = event.getDirectory();
            String path = dir.getPath();
            int index = path.lastIndexOf(File.separatorChar);
            for (int i = 0; i < index; ++i) {
                System.out.print(' ');
            }
            System.out.print(dir.getName() + ' ');
        }
    }

    public void inDirectoryVisited(DirectoryActionEvent event) {
        if (event.isSelected()) {
            ++this.nbVisitedDitectories;
            System.out.println();
        }
    }

    public void copyingContentDir(DirectoryActionEvent event) {
    }

    public void visitingOutDirectory(DirectoryActionEvent event) {
    }

    public void outDirectoryVisited(DirectoryActionEvent event) {
    }

    public void generateIndexPage(DirectoryActionEvent event) {
        ++this.nbCreatedIndexPages;
        System.out.print("i");
    }

    public void generateImagePage(DirectoryActionEvent event) {
        ++this.nbCreatedImagePages;
        System.out.print(".");
    }

    public void copySkin(DirectoryActionEvent event) {
        ++this.nbCopiedSkins;
        System.out.print("s(" + event.getDirectory().getName() + ")");
    }

    public void creatingThumbnail(DirectoryActionEvent event) {
        ++this.nbCreatedThumbnails;
        System.out.print("+");
    }

    public void writingSlideshowContent(DirectoryActionEvent event) {
        ++this.nbUpdatedContentFiles;
    }

    public void copyingImage(DirectoryActionEvent event) {
        System.out.print("=");
    }

    public void resizingImage(DirectoryActionEvent event) {
        System.out.print("o");
    }

    public void imageResized(DirectoryActionEvent event) {
    }

    public void slideshowContentWroten(DirectoryActionEvent event) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

