/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.produce;

import java.awt.Dimension;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Iterator;
import org.xissweb.data.content.ImageDescInfo;
import org.xissweb.data.content.ImageInfo;
import org.xissweb.file.FileHelper;
import org.xissweb.image.ImageData;
import org.xissweb.image.ImageHelper;
import org.xissweb.produce.AbstractDirectoryAction;
import org.xissweb.produce.DirectoryActionEvent;
import org.xissweb.produce.DirectoryActionEventListener;
import org.xissweb.produce.ProduceEventListener;

public abstract class AbstractProducer
extends AbstractDirectoryAction {
    protected AbstractProducer() {
    }

    protected void notifyWritingSlideshowContent(File dir, File slideshowFile) {
        DirectoryActionEvent event = new DirectoryActionEvent((Object)this, dir, slideshowFile);
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ((ProduceEventListener)i.next()).writingSlideshowContent(event);
        }
    }

    protected void notifySlideshowContentWroten(File dir, File slideshowFile) {
        DirectoryActionEvent event = new DirectoryActionEvent((Object)this, dir, slideshowFile);
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ((ProduceEventListener)i.next()).slideshowContentWroten(event);
        }
    }

    protected void copyDirectoryContent(File sourceDir, File targetDir) {
        this.notifyCopyingContentDir(sourceDir, targetDir);
        FileHelper.copyFilesOnly((File)sourceDir, (File)targetDir);
    }

    protected void copyDirectoryContent(File sourceDir, File targetDir, FileFilter filter) {
        this.notifyCopyingContentDir(sourceDir, targetDir);
        FileHelper.copyFiles((File)sourceDir, (File)targetDir, (FileFilter)filter, (boolean)true);
    }

    protected void notifyCopyingContentDir(File currentDir, File targetDir) {
        DirectoryActionEvent event = new DirectoryActionEvent((Object)this, currentDir, targetDir);
        Iterator l = this.listeners.iterator();
        while (l.hasNext()) {
            ((ProduceEventListener)l.next()).copyingContentDir(event);
        }
    }

    protected boolean hasImageInRepository() {
        return this.properties.getOriginalImageRepository() != null;
    }

    protected boolean readImageInfo(ImageInfo imageInfo, ImageData imageData, int maxW, int maxH) {
        boolean updated = false;
        updated = imageInfo.createOrUpdateMetaData(imageData) || updated;
        ImageDescInfo mainDesc = new ImageDescInfo(imageData);
        ImageDescInfo originalDesc = null;
        if (this.hasImageInRepository()) {
            originalDesc = mainDesc.cloneDesc();
            Dimension dim = ImageHelper.imageSize(originalDesc.getWidth(), originalDesc.getHeight(), maxW, maxH);
            mainDesc.setWidth(dim.width);
            mainDesc.setHeight(dim.height);
            mainDesc.setExtension("jpeg");
        }
        if (imageInfo.getMainImageDesc() == null || !imageInfo.getMainImageDesc().equals(mainDesc)) {
            imageInfo.setMainImageDesc(mainDesc);
            updated = true;
        }
        if (imageInfo.getOriginalImageDesc() == null && originalDesc != null || imageInfo.getOriginalImageDesc() != null && !imageInfo.getOriginalImageDesc().equals(originalDesc)) {
            imageInfo.setOriginalImageDesc(originalDesc);
            updated = true;
        }
        return updated;
    }

    protected File targetFile(ImageInfo iInfo, File targetImgDir) {
        return new File(targetImgDir, iInfo.getFileName() + '.' + iInfo.getMainImageDesc().getExtension());
    }

    protected void resizeOrCopy(ImageInfo iInfo, ImageData imageData, File targetImgDir, File targetFile) {
        ImageDescInfo desc = iInfo.getMainImageDesc();
        ImageDescInfo oDesc = iInfo.getOriginalImageDesc();
        if (desc.getWidth() != oDesc.getWidth() || desc.getHeight() != oDesc.getHeight()) {
            ImageHelper resizer = new ImageHelper();
            int quality = 1;
            if (this.properties.getReductionQuality() == "low") {
                quality = 0;
            }
            this.notifyResizingImage(targetImgDir, imageData.getFile());
            try {
                resizer.createImage(imageData.getFile(), targetFile, desc.getExtension(), desc.getWidth(), desc.getHeight(), quality);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.notifyImageResized(targetImgDir, imageData.getFile());
        } else {
            this.notifyCopyingImage(targetImgDir, imageData.getFile());
            FileHelper.copyFile((File)imageData.getFile(), (File)targetFile, (boolean)true);
        }
    }

    protected void notifyCopyingImage(File dir, File file) {
        DirectoryActionEvent event = new DirectoryActionEvent((Object)this, dir, file);
        Iterator l = this.listeners.iterator();
        while (l.hasNext()) {
            ((DirectoryActionEventListener)l.next()).copyingImage(event);
        }
    }

    protected void notifyResizingImage(File dir, File file) {
        DirectoryActionEvent event = new DirectoryActionEvent((Object)this, dir, file);
        Iterator l = this.listeners.iterator();
        while (l.hasNext()) {
            ((DirectoryActionEventListener)l.next()).resizingImage(event);
        }
    }

    protected void notifyImageResized(File dir, File file) {
        DirectoryActionEvent event = new DirectoryActionEvent((Object)this, dir, file);
        Iterator l = this.listeners.iterator();
        while (l.hasNext()) {
            ((DirectoryActionEventListener)l.next()).imageResized(event);
        }
    }
}

