/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.produce;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.xissweb.file.DirectoryObserver;
import org.xissweb.produce.DirectoryActionEvent;
import org.xissweb.produce.DirectoryActionEventListener;
import org.xissweb.project.SlideShowProject;
import org.xissweb.project.SlideShowProperties;

public abstract class AbstractDirectoryAction
implements DirectoryObserver {
    protected ArrayList listeners = new ArrayList();
    protected SlideShowProject project;
    protected SlideShowProperties properties;
    protected Set selection = null;
    private File inDirectory = null;
    private File outDirectory = null;

    public static boolean isSelectedDir(File dir, Set selectedDirs) {
        return selectedDirs == null ? true : selectedDirs.contains(dir);
    }

    public SlideShowProject getProject() {
        return this.project;
    }

    public void setProject(SlideShowProject project) {
        this.project = project;
        this.properties = project.getProperties();
    }

    public void setSelection(Set selection) {
        this.selection = selection;
    }

    public boolean isSelectedDir(File dir) {
        return AbstractDirectoryAction.isSelectedDir(dir, this.selection);
    }

    public boolean inDirectory(File directory) {
        boolean result;
        boolean selected = this.isSelectedDir(directory);
        if (this.inDirectory == null) {
            this.inDirectory = directory;
            this.notifyInVisitingDir(directory, selected);
        }
        if (!(result = this.doInDirectory(directory, selected))) {
            this.inDirectory = null;
            this.notifyInDirVisited(directory, selected);
        }
        return result;
    }

    public boolean outDirectory(File directory) {
        boolean result;
        boolean selected = this.isSelectedDir(directory);
        if (this.outDirectory == null) {
            this.outDirectory = directory;
            this.notifyOutVisitingDir(directory, selected);
        }
        if (!(result = this.doOutDirectory(directory, selected))) {
            this.outDirectory = null;
            this.notifyOutDirVisited(directory, selected);
        }
        return result;
    }

    public void stop() {
        this.inDirectory = null;
        this.outDirectory = null;
    }

    protected abstract boolean doInDirectory(File var1, boolean var2);

    protected abstract boolean doOutDirectory(File var1, boolean var2);

    public synchronized void addListener(DirectoryActionEventListener listener) {
        this.listeners.add(listener);
    }

    public synchronized void removeListener(DirectoryActionEventListener listener) {
        this.listeners.remove(listener);
    }

    protected void notifyInVisitingDir(File dir, boolean selected) {
        DirectoryActionEvent event = new DirectoryActionEvent((Object)this, dir, selected);
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ((DirectoryActionEventListener)i.next()).visitingInDirectory(event);
        }
    }

    protected void notifyInDirVisited(File dir, boolean selected) {
        DirectoryActionEvent event = new DirectoryActionEvent((Object)this, dir, selected);
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ((DirectoryActionEventListener)i.next()).inDirectoryVisited(event);
        }
    }

    protected void notifyOutVisitingDir(File dir, boolean selected) {
        DirectoryActionEvent event = new DirectoryActionEvent((Object)this, dir, selected);
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ((DirectoryActionEventListener)i.next()).visitingOutDirectory(event);
        }
    }

    protected void notifyOutDirVisited(File dir, boolean selected) {
        DirectoryActionEvent event = new DirectoryActionEvent((Object)this, dir, selected);
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ((DirectoryActionEventListener)i.next()).outDirectoryVisited(event);
        }
    }
}

