/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.sow;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.xissweb.file.FileHelper;
import org.xissweb.gui.Main;
import org.xissweb.gui.XissWebUI;
import org.xissweb.gui.prefs.ConfigurableEditable;
import org.xissweb.gui.prefs.PreferencesEditionManager;
import org.xissweb.gui.prefs.data.PreferenceInfo;
import org.xissweb.gui.sow.SwingSower;
import org.xissweb.gui.util.ActiveLabel;
import org.xissweb.gui.util.ImageFileCounter;
import org.xissweb.gui.worker.ProcessLauncher;
import org.xissweb.gui.worker.SwingWorker;
import org.xissweb.i18n.TextDisplayer;
import org.xissweb.prefs.ui.ComponentConfigurator;
import org.xissweb.produce.DirectoryActionEvent;
import org.xissweb.produce.sow.SowEventListener;
import org.xissweb.produce.sow.Sower;
import org.xissweb.project.SlideShowProject;

public class SowLauncher
extends JDialog
implements ProcessLauncher,
ConfigurableEditable,
SowEventListener {
    private static final long serialVersionUID = -2052982625903983332L;
    private static final String PREFS_ID = "org.xissweb.gui.sow.SowLauncher";
    private static final String PAUSE_ICON = "/images/common/pause.png";
    private static final String RESTART_ICON = "/images/common/restart.png";
    private static final String STOP_ICON = "/images/common/stop.png";
    private static final String WAITING_ANIM_ICON = "/images/common/waitingAnim.gif";
    public static final String CLOSE_WHEN_DONE = "close.when.done";
    public static final String NO_MODE = "no.mode";
    public static final String REVERSE_MODE = "reverse.mode";
    public static final String REPOSITORY_MODE = "repository.mode";
    private static final long LARGE_IMAGE_FILE_SIZE = 0x100000L;
    private SlideShowProject project;
    private SwingSower swingSower;
    private Sower sower;
    private Set selection = null;
    private String mode;
    private File baseDir;
    private File destDir;
    private TextDisplayer textDisplayer = new TextDisplayer(class$org$xissweb$gui$sow$SowLauncher == null ? (class$org$xissweb$gui$sow$SowLauncher = SowLauncher.class$("org.xissweb.gui.sow.SowLauncher")) : class$org$xissweb$gui$sow$SowLauncher);
    private int nbVisitedDir;
    private int dirCount;
    private int imgCount;
    private int nbImageAction;
    private int nbReadedSlideshowContent;
    private int nbWrotenSlideshowContent;
    private int nbNewSlideshowContent;
    private JPanel jContentPane = null;
    private JPanel headerPanel = null;
    private JPanel footerPanel = null;
    private JPanel mainPanel = null;
    private JProgressBar sowProgress = null;
    private JTextArea infoTextArea = null;
    private JScrollPane jScrollPane = null;
    private JLabel srcLabel = null;
    private JButton closeButton = null;
    private JProgressBar directoryProgress = null;
    private JLabel sowTextLabel = null;
    private JLabel modeTextLabel = null;
    private JLabel modeDirLabel = null;
    private JCheckBox closeWhenDoneCheckBox = null;
    private JPanel buttonsPanel = null;
    private ActiveLabel stopButton = null;
    private ActiveLabel pauseRestartButton = null;
    private JLabel largeImageProgress = null;
    static /* synthetic */ Class class$org$xissweb$gui$sow$SowLauncher;

    public SowLauncher(Frame parent) {
        super(parent, "", true);
        this.initialize();
        this.sower = new Sower();
        this.sower.addListener(this);
        this.sower.addListener(Main.get().getXissWeb().getFileManager());
        this.sower.addListener((SowEventListener)((Object)Main.get().getEditorsContainer()));
        this.sowProgress.setIndeterminate(false);
        this.closeButton.setEnabled(true);
        this.applyPreferences();
        PreferencesEditionManager.get().registerConfigurable(this);
    }

    public String getMode() {
        return this.mode;
    }

    private void applyPreferences() {
        ComponentConfigurator.configure((Component)this);
        PreferenceInfo pInfo = PreferencesEditionManager.get().getPreferenceInfo(CLOSE_WHEN_DONE, PREFS_ID);
        boolean close = pInfo.getDefaultValue().equals("true");
        this.closeWhenDoneCheckBox.setSelected(Main.preferences.getBoolean(CLOSE_WHEN_DONE, PREFS_ID, close));
    }

    public void prefrerenceEdited(PreferenceInfo prefInfo, Object value) {
        if (prefInfo.getKey().equals(CLOSE_WHEN_DONE)) {
            this.closeWhenDoneCheckBox.setSelected((Boolean)value);
            this.storeClosePreference();
        }
    }

    public String getDefaultValue(PreferenceInfo prefInfo) {
        return null;
    }

    void storeClosePreference() {
        Main.preferences.putBoolean(CLOSE_WHEN_DONE, PREFS_ID, this.closeWhenDoneCheckBox.isSelected());
    }

    private void initialize() {
        this.setContentPane(this.getJContentPane());
        this.setTitle(ResourceBundle.getBundle(this.getClass().getName()).getString("title"));
        this.setBounds(new Rectangle(0, 0, 470, 390));
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getHeaderPanel(), "North");
            this.jContentPane.add((Component)this.getFooterPanel(), "South");
            this.jContentPane.add((Component)this.getMainPanel(), "Center");
        }
        return this.jContentPane;
    }

    public void visitingInDirectory(DirectoryActionEvent event) {
        if (event.isSelected()) {
            ++this.nbVisitedDir;
            ++this.dirCount;
            this.directoryProgress.setValue(this.nbVisitedDir);
            this.nbImageAction = 0;
            this.sowProgress.setValue(0);
            File currentDir = event.getDirectory();
            String path = FileHelper.relativePath((File)this.baseDir, (File)currentDir);
            int index = path.lastIndexOf(File.separatorChar);
            StringBuffer buff = new StringBuffer();
            for (int i = 0; i < index; ++i) {
                buff.append(' ');
            }
            buff.append(currentDir.getName()).append(' ');
            int nbImages = ImageFileCounter.countImages(currentDir, this.project.getProperties());
            if (nbImages > 0 && this.mode.equals(REPOSITORY_MODE) && this.project.getProperties().isImportImage()) {
                File currrDestDir = FileHelper.fileInTargetDir((File)this.baseDir, (File)currentDir, (File)this.destDir);
                nbImages += ImageFileCounter.countImages(currentDir, currrDestDir, this.project.getProperties());
            }
            this.sowProgress.setMaximum(nbImages);
            this.addInfo(buff.toString());
        }
    }

    public void inDirectoryVisited(DirectoryActionEvent event) {
        if (event.isSelected()) {
            ++this.nbVisitedDir;
            this.directoryProgress.setValue(this.nbVisitedDir);
            this.addInfo("\n");
        }
    }

    public void readingImage(DirectoryActionEvent event) {
        this.addInfo(".");
    }

    public void imageReaded(DirectoryActionEvent event) {
        ++this.nbImageAction;
        ++this.imgCount;
        this.sowProgress.setValue(this.nbImageAction);
    }

    public void slideshowContentReaded(DirectoryActionEvent event) {
        ++this.nbReadedSlideshowContent;
    }

    public void writingSlideshowContent(DirectoryActionEvent event) {
        ++this.nbWrotenSlideshowContent;
    }

    public void slideshowContentCreated(DirectoryActionEvent event) {
        ++this.nbNewSlideshowContent;
    }

    public void resizingImage(DirectoryActionEvent event) {
        this.addInfo("o");
        if (event.getFileOrDir().length() > 0x100000L) {
            this.getLargeImageProgress().setVisible(true);
        }
    }

    public void imageResized(DirectoryActionEvent event) {
        this.getLargeImageProgress().setVisible(false);
        ++this.nbImageAction;
        this.sowProgress.setValue(this.nbImageAction);
    }

    public void copyingContentDir(DirectoryActionEvent event) {
    }

    public void slideshowContentWroten(DirectoryActionEvent event) {
    }

    public void copyingImage(DirectoryActionEvent event) {
    }

    public void outDirectoryVisited(DirectoryActionEvent event) {
    }

    public void visitingOutDirectory(DirectoryActionEvent event) {
    }

    private JPanel getHeaderPanel() {
        if (this.headerPanel == null) {
            this.modeDirLabel = new JLabel();
            this.modeDirLabel.setText("-");
            this.modeDirLabel.setFont(new Font("Arial", 1, 12));
            this.modeDirLabel.setVisible(false);
            this.modeTextLabel = new JLabel();
            this.modeTextLabel.setText("-");
            this.modeTextLabel.setFont(new Font("Arial", 0, 12));
            this.modeTextLabel.setVisible(false);
            this.sowTextLabel = new JLabel();
            this.sowTextLabel.setText("-");
            this.sowTextLabel.setFont(new Font("Arial", 0, 12));
            this.srcLabel = new JLabel();
            this.srcLabel.setText("-");
            this.srcLabel.setFont(new Font("Arial", 1, 12));
            this.headerPanel = new JPanel();
            this.headerPanel.add((Component)this.sowTextLabel, null);
            this.headerPanel.add((Component)this.srcLabel, null);
            this.headerPanel.add((Component)this.modeTextLabel, null);
            this.headerPanel.add((Component)this.modeDirLabel, null);
        }
        this.textDisplayer.register(this.sowTextLabel, "sow.text");
        return this.headerPanel;
    }

    private JPanel getFooterPanel() {
        if (this.footerPanel == null) {
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints7.gridy = 0;
            gridBagConstraints7.anchor = 13;
            gridBagConstraints7.weightx = 10.0;
            gridBagConstraints7.gridx = 1;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints6.gridy = 0;
            gridBagConstraints6.anchor = 17;
            gridBagConstraints6.weightx = 10.0;
            gridBagConstraints6.gridx = 0;
            this.footerPanel = new JPanel();
            this.footerPanel.setLayout(new GridBagLayout());
            this.footerPanel.add((Component)this.getCloseWhenDoneCheckBox(), gridBagConstraints6);
            this.footerPanel.add((Component)this.getCloseButton(), gridBagConstraints7);
        }
        return this.footerPanel;
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
            gridBagConstraints21.gridx = 0;
            gridBagConstraints21.weightx = 10.0;
            gridBagConstraints21.fill = 2;
            gridBagConstraints21.gridy = 3;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridheight = 1;
            gridBagConstraints3.gridx = 1;
            gridBagConstraints3.gridy = 2;
            gridBagConstraints3.ipadx = 0;
            gridBagConstraints3.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.weighty = 0.0;
            gridBagConstraints3.gridwidth = 1;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.insets = new Insets(5, 60, 5, 60);
            gridBagConstraints2.gridy = 2;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.gridwidth = 3;
            gridBagConstraints2.gridx = 0;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.insets = new Insets(5, 60, 5, 60);
            gridBagConstraints1.gridy = 1;
            gridBagConstraints1.fill = 2;
            gridBagConstraints1.gridwidth = 3;
            gridBagConstraints1.gridx = 0;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 10.0;
            gridBagConstraints.weighty = 10.0;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.insets = new Insets(5, 20, 5, 20);
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new GridBagLayout());
            this.mainPanel.setBorder(BorderFactory.createEtchedBorder(0));
            this.mainPanel.add((Component)this.getJScrollPane(), gridBagConstraints);
            this.mainPanel.add((Component)this.getJProgressBar2(), gridBagConstraints1);
            this.mainPanel.add((Component)this.getJProgressBar(), gridBagConstraints2);
            this.mainPanel.add((Component)this.getLargeImageProgress(), gridBagConstraints3);
            this.mainPanel.add((Component)this.getButtonsPanel(), gridBagConstraints21);
        }
        return this.mainPanel;
    }

    public void performStart() {
        ImageFileCounter counter = new ImageFileCounter();
        this.baseDir = this.mode.equals(REVERSE_MODE) ? this.project.getOriginDiretory() : (this.mode.equals(REPOSITORY_MODE) ? this.project.getRepositoryDirectory() : this.project.getSrcDirectory());
        if (this.mode.equals(REVERSE_MODE)) {
            counter.countReverse(this.project, this.baseDir, this.selection);
        } else {
            counter.count(this.project, this.baseDir, this.selection);
        }
        this.destDir = this.project.getSrcDirectory();
        this.sower.setProject(this.project);
        this.sower.setSelection(this.selection);
        this.swingSower = new SwingSower();
        this.swingSower.setSower(this.sower);
        this.swingSower.setMode(this.getMode());
        this.swingSower.setLauncher(this);
        this.closeButton.setEnabled(false);
        this.pauseRestartButton.setEnabled(true);
        this.stopButton.setEnabled(true);
        this.dirCount = 0;
        this.imgCount = 0;
        this.nbVisitedDir = 0;
        this.nbWrotenSlideshowContent = 0;
        this.nbReadedSlideshowContent = 0;
        this.nbNewSlideshowContent = 0;
        this.directoryProgress.setValue(0);
        this.directoryProgress.setMaximum(counter.getDirectoryCount() * 2 + 1);
        this.sowProgress.setValue(0);
        this.sowProgress.setMaximum(counter.getImageCount());
        this.swingSower.start();
        this.setInfo("");
    }

    private JProgressBar getJProgressBar() {
        if (this.sowProgress == null) {
            this.sowProgress = new JProgressBar();
            this.sowProgress.setIndeterminate(false);
        }
        return this.sowProgress;
    }

    public void openPrecessor(SlideShowProject project, String mode, Set selectedDirs) {
        this.project = project;
        this.selection = selectedDirs == null ? null : new HashSet(selectedDirs);
        this.modeTextLabel.setVisible(false);
        this.modeDirLabel.setVisible(false);
        this.mode = mode;
        this.setTitle(ResourceBundle.getBundle(this.getClass().getName()).getString("title") + " " + project.getLocation().getName());
        StringBuffer text = new StringBuffer();
        if (this.selection == null) {
            text.append(project.getProperties().getSrcRootDir());
        } else {
            File baseDir = mode == REPOSITORY_MODE ? project.getRepositoryDirectory() : project.getSrcDirectory();
            Object[] dirs = this.selection.toArray(new File[this.selection.size()]);
            Arrays.sort(dirs);
            for (int i = 0; i < dirs.length; ++i) {
                Object f = dirs[i];
                text.append(FileHelper.relativePath((File)baseDir, (File)f));
                if (i + 1 >= dirs.length) continue;
                text.append(", ");
            }
        }
        if (!mode.equals(NO_MODE)) {
            text.append("  ");
            this.modeTextLabel.setText(ResourceBundle.getBundle(this.getClass().getName()).getString(mode));
            this.modeTextLabel.setVisible(true);
            if (mode.equals(REVERSE_MODE)) {
                this.modeDirLabel.setText(project.getProperties().getOriginRootDir());
            } else {
                this.modeDirLabel.setText(project.getProperties().getOriginalImageRepository());
            }
            this.modeDirLabel.setVisible(true);
        }
        this.srcLabel.setText(text.toString());
        this.sowProgress.setIndeterminate(false);
        this.textDisplayer.resetAllText();
        this.setPauseDisplay(true);
        this.getPauseRestartButton().setEnabled(true);
        this.performStart();
        this.setVisible(true);
    }

    private void setPauseDisplay(boolean val) {
        if (val) {
            this.getPauseRestartButton().setIcon(XissWebUI.getIcon(PAUSE_ICON));
            this.textDisplayer.registerToolTip(this.getPauseRestartButton(), "pause.button");
        } else {
            this.getPauseRestartButton().setIcon(XissWebUI.getIcon(RESTART_ICON));
            this.textDisplayer.registerToolTip(this.getPauseRestartButton(), "restart.button");
        }
    }

    public void performPauseRestart() {
        this.swingSower.interrupt(false);
        this.setPauseDisplay(!this.swingSower.isInPause());
    }

    public void performStop() {
        this.swingSower.interrupt(true);
    }

    public void processFinished(SwingWorker worker, long time, boolean complete) {
        ++this.nbVisitedDir;
        this.directoryProgress.setValue(this.nbVisitedDir);
        this.closeButton.setEnabled(true);
        SimpleDateFormat df = new SimpleDateFormat("mm:ss.SSS");
        StringBuffer buff = new StringBuffer();
        buff.append("Done ").append(df.format(new Date(time)));
        buff.append("\n   ").append(this.dirCount).append("  ").append(this.textDisplayer.getString("message.sow.visited"));
        buff.append("\n   ").append(this.nbWrotenSlideshowContent - this.nbNewSlideshowContent).append("  ").append(this.textDisplayer.getString("message.sow.updated.slideshows")).append(" ");
        buff.append(this.textDisplayer.getString("message.sow.on")).append(" ").append(this.nbReadedSlideshowContent).append(" ").append(this.textDisplayer.getString("message.sow.existing.slideshows"));
        buff.append("\n   ").append(this.nbNewSlideshowContent).append("  ").append(this.textDisplayer.getString("message.sow.new.slideshows"));
        buff.append("\n   ").append(this.imgCount).append("  ").append(this.textDisplayer.getString("message.sow.images.number"));
        this.addInfo(buff.toString());
        this.addInfo("\n");
        this.setPauseDisplay(true);
        this.pauseRestartButton.setEnabled(false);
        this.stopButton.setEnabled(false);
        this.closeButton.setEnabled(true);
        this.sower.stop();
        if (this.closeWhenDoneCheckBox.isSelected()) {
            this.setVisible(false);
        }
    }

    public void setInfo(String text) {
        this.infoTextArea.setText(text);
        this.scrollInfoToBottom();
    }

    public void addInfo(String text) {
        this.infoTextArea.append(text);
        this.scrollInfoToBottom();
    }

    private void scrollInfoToBottom() {
        Point pt = this.jScrollPane.getViewport().getViewPosition();
        pt.setLocation(pt.getX(), (double)Math.max(0, this.infoTextArea.getHeight() - this.jScrollPane.getViewport().getHeight()));
        this.jScrollPane.getViewport().setViewPosition(pt);
    }

    private JTextArea getJTextArea() {
        if (this.infoTextArea == null) {
            this.infoTextArea = new JTextArea();
            this.infoTextArea.setFont(new Font("Courier New", 0, 12));
            this.infoTextArea.setTabSize(3);
            this.infoTextArea.setBackground(XissWebUI.paleColor);
            this.infoTextArea.setEditable(false);
            this.infoTextArea.setBounds(new Rectangle(0, 0, 420, 210));
        }
        return this.infoTextArea;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getJTextArea());
        }
        return this.jScrollPane;
    }

    private JButton getCloseButton() {
        if (this.closeButton == null) {
            this.closeButton = new JButton();
            this.textDisplayer.register(this.closeButton, "close.button");
            this.closeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SowLauncher.this.setVisible(false);
                }
            });
        }
        return this.closeButton;
    }

    private JProgressBar getJProgressBar2() {
        if (this.directoryProgress == null) {
            this.directoryProgress = new JProgressBar();
        }
        return this.directoryProgress;
    }

    private JCheckBox getCloseWhenDoneCheckBox() {
        if (this.closeWhenDoneCheckBox == null) {
            this.closeWhenDoneCheckBox = new JCheckBox();
            this.textDisplayer.register(this.closeWhenDoneCheckBox, CLOSE_WHEN_DONE);
            this.closeWhenDoneCheckBox.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    SowLauncher.this.storeClosePreference();
                }
            });
        }
        return this.closeWhenDoneCheckBox;
    }

    private JPanel getButtonsPanel() {
        if (this.buttonsPanel == null) {
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints5.gridx = 1;
            gridBagConstraints5.gridy = 0;
            gridBagConstraints5.gridheight = 1;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridheight = 1;
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.gridy = 0;
            gridBagConstraints4.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints4.gridwidth = 1;
            this.buttonsPanel = new JPanel();
            this.buttonsPanel.setLayout(new GridBagLayout());
            this.buttonsPanel.add((Component)this.getPauseRestartButton(), gridBagConstraints4);
            this.buttonsPanel.add((Component)this.getStopButton(), gridBagConstraints5);
        }
        return this.buttonsPanel;
    }

    private ActiveLabel getStopButton() {
        if (this.stopButton == null) {
            this.stopButton = new ActiveLabel();
            this.textDisplayer.registerToolTip(this.stopButton, "stop.button");
            this.stopButton.setIcon(XissWebUI.getIcon(STOP_ICON));
            this.stopButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SowLauncher.this.performStop();
                }
            });
        }
        return this.stopButton;
    }

    private ActiveLabel getPauseRestartButton() {
        if (this.pauseRestartButton == null) {
            this.pauseRestartButton = new ActiveLabel();
            this.pauseRestartButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SowLauncher.this.performPauseRestart();
                }
            });
        }
        return this.pauseRestartButton;
    }

    private JLabel getLargeImageProgress() {
        if (this.largeImageProgress == null) {
            this.largeImageProgress = new JLabel();
            this.largeImageProgress.setText("");
            this.largeImageProgress.setIcon(XissWebUI.getIcon(WAITING_ANIM_ICON));
            this.largeImageProgress.setVisible(false);
        }
        return this.largeImageProgress;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

