/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.skin.simple;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.xissweb.data.skin.LineInfo;
import org.xissweb.gui.skin.simple.SkinEditor;
import org.xissweb.gui.skin.simple.SkinLinePanel;

public class SkinLinesContainerPanel
extends JPanel {
    private static final long serialVersionUID = 5012933050621852210L;
    private int nbLines;
    private LineInfo[] linesInfo;
    private SkinLinePanel[] linesPanel = null;

    public SkinLinesContainerPanel(int nbLines) {
        this.nbLines = nbLines;
        this.linesInfo = new LineInfo[nbLines];
        this.linesPanel = new SkinLinePanel[nbLines];
        this.initialize();
    }

    public void setEditor(SkinEditor editor) {
        for (int i = 0; i < this.linesPanel.length; ++i) {
            this.linesPanel[i].setEditor(editor);
        }
    }

    public void setLinesInfo(LineInfo[] lineInfos) {
        for (int i = 0; i < lineInfos.length; ++i) {
            this.setLineInfoAt(lineInfos[i], i);
        }
    }

    public void setLineInfoAt(LineInfo lineInfo, int index) {
        this.linesInfo[index] = lineInfo;
        this.fillFields(index);
    }

    public JLabel[] getTitles() {
        JLabel[] labels = new JLabel[this.nbLines];
        for (int i = 0; i < labels.length; ++i) {
            labels[i] = this.linesPanel[i].getTitleLabel();
        }
        return labels;
    }

    public JLabel getTitleAt(int index) {
        return this.linesPanel[index].getTitleLabel();
    }

    private void fillFields(int index) {
        this.linesPanel[index].setLineInfo(this.linesInfo[index]);
    }

    private void initialize() {
        this.setLayout(new GridBagLayout());
        for (int i = 0; i < this.nbLines; ++i) {
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = i;
            constraints.fill = 2;
            constraints.insets = new Insets(5, 5, 5, 5);
            this.linesPanel[i] = new SkinLinePanel();
            this.add((Component)this.linesPanel[i], constraints);
        }
    }
}

