/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.skin.simple;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.xissweb.data.skin.AnimationLoadInfo;
import org.xissweb.data.skin.SlideShowSkinInfo;
import org.xissweb.data.skin.xml.SkinDeserializer;
import org.xissweb.data.skin.xml.SkinSerializer;
import org.xissweb.gui.XissWebUI;
import org.xissweb.gui.editor.Editor;
import org.xissweb.gui.editor.EditorsContainer;
import org.xissweb.gui.editor.ValidProcessHandler;
import org.xissweb.gui.editor.number.IntegerValueChecker;
import org.xissweb.gui.skin.simple.SkinColorPanel;
import org.xissweb.gui.skin.simple.SkinEditorHelper;
import org.xissweb.gui.skin.simple.SkinFontPanel;
import org.xissweb.gui.skin.simple.SkinGraphicDrawer;
import org.xissweb.gui.skin.simple.SkinGraphicElementRenderer;
import org.xissweb.gui.skin.simple.SkinGraphicModel;
import org.xissweb.gui.skin.simple.SkinLinesContainerPanel;
import org.xissweb.i18n.LangChangedOberver;
import org.xissweb.i18n.TextDisplayManager;
import org.xissweb.i18n.TextDisplayer;
import org.xissweb.prefs.ui.SplitPaneConfigurator;

public class SkinEditor
extends JSplitPane
implements Editor,
LangChangedOberver {
    private static final long serialVersionUID = 9130217953484466387L;
    static final String ERROR_ICON = "/images/common/error.png";
    static final String WAIT_ICON_PATH = "/images/skin/wait/";
    private static final String SKIN_DOC_ICON = "/images/file/skinDoc.png";
    private static final Font subTitleFont = XissWebUI.plainFont;
    private static final Font subSubTitleFont = subTitleFont.deriveFont(2);
    private File skinInfoFile;
    private SkinDeserializer deserializer = new SkinDeserializer();
    private SkinSerializer serializer = new SkinSerializer();
    private SlideShowSkinInfo skinInfo;
    private SlideShowSkinInfo skinInfoRef;
    private boolean modified;
    private EditorsContainer editorsContainer;
    private TextDisplayer textDisplayer = TextDisplayManager.createTextDisplayFor(this.getClass());
    Color colorChoosed = null;
    private JPanel editionPanel = null;
    private SkinGraphicDrawer skinGraphicDrawer = null;
    JColorChooser colorChooser = null;
    private JDialog colorChooserDialog = null;
    private SkinColorPanel colorBodyBackgroundPanel = null;
    private SkinColorPanel colorPageBackgroundPanel = null;
    private SkinColorPanel colorForegroundPanel = null;
    private SkinColorPanel colorLinkForegroundPanel = null;
    private SkinColorPanel colorLinkHoverPanel = null;
    private SkinColorPanel colorDisabledForegroundPanel = null;
    private JLabel colorLabel = null;
    private JPanel colorsPanel = null;
    private JPanel pagePanel = null;
    private SkinFontPanel pageFontPanel = null;
    private JPanel componentPanel = null;
    private SkinFontPanel copyrightFontPanel = null;
    private JPanel imageAreaPanel = null;
    private SkinLinesContainerPanel thumbnailPanel = null;
    private SkinLinesContainerPanel pageLinkPanel = null;
    private JScrollPane editorScrollPane = null;
    private SkinColorPanel imageAreaColorPanel = null;
    private SkinFontPanel imageAreaFontPanel = null;
    private SkinLinesContainerPanel imageAreaBorderPanel = null;
    private JCheckBox centeredCheckBox = null;
    private JLabel imageAreaMarginLabel = null;
    private JTextField imageAreaMarginTextField = null;
    private JLabel imageAreaMarginErrorLabel = null;
    private SkinColorPanel imageBackgroundPanel = null;
    private SkinFontPanel skinMetaDatatPanel = null;
    private JPanel localIndexPanel = null;
    private SkinColorPanel localIndexBorderColorPanel = null;
    private SkinColorPanel localIndexBackgroundPanel = null;
    private JPanel animationPanel = null;
    JComboBox loadScreenBackgroundComboBox = null;
    JSlider opacitySlider = null;
    JComboBox waitIconStyleComboBox = null;
    JLabel waitIconLabel;
    JLabel opacityValueLabel;

    public SkinEditor() {
        TextDisplayManager.get().addObserver(this);
        this.initialize();
        SplitPaneConfigurator.configure((JSplitPane)this);
    }

    private void initialize() {
        this.setSize(new Dimension(346, 270));
        this.setLeftComponent(this.getEditorScrollPane());
        this.setRightComponent(this.getSkinGraphicDrawer());
        this.setOrientation(1);
        this.setDividerSize(5);
    }

    public void modified(boolean error) {
    }

    public void langChanged() {
        this.colorChooserDialog = null;
        this.colorChooser = null;
    }

    public void setEditorsContainer(EditorsContainer editorsContainer) {
        this.editorsContainer = editorsContainer;
    }

    public void setEditedDocument(Object document) {
        this.skinInfoFile = (File)document;
    }

    public Object getEditedDocument() {
        return this.skinInfoFile;
    }

    public boolean isReadOnly() {
        return this.skinInfoFile.canWrite();
    }

    public void edit() {
        this.skinInfo = this.deserializer.deserialize(this.skinInfoFile);
        this.skinInfoRef = this.deserializer.deserialize(this.skinInfoFile);
        ((SkinGraphicModel)this.getSkinGraphicDrawer().getModel()).setSkinInfo(this.skinInfo);
        this.fillEditor();
        this.modified = false;
        this.editorsContainer.editorStatusChange(this, 0);
    }

    public void edit(Object arg) {
        this.edit();
    }

    public void setValidProcessHandler(ValidProcessHandler handler) {
    }

    public ValidProcessHandler getValidProcessHandler() {
        return null;
    }

    public boolean isDocumentValid() {
        return true;
    }

    public int save() {
        this.serializer.serialize(this.skinInfo, this.skinInfoFile);
        this.skinInfoRef = this.deserializer.deserialize(this.skinInfoFile);
        this.modified = false;
        this.editorsContainer.editorStatusChange(this, 3);
        return 3;
    }

    public void cancel() {
        this.skinInfo = null;
        this.skinInfo = this.deserializer.deserialize(this.skinInfoFile);
        ((SkinGraphicModel)this.getSkinGraphicDrawer().getModel()).setSkinInfo(this.skinInfo);
        this.fillEditor();
        this.modified = false;
        this.editorsContainer.editorStatusChange(this, 2);
    }

    public void reload() {
        this.fillEditor();
        this.getSkinGraphicDrawer().repaint();
    }

    public String getDocumentName() {
        return this.skinInfoFile.getParentFile().getName();
    }

    public boolean hasDocumentModified() {
        return this.modified;
    }

    public Component getEditorGuiComponent() {
        return this;
    }

    public Icon getIcon() {
        return XissWebUI.getIcon(SKIN_DOC_ICON);
    }

    public JMenuItem[] getMenuItems() {
        return null;
    }

    void elementEdited(Object origin) {
        this.getSkinGraphicDrawer().repaint();
        this.modified = !SkinEditorHelper.equal(this.skinInfo, this.skinInfoRef);
        this.editorsContainer.editorStatusChange(this, this.modified ? 1 : 2);
    }

    private void fillEditor() {
        this.colorBodyBackgroundPanel.setColorInfo(this.skinInfo.getColors().getBodyBackground());
        this.colorPageBackgroundPanel.setColorInfo(this.skinInfo.getColors().getPageBackground());
        this.colorForegroundPanel.setColorInfo(this.skinInfo.getColors().getForeground());
        this.colorLinkForegroundPanel.setColorInfo(this.skinInfo.getColors().getLinkForeground());
        this.colorLinkHoverPanel.setColorInfo(this.skinInfo.getColors().getLinkHover());
        this.colorDisabledForegroundPanel.setColorInfo(this.skinInfo.getColors().getDisabledForeground());
        this.centeredCheckBox.setSelected(this.skinInfo.getPage().isCentered());
        this.pageFontPanel.setFontInfo(this.skinInfo.getPage().getFont());
        this.pageLinkPanel.setLineInfoAt(this.skinInfo.getPage().getLink().getNormal(), 0);
        this.pageLinkPanel.setLineInfoAt(this.skinInfo.getPage().getLink().getHover(), 1);
        this.imageAreaMarginTextField.setText(Integer.toString(this.skinInfo.getComponent().getImageArea().getMargin()));
        this.imageAreaColorPanel.setColorInfo(this.skinInfo.getComponent().getImageArea().getColor());
        if (this.skinInfo.getComponent().getImageArea().getBackground() != null) {
            this.imageBackgroundPanel.setVerifyInputWhenFocusTarget(true);
            this.imageBackgroundPanel.setColorInfo(this.skinInfo.getComponent().getImageArea().getBackground());
        } else {
            this.imageBackgroundPanel.setVerifyInputWhenFocusTarget(false);
        }
        this.imageAreaFontPanel.setFontInfo(this.skinInfo.getComponent().getImageArea().getFont());
        this.skinMetaDatatPanel.setFontInfo(this.skinInfo.getComponent().getImageArea().getMetadataFont());
        this.imageAreaBorderPanel.setLineInfoAt(this.skinInfo.getComponent().getImageArea().getBorder(), 0);
        this.localIndexBorderColorPanel.setColorInfo(this.skinInfo.getComponent().getImageArea().getLocalIndex().getBorderColor());
        this.localIndexBackgroundPanel.setColorInfo(this.skinInfo.getComponent().getImageArea().getLocalIndex().getBackground());
        this.loadScreenBackgroundComboBox.setSelectedIndex(this.skinInfo.getComponent().getImageArea().getAnimationLoad().getBackground());
        this.waitIconStyleComboBox.setSelectedIndex(this.skinInfo.getComponent().getImageArea().getAnimationLoad().getIconStyle());
        this.opacitySlider.setValue((int)(this.skinInfo.getComponent().getImageArea().getAnimationLoad().getOpacity() * 10.0f));
        this.thumbnailPanel.setLineInfoAt(this.skinInfo.getComponent().getThumbnail().getLink().getNormal(), 0);
        this.thumbnailPanel.setLineInfoAt(this.skinInfo.getComponent().getThumbnail().getLink().getHover(), 1);
        this.thumbnailPanel.setLineInfoAt(this.skinInfo.getComponent().getThumbnail().getCurrent(), 2);
        this.copyrightFontPanel.setFontInfo(this.skinInfo.getComponent().getCopyright().getFont());
    }

    void currentColor(String key) {
        this.colorLabel.setText(key == null ? " " : this.textDisplayer.getString(key));
    }

    Color chooseColor(SkinColorPanel panel) {
        if (this.colorChooserDialog == null) {
            this.colorChooser = new JColorChooser();
            this.colorChooserDialog = JColorChooser.createDialog(this, "", true, this.colorChooser, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SkinEditor.this.colorChoosed = SkinEditor.this.colorChooser.getColor();
                }
            }, null);
        }
        Color c = panel.getColor();
        this.colorChoosed = null;
        this.colorChooserDialog.setTitle(this.textDisplayer.getString(panel.getToolTipKey() == null ? "color.default.title" : panel.getToolTipKey()));
        this.colorChooser.setColor(c);
        this.colorChooserDialog.setVisible(true);
        return this.colorChoosed != null && !c.equals(this.colorChoosed) ? this.colorChoosed : null;
    }

    void centeredStateChanged() {
        if (this.centeredCheckBox.isSelected() != this.skinInfo.getPage().isCentered()) {
            this.skinInfo.getPage().setCentered(this.centeredCheckBox.isSelected());
            this.elementEdited(this.skinInfo.getPage());
        }
    }

    void imageAreaMarginChanhed() {
        int check = IntegerValueChecker.checkValue(this.imageAreaMarginTextField.getText());
        if (check != 3 && check != 2) {
            this.imageAreaMarginErrorLabel.setText(IntegerValueChecker.getMessage(check));
            this.imageAreaMarginErrorLabel.setVisible(true);
        } else {
            this.imageAreaMarginErrorLabel.setVisible(false);
            this.skinInfo.getComponent().getImageArea().setMargin(IntegerValueChecker.getValue(this.imageAreaMarginTextField.getText()));
            this.elementEdited(this.skinInfo.getComponent().getImageArea());
        }
    }

    void loadScreenBackgroundChanged() {
        AnimationLoadInfo animationLoad = this.skinInfo.getComponent().getImageArea().getAnimationLoad();
        animationLoad.setBackground(this.loadScreenBackgroundComboBox.getSelectedIndex());
        this.elementEdited(animationLoad);
    }

    void waitIconStyleChanged() {
        AnimationLoadInfo animationLoad = this.skinInfo.getComponent().getImageArea().getAnimationLoad();
        animationLoad.setIconStyle(this.waitIconStyleComboBox.getSelectedIndex());
        this.elementEdited(animationLoad);
    }

    void opacityChanged() {
        AnimationLoadInfo animationLoad = this.skinInfo.getComponent().getImageArea().getAnimationLoad();
        float value = (float)this.opacitySlider.getValue() / 10.0f;
        if (value != animationLoad.getOpacity()) {
            animationLoad.setOpacity(value);
            this.elementEdited(animationLoad);
        }
    }

    private JPanel getEditionPanel() {
        if (this.editionPanel == null) {
            GridBagConstraints colorsPanelConstraints = new GridBagConstraints();
            colorsPanelConstraints.insets = new Insets(5, 5, 5, 5);
            colorsPanelConstraints.gridy = 0;
            colorsPanelConstraints.gridx = 0;
            colorsPanelConstraints.fill = 2;
            GridBagConstraints pagePanelConstraints = new GridBagConstraints();
            pagePanelConstraints.insets = new Insets(5, 5, 5, 5);
            pagePanelConstraints.gridy = 1;
            pagePanelConstraints.gridx = 0;
            pagePanelConstraints.fill = 2;
            GridBagConstraints componentsPanelConstraints = new GridBagConstraints();
            componentsPanelConstraints.insets = new Insets(5, 5, 5, 5);
            componentsPanelConstraints.gridy = 2;
            componentsPanelConstraints.gridx = 0;
            componentsPanelConstraints.fill = 2;
            this.editionPanel = new JPanel();
            this.editionPanel.setLayout(new GridBagLayout());
            this.editionPanel.add((Component)this.getColorsPanel(), colorsPanelConstraints);
            this.editionPanel.add((Component)this.getPagePanel(), pagePanelConstraints);
            this.editionPanel.add((Component)this.getComponentPanel(), componentsPanelConstraints);
        }
        return this.editionPanel;
    }

    private SkinGraphicDrawer getSkinGraphicDrawer() {
        if (this.skinGraphicDrawer == null) {
            this.skinGraphicDrawer = new SkinGraphicDrawer();
            this.skinGraphicDrawer.setModel(new SkinGraphicModel());
            this.skinGraphicDrawer.setElementRenderer(new SkinGraphicElementRenderer());
        }
        return this.skinGraphicDrawer;
    }

    private SkinColorPanel getColorBodyBackgroundPanel() {
        if (this.colorBodyBackgroundPanel == null) {
            this.colorBodyBackgroundPanel = new SkinColorPanel();
            this.colorBodyBackgroundPanel.setEditor(this);
            this.colorBodyBackgroundPanel.setToolTipKey("body.background.tooltip");
        }
        return this.colorBodyBackgroundPanel;
    }

    private SkinColorPanel getColorPageBackgroundPanel() {
        if (this.colorPageBackgroundPanel == null) {
            this.colorPageBackgroundPanel = new SkinColorPanel();
            this.colorPageBackgroundPanel.setEditor(this);
            this.colorPageBackgroundPanel.setToolTipKey("page.background.tooltip");
        }
        return this.colorPageBackgroundPanel;
    }

    private SkinColorPanel getColorForegroundPanel() {
        if (this.colorForegroundPanel == null) {
            this.colorForegroundPanel = new SkinColorPanel();
            this.colorForegroundPanel.setEditor(this);
            this.colorForegroundPanel.setToolTipKey("foreground.tooltip");
        }
        return this.colorForegroundPanel;
    }

    private SkinColorPanel getColorLinkForegroundPanel() {
        if (this.colorLinkForegroundPanel == null) {
            this.colorLinkForegroundPanel = new SkinColorPanel();
            this.colorLinkForegroundPanel.setEditor(this);
            this.colorLinkForegroundPanel.setToolTipKey("link.foreground.tooltip");
        }
        return this.colorLinkForegroundPanel;
    }

    private SkinColorPanel getColorLinkHoverPanel() {
        if (this.colorLinkHoverPanel == null) {
            this.colorLinkHoverPanel = new SkinColorPanel();
            this.colorLinkHoverPanel.setEditor(this);
            this.colorLinkHoverPanel.setToolTipKey("link.hover.tooltip");
        }
        return this.colorLinkHoverPanel;
    }

    private SkinColorPanel getColorDisabledForegroundPanel() {
        if (this.colorDisabledForegroundPanel == null) {
            this.colorDisabledForegroundPanel = new SkinColorPanel();
            this.colorDisabledForegroundPanel.setEditor(this);
            this.colorDisabledForegroundPanel.setToolTipKey("disabled.foreground.tooltip");
        }
        return this.colorDisabledForegroundPanel;
    }

    private JPanel getColorsPanel() {
        if (this.colorsPanel == null) {
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.gridy = 2;
            gridBagConstraints6.gridwidth = 3;
            gridBagConstraints6.gridheight = 1;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.insets = new Insets(5, 10, 5, 50);
            gridBagConstraints5.gridx = 2;
            gridBagConstraints5.gridy = 1;
            gridBagConstraints5.gridheight = 1;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.insets = new Insets(5, 10, 5, 10);
            gridBagConstraints4.gridx = 1;
            gridBagConstraints4.gridy = 1;
            gridBagConstraints4.gridheight = 1;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.insets = new Insets(5, 50, 5, 10);
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 1;
            gridBagConstraints3.gridheight = 1;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.insets = new Insets(5, 10, 5, 50);
            gridBagConstraints2.gridx = 2;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.gridheight = 1;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.insets = new Insets(5, 10, 5, 10);
            gridBagConstraints1.gridx = 1;
            gridBagConstraints1.gridy = 0;
            gridBagConstraints1.gridheight = 1;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(5, 50, 5, 10);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridheight = 1;
            this.colorLabel = new JLabel();
            this.colorLabel.setFont(XissWebUI.labelPlainFont);
            this.colorLabel.setText(" ");
            this.colorsPanel = new JPanel();
            this.colorsPanel.setLayout(new GridBagLayout());
            TitledBorder border = BorderFactory.createTitledBorder(null, "?", 0, 0, XissWebUI.labelPlainFont, XissWebUI.mediumDarkColor);
            this.textDisplayer.registerTitle(border, "colors.border.title");
            this.colorsPanel.setBorder(border);
            this.colorsPanel.add((Component)this.getColorBodyBackgroundPanel(), gridBagConstraints);
            this.colorsPanel.add((Component)this.getColorPageBackgroundPanel(), gridBagConstraints1);
            this.colorsPanel.add((Component)this.getColorForegroundPanel(), gridBagConstraints2);
            this.colorsPanel.add((Component)this.getColorLinkForegroundPanel(), gridBagConstraints3);
            this.colorsPanel.add((Component)this.getColorLinkHoverPanel(), gridBagConstraints4);
            this.colorsPanel.add((Component)this.getColorDisabledForegroundPanel(), gridBagConstraints5);
            this.colorsPanel.add((Component)this.colorLabel, gridBagConstraints6);
        }
        return this.colorsPanel;
    }

    private JPanel getPagePanel() {
        if (this.pagePanel == null) {
            GridBagConstraints centerConstraints = new GridBagConstraints();
            centerConstraints.gridx = 0;
            centerConstraints.insets = new Insets(5, 5, 5, 5);
            centerConstraints.gridy = 0;
            GridBagConstraints pageFontPanelConstraints = new GridBagConstraints();
            pageFontPanelConstraints.gridx = 0;
            pageFontPanelConstraints.insets = new Insets(5, 5, 5, 5);
            pageFontPanelConstraints.gridy = 1;
            GridBagConstraints pageLinkPanelConstraints = new GridBagConstraints();
            pageLinkPanelConstraints.gridx = 0;
            pageLinkPanelConstraints.insets = new Insets(5, 5, 5, 5);
            pageLinkPanelConstraints.fill = 2;
            pageLinkPanelConstraints.gridheight = 1;
            pageLinkPanelConstraints.gridwidth = 1;
            pageLinkPanelConstraints.gridy = 2;
            this.pagePanel = new JPanel();
            this.pagePanel.setLayout(new GridBagLayout());
            TitledBorder border = BorderFactory.createTitledBorder(null, "?", 0, 0, XissWebUI.labelPlainFont, XissWebUI.mediumDarkColor);
            this.textDisplayer.registerTitle(border, "page.border.title");
            this.pagePanel.setBorder(border);
            this.pagePanel.add((Component)this.getCenteredCheckBox(), centerConstraints);
            this.pagePanel.add((Component)this.getPageFontPanel(), pageFontPanelConstraints);
            this.pagePanel.add((Component)this.getPageLinkPanel(), pageLinkPanelConstraints);
        }
        return this.pagePanel;
    }

    private SkinFontPanel getPageFontPanel() {
        if (this.pageFontPanel == null) {
            this.pageFontPanel = new SkinFontPanel();
            this.pageFontPanel.setEditor(this);
        }
        return this.pageFontPanel;
    }

    private JPanel getComponentPanel() {
        if (this.componentPanel == null) {
            GridBagConstraints imageAreaPanelConstraints = new GridBagConstraints();
            imageAreaPanelConstraints.gridx = 0;
            imageAreaPanelConstraints.gridy = 0;
            imageAreaPanelConstraints.insets = new Insets(5, 5, 5, 5);
            imageAreaPanelConstraints.fill = 2;
            GridBagConstraints thumnailsPanelConstraints = new GridBagConstraints();
            thumnailsPanelConstraints.gridx = 0;
            thumnailsPanelConstraints.gridy = 1;
            thumnailsPanelConstraints.insets = new Insets(5, 5, 5, 5);
            thumnailsPanelConstraints.fill = 2;
            GridBagConstraints copyrightFontPanelConstraints = new GridBagConstraints();
            copyrightFontPanelConstraints.gridx = 0;
            copyrightFontPanelConstraints.gridy = 2;
            copyrightFontPanelConstraints.insets = new Insets(5, 5, 5, 5);
            copyrightFontPanelConstraints.fill = 2;
            this.componentPanel = new JPanel();
            this.componentPanel.setLayout(new GridBagLayout());
            TitledBorder border = BorderFactory.createTitledBorder(null, "?", 0, 0, XissWebUI.labelPlainFont, XissWebUI.mediumDarkColor);
            this.textDisplayer.registerTitle(border, "component.border.title");
            this.componentPanel.setBorder(border);
            this.componentPanel.add((Component)this.getImageAreaPanel(), imageAreaPanelConstraints);
            this.componentPanel.add((Component)this.getThumbnailPanel(), thumnailsPanelConstraints);
            this.componentPanel.add((Component)this.getCopyrightFontPanel(), copyrightFontPanelConstraints);
        }
        return this.componentPanel;
    }

    private SkinFontPanel getCopyrightFontPanel() {
        if (this.copyrightFontPanel == null) {
            this.copyrightFontPanel = new SkinFontPanel();
            this.copyrightFontPanel.setEditor(this);
            TitledBorder border = BorderFactory.createTitledBorder(null, "?", 0, 0, subTitleFont, XissWebUI.mediumDarkColor);
            this.textDisplayer.registerTitle(border, "component.copyright.title");
            this.copyrightFontPanel.setBorder(border);
        }
        return this.copyrightFontPanel;
    }

    private JPanel getImageAreaPanel() {
        if (this.imageAreaPanel == null) {
            this.imageAreaMarginErrorLabel = new JLabel();
            this.imageAreaMarginErrorLabel.setVisible(false);
            this.imageAreaMarginErrorLabel.setIcon(XissWebUI.getIcon(ERROR_ICON));
            this.imageAreaMarginLabel = new JLabel();
            this.imageAreaMarginLabel.setText("component.image.area.margin");
            this.textDisplayer.register(this.imageAreaMarginLabel, "component.image.area.margin");
            GridBagConstraints imageAreaMarginLabelConstraints = new GridBagConstraints();
            imageAreaMarginLabelConstraints.anchor = 10;
            imageAreaMarginLabelConstraints.gridx = 0;
            imageAreaMarginLabelConstraints.gridy = 0;
            imageAreaMarginLabelConstraints.insets = new Insets(5, 25, 5, 5);
            GridBagConstraints imageAreaMarginTextFieldConstraints = new GridBagConstraints();
            imageAreaMarginTextFieldConstraints.fill = 0;
            imageAreaMarginTextFieldConstraints.gridx = 1;
            imageAreaMarginTextFieldConstraints.gridy = 0;
            imageAreaMarginTextFieldConstraints.insets = new Insets(5, 5, 5, 5);
            GridBagConstraints imageAreaColorConstraints = new GridBagConstraints();
            imageAreaColorConstraints.anchor = 10;
            imageAreaColorConstraints.gridx = 2;
            imageAreaColorConstraints.gridy = 0;
            imageAreaColorConstraints.insets = new Insets(5, 50, 5, 10);
            GridBagConstraints imageAreaBackgroundConstraints = new GridBagConstraints();
            imageAreaBackgroundConstraints.anchor = 10;
            imageAreaBackgroundConstraints.gridx = 3;
            imageAreaBackgroundConstraints.gridy = 0;
            imageAreaBackgroundConstraints.insets = new Insets(5, 10, 5, 25);
            GridBagConstraints imageAreaMarginErrorConstraints = new GridBagConstraints();
            imageAreaMarginErrorConstraints.gridwidth = 4;
            imageAreaMarginErrorConstraints.anchor = 10;
            imageAreaMarginErrorConstraints.gridx = 0;
            imageAreaMarginErrorConstraints.gridy = 1;
            GridBagConstraints imageAreaBorderConstraints = new GridBagConstraints();
            imageAreaBorderConstraints.gridheight = 1;
            imageAreaBorderConstraints.gridwidth = 4;
            imageAreaBorderConstraints.gridx = 0;
            imageAreaBorderConstraints.gridy = 2;
            imageAreaBorderConstraints.insets = new Insets(5, 5, 5, 5);
            imageAreaBorderConstraints.fill = 2;
            GridBagConstraints imageAreaFontConstraints = new GridBagConstraints();
            imageAreaFontConstraints.gridheight = 1;
            imageAreaFontConstraints.gridwidth = 4;
            imageAreaFontConstraints.gridx = 0;
            imageAreaFontConstraints.gridy = 3;
            imageAreaFontConstraints.insets = new Insets(5, 5, 5, 5);
            imageAreaFontConstraints.fill = 2;
            GridBagConstraints metadataConstraints = new GridBagConstraints();
            metadataConstraints.gridheight = 1;
            metadataConstraints.gridwidth = 4;
            metadataConstraints.gridx = 0;
            metadataConstraints.gridy = 4;
            metadataConstraints.insets = new Insets(5, 5, 5, 5);
            metadataConstraints.fill = 2;
            GridBagConstraints localIndexConstraints = new GridBagConstraints();
            localIndexConstraints.gridheight = 1;
            localIndexConstraints.gridwidth = 4;
            localIndexConstraints.gridx = 0;
            localIndexConstraints.gridy = 5;
            localIndexConstraints.insets = new Insets(5, 5, 5, 5);
            localIndexConstraints.fill = 2;
            GridBagConstraints animationPanelConstraints = new GridBagConstraints();
            animationPanelConstraints.gridx = 0;
            animationPanelConstraints.gridy = 6;
            animationPanelConstraints.gridwidth = 4;
            animationPanelConstraints.insets = new Insets(5, 5, 5, 5);
            animationPanelConstraints.fill = 2;
            this.imageAreaPanel = new JPanel(new GridBagLayout());
            TitledBorder border = BorderFactory.createTitledBorder(null, "?", 0, 0, subTitleFont, XissWebUI.mediumDarkColor);
            this.textDisplayer.registerTitle(border, "component.image.area.title");
            this.imageAreaPanel.setBorder(border);
            this.imageAreaPanel.add((Component)this.imageAreaMarginLabel, imageAreaMarginLabelConstraints);
            this.imageAreaPanel.add((Component)this.getImageAreaMarginTextField(), imageAreaMarginTextFieldConstraints);
            this.imageAreaPanel.add((Component)this.getImageAreaColorPanel(), imageAreaColorConstraints);
            this.imageAreaPanel.add((Component)this.getImageBackgroundPanel(), imageAreaBackgroundConstraints);
            this.imageAreaPanel.add((Component)this.imageAreaMarginErrorLabel, imageAreaMarginErrorConstraints);
            this.imageAreaPanel.add((Component)this.getImageAreaBorderPanel(), imageAreaBorderConstraints);
            this.imageAreaPanel.add((Component)this.getImageAreaFontPanel(), imageAreaFontConstraints);
            this.imageAreaPanel.add((Component)this.getSkinMetaDatatPanel(), metadataConstraints);
            this.imageAreaPanel.add((Component)this.getLocalIndexPanel(), localIndexConstraints);
            this.imageAreaPanel.add((Component)this.getAnimationPanel(), animationPanelConstraints);
        }
        return this.imageAreaPanel;
    }

    private SkinLinesContainerPanel getThumbnailPanel() {
        if (this.thumbnailPanel == null) {
            this.thumbnailPanel = new SkinLinesContainerPanel(3);
            this.thumbnailPanel.setEditor(this);
            this.textDisplayer.register(this.thumbnailPanel.getTitleAt(0), "thumbnail.border.normal");
            this.textDisplayer.register(this.thumbnailPanel.getTitleAt(1), "thumbnail.border.hover");
            this.textDisplayer.register(this.thumbnailPanel.getTitleAt(2), "thumbnail.border.current");
            TitledBorder border = BorderFactory.createTitledBorder(null, "?", 0, 0, subTitleFont, XissWebUI.mediumDarkColor);
            this.textDisplayer.registerTitle(border, "component.thumbnail.title");
            this.thumbnailPanel.setBorder(border);
        }
        return this.thumbnailPanel;
    }

    private SkinLinesContainerPanel getPageLinkPanel() {
        if (this.pageLinkPanel == null) {
            this.pageLinkPanel = new SkinLinesContainerPanel(2);
            this.pageLinkPanel.setEditor(this);
            this.textDisplayer.register(this.pageLinkPanel.getTitleAt(0), "page.link.normal.label");
            this.textDisplayer.register(this.pageLinkPanel.getTitleAt(1), "page.link.hover.label");
        }
        return this.pageLinkPanel;
    }

    private JScrollPane getEditorScrollPane() {
        if (this.editorScrollPane == null) {
            this.editorScrollPane = new JScrollPane();
            this.editorScrollPane.setBounds(new Rectangle(5, 5, 10, 10));
            this.editorScrollPane.setViewportView(this.getEditionPanel());
        }
        return this.editorScrollPane;
    }

    private SkinColorPanel getImageAreaColorPanel() {
        if (this.imageAreaColorPanel == null) {
            this.imageAreaColorPanel = new SkinColorPanel();
            this.imageAreaColorPanel.setEditor(this);
        }
        return this.imageAreaColorPanel;
    }

    private SkinFontPanel getImageAreaFontPanel() {
        if (this.imageAreaFontPanel == null) {
            this.imageAreaFontPanel = new SkinFontPanel();
            this.imageAreaFontPanel.setEditor(this);
            TitledBorder border = BorderFactory.createTitledBorder(null, "comment.font.title", 0, 0, subSubTitleFont, XissWebUI.mediumDarkColor);
            this.imageAreaFontPanel.setBorder(border);
            this.textDisplayer.registerTitle(border, "comment.font.title");
        }
        return this.imageAreaFontPanel;
    }

    private SkinLinesContainerPanel getImageAreaBorderPanel() {
        if (this.imageAreaBorderPanel == null) {
            this.imageAreaBorderPanel = new SkinLinesContainerPanel(1);
            this.imageAreaBorderPanel.setEditor(this);
        }
        return this.imageAreaBorderPanel;
    }

    private JCheckBox getCenteredCheckBox() {
        if (this.centeredCheckBox == null) {
            this.centeredCheckBox = new JCheckBox();
            this.textDisplayer.register(this.centeredCheckBox, "page.centered.check.box");
            this.centeredCheckBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    SkinEditor.this.centeredStateChanged();
                }
            });
        }
        return this.centeredCheckBox;
    }

    private JTextField getImageAreaMarginTextField() {
        if (this.imageAreaMarginTextField == null) {
            this.imageAreaMarginTextField = new JTextField();
            this.imageAreaMarginTextField.setColumns(3);
            this.imageAreaMarginTextField.addKeyListener(new KeyAdapter(){

                public void keyTyped(KeyEvent e) {
                    SkinEditor.this.imageAreaMarginChanhed();
                }
            });
            this.imageAreaMarginTextField.addCaretListener(new CaretListener(){

                public void caretUpdate(CaretEvent e) {
                    SkinEditor.this.imageAreaMarginChanhed();
                }
            });
        }
        return this.imageAreaMarginTextField;
    }

    private SkinColorPanel getImageBackgroundPanel() {
        if (this.imageBackgroundPanel == null) {
            this.imageBackgroundPanel = new SkinColorPanel();
            this.imageBackgroundPanel.setEditor(this);
        }
        return this.imageBackgroundPanel;
    }

    private SkinFontPanel getSkinMetaDatatPanel() {
        if (this.skinMetaDatatPanel == null) {
            this.skinMetaDatatPanel = new SkinFontPanel();
            this.skinMetaDatatPanel.setEditor(this);
            TitledBorder border = BorderFactory.createTitledBorder(null, "metadata.font.title", 0, 0, subSubTitleFont, XissWebUI.mediumDarkColor);
            this.skinMetaDatatPanel.setBorder(border);
            this.textDisplayer.registerTitle(border, "metadata.font.title");
        }
        return this.skinMetaDatatPanel;
    }

    private JPanel getLocalIndexPanel() {
        if (this.localIndexPanel == null) {
            GridBagConstraints backgroundConstraints = new GridBagConstraints();
            backgroundConstraints.insets = new Insets(5, 25, 5, 10);
            backgroundConstraints.gridy = 0;
            backgroundConstraints.gridx = 1;
            GridBagConstraints borderColorConstraints = new GridBagConstraints();
            borderColorConstraints.insets = new Insets(5, 10, 5, 25);
            borderColorConstraints.gridy = 0;
            borderColorConstraints.gridx = 0;
            this.localIndexPanel = new JPanel();
            this.localIndexPanel.setLayout(new GridBagLayout());
            TitledBorder border = BorderFactory.createTitledBorder(null, "local.index", 0, 0, subTitleFont, XissWebUI.mediumDarkColor);
            this.textDisplayer.registerTitle(border, "local.index");
            this.localIndexPanel.setBorder(border);
            this.localIndexPanel.add((Component)this.getLocalIndexBorderColorPanel(), borderColorConstraints);
            this.localIndexPanel.add((Component)this.getLocalIndexBackgroundPanel(), backgroundConstraints);
        }
        return this.localIndexPanel;
    }

    private SkinColorPanel getLocalIndexBorderColorPanel() {
        if (this.localIndexBorderColorPanel == null) {
            this.localIndexBorderColorPanel = new SkinColorPanel();
            this.localIndexBorderColorPanel.setEditor(this);
        }
        return this.localIndexBorderColorPanel;
    }

    private SkinColorPanel getLocalIndexBackgroundPanel() {
        if (this.localIndexBackgroundPanel == null) {
            this.localIndexBackgroundPanel = new SkinColorPanel();
            this.localIndexBackgroundPanel.setEditor(this);
        }
        return this.localIndexBackgroundPanel;
    }

    private JPanel getAnimationPanel() {
        if (this.animationPanel == null) {
            this.animationPanel = new JPanel();
            this.animationPanel.setLayout(new GridBagLayout());
            TitledBorder border = BorderFactory.createTitledBorder(null, "local.index", 0, 0, subTitleFont, XissWebUI.mediumDarkColor);
            this.textDisplayer.registerTitle(border, "animation.title");
            this.animationPanel.setBorder(border);
            JLabel loadScreenBackgroundLabel = new JLabel();
            this.textDisplayer.register(loadScreenBackgroundLabel, "load.screen.background.label");
            GridBagConstraints loadScreenBackgroundLabelConstraints = new GridBagConstraints();
            loadScreenBackgroundLabelConstraints.gridx = 0;
            loadScreenBackgroundLabelConstraints.gridx = 0;
            loadScreenBackgroundLabelConstraints.anchor = 13;
            loadScreenBackgroundLabelConstraints.insets = new Insets(5, 5, 5, 5);
            this.animationPanel.add((Component)loadScreenBackgroundLabel, loadScreenBackgroundLabelConstraints);
            GridBagConstraints loadScreenBackgroundComboBoxConstraints = new GridBagConstraints();
            loadScreenBackgroundComboBoxConstraints.gridx = 1;
            loadScreenBackgroundComboBoxConstraints.gridy = 0;
            loadScreenBackgroundComboBoxConstraints.fill = 2;
            loadScreenBackgroundComboBoxConstraints.anchor = 17;
            loadScreenBackgroundComboBoxConstraints.insets = new Insets(5, 5, 5, 5);
            this.animationPanel.add((Component)this.getLoadScreenBackgroundComboBox(), loadScreenBackgroundComboBoxConstraints);
            JLabel waitIconStyleLabel = new JLabel();
            this.textDisplayer.register(waitIconStyleLabel, "wait.icon.style.label");
            GridBagConstraints waitIconStyleLabelConstraints = new GridBagConstraints();
            waitIconStyleLabelConstraints.gridx = 0;
            waitIconStyleLabelConstraints.gridy = 1;
            waitIconStyleLabelConstraints.anchor = 13;
            waitIconStyleLabelConstraints.insets = new Insets(5, 5, 5, 5);
            this.animationPanel.add((Component)waitIconStyleLabel, waitIconStyleLabelConstraints);
            GridBagConstraints waitIconStyleComboBoxConstraints = new GridBagConstraints();
            waitIconStyleComboBoxConstraints.gridx = 1;
            waitIconStyleComboBoxConstraints.gridy = 1;
            waitIconStyleComboBoxConstraints.fill = 2;
            waitIconStyleComboBoxConstraints.anchor = 17;
            waitIconStyleComboBoxConstraints.insets = new Insets(5, 5, 5, 5);
            this.animationPanel.add((Component)this.getWaitIconStyleComboBox(), waitIconStyleComboBoxConstraints);
            this.waitIconLabel = new JLabel();
            GridBagConstraints waitIconLabelConstraints = new GridBagConstraints();
            waitIconLabelConstraints.gridheight = 2;
            waitIconLabelConstraints.gridx = 2;
            waitIconLabelConstraints.gridy = 0;
            waitIconLabelConstraints.insets = new Insets(0, 5, 0, 5);
            waitIconLabelConstraints.anchor = 17;
            this.animationPanel.add((Component)this.waitIconLabel, waitIconLabelConstraints);
            JLabel opacityLabel = new JLabel();
            this.textDisplayer.register(opacityLabel, "load.screen.opacity.label");
            GridBagConstraints opacityLabelConstraints = new GridBagConstraints();
            opacityLabelConstraints.gridx = 0;
            opacityLabelConstraints.gridy = 2;
            opacityLabelConstraints.anchor = 13;
            opacityLabelConstraints.insets = new Insets(5, 5, 5, 5);
            this.animationPanel.add((Component)opacityLabel, opacityLabelConstraints);
            GridBagConstraints opacitySliderConstraints = new GridBagConstraints();
            opacitySliderConstraints.gridx = 1;
            opacitySliderConstraints.gridy = 2;
            opacitySliderConstraints.fill = 1;
            opacitySliderConstraints.anchor = 17;
            opacitySliderConstraints.insets = new Insets(5, 5, 5, 5);
            this.animationPanel.add((Component)this.getOpacitySlider(), opacitySliderConstraints);
            this.opacityValueLabel = new JLabel();
            this.opacityValueLabel.setFont(XissWebUI.plainFont);
            GridBagConstraints opacityValueLabelConstraints = new GridBagConstraints();
            opacityValueLabelConstraints.gridx = 2;
            opacityValueLabelConstraints.gridy = 2;
            opacityValueLabelConstraints.anchor = 17;
            opacityValueLabelConstraints.insets = new Insets(5, 5, 5, 5);
            this.animationPanel.add((Component)this.opacityValueLabel, opacityValueLabelConstraints);
        }
        return this.animationPanel;
    }

    private JComboBox getLoadScreenBackgroundComboBox() {
        if (this.loadScreenBackgroundComboBox == null) {
            this.loadScreenBackgroundComboBox = new JComboBox();
            this.textDisplayer.registerCombo(this.loadScreenBackgroundComboBox, new String[]{"load.screen.background.white", "load.screen.background.black"});
            this.loadScreenBackgroundComboBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SkinEditor.this.loadScreenBackgroundChanged();
                }
            });
            this.loadScreenBackgroundComboBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    SkinEditor.this.displayWaitIcon();
                }
            });
        }
        return this.loadScreenBackgroundComboBox;
    }

    private JComboBox getWaitIconStyleComboBox() {
        if (this.waitIconStyleComboBox == null) {
            this.waitIconStyleComboBox = new JComboBox();
            this.textDisplayer.registerCombo(this.waitIconStyleComboBox, new String[]{"wait.icon.style.default", "wait.icon.style.bar", "wait.icon.style.flower", "wait.icon.style.pike", "wait.icon.style.roller", "wait.icon.style.wheel-throbber", "wait.icon.style.earth", "wait.icon.style.movie"});
            this.waitIconStyleComboBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SkinEditor.this.waitIconStyleChanged();
                }
            });
            this.waitIconStyleComboBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    SkinEditor.this.displayWaitIcon();
                }
            });
        }
        return this.waitIconStyleComboBox;
    }

    void displayWaitIcon() {
        int b = this.loadScreenBackgroundComboBox.getSelectedIndex();
        int s = this.waitIconStyleComboBox.getSelectedIndex();
        if (b != -1 && s != -1) {
            String icon = WAIT_ICON_PATH + AnimationLoadInfo.iconName(this.waitIconStyleComboBox.getSelectedIndex(), this.loadScreenBackgroundComboBox.getSelectedIndex());
            this.waitIconLabel.setIcon(XissWebUI.getIcon(icon));
        }
    }

    private JSlider getOpacitySlider() {
        if (this.opacitySlider == null) {
            this.opacitySlider = new JSlider();
            Dimension dim = new Dimension();
            dim.height = 40;
            dim.width = 100;
            this.opacitySlider.setPreferredSize(dim);
            this.opacitySlider.setMinimum(0);
            this.opacitySlider.setMaximum(10);
            this.opacitySlider.setPaintTicks(true);
            this.opacitySlider.setSnapToTicks(true);
            this.opacitySlider.setValueIsAdjusting(true);
            this.opacitySlider.setMajorTickSpacing(1);
            this.opacitySlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    SkinEditor.this.opacityValueLabel.setText(Float.toString((float)SkinEditor.this.opacitySlider.getValue() / 10.0f));
                    SkinEditor.this.opacityChanged();
                }
            });
        }
        return this.opacitySlider;
    }
}

