/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.properties.editor;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.xissweb.gui.properties.PropertyEditorObserver;
import org.xissweb.gui.properties.PropertyValueEditor;

public class PropertyEnumEditor
extends JPanel
implements PropertyValueEditor {
    private static final long serialVersionUID = 8579829142536781643L;
    private JComboBox valueField = null;
    private String propertyKey;
    private String initValue;
    private String defaultValue;
    private String[] possibleValues;
    private HashSet observers = new HashSet();

    public PropertyEnumEditor() {
        this.initialize();
    }

    private void initialize() {
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setVgap(10);
        this.setLayout(flowLayout);
        this.add((Component)this.getJComboBox(), null);
    }

    private JComboBox getJComboBox() {
        if (this.valueField == null) {
            this.valueField = new JComboBox();
            this.valueField.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        PropertyEnumEditor.this.notifyObservers((String)e.getItem());
                    }
                }
            });
        }
        return this.valueField;
    }

    public void registerEditorObserver(PropertyEditorObserver observer) {
        this.observers.add(observer);
    }

    void notifyObservers(String value) {
        Iterator i = this.observers.iterator();
        while (i.hasNext()) {
            PropertyEditorObserver observer = (PropertyEditorObserver)i.next();
            observer.propertyValueEdited(this.propertyKey, value);
        }
    }

    protected String[] getPossibleValues() {
        return this.possibleValues;
    }

    public void initEdition(String propKey, String value, String defaultValue, String[] values) {
        this.possibleValues = values;
        this.propertyKey = propKey;
        this.initValue = value;
        this.defaultValue = defaultValue;
        this.valueField.removeAllItems();
        String[] allValues = values;
        if (allValues == null) {
            allValues = this.getPossibleValues();
        }
        for (int i = 0; i < allValues.length; ++i) {
            this.valueField.addItem(allValues[i]);
        }
        this.reset();
    }

    public void reset() {
        if (this.initValue != null) {
            this.valueField.setSelectedItem(this.initValue);
        } else if (this.defaultValue != null) {
            this.valueField.setSelectedItem(this.defaultValue);
        }
    }
}

