/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.properties.editor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.xissweb.file.FileHelper;
import org.xissweb.gui.properties.PropertyEditorObserver;
import org.xissweb.gui.properties.PropertyValueEditor;

public abstract class AbstractPropertyPathEditor
extends JPanel
implements PropertyValueEditor {
    private static final long serialVersionUID = -9082881190708280389L;
    private String propertyKey;
    private String initValue;
    private String defaultValue;
    private JTextField valueField = null;
    private JButton jButton = null;
    private JFileChooser pathSelector;
    private HashSet observers = new HashSet();

    protected AbstractPropertyPathEditor() {
        this.initialize();
    }

    private void initialize() {
        FlowLayout layout = new FlowLayout();
        layout.setVgap(10);
        this.setLayout(layout);
        this.add((Component)this.getJTextField(), null);
        this.add((Component)this.getJButton(), null);
    }

    private JTextField getJTextField() {
        if (this.valueField == null) {
            this.valueField = new JTextField();
            this.valueField.setPreferredSize(new Dimension(320, 20));
            this.valueField.setEditable(this.getPathBase() == null);
            if (this.getPathBase() == null) {
                this.valueField.addKeyListener(new KeyAdapter(){

                    public void keyTyped(KeyEvent e) {
                        AbstractPropertyPathEditor.this.textChanged();
                    }
                });
                this.valueField.addCaretListener(new CaretListener(){

                    public void caretUpdate(CaretEvent e) {
                        AbstractPropertyPathEditor.this.textChanged();
                    }
                });
            }
        }
        return this.valueField;
    }

    void textChanged() {
        this.notifyObservers();
    }

    protected JFileChooser getPathSelector() {
        if (this.pathSelector == null) {
            this.pathSelector = new JFileChooser();
            this.initPathSelector(this.pathSelector);
        }
        return this.pathSelector;
    }

    protected abstract void initPathSelector(JFileChooser var1);

    protected abstract File getPathBase();

    private JButton getJButton() {
        if (this.jButton == null) {
            this.jButton = new JButton();
            this.jButton.setText("...");
            this.jButton.setHorizontalAlignment(2);
            this.jButton.setHorizontalTextPosition(2);
            this.jButton.setPreferredSize(new Dimension(43, 20));
            this.jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (AbstractPropertyPathEditor.this.editValue()) {
                        AbstractPropertyPathEditor.this.notifyObservers();
                    }
                }
            });
        }
        return this.jButton;
    }

    protected boolean editValue() {
        boolean edited = false;
        File base = this.getPathBase();
        if (base != null) {
            this.getPathSelector().setCurrentDirectory(this.getPathBase());
        } else {
            this.getPathSelector().setCurrentDirectory(new File(this.valueField.getText()));
        }
        int returnVal = this.getPathSelector().showOpenDialog(this);
        if (returnVal == 0) {
            String textValue = base != null ? FileHelper.relativePath((File)this.getPathBase(), (File)this.getPathSelector().getSelectedFile()) : this.getPathSelector().getSelectedFile().getAbsolutePath();
            this.valueField.setText(textValue);
            edited = true;
        }
        return edited;
    }

    public void initEdition(String propKey, String value, String defaultValue, String[] values) {
        this.propertyKey = propKey;
        this.initValue = value;
        this.defaultValue = defaultValue;
        this.reset();
    }

    public void reset() {
        if (this.initValue != null) {
            this.valueField.setText(this.initValue);
        } else {
            this.valueField.setText(this.defaultValue);
        }
    }

    public void registerEditorObserver(PropertyEditorObserver observer) {
        this.observers.add(observer);
    }

    void notifyObservers() {
        Iterator i = this.observers.iterator();
        while (i.hasNext()) {
            PropertyEditorObserver observer = (PropertyEditorObserver)i.next();
            observer.propertyValueEdited(this.propertyKey, this.valueField.getText());
        }
    }
}

