/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.project.repository;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.tree.DefaultMutableTreeNode;
import org.xissweb.gui.XissWebUI;
import org.xissweb.gui.project.AbstractNewProjectDialog;
import org.xissweb.gui.project.FileNewProjectTreeModel;
import org.xissweb.gui.project.FileTransferHandler;
import org.xissweb.gui.project.ProjectAnalyzer;
import org.xissweb.i18n.TextDisplayManager;
import org.xissweb.i18n.TextDisplayer;

public class NewRepositoryProjectDialog
extends AbstractNewProjectDialog {
    private static final long serialVersionUID = 1L;
    private static final String IMAGE_REPOSITORY_ICON = "/images/file/repository.png";
    public static final int REPOSITORY_DIR = 0;
    public static final int PROJECT_DIR = 1;
    int currentLocationInAnalyse = -1;
    private File repositoryLocation;
    private ProjectAnalyzer repositoryAnalyser;
    private TextDisplayer textDisplayer = TextDisplayManager.createTextDisplayFor(this.getClass());
    private JPanel mainPanel = null;
    private JLabel repositoryLocationLabel = null;
    private JTextField repositoryLocationTextField = null;
    private JButton repositoryLocationButton = null;

    public NewRepositoryProjectDialog(Frame owner) {
        super(owner);
        this.initialize();
        this.getFileTree().setModel(new FileNewProjectTreeModel(true));
        this.applyPreferences();
        this.imageViewLocationRegistration();
    }

    public int showDialog(File directory, int dirType) {
        if (directory != null) {
            if (dirType == 1) {
                this.performProjectLocation(directory);
            } else if (dirType == 0) {
                this.performRepositoryLocation(directory);
            }
        }
        return super.showDialog();
    }

    protected String getHelpTag() {
        return "newrepositoryproject";
    }

    public File getRepositoryLocation() {
        return this.repositoryLocation;
    }

    protected void performOk() {
        this.option = 0;
        this.setVisible(false);
    }

    public void performProjectLocation() {
        this.performProjectLocation(this.selectAProjectLocation());
    }

    public void performProjectLocation(File location) {
        if (location != null) {
            if (location.equals(this.repositoryLocation)) {
                this.displayEquals(location, "project.equals.to.repository.location", "project.equals.to.repository.equals");
                return;
            }
            File propFile = new File(location, "xissweb.properties");
            if (!propFile.exists()) {
                this.getProjectLocationTextField().setText(location.getAbsolutePath());
                this.currentLocationInAnalyse = 1;
                this.analyseLocation(location, new ProjectAnalyzer(this));
            } else {
                this.displayProjectExistWarning(location);
            }
        }
    }

    void performRepositoryLocation() {
        this.performRepositoryLocation(this.selectAProjectLocation(this.textDisplayer.getString("repository.location.aprouve.text")));
    }

    public void performRepositoryLocation(File location) {
        if (location != null) {
            if (location.equals(this.projectLocation)) {
                this.displayEquals(location, "repository.equals.to.project.location", "repository.equals.to.project.equals");
                return;
            }
            File propFile = new File(location, "xissweb.properties");
            if (!propFile.exists()) {
                this.repositoryLocationTextField.setText(location.getAbsolutePath());
                this.currentLocationInAnalyse = 0;
                this.analyseLocation(location, new ProjectAnalyzer(this));
            } else {
                this.displayProjectImpossibleForRepository(location);
            }
        }
    }

    protected void onFileNodeClicked(DefaultMutableTreeNode node) {
        int nodeType;
        if (node.getUserObject() instanceof Integer && (nodeType = ((Integer)node.getUserObject()).intValue()) == 2) {
            this.performRepositoryLocation();
            return;
        }
        if (node.getUserObject() instanceof File) {
            File file = (File)node.getUserObject();
            if (this.repositoryAnalyser != null && this.repositoryAnalyser.getLocation().equals(file)) {
                this.performRepositoryLocation();
                return;
            }
        }
        super.onFileNodeClicked(node);
    }

    protected void choosedLocationAnalysed(ProjectAnalyzer currentAnalyzer) {
        switch (this.currentLocationInAnalyse) {
            case 1: {
                this.analyzer = currentAnalyzer;
                this.projectLocation = currentAnalyzer.getLocation();
                break;
            }
            case 0: {
                this.repositoryAnalyser = currentAnalyzer;
                this.repositoryLocation = this.repositoryAnalyser.getLocation();
                this.getImageNumberTextField().setText(this.repositoryAnalyser.getImageCount() + " " + this.textDisplayer.getString("repository.nb.images.found"));
            }
        }
        this.displayCurrentChoice(true);
        this.getFileTree().setModel(new FileNewProjectTreeModel(this.projectLocation, this.repositoryLocation));
        this.displayAnalyseResult();
    }

    protected void displayCurrentChoice(boolean display) {
        super.displayCurrentChoice(display);
        this.repositoryLocationButton.setEnabled(display);
        if (display) {
            if (this.repositoryLocation != null) {
                this.repositoryLocationTextField.setText(this.repositoryLocation.getAbsolutePath());
            } else {
                this.repositoryLocationTextField.setText("");
            }
        }
    }

    private void displayAnalyseResult() {
        if (this.repositoryAnalyser != null) {
            if (this.repositoryAnalyser.getImageCount() == 0) {
                this.getImageNumberTextField().setText(this.textDisplayer.getString("repository.no.image.found"));
                this.getAnalyseLabel().setText(this.textDisplayer.getString("repository.no.image.found"));
                this.getAnalyseLabel().setIcon(XissWebUI.getIcon("/images/common/warning.png"));
            } else {
                this.getImageNumberTextField().setText(this.repositoryAnalyser.getImageCount() + " " + this.textDisplayer.getString("repository.nb.images.found"));
                if (!this.repositoryAnalyser.hasDirectoyHierarchy()) {
                    this.getAnalyseLabel().setText(this.textDisplayer.getString("repository.images.wrong.organization"));
                    this.getAnalyseLabel().setIcon(XissWebUI.getIcon("/images/common/warning.png"));
                }
            }
        }
        if (this.isAnalyseOk()) {
            this.getAnalyseLabel().setIcon(null);
            this.getAnalyseLabel().setText("");
        }
        this.getOkButton().setEnabled(this.isReadyToCreateProject());
    }

    private boolean isAnalyseOk() {
        boolean ok = true;
        if (this.repositoryAnalyser != null) {
            ok = this.repositoryAnalyser.getImageCount() > 0 && this.repositoryAnalyser.hasDirectoyHierarchy();
        }
        return ok;
    }

    private boolean isReadyToCreateProject() {
        boolean ready = this.isAnalyseOk() && this.repositoryAnalyser != null && this.analyzer != null;
        return ready;
    }

    protected JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.textDisplayer.registerTitle(this, "title");
            GridBagConstraints helpLabelConstraints = new GridBagConstraints();
            helpLabelConstraints.anchor = 11;
            helpLabelConstraints.gridx = 0;
            helpLabelConstraints.insets = new Insets(2, 5, 2, 15);
            helpLabelConstraints.gridy = 2;
            GridBagConstraints showImgViewerConstraints = new GridBagConstraints();
            showImgViewerConstraints.anchor = 17;
            showImgViewerConstraints.gridx = 2;
            showImgViewerConstraints.insets = new Insets(2, 5, 2, 15);
            showImgViewerConstraints.gridy = 2;
            GridBagConstraints waitingConstaintes = new GridBagConstraints();
            waitingConstaintes.fill = 1;
            waitingConstaintes.gridx = 1;
            waitingConstaintes.gridy = 3;
            waitingConstaintes.weightx = 1.0;
            waitingConstaintes.weighty = 1.0;
            waitingConstaintes.insets = new Insets(5, 5, 5, 5);
            GridBagConstraints fileTreeConstaints = new GridBagConstraints();
            fileTreeConstaints.fill = 1;
            fileTreeConstaints.gridx = 1;
            fileTreeConstaints.gridy = 3;
            fileTreeConstaints.weightx = 1.0;
            fileTreeConstaints.weighty = 1.0;
            fileTreeConstaints.insets = new Insets(5, 5, 5, 5);
            GridBagConstraints constraintsLocLabel = new GridBagConstraints();
            constraintsLocLabel.gridx = 0;
            constraintsLocLabel.gridy = 0;
            constraintsLocLabel.anchor = 13;
            constraintsLocLabel.insets = new Insets(5, 15, 5, 5);
            GridBagConstraints constraintsLocText = new GridBagConstraints();
            constraintsLocText.fill = 2;
            constraintsLocText.gridx = 1;
            constraintsLocText.gridy = 0;
            constraintsLocText.weightx = 1.0;
            constraintsLocText.insets = new Insets(2, 5, 2, 5);
            GridBagConstraints constraintsLocButton = new GridBagConstraints();
            constraintsLocButton.anchor = 17;
            constraintsLocButton.gridx = 2;
            constraintsLocButton.gridy = 0;
            constraintsLocButton.insets = new Insets(2, 5, 2, 15);
            GridBagConstraints imageNumConstraints = new GridBagConstraints();
            imageNumConstraints.fill = 2;
            imageNumConstraints.gridx = 1;
            imageNumConstraints.gridy = 2;
            imageNumConstraints.weightx = 1.0;
            imageNumConstraints.insets = new Insets(2, 5, 2, 5);
            GridBagConstraints constraintsRepLabel = new GridBagConstraints();
            constraintsRepLabel.gridx = 0;
            constraintsRepLabel.gridy = 1;
            constraintsRepLabel.anchor = 13;
            constraintsRepLabel.insets = new Insets(5, 15, 5, 5);
            GridBagConstraints constraintsRepText = new GridBagConstraints();
            constraintsRepText.fill = 2;
            constraintsRepText.gridx = 1;
            constraintsRepText.gridy = 1;
            constraintsRepText.weightx = 1.0;
            constraintsRepText.insets = new Insets(2, 5, 2, 5);
            GridBagConstraints constraintsRepButton = new GridBagConstraints();
            constraintsRepButton.anchor = 17;
            constraintsRepButton.gridx = 2;
            constraintsRepButton.gridy = 1;
            constraintsRepButton.insets = new Insets(2, 5, 2, 15);
            GridBagConstraints analyseInfoConstraints = new GridBagConstraints();
            analyseInfoConstraints.fill = 2;
            analyseInfoConstraints.gridwidth = 3;
            analyseInfoConstraints.gridx = 0;
            analyseInfoConstraints.gridy = 4;
            analyseInfoConstraints.insets = new Insets(5, 5, 5, 5);
            analyseInfoConstraints.weightx = 1.0;
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new GridBagLayout());
            this.mainPanel.add((Component)this.getRepositoryLocationLabel(), constraintsRepLabel);
            this.mainPanel.add((Component)this.getProjectLocationLabel(), constraintsLocLabel);
            this.mainPanel.add((Component)this.getProjectLocationTextField(), constraintsLocText);
            this.mainPanel.add((Component)this.getProjectLocationButton(), constraintsLocButton);
            this.mainPanel.add((Component)this.getRepositoryLocationTextField(), constraintsRepText);
            this.mainPanel.add((Component)this.getRepositoryLocationButton(), constraintsRepButton);
            this.mainPanel.add((Component)this.getImageNumberTextField(), imageNumConstraints);
            this.mainPanel.add(this.getFileTreeContainer(), fileTreeConstaints);
            this.mainPanel.add((Component)this.getWaitPanel(), waitingConstaintes);
            this.mainPanel.add((Component)this.getAnalyseLabel(), analyseInfoConstraints);
            this.mainPanel.add((Component)this.getShowImageViewerCheckBox(), showImgViewerConstraints);
            this.mainPanel.add((Component)this.getHelpLabel(), helpLabelConstraints);
            this.getWaitPanel().setVisible(false);
        }
        return this.mainPanel;
    }

    public JButton getRepositoryLocationButton() {
        if (this.repositoryLocationButton == null) {
            this.repositoryLocationButton = new JButton();
            this.repositoryLocationButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    NewRepositoryProjectDialog.this.performRepositoryLocation();
                }
            });
            this.textDisplayer.register(this.repositoryLocationButton, "repository.location.button");
        }
        return this.repositoryLocationButton;
    }

    private void displayEquals(File location, String key1, String key2) {
        StringBuffer buff = new StringBuffer();
        buff.append(this.textDisplayer.getString(key1)).append(" \"");
        buff.append(location.getAbsolutePath()).append("\" \n");
        buff.append(this.textDisplayer.getString(key2));
        XissWebUI.showErrorMessage(buff, this.textDisplayer.getString("repository.project.location.title"));
    }

    private void displayProjectImpossibleForRepository(File location) {
        StringBuffer buff = new StringBuffer();
        buff.append(this.textDisplayer.getString("repository.project.location.location")).append(" \"");
        buff.append(location.getAbsolutePath()).append("\" \n");
        buff.append(this.textDisplayer.getString("repository.project.location.existing"));
        buff.append("\n\n");
        buff.append(this.textDisplayer.getString("repository.project.location.impossible"));
        XissWebUI.showErrorMessage(buff, this.textDisplayer.getString("repository.project.location.title"));
    }

    public JTextField getRepositoryLocationTextField() {
        if (this.repositoryLocationTextField == null) {
            this.repositoryLocationTextField = new JTextField();
            this.repositoryLocationTextField.setEditable(false);
            this.repositoryLocationTextField.setEnabled(false);
            this.repositoryLocationTextField.setTransferHandler(new FileTransferHandler(this));
        }
        return this.repositoryLocationTextField;
    }

    public JLabel getRepositoryLocationLabel() {
        if (this.repositoryLocationLabel == null) {
            this.repositoryLocationLabel = new JLabel();
            this.repositoryLocationLabel.setIcon(XissWebUI.getIcon(IMAGE_REPOSITORY_ICON));
            this.textDisplayer.register(this.repositoryLocationLabel, "repository.location.label");
        }
        return this.repositoryLocationLabel;
    }
}

