/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.project;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.TransferHandler;
import org.xissweb.gui.project.AbstractNewProjectDialog;
import org.xissweb.gui.project.repository.NewRepositoryProjectDialog;

public class FileTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = -8704699985861636093L;
    private static final DataFlavor fileFlavor = DataFlavor.javaFileListFlavor;
    private AbstractNewProjectDialog dialog;

    public FileTransferHandler(AbstractNewProjectDialog dialog) {
        this.dialog = dialog;
    }

    public boolean importData(JComponent c, Transferable t) {
        if (!this.canImport(c, t.getTransferDataFlavors())) {
            return false;
        }
        try {
            if (this.hasFileFlavor(t.getTransferDataFlavors())) {
                List files = (List)t.getTransferData(fileFlavor);
                if (files.size() == 1 && ((File)files.get(0)).isDirectory()) {
                    NewRepositoryProjectDialog d;
                    File file = (File)files.get(0);
                    JTextField textField = (JTextField)c;
                    if (textField == this.dialog.getProjectLocationTextField()) {
                        this.dialog.performProjectLocation(file);
                    } else if (this.dialog instanceof NewRepositoryProjectDialog && textField == (d = (NewRepositoryProjectDialog)this.dialog).getRepositoryLocationTextField()) {
                        d.performRepositoryLocation(file);
                    }
                    return true;
                }
                return false;
            }
        }
        catch (UnsupportedFlavorException ufe) {
            System.out.println("importData: unsupported data flavor");
        }
        catch (IOException ieo) {
            System.out.println("importData: I/O exception");
        }
        return false;
    }

    public boolean canImport(JComponent c, DataFlavor[] flavors) {
        return this.hasFileFlavor(flavors);
    }

    private boolean hasFileFlavor(DataFlavor[] flavors) {
        for (int i = 0; i < flavors.length; ++i) {
            if (!fileFlavor.equals(flavors[i])) continue;
            return true;
        }
        return false;
    }
}

