/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.layout.editor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import org.xissweb.data.layout.TransitionInfo;
import org.xissweb.gui.editor.DocumentException;
import org.xissweb.gui.layout.LayoutEditor;
import org.xissweb.gui.layout.editor.AbstractLayoutElementEditor;
import org.xissweb.i18n.TextDisplayManager;
import org.xissweb.i18n.TextDisplayer;

public class TransitionInfoEditor
extends AbstractLayoutElementEditor {
    private static final long serialVersionUID = 7445748581325408985L;
    private static final String[] transitionValues = new String[]{"transition.slow", "transition.medium", "transition.fast", "transition.none"};
    private TransitionInfo transition;
    private TextDisplayer textDisplayer = TextDisplayManager.createTextDisplayFor(this.getClass());
    private JLabel transitionLabel = null;
    private JComboBox transitionComboBox = null;

    public TransitionInfoEditor(LayoutEditor mainEditor) {
        super(mainEditor);
        this.initialize();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.insets = new Insets(0, 0, 0, 5);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints.weightx = 1.0;
        this.transitionLabel = new JLabel();
        this.transitionLabel.setText("transition.label");
        this.textDisplayer.register(this.transitionLabel, "transition.label");
        this.setLayout(new GridBagLayout());
        this.add((Component)this.transitionLabel, gridBagConstraints1);
        this.add((Component)this.getTransitionComboBox(), gridBagConstraints);
    }

    protected void initEdition() {
        this.transitionComboBox.setSelectedIndex(this.getTransirtionIndexValue());
    }

    protected void doSave() {
        this.transition.setTransition(this.getTransitionValue());
    }

    private int getTransitionValue() {
        switch (this.getTransitionComboBox().getSelectedIndex()) {
            case 0: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 0;
            }
        }
        return 3;
    }

    private int getTransirtionIndexValue() {
        switch (this.transition.getTransition()) {
            case 0: {
                return 3;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 2;
            }
        }
        return 1;
    }

    public void modified(boolean error) {
        if (!this.initializing && this.transition != null) {
            if (!error) {
                boolean bl = this.isModified = this.transition.getTransition() != this.getTransitionValue();
                if (this.isModified) {
                    this.save();
                }
            }
            this.onError = error;
        }
    }

    public Object getEditedDocument() {
        return this.transition;
    }

    public void setEditedDocument(Object document) throws DocumentException {
        this.transition = (TransitionInfo)document;
    }

    private JComboBox getTransitionComboBox() {
        if (this.transitionComboBox == null) {
            this.transitionComboBox = new JComboBox();
            this.transitionComboBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TransitionInfoEditor.this.modified(false);
                }
            });
            this.textDisplayer.registerCombo(this.transitionComboBox, transitionValues);
        }
        return this.transitionComboBox;
    }
}

