/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.layout.editor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.xissweb.data.layout.ThumbnailsInfoInfo;
import org.xissweb.gui.XissWebUI;
import org.xissweb.gui.editor.number.IntegerValueChecker;
import org.xissweb.gui.layout.LayoutEditor;
import org.xissweb.gui.layout.editor.AbstractLayoutElementEditor;
import org.xissweb.i18n.TextDisplayManager;

public class ThumbnailsInfoEditor
extends AbstractLayoutElementEditor {
    private static final long serialVersionUID = -8181073350335764875L;
    private static final String[] units = new String[]{"unit.pixel", "unit.percent"};
    private static final String[] shapes = new String[]{"shape.rectangle", "shape.square"};
    private static final String[] qualities = new String[]{"quality.low", "quality.high"};
    private ThumbnailsInfoInfo thumbnailsInfo;
    private JLabel sizeLabel = null;
    private JTextField sizeTextField = null;
    private JLabel shapeLabel = null;
    private JLabel titleLabel = null;
    private JComboBox shapeComboBox = null;
    private JLabel errorLabel = null;
    private JLabel unitLabel = null;
    private JComboBox unitComboBox = null;
    private JLabel qualityLabel = null;
    private JComboBox qualityComboBox = null;

    public ThumbnailsInfoEditor(LayoutEditor mainEditor) {
        super(mainEditor);
        this.textDisplayer = TextDisplayManager.createTextDisplayFor(this.getClass());
        this.initialize();
    }

    public void setEditedDocument(Object document) {
        this.thumbnailsInfo = (ThumbnailsInfoInfo)document;
    }

    public Object getEditedDocument() {
        return this.thumbnailsInfo;
    }

    protected void doSave() {
        this.thumbnailsInfo.setSize(this.getSizeValue());
        this.thumbnailsInfo.setShape(this.getShapeValue());
        this.thumbnailsInfo.setUnit(this.getUnitValue());
        this.thumbnailsInfo.setQuality(this.getQualityValue());
    }

    private int getShapeIndex() {
        int index = 0;
        if (this.thumbnailsInfo.getShape() != null) {
            if (this.thumbnailsInfo.getShape().equals("rectangle")) {
                index = 0;
            } else if (this.thumbnailsInfo.getShape().equals("square")) {
                index = 1;
            }
        }
        return index;
    }

    private int getUnitIndex() {
        int index = 0;
        if (this.thumbnailsInfo.getUnit() != null) {
            if (this.thumbnailsInfo.getUnit().equals("px")) {
                index = 0;
            } else if (this.thumbnailsInfo.getUnit().equals("%")) {
                index = 1;
            }
        }
        return index;
    }

    private int getQualityIndex() {
        int index = 0;
        if (this.thumbnailsInfo.getQuality() != null) {
            if (this.thumbnailsInfo.getQuality().equals("low")) {
                index = 0;
            } else if (this.thumbnailsInfo.getQuality().equals("high")) {
                index = 1;
            }
        }
        return index;
    }

    private String getShapeValue() {
        switch (this.getShapeComboBox().getSelectedIndex()) {
            case 0: {
                return "rectangle";
            }
        }
        return "square";
    }

    private String getUnitValue() {
        switch (this.getUnitComboBox().getSelectedIndex()) {
            case 0: {
                return "px";
            }
        }
        return "%";
    }

    private String getQualityValue() {
        switch (this.getQualityComboBox().getSelectedIndex()) {
            case 0: {
                return "low";
            }
        }
        return "high";
    }

    private int getSizeValue() {
        return IntegerValueChecker.getValue(this.getSizeTextField().getText());
    }

    protected void initEdition() {
        this.getSizeTextField().setText(Integer.toString(this.thumbnailsInfo.getSize()));
        this.getShapeComboBox().setSelectedIndex(this.getShapeIndex());
        this.getUnitComboBox().setSelectedIndex(this.getUnitIndex());
        this.getQualityComboBox().setSelectedIndex(this.getQualityIndex());
    }

    public void modified(boolean error) {
        if (!this.initializing && this.thumbnailsInfo != null) {
            if (!error) {
                boolean bl = this.isModified = this.thumbnailsInfo.getSize() != this.getSizeValue() || !this.thumbnailsInfo.getShape().equals(this.getShapeValue()) || !this.thumbnailsInfo.getUnit().equals(this.getUnitValue()) || !this.thumbnailsInfo.getQuality().equals(this.getQualityValue());
                if (this.isModified) {
                    this.save();
                }
            }
            this.onError = error;
        }
    }

    private void initialize() {
        this.errorLabel = new JLabel();
        this.errorLabel.setIcon(XissWebUI.getIcon("/images/common/error.png"));
        this.errorLabel.setText("error");
        this.errorLabel.setVisible(false);
        this.unitLabel = new JLabel();
        this.unitLabel.setText("unit.label");
        this.textDisplayer.register(this.unitLabel, "unit.label");
        this.sizeLabel = new JLabel();
        this.sizeLabel.setText("size.label");
        this.textDisplayer.register(this.sizeLabel, "size.label");
        this.shapeLabel = new JLabel();
        this.shapeLabel.setText("shape.label");
        this.textDisplayer.register(this.shapeLabel, "shape.label");
        this.qualityLabel = new JLabel();
        this.qualityLabel.setText("quality.label");
        this.textDisplayer.register(this.qualityLabel, "quality.label");
        GridBagConstraints qualityComboBoxConstraints = new GridBagConstraints();
        qualityComboBoxConstraints.fill = 0;
        qualityComboBoxConstraints.gridx = 3;
        qualityComboBoxConstraints.gridy = 2;
        qualityComboBoxConstraints.weightx = 200.0;
        qualityComboBoxConstraints.anchor = 18;
        qualityComboBoxConstraints.insets = new Insets(5, 5, 5, 5);
        GridBagConstraints qualityLabelConstraints = new GridBagConstraints();
        qualityLabelConstraints.anchor = 12;
        qualityLabelConstraints.gridx = 2;
        qualityLabelConstraints.gridy = 2;
        qualityLabelConstraints.weighty = 0.0;
        qualityLabelConstraints.insets = new Insets(7, 15, 7, 5);
        GridBagConstraints shapeCOmboBoxConstraints = new GridBagConstraints();
        shapeCOmboBoxConstraints.fill = 2;
        shapeCOmboBoxConstraints.gridx = 1;
        shapeCOmboBoxConstraints.gridy = 2;
        shapeCOmboBoxConstraints.weightx = 1.0;
        shapeCOmboBoxConstraints.anchor = 18;
        shapeCOmboBoxConstraints.insets = new Insets(5, 5, 5, 5);
        GridBagConstraints shapeLabelConstraints = new GridBagConstraints();
        shapeLabelConstraints.anchor = 12;
        shapeLabelConstraints.gridx = 0;
        shapeLabelConstraints.gridy = 2;
        shapeLabelConstraints.weighty = 2000.0;
        shapeLabelConstraints.insets = new Insets(7, 30, 7, 5);
        GridBagConstraints sizeTextFieldConstraints = new GridBagConstraints();
        sizeTextFieldConstraints.fill = 0;
        sizeTextFieldConstraints.gridx = 3;
        sizeTextFieldConstraints.gridy = 1;
        sizeTextFieldConstraints.weightx = 0.0;
        sizeTextFieldConstraints.anchor = 17;
        sizeTextFieldConstraints.insets = new Insets(5, 5, 5, 5);
        GridBagConstraints sizeLabelConstraints = new GridBagConstraints();
        sizeLabelConstraints.anchor = 13;
        sizeLabelConstraints.gridx = 2;
        sizeLabelConstraints.gridy = 1;
        sizeLabelConstraints.insets = new Insets(7, 15, 7, 5);
        GridBagConstraints unitComboBoxConstraints = new GridBagConstraints();
        unitComboBoxConstraints.fill = 2;
        unitComboBoxConstraints.gridx = 1;
        unitComboBoxConstraints.gridy = 1;
        unitComboBoxConstraints.weightx = 1.0;
        unitComboBoxConstraints.anchor = 17;
        unitComboBoxConstraints.insets = new Insets(5, 5, 5, 5);
        GridBagConstraints unitLabelConstraints = new GridBagConstraints();
        unitLabelConstraints.anchor = 13;
        unitLabelConstraints.gridx = 0;
        unitLabelConstraints.gridy = 1;
        unitLabelConstraints.insets = new Insets(7, 30, 7, 5);
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.insets = new Insets(7, 5, 7, 5);
        gridBagConstraints11.gridwidth = 1;
        gridBagConstraints11.gridx = 4;
        gridBagConstraints11.gridy = 1;
        gridBagConstraints11.anchor = 17;
        gridBagConstraints11.weightx = 200.0;
        gridBagConstraints11.gridheight = 1;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 30, 0);
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.gridy = 0;
        this.titleLabel = new JLabel();
        this.titleLabel.setText("editor.label");
        this.textDisplayer.register(this.titleLabel, "editor.title");
        this.titleLabel.setForeground(XissWebUI.darkColor);
        this.titleLabel.setFont(XissWebUI.titleFont);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.titleLabel, gridBagConstraints);
        this.add((Component)this.errorLabel, gridBagConstraints11);
        this.add((Component)this.unitLabel, unitLabelConstraints);
        this.add((Component)this.getUnitComboBox(), unitComboBoxConstraints);
        this.add((Component)this.sizeLabel, sizeLabelConstraints);
        this.add((Component)this.getSizeTextField(), sizeTextFieldConstraints);
        this.add((Component)this.shapeLabel, shapeLabelConstraints);
        this.add((Component)this.getShapeComboBox(), shapeCOmboBoxConstraints);
        this.add((Component)this.qualityLabel, qualityLabelConstraints);
        this.add((Component)this.getQualityComboBox(), qualityComboBoxConstraints);
    }

    private JTextField getSizeTextField() {
        if (this.sizeTextField == null) {
            this.sizeTextField = new JTextField();
            this.sizeTextField.setColumns(5);
            this.sizeTextField.addKeyListener(new KeyAdapter(){

                public void keyTyped(KeyEvent e) {
                    ThumbnailsInfoEditor.this.sizeChanged();
                }
            });
            this.sizeTextField.addCaretListener(new CaretListener(){

                public void caretUpdate(CaretEvent e) {
                    ThumbnailsInfoEditor.this.sizeChanged();
                }
            });
        }
        return this.sizeTextField;
    }

    void sizeChanged() {
        String text = this.sizeTextField.getText();
        int status = IntegerValueChecker.checkValue(text);
        if (status == -1 || status == 2 || status == 0) {
            this.errorLabel.setText(IntegerValueChecker.getMessage(status));
            this.errorLabel.setVisible(true);
            this.modified(true);
        } else {
            this.errorLabel.setVisible(false);
            this.modified(false);
        }
    }

    private JComboBox getShapeComboBox() {
        if (this.shapeComboBox == null) {
            this.shapeComboBox = new JComboBox();
            this.textDisplayer.registerCombo(this.shapeComboBox, shapes);
            this.shapeComboBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent event) {
                    ThumbnailsInfoEditor.this.modified(ThumbnailsInfoEditor.this.onError);
                }
            });
        }
        return this.shapeComboBox;
    }

    private JComboBox getUnitComboBox() {
        if (this.unitComboBox == null) {
            this.unitComboBox = new JComboBox();
            this.textDisplayer.registerCombo(this.unitComboBox, units);
            this.unitComboBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    ThumbnailsInfoEditor.this.modified(ThumbnailsInfoEditor.this.onError);
                }
            });
        }
        return this.unitComboBox;
    }

    private JComboBox getQualityComboBox() {
        if (this.qualityComboBox == null) {
            this.qualityComboBox = new JComboBox();
            this.textDisplayer.registerCombo(this.qualityComboBox, qualities);
            this.qualityComboBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    ThumbnailsInfoEditor.this.modified(ThumbnailsInfoEditor.this.onError);
                }
            });
        }
        return this.qualityComboBox;
    }
}

