/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.layout.editor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.xissweb.data.layout.ThumbnailsInfo;
import org.xissweb.gui.XissWebUI;
import org.xissweb.gui.editor.number.IntegerValueChecker;
import org.xissweb.gui.layout.LayoutEditor;
import org.xissweb.gui.layout.editor.AbstractLayoutElementEditor;
import org.xissweb.i18n.TextDisplayManager;

public class ThumbnailsEditor
extends AbstractLayoutElementEditor {
    private static final long serialVersionUID = 196040226868653814L;
    private ThumbnailsInfo thumbnails;
    private boolean onWidthError;
    private boolean onRangeError;
    private JLabel widthLabel = null;
    private JTextField widthTextField = null;
    private JLabel rangeLabel = null;
    private JLabel titleLabel = null;
    private JLabel widthErrorLabel = null;
    private JTextField rangeTextField = null;
    private JLabel rangeErrorLabel = null;

    public ThumbnailsEditor(LayoutEditor mainEditor) {
        super(mainEditor);
        this.textDisplayer = TextDisplayManager.createTextDisplayFor(this.getClass());
        this.initialize();
    }

    public void setEditedDocument(Object document) {
        this.thumbnails = (ThumbnailsInfo)document;
    }

    public Object getEditedDocument() {
        return this.thumbnails;
    }

    protected void doSave() {
        this.thumbnails.setWidth(IntegerValueChecker.getValue(this.getWidthTextField().getText()));
        this.thumbnails.setRange(IntegerValueChecker.getValue(this.getRangeTextField().getText()));
    }

    protected void initEdition() {
        if (this.thumbnails.getWidth() == -1) {
            this.getWidthTextField().setText("");
        } else {
            this.getWidthTextField().setText(Integer.toString(this.thumbnails.getWidth()));
        }
        if (this.thumbnails.getRange() == -1) {
            this.getRangeTextField().setText("");
        } else {
            this.getRangeTextField().setText(Integer.toString(this.thumbnails.getRange()));
        }
        this.onWidthError = false;
        this.onRangeError = false;
    }

    private int getWidthValue() {
        return IntegerValueChecker.getValue(this.getWidthTextField().getText());
    }

    private int getRangeValue() {
        return IntegerValueChecker.getValue(this.getRangeTextField().getText());
    }

    public void modified(boolean error) {
        if (this.thumbnails != null) {
            if (!error) {
                boolean bl = this.isModified = this.thumbnails.getWidth() != this.getWidthValue() || this.thumbnails.getRange() != this.getRangeValue();
                if (this.isModified) {
                    this.save();
                }
            }
            this.onError = error;
        }
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 2;
        gridBagConstraints1.anchor = 18;
        gridBagConstraints1.insets = new Insets(7, 5, 7, 5);
        gridBagConstraints1.weightx = 200.0;
        gridBagConstraints1.gridy = 2;
        this.rangeErrorLabel = new JLabel();
        this.rangeErrorLabel.setText("JLabel");
        this.rangeErrorLabel.setIcon(XissWebUI.getIcon("/images/common/error.png"));
        this.rangeErrorLabel.setVisible(false);
        this.widthErrorLabel = new JLabel();
        this.widthErrorLabel.setIcon(XissWebUI.getIcon("/images/common/error.png"));
        this.widthErrorLabel.setVisible(false);
        this.widthLabel = new JLabel();
        this.widthLabel.setText("width.label");
        this.textDisplayer.register(this.widthLabel, "width.label");
        this.rangeLabel = new JLabel();
        this.rangeLabel.setText("range.label");
        this.textDisplayer.register(this.rangeLabel, "range.label");
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.fill = 0;
        gridBagConstraints5.gridx = 1;
        gridBagConstraints5.gridy = 2;
        gridBagConstraints5.weightx = 0.0;
        gridBagConstraints5.weighty = 0.0;
        gridBagConstraints5.anchor = 18;
        gridBagConstraints5.insets = new Insets(7, 5, 7, 5);
        GridBagConstraints rangeLabelConstraints = new GridBagConstraints();
        rangeLabelConstraints.insets = new Insets(7, 30, 7, 5);
        rangeLabelConstraints.gridy = 2;
        rangeLabelConstraints.weighty = 2000.0;
        rangeLabelConstraints.anchor = 12;
        rangeLabelConstraints.gridx = 0;
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.fill = 0;
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.gridy = 1;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.weighty = 0.0;
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.insets = new Insets(5, 5, 5, 5);
        GridBagConstraints widthLabelConstraints = new GridBagConstraints();
        widthLabelConstraints.insets = new Insets(7, 30, 7, 5);
        widthLabelConstraints.gridy = 1;
        widthLabelConstraints.weighty = 0.0;
        widthLabelConstraints.gridx = 0;
        widthLabelConstraints.anchor = 13;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(7, 5, 7, 5);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 200.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridheight = 1;
        GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
        gridBagConstraints21.gridx = 0;
        gridBagConstraints21.insets = new Insets(10, 0, 30, 0);
        gridBagConstraints21.weighty = 1.0;
        gridBagConstraints21.gridwidth = 3;
        gridBagConstraints21.gridy = 0;
        this.titleLabel = new JLabel();
        this.titleLabel.setText("editor.label");
        this.textDisplayer.register(this.titleLabel, "editor.title");
        this.titleLabel.setForeground(XissWebUI.darkColor);
        this.titleLabel.setFont(XissWebUI.titleFont);
        this.setLayout(new GridBagLayout());
        this.setSize(400, 300);
        this.setPreferredSize(new Dimension(400, 300));
        this.setMaximumSize(new Dimension(300, 700));
        this.setMinimumSize(new Dimension(300, 700));
        this.add((Component)this.titleLabel, gridBagConstraints21);
        this.add((Component)this.widthErrorLabel, gridBagConstraints);
        this.add((Component)this.widthLabel, widthLabelConstraints);
        this.add((Component)this.getWidthTextField(), gridBagConstraints3);
        this.add((Component)this.rangeErrorLabel, gridBagConstraints1);
        this.add((Component)this.rangeLabel, rangeLabelConstraints);
        this.add((Component)this.getRangeTextField(), gridBagConstraints5);
    }

    private JTextField getWidthTextField() {
        if (this.widthTextField == null) {
            this.widthTextField = new JTextField();
            this.widthTextField.setColumns(10);
            this.widthTextField.addKeyListener(new KeyAdapter(){

                public void keyTyped(KeyEvent e) {
                    ThumbnailsEditor.this.widthChanged();
                }
            });
            this.widthTextField.addCaretListener(new CaretListener(){

                public void caretUpdate(CaretEvent e) {
                    ThumbnailsEditor.this.widthChanged();
                }
            });
        }
        return this.widthTextField;
    }

    void widthChanged() {
        if (!this.initializing) {
            String text = this.widthTextField.getText();
            int status = IntegerValueChecker.checkValue(text);
            if (status == -1 || status == 0) {
                this.widthErrorLabel.setText(IntegerValueChecker.getMessage(status));
                this.widthErrorLabel.setVisible(true);
                this.onWidthError = true;
                this.modified(this.onWidthError);
            } else {
                this.widthErrorLabel.setVisible(false);
                this.onWidthError = false;
                this.modified(this.onRangeError);
            }
        }
    }

    private JTextField getRangeTextField() {
        if (this.rangeTextField == null) {
            this.rangeTextField = new JTextField();
            this.rangeTextField.setColumns(10);
            this.rangeTextField.addKeyListener(new KeyAdapter(){

                public void keyTyped(KeyEvent e) {
                    ThumbnailsEditor.this.rangeChanged();
                }
            });
            this.rangeTextField.addCaretListener(new CaretListener(){

                public void caretUpdate(CaretEvent e) {
                    ThumbnailsEditor.this.rangeChanged();
                }
            });
        }
        return this.rangeTextField;
    }

    void rangeChanged() {
        if (!this.initializing) {
            String text = this.rangeTextField.getText();
            int status = IntegerValueChecker.checkValue(text);
            if (status != 3) {
                this.rangeErrorLabel.setText(IntegerValueChecker.getMessage(status));
                this.rangeErrorLabel.setVisible(true);
                this.onRangeError = true;
                this.modified(this.onRangeError);
            } else {
                this.rangeErrorLabel.setVisible(false);
                this.onRangeError = false;
                this.modified(this.onWidthError);
            }
        }
    }
}

