/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.layout.editor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import org.xissweb.data.layout.ArrangementInfo;
import org.xissweb.data.layout.NavigationBarInfo;
import org.xissweb.data.layout.SlideShowLayoutInfo;
import org.xissweb.gui.XissWebUI;
import org.xissweb.gui.layout.LayoutEditor;
import org.xissweb.gui.layout.editor.AbstractLayoutElementEditor;
import org.xissweb.i18n.TextDisplayManager;

public class NavigationBarEditor
extends AbstractLayoutElementEditor {
    private static final long serialVersionUID = 4710763048377407826L;
    private static final String INIT_ICON = "/images/layout/init.gif";
    private static final String BACKWARD_ICON = "/images/layout/backward.gif";
    private static final String FORWARD_ICON = "/images/layout/forward.gif";
    private static final String NEXT_ICON = "/images/layout/next.gif";
    private static final String PREVIOUS_ICON = "/images/layout/previous.gif";
    private static final String helpTag = "navigation";
    private static final String[] types = new String[]{"type.basic", "type.circular", "type.links", "type.previous", "type.next"};
    private NavigationBarInfo navigationBar;
    private JLabel typeLabel = null;
    private JComboBox typeComboBox = null;
    private JCheckBox previousCheckBox;
    private JCheckBox backwardCheckBox;
    private JCheckBox initCheckBox;
    private JCheckBox forwardCheckBox;
    private JCheckBox nextCheckBox;

    public NavigationBarEditor(LayoutEditor mainEditor) {
        super(mainEditor);
        this.textDisplayer = TextDisplayManager.createTextDisplayFor(this.getClass());
        this.initialize();
    }

    public void setEditedDocument(Object document) {
        this.navigationBar = (NavigationBarInfo)document;
    }

    public Object getEditedDocument() {
        return this.navigationBar;
    }

    protected void doSave() {
        String nBarType = this.getTypeValue();
        SlideShowLayoutInfo layoutInfo = this.mainEditor.getLayoutInfo();
        this.setNavType(layoutInfo.getArrangement().getComponents(), nBarType);
        this.navigationBar.setPrevious(this.previousCheckBox.isSelected());
        this.navigationBar.setBackward(this.backwardCheckBox.isSelected());
        this.navigationBar.setInit(this.initCheckBox.isSelected());
        this.navigationBar.setForward(this.forwardCheckBox.isSelected());
        this.navigationBar.setNext(this.nextCheckBox.isSelected());
    }

    protected void setNavType(List components, String nBarType) {
        Iterator i = components.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (o instanceof NavigationBarInfo) {
                NavigationBarInfo nBarInfo = (NavigationBarInfo)o;
                nBarInfo.setType(nBarType);
                continue;
            }
            if (!(o instanceof ArrangementInfo)) continue;
            ArrangementInfo aInfo = (ArrangementInfo)o;
            this.setNavType(aInfo.getComponents(), nBarType);
        }
    }

    private int getNavigationBarTypeIndex() {
        int index = 0;
        if (this.navigationBar.getType() != null) {
            if (this.navigationBar.getType().equals("basic")) {
                index = 0;
            } else if (this.navigationBar.getType().equals("circular")) {
                index = 1;
            } else if (this.navigationBar.getType().equals("links")) {
                index = 2;
            } else if (this.navigationBar.getType().equals("previous")) {
                index = 3;
            } else if (this.navigationBar.getType().equals("next")) {
                index = 4;
            }
        }
        return index;
    }

    private String getNavigationBarType(int index) {
        switch (index) {
            case 1: {
                return "circular";
            }
            case 2: {
                return "links";
            }
            case 3: {
                return "previous";
            }
            case 4: {
                return "next";
            }
        }
        return "basic";
    }

    private String getTypeValue() {
        return this.getNavigationBarType(this.getTypeComboBox().getSelectedIndex());
    }

    protected void initEdition() {
        this.getTypeComboBox().setSelectedIndex(this.getNavigationBarTypeIndex());
        this.getPreviousCheckBox().setSelected(this.navigationBar.hasPrevious());
        this.getBackwardCheckBox().setSelected(this.navigationBar.hasBackward());
        this.getInitCheckBox().setSelected(this.navigationBar.hasInit());
        this.getForwardCheckBox().setSelected(this.navigationBar.hasForward());
        this.getNextCheckBox().setSelected(this.navigationBar.hasNext());
    }

    public void modified(boolean error) {
        if (!this.initializing && this.navigationBar != null) {
            if (!error) {
                boolean bl = this.isModified = !this.navigationBar.getType().equals(this.getTypeValue()) || this.navigationBar.hasPrevious() != this.previousCheckBox.isSelected() || this.navigationBar.hasBackward() != this.previousCheckBox.isSelected() || this.navigationBar.hasInit() != this.initCheckBox.isSelected() || this.navigationBar.hasForward() != this.forwardCheckBox.isSelected() || this.navigationBar.hasNext() != this.nextCheckBox.isSelected();
                if (this.isModified) {
                    this.save();
                }
            }
            this.onError = error;
        }
    }

    private void initialize() {
        this.typeLabel = new JLabel();
        this.typeLabel.setText("type.label");
        this.textDisplayer.register(this.typeLabel, "type.label");
        GridBagConstraints navLabelConstraints = new GridBagConstraints();
        navLabelConstraints.insets = new Insets(5, 30, 0, 0);
        navLabelConstraints.gridx = 0;
        navLabelConstraints.anchor = 10;
        GridBagConstraints typeComboBoxConstaints = new GridBagConstraints();
        typeComboBoxConstaints.anchor = 17;
        typeComboBoxConstaints.insets = new Insets(5, 5, 5, 5);
        typeComboBoxConstaints.gridheight = 1;
        typeComboBoxConstaints.gridx = 1;
        typeComboBoxConstaints.gridy = 1;
        typeComboBoxConstaints.fill = 0;
        GridBagConstraints typeLabelConstraints = new GridBagConstraints();
        typeLabelConstraints.anchor = 17;
        typeLabelConstraints.gridheight = 1;
        typeLabelConstraints.gridx = 0;
        typeLabelConstraints.gridy = 1;
        typeLabelConstraints.gridwidth = 1;
        typeLabelConstraints.insets = new Insets(7, 30, 7, 5);
        GridBagConstraints previousConstraints = new GridBagConstraints();
        previousConstraints.gridx = 1;
        previousConstraints.gridy = 2;
        previousConstraints.anchor = 17;
        previousConstraints.gridwidth = 1;
        previousConstraints.insets = new Insets(5, 5, 0, 0);
        GridBagConstraints backwardConstraints = new GridBagConstraints();
        backwardConstraints.gridx = 1;
        backwardConstraints.gridy = 3;
        backwardConstraints.anchor = 17;
        backwardConstraints.gridwidth = 1;
        backwardConstraints.insets = new Insets(5, 5, 0, 0);
        GridBagConstraints initConstraints = new GridBagConstraints();
        initConstraints.gridx = 1;
        initConstraints.gridy = 4;
        initConstraints.anchor = 17;
        initConstraints.gridwidth = 1;
        initConstraints.insets = new Insets(5, 5, 0, 0);
        GridBagConstraints forwardConstraints = new GridBagConstraints();
        forwardConstraints.gridx = 1;
        forwardConstraints.gridy = 5;
        forwardConstraints.anchor = 17;
        forwardConstraints.gridwidth = 1;
        forwardConstraints.insets = new Insets(5, 5, 0, 0);
        GridBagConstraints nextConstraints = new GridBagConstraints();
        nextConstraints.gridx = 1;
        nextConstraints.gridy = 6;
        nextConstraints.anchor = 18;
        nextConstraints.weighty = 100.0;
        nextConstraints.weightx = 100.0;
        nextConstraints.gridwidth = 1;
        nextConstraints.insets = new Insets(5, 5, 0, 0);
        this.addTitle(2, helpTag);
        this.add((Component)this.typeLabel, typeLabelConstraints);
        this.add((Component)this.getTypeComboBox(), typeComboBoxConstaints);
        JLabel navLabel = new JLabel();
        navLabel.setIcon(XissWebUI.getIcon(PREVIOUS_ICON));
        navLabelConstraints.gridy = 2;
        this.add((Component)navLabel, navLabelConstraints);
        this.add((Component)this.getPreviousCheckBox(), previousConstraints);
        navLabel = new JLabel();
        navLabel.setIcon(XissWebUI.getIcon(BACKWARD_ICON));
        navLabelConstraints.gridy = 3;
        this.add((Component)navLabel, navLabelConstraints);
        this.add((Component)this.getBackwardCheckBox(), backwardConstraints);
        navLabel = new JLabel();
        navLabel.setIcon(XissWebUI.getIcon(INIT_ICON));
        navLabelConstraints.gridy = 4;
        this.add((Component)navLabel, navLabelConstraints);
        this.add((Component)this.getInitCheckBox(), initConstraints);
        navLabel = new JLabel();
        navLabel.setIcon(XissWebUI.getIcon(FORWARD_ICON));
        navLabelConstraints.gridy = 5;
        this.add((Component)navLabel, navLabelConstraints);
        this.add((Component)this.getForwardCheckBox(), forwardConstraints);
        navLabel = new JLabel();
        navLabel.setIcon(XissWebUI.getIcon(NEXT_ICON));
        navLabelConstraints.anchor = 11;
        navLabelConstraints.gridy = 6;
        navLabelConstraints.insets = new Insets(12, 30, 0, 0);
        this.add((Component)navLabel, navLabelConstraints);
        this.add((Component)this.getNextCheckBox(), nextConstraints);
    }

    private JCheckBox getPreviousCheckBox() {
        if (this.previousCheckBox == null) {
            this.previousCheckBox = this.createNavCheckBox();
            this.previousCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    NavigationBarEditor.this.modified(NavigationBarEditor.this.onError);
                }
            });
            this.textDisplayer.register(this.previousCheckBox, "check.box.previous");
        }
        return this.previousCheckBox;
    }

    private JCheckBox getBackwardCheckBox() {
        if (this.backwardCheckBox == null) {
            this.backwardCheckBox = this.createNavCheckBox();
            this.backwardCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    NavigationBarEditor.this.modified(NavigationBarEditor.this.onError);
                }
            });
            this.textDisplayer.register(this.backwardCheckBox, "check.box.backward");
        }
        return this.backwardCheckBox;
    }

    private JCheckBox getInitCheckBox() {
        if (this.initCheckBox == null) {
            this.initCheckBox = this.createNavCheckBox();
            this.initCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    NavigationBarEditor.this.modified(NavigationBarEditor.this.onError);
                }
            });
            this.textDisplayer.register(this.initCheckBox, "check.box.init");
        }
        return this.initCheckBox;
    }

    private JCheckBox getForwardCheckBox() {
        if (this.forwardCheckBox == null) {
            this.forwardCheckBox = this.createNavCheckBox();
            this.forwardCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    NavigationBarEditor.this.modified(NavigationBarEditor.this.onError);
                }
            });
            this.textDisplayer.register(this.forwardCheckBox, "check.box.forward");
        }
        return this.forwardCheckBox;
    }

    private JCheckBox getNextCheckBox() {
        if (this.nextCheckBox == null) {
            this.nextCheckBox = this.createNavCheckBox();
            this.nextCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    NavigationBarEditor.this.modified(NavigationBarEditor.this.onError);
                }
            });
            this.textDisplayer.register(this.nextCheckBox, "check.box.next");
        }
        return this.nextCheckBox;
    }

    private JCheckBox createNavCheckBox() {
        JCheckBox box = new JCheckBox();
        box.setHorizontalTextPosition(4);
        box.setIconTextGap(5);
        return box;
    }

    private JComboBox getTypeComboBox() {
        if (this.typeComboBox == null) {
            this.typeComboBox = new JComboBox();
            this.textDisplayer.registerCombo(this.typeComboBox, types);
            this.typeComboBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    NavigationBarEditor.this.modified(NavigationBarEditor.this.onError);
                }
            });
        }
        return this.typeComboBox;
    }
}

