/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.layout.editor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.xissweb.data.layout.SlideShowLayoutInfo;
import org.xissweb.gui.XissWebUI;
import org.xissweb.gui.editor.number.IntegerValueChecker;
import org.xissweb.gui.layout.LayoutEditor;
import org.xissweb.gui.layout.editor.AbstractLayoutElementEditor;
import org.xissweb.i18n.TextDisplayManager;

public class LayoutPageEditor
extends AbstractLayoutElementEditor {
    private static final long serialVersionUID = -5607596522848293507L;
    private SlideShowLayoutInfo layout;
    private JTextField commentTextField = null;
    private JLabel commentLabel = null;
    private JLabel pageWidthLabel = null;
    private JTextField pageWidthTextField = null;
    private JLabel errorLabel = null;

    public LayoutPageEditor(LayoutEditor mainEditor) {
        super(mainEditor);
        this.textDisplayer = TextDisplayManager.createTextDisplayFor(this.getClass());
        this.initialize();
    }

    public void setEditedDocument(Object document) {
        this.layout = (SlideShowLayoutInfo)document;
    }

    public Object getEditedDocument() {
        return this.layout;
    }

    protected void doSave() {
        this.layout.setPageWidth(this.getPageWidthValue());
        this.layout.setComment(this.getCommentTextField().getText());
    }

    private int getPageWidthValue() {
        return IntegerValueChecker.getValue(this.getPageWidthTextField().getText());
    }

    protected void initEdition() {
        this.initializing = true;
        this.getCommentTextField().setText(this.layout.getComment());
        this.getPageWidthTextField().setText(Integer.toString(this.layout.getPageWidth()));
    }

    public void modified(boolean error) {
        if (!this.initializing && !error) {
            boolean bl = this.isModified = this.layout.getPageWidth() != this.getPageWidthValue() || !this.getCommentTextField().getText().equals(this.layout.getComment());
            if (this.isModified) {
                this.save();
            }
        }
    }

    private void initialize() {
        this.commentLabel = new JLabel();
        this.commentLabel.setText("label.comment");
        this.textDisplayer.register(this.commentLabel, "label.comment");
        this.errorLabel = new JLabel();
        this.errorLabel.setIcon(XissWebUI.getIcon("/images/common/error.png"));
        this.errorLabel.setVisible(false);
        this.pageWidthLabel = new JLabel();
        this.pageWidthLabel.setText("label.page.width");
        this.textDisplayer.register(this.pageWidthLabel, "label.page.width");
        GridBagConstraints errorLabelConstraints = new GridBagConstraints();
        errorLabelConstraints.insets = new Insets(25, 5, 0, 0);
        errorLabelConstraints.gridx = 1;
        errorLabelConstraints.gridy = 2;
        errorLabelConstraints.anchor = 18;
        GridBagConstraints pageWidthTextFieldConstraints = new GridBagConstraints();
        pageWidthTextFieldConstraints.anchor = 18;
        pageWidthTextFieldConstraints.insets = new Insets(5, 5, 5, 5);
        pageWidthTextFieldConstraints.gridx = 1;
        pageWidthTextFieldConstraints.gridy = 2;
        pageWidthTextFieldConstraints.weightx = 0.0;
        pageWidthTextFieldConstraints.fill = 0;
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.anchor = 12;
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 2;
        gridBagConstraints3.weighty = 2000.0;
        gridBagConstraints3.insets = new Insets(7, 30, 7, 5);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.anchor = 18;
        gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.anchor = 12;
        gridBagConstraints11.gridx = 0;
        gridBagConstraints11.gridy = 1;
        gridBagConstraints11.weighty = 0.0;
        gridBagConstraints11.weightx = 0.0;
        gridBagConstraints11.insets = new Insets(7, 30, 7, 5);
        this.addTitle(3);
        this.add((Component)this.commentLabel, gridBagConstraints11);
        this.add((Component)this.getCommentTextField(), gridBagConstraints2);
        this.add((Component)this.pageWidthLabel, gridBagConstraints3);
        this.add((Component)this.getPageWidthTextField(), pageWidthTextFieldConstraints);
        this.add((Component)this.errorLabel, errorLabelConstraints);
    }

    private JTextField getCommentTextField() {
        if (this.commentTextField == null) {
            this.commentTextField = new JTextField();
            this.commentTextField.setColumns(20);
            this.commentTextField.addKeyListener(new KeyAdapter(){

                public void keyTyped(KeyEvent e) {
                    LayoutPageEditor.this.pageCommentChanged();
                }
            });
            this.commentTextField.addCaretListener(new CaretListener(){

                public void caretUpdate(CaretEvent e) {
                    LayoutPageEditor.this.pageCommentChanged();
                }
            });
        }
        return this.commentTextField;
    }

    void pageCommentChanged() {
        this.modified(false);
    }

    private JTextField getPageWidthTextField() {
        if (this.pageWidthTextField == null) {
            this.pageWidthTextField = new JTextField();
            this.pageWidthTextField.setColumns(20);
            this.pageWidthTextField.addKeyListener(new KeyAdapter(){

                public void keyTyped(KeyEvent e) {
                    LayoutPageEditor.this.pageWidthChanged();
                }
            });
            this.pageWidthTextField.addCaretListener(new CaretListener(){

                public void caretUpdate(CaretEvent e) {
                    LayoutPageEditor.this.pageWidthChanged();
                }
            });
        }
        return this.pageWidthTextField;
    }

    void pageWidthChanged() {
        String text = this.pageWidthTextField.getText();
        int status = IntegerValueChecker.checkValue(text);
        if (status == -1 || status == 0) {
            this.errorLabel.setText(IntegerValueChecker.getMessage(status));
            this.errorLabel.setVisible(true);
            this.modified(true);
        } else {
            this.errorLabel.setVisible(false);
            this.modified(false);
        }
    }
}

