/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.layout.editor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.xissweb.data.layout.ArrangementInfo;
import org.xissweb.gui.XissWebUI;
import org.xissweb.gui.editor.number.IntegerValueChecker;
import org.xissweb.gui.layout.LayoutEditor;
import org.xissweb.gui.layout.editor.AbstractLayoutElementEditor;
import org.xissweb.i18n.TextDisplayManager;

public class ArrangementEditor
extends AbstractLayoutElementEditor {
    private static final long serialVersionUID = -8475112191845654611L;
    private static final String[] orientations = new String[]{"orientation.horizontal", "orientation.vertical"};
    private ArrangementInfo arrangement;
    private JLabel widthLabel = null;
    private JTextField widthTextField = null;
    private JLabel orientationLabel = null;
    private JComboBox orientationComboBox = null;
    private JLabel errorLabel = null;

    public ArrangementEditor(LayoutEditor mainEditor) {
        super(mainEditor);
        this.textDisplayer = TextDisplayManager.createTextDisplayFor(this.getClass());
        this.initialize();
    }

    public void setEditedDocument(Object document) {
        this.arrangement = (ArrangementInfo)document;
    }

    public Object getEditedDocument() {
        return this.arrangement;
    }

    protected void doSave() {
        this.arrangement.setWidth(this.getWidthValue());
        this.arrangement.setOrientation(this.getOrientationValue());
    }

    private int getOrentationIndex() {
        int index = 0;
        if (this.arrangement.getOrientation() != null) {
            if (this.arrangement.getOrientation().equals("vertical")) {
                index = 1;
            } else if (this.arrangement.getOrientation().equals("horizontal")) {
                index = 0;
            }
        }
        return index;
    }

    private String getOrientationValue(int index) {
        switch (index) {
            case 1: {
                return "vertical";
            }
        }
        return "horizontal";
    }

    private int getWidthValue() {
        return IntegerValueChecker.getValue(this.getWidthTextField().getText());
    }

    private String getOrientationValue() {
        return this.getOrientationValue(this.getOrientationComboBox().getSelectedIndex());
    }

    protected void initEdition() {
        if (this.arrangement.getWidth() == -1) {
            this.getWidthTextField().setText("");
        } else {
            this.getWidthTextField().setText(Integer.toString(this.arrangement.getWidth()));
        }
        this.getOrientationComboBox().setSelectedIndex(this.getOrentationIndex());
    }

    public void modified() {
        this.modified(false);
    }

    public void modified(boolean error) {
        if (!this.initializing && this.arrangement != null) {
            if (!error) {
                boolean bl = this.isModified = this.arrangement.getWidth() != this.getWidthValue() || !this.arrangement.getOrientation().equals(this.getOrientationValue());
                if (this.isModified) {
                    this.save();
                }
            }
            this.onError = error;
        }
    }

    private void initialize() {
        this.widthLabel = new JLabel();
        this.widthLabel.setText("width.label");
        this.textDisplayer.register(this.widthLabel, "width.label");
        this.errorLabel = new JLabel();
        this.errorLabel.setIcon(XissWebUI.getIcon("/images/common/error.png"));
        this.errorLabel.setVisible(false);
        this.orientationLabel = new JLabel();
        this.orientationLabel.setText("orientation.label");
        this.textDisplayer.register(this.orientationLabel, "orientation.label");
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.fill = 0;
        gridBagConstraints5.gridx = 1;
        gridBagConstraints5.gridy = 2;
        gridBagConstraints5.weightx = 0.0;
        gridBagConstraints5.anchor = 18;
        gridBagConstraints5.insets = new Insets(5, 5, 5, 5);
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.gridwidth = 1;
        gridBagConstraints4.gridx = 2;
        gridBagConstraints4.gridy = 1;
        gridBagConstraints4.weighty = 0.0;
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.weightx = 200.0;
        gridBagConstraints4.insets = new Insets(7, 5, 7, 5);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.insets = new Insets(7, 30, 7, 5);
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 2;
        gridBagConstraints3.weighty = 2000.0;
        gridBagConstraints3.anchor = 12;
        gridBagConstraints3.ipadx = 0;
        gridBagConstraints3.gridwidth = 1;
        GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
        gridBagConstraints21.fill = 0;
        gridBagConstraints21.gridx = 1;
        gridBagConstraints21.gridy = 1;
        gridBagConstraints21.weightx = 1.0;
        gridBagConstraints21.anchor = 17;
        gridBagConstraints21.insets = new Insets(5, 5, 5, 5);
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.anchor = 12;
        gridBagConstraints11.gridx = 0;
        gridBagConstraints11.gridy = 1;
        gridBagConstraints11.weighty = 0.0;
        gridBagConstraints11.weightx = 0.0;
        gridBagConstraints11.ipadx = 0;
        gridBagConstraints11.insets = new Insets(7, 30, 7, 5);
        this.addTitle(3);
        this.add((Component)this.errorLabel, gridBagConstraints4);
        this.add((Component)this.widthLabel, gridBagConstraints11);
        this.add((Component)this.getWidthTextField(), gridBagConstraints21);
        this.add((Component)this.orientationLabel, gridBagConstraints3);
        this.add((Component)this.getOrientationComboBox(), gridBagConstraints5);
    }

    private JTextField getWidthTextField() {
        if (this.widthTextField == null) {
            this.widthTextField = new JTextField();
            this.widthTextField.setColumns(10);
            this.widthTextField.addKeyListener(new KeyAdapter(){

                public void keyTyped(KeyEvent e) {
                    ArrangementEditor.this.widthChanged();
                }
            });
            this.widthTextField.addCaretListener(new CaretListener(){

                public void caretUpdate(CaretEvent e) {
                    ArrangementEditor.this.widthChanged();
                }
            });
        }
        return this.widthTextField;
    }

    void widthChanged() {
        String text = this.widthTextField.getText();
        int status = IntegerValueChecker.checkValue(text);
        if (status == -1 || status == 0) {
            this.errorLabel.setText(IntegerValueChecker.getMessage(status));
            this.errorLabel.setVisible(true);
            this.modified(true);
        } else {
            this.errorLabel.setVisible(false);
            this.modified(false);
        }
    }

    private JComboBox getOrientationComboBox() {
        if (this.orientationComboBox == null) {
            this.orientationComboBox = new JComboBox();
            this.textDisplayer.registerCombo(this.orientationComboBox, orientations);
            this.orientationComboBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent event) {
                    if (!ArrangementEditor.this.initializing) {
                        ArrangementEditor.this.modified(ArrangementEditor.this.onError);
                    }
                }
            });
        }
        return this.orientationComboBox;
    }
}

