/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.layout;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultMutableTreeNode;
import org.xissweb.data.layout.Arrangeable;
import org.xissweb.data.layout.ArrangementInfo;
import org.xissweb.gui.graphic.GraphicElement;
import org.xissweb.gui.layout.LayoutEditor;
import org.xissweb.gui.layout.LayoutGraphicModel;
import org.xissweb.gui.layout.LayoutTreeModel;
import org.xissweb.gui.util.tree.TreeHelper;

public class LayoutElementTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = 6700794202948612109L;
    DataFlavor nodeFlavor;
    String nodeFlavorType = "application/x-java-jvm-local-objectref;class=javax.swing.tree.DefaultMutableTreeNode";
    LayoutEditor editor;
    JTree source = null;
    DefaultMutableTreeNode originNode = null;
    int targetRow = -1;
    int originRow = 0;

    public LayoutElementTransferHandler(LayoutEditor editor) {
        this.editor = editor;
        try {
            this.nodeFlavor = new DataFlavor(this.nodeFlavorType);
        }
        catch (ClassNotFoundException e) {
            System.out.println("ContentElementTransferHandler: unable to create data flavor");
            e.printStackTrace();
        }
    }

    public boolean importData(JComponent c, Transferable t) {
        if (!this.canImport(c, t.getTransferDataFlavors())) {
            return false;
        }
        JTree target = (JTree)c;
        DefaultMutableTreeNode from = null;
        try {
            if (!this.hasNodeFlavor(t.getTransferDataFlavors())) {
                return false;
            }
            from = (DefaultMutableTreeNode)t.getTransferData(this.nodeFlavor);
        }
        catch (UnsupportedFlavorException ufe) {
            System.out.println("importData: unsupported data flavor");
            return false;
        }
        catch (IOException e) {
            System.out.println("importData: I/O error during transfert");
            return false;
        }
        DefaultMutableTreeNode to = TreeHelper.getSelectedNode(target);
        this.targetRow = target.getMinSelectionRow();
        boolean result = false;
        result = this.source.equals(target) && this.isDroppingToItself() ? false : (to.getUserObject() instanceof ArrangementInfo ? this.doImportInArrangement(target, to, from) : this.doImportOnElement(target, to, from));
        if (!result) {
            this.originNode = null;
        }
        return result;
    }

    private boolean isDroppingToItself() {
        return this.originRow == this.targetRow;
    }

    private void beforeImporatation() {
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.originNode.getParent();
        ArrangementInfo a = (ArrangementInfo)parent.getUserObject();
        a.getComponents().remove(this.originNode.getUserObject());
        parent.remove(this.originNode);
        GraphicElement graphicE = this.editor.getGraphicModel().getElement(parent.getUserObject());
        graphicE.remove(this.editor.getGraphicModel().getElement(this.originNode.getUserObject()));
    }

    private boolean doImportInArrangement(JTree tree, DefaultMutableTreeNode to, DefaultMutableTreeNode from) {
        this.beforeImporatation();
        return this.insertAt(tree, to, from, 0);
    }

    private boolean doImportOnElement(JTree tree, DefaultMutableTreeNode to, DefaultMutableTreeNode from) {
        this.beforeImporatation();
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)to.getParent();
        ArrangementInfo a = (ArrangementInfo)parent.getUserObject();
        int index = a.getComponents().indexOf(to.getUserObject());
        return this.insertAt(tree, parent, from, index + 1);
    }

    private boolean insertAt(JTree tree, DefaultMutableTreeNode aNode, DefaultMutableTreeNode element, int index) {
        ArrangementInfo a = (ArrangementInfo)aNode.getUserObject();
        a.getComponents().add(index, element.getUserObject());
        aNode.insert(element, index);
        GraphicElement graphicE = this.editor.getGraphicModel().getElement(a);
        GraphicElement e = ((LayoutGraphicModel)this.editor.getGraphicModel()).createElement((Arrangeable)element.getUserObject());
        graphicE.insert(e, index);
        return true;
    }

    protected void exportDone(JComponent c, Transferable data, int action) {
        if (action == 2 && this.originNode != null) {
            JTree tree = (JTree)c;
            this.originNode = null;
            LayoutTreeModel treeModel = (LayoutTreeModel)tree.getModel();
            treeModel.nodeStructureChanged((DefaultMutableTreeNode)treeModel.getRoot());
            TreeHelper.expandAll(tree);
            this.editor.modified(false);
        }
    }

    private boolean hasNodeFlavor(DataFlavor[] flavors) {
        if (this.nodeFlavor == null) {
            return false;
        }
        for (int i = 0; i < flavors.length; ++i) {
            if (!flavors[i].equals(this.nodeFlavor)) continue;
            return true;
        }
        return false;
    }

    public boolean canImport(JComponent c, DataFlavor[] flavors) {
        return this.hasNodeFlavor(flavors);
    }

    protected Transferable createTransferable(JComponent c) {
        TreeNodeTransferable transf = null;
        this.source = (JTree)c;
        this.originNode = TreeHelper.getSelectedNode(this.source);
        this.originRow = this.source.getMinSelectionRow();
        if (this.originNode != null && this.originNode.getUserObject() instanceof Arrangeable && this.editor.getLayoutInfo().getArrangement() != this.originNode.getUserObject()) {
            Arrangeable a = (Arrangeable)this.originNode.getUserObject();
            LayoutTreeModel model = (LayoutTreeModel)this.source.getModel();
            transf = new TreeNodeTransferable(model.createNode((Arrangeable)a.clone()));
        }
        return transf;
    }

    public int getSourceActions(JComponent c) {
        return 2;
    }

    public class TreeNodeTransferable
    implements Transferable {
        DefaultMutableTreeNode data;

        public TreeNodeTransferable(DefaultMutableTreeNode node) {
            this.data = node;
        }

        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (!this.isDataFlavorSupported(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.data;
        }

        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{LayoutElementTransferHandler.this.nodeFlavor};
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return LayoutElementTransferHandler.this.nodeFlavor.equals(flavor);
        }
    }
}

