/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.image;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.AffineTransform;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import org.xissweb.gui.XissWebUI;
import org.xissweb.gui.image.ImageDisplayerObsever;
import org.xissweb.image.ImageHelper;
import org.xissweb.project.SlideShowProperties;

public class ImageDisplayer
extends Component {
    private static final long serialVersionUID = 969889369534364548L;
    private static final String IMAGE_ADAPT_SIZE_ICON = "/images/image/adaptsize.png";
    private static final String IMAGE_FULL_SIZE_ICON = "/images/image/fullsize.png";
    private static final String IMAGE_NOT_FOUND_RELATIVE_PATH = "gui/images/content/notFoundImage.png";
    private static final int actionMargin = 10;
    private static final int rounded = 10;
    private static final float thinkness = 2.0f;
    private boolean fullSize = false;
    private ImageDisplayerObsever observer;
    private File imageFile = null;
    private BufferedImage image = null;
    private boolean displayActionState = false;
    private int xAction;
    private int yAction;
    private RoundRectangle2D rectAction;

    public ImageDisplayer() {
        this.initialize();
    }

    public void setObserver(ImageDisplayerObsever observer) {
        this.observer = observer;
    }

    private void initialize() {
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                ImageDisplayer.this.onMouseClicked(e);
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent e) {
                ImageDisplayer.this.onMouseMoved(e);
            }
        });
    }

    void onMouseMoved(MouseEvent e) {
        if (this.displayActionState && !this.rectAction.contains(e.getX(), e.getY())) {
            this.displayActionState = false;
            this.repaint();
        }
    }

    void onMouseClicked(MouseEvent e) {
        boolean bl = this.displayActionState = !this.displayActionState;
        if (this.displayActionState) {
            this.xAction = e.getX();
            this.yAction = e.getY();
            this.repaint();
        } else {
            this.setFullSize(!this.fullSize);
        }
    }

    public void setImageFile(File f) {
        this.imageFile = f;
        if (f != null && !this.imageFile.exists()) {
            this.imageFile = new File(SlideShowProperties.getRsrcDir(), IMAGE_NOT_FOUND_RELATIVE_PATH);
        }
        this.displayActionState = false;
        if (this.imageFile == null) {
            this.image = null;
        } else {
            if (this.observer != null) {
                this.beforeReading();
            }
            this.image = ImageHelper.readImage(this.imageFile);
            if (this.observer != null) {
                this.afterReading();
            }
        }
        this.updateContent();
    }

    private void beforeReading() {
        this.observer.imageFileReadStart(this);
    }

    private void afterReading() {
        this.observer.imageFileReadDone(this);
    }

    public File getImageFile() {
        return this.imageFile;
    }

    public void paint(Graphics g) {
        Graphics2D g2D = (Graphics2D)g;
        if (this.image != null) {
            int imgX = 0;
            int imgY = 0;
            float imgW = this.image.getWidth();
            float imgH = this.image.getHeight();
            float areaW = this.getParent().getWidth();
            float areaH = this.getParent().getHeight();
            float ratio = 1.0f;
            if (!(this.isFullSize() || imgW <= areaW && imgH <= areaH)) {
                ratio = Math.min(areaW / imgW, areaH / imgH);
            }
            imgX = Math.max(0, Math.round((areaW - imgW * ratio) / 2.0f));
            imgY = Math.max(0, Math.round((areaH - imgH * ratio) / 2.0f));
            AffineTransform transf = new AffineTransform(ratio, 0.0f, 0.0f, ratio, imgX, imgY);
            g2D.drawImage(this.image, transf, null);
        }
        if (this.displayActionState) {
            this.displayMenu(g2D, this.fullSize ? XissWebUI.getIcon(IMAGE_ADAPT_SIZE_ICON) : XissWebUI.getIcon(IMAGE_FULL_SIZE_ICON));
        }
    }

    private void displayMenu(Graphics2D g2D, ImageIcon menuImage) {
        int xA = this.xAction - menuImage.getIconWidth() / 2;
        int yA = this.yAction - menuImage.getIconHeight() / 2;
        this.rectAction = new RoundRectangle2D.Double(xA - 10, yA - 10, menuImage.getIconWidth() + 20, menuImage.getIconHeight() + 20, 10.0, 10.0);
        Composite comp = g2D.getComposite();
        Paint p = g2D.getPaint();
        Stroke stroke = g2D.getStroke();
        g2D.setStroke(new BasicStroke(2.0f));
        g2D.setPaint(Color.white);
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2D.draw(this.rectAction);
        g2D.setStroke(stroke);
        g2D.setComposite(AlphaComposite.getInstance(3, 0.5f));
        g2D.fill(this.rectAction);
        g2D.drawImage(menuImage.getImage(), xA, yA, null);
        g2D.setPaint(p);
        g2D.setComposite(comp);
    }

    public void setFullSize(boolean fullSize) {
        this.fullSize = fullSize;
        this.updateContent();
        if (this.observer != null) {
            this.observer.imageSizeTypeChanged(this);
        }
    }

    public boolean isFullSize() {
        return this.fullSize;
    }

    public Dimension getPreferredSize() {
        JViewport view = (JViewport)this.getParent();
        Dimension dim = view.getExtentSize();
        if (this.image != null && this.isFullSize()) {
            int w = this.image.getWidth(null);
            int h = this.image.getHeight(null);
            dim = new Dimension(w, h);
        }
        return dim;
    }

    private void updateContent() {
        this.repaint();
        Container parent = this.getParent();
        if (parent != null) {
            parent = parent.getParent();
        }
        if (parent != null && parent instanceof JScrollPane) {
            ((JScrollPane)parent).revalidate();
        }
    }
}

