/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.examples;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import org.xissweb.gui.examples.ExamplesInstallerDialog;

public class FileTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = -6657499392622233889L;
    private static final DataFlavor fileFlavor = DataFlavor.javaFileListFlavor;
    private ExamplesInstallerDialog exInstaller;

    public FileTransferHandler(ExamplesInstallerDialog exInstaller) {
        this.exInstaller = exInstaller;
    }

    public boolean importData(JComponent c, Transferable t) {
        if (!this.canImport(c, t.getTransferDataFlavors())) {
            return false;
        }
        try {
            if (this.hasFileFlavor(t.getTransferDataFlavors())) {
                List files = (List)t.getTransferData(fileFlavor);
                if (files.size() == 1 && ((File)files.get(0)).isFile() && ExamplesInstallerDialog.isExampleArchive((File)files.get(0))) {
                    this.exInstaller.archiveExempleChoosed((File)files.get(0));
                    return true;
                }
                return false;
            }
        }
        catch (UnsupportedFlavorException ufe) {
            System.out.println("importData: unsupported data flavor");
        }
        catch (IOException ieo) {
            System.out.println("importData: I/O exception");
        }
        return false;
    }

    public boolean canImport(JComponent c, DataFlavor[] flavors) {
        return this.hasFileFlavor(flavors);
    }

    private boolean hasFileFlavor(DataFlavor[] flavors) {
        for (int i = 0; i < flavors.length; ++i) {
            if (!fileFlavor.equals(flavors[i])) continue;
            return true;
        }
        return false;
    }
}

