/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.editor.valid;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import org.xissweb.gui.XissWebUI;
import org.xissweb.gui.editor.valid.EditorErrorComponent;
import org.xissweb.gui.editor.valid.EditorValidHandler;
import org.xissweb.gui.editor.valid.EditorValidInfo;
import org.xissweb.gui.util.LabelCellRenderer;

public class EditorValidTreeCellRenderer
implements TreeCellRenderer {
    private static final long serialVersionUID = 8123702601371232802L;
    private static final String WARN_ICON = "/images/common/warning.png";
    private static final String ERR_ICON = "/images/common/error.png";
    private Font plainTextFont = XissWebUI.plainFont;
    private JPanel panel;
    private JLabel label;

    public EditorValidTreeCellRenderer() {
        FlowLayout layout = new FlowLayout();
        layout.setHgap(1);
        layout.setVgap(1);
        layout.setAlignment(0);
        this.panel = new JPanel(layout);
        this.label = new JLabel();
        this.panel.add(this.label);
        this.panel.setBackground(EditorErrorComponent.backgroundColor);
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        Object userObject = node.getUserObject();
        String data = "";
        if (!node.isRoot()) {
            if (userObject instanceof EditorValidHandler) {
                EditorValidHandler h = (EditorValidHandler)userObject;
                data = h.getEditor().getDocumentName();
                this.label.setIcon(h.getEditor().getIcon());
            } else if (userObject instanceof EditorValidInfo) {
                EditorValidInfo info = (EditorValidInfo)userObject;
                StringBuffer buff = new StringBuffer();
                EditorValidHandler.appendMessage(buff, info);
                data = buff.toString();
                if (info.getErrotType().equals("warning")) {
                    this.label.setIcon(XissWebUI.getIcon(WARN_ICON));
                } else {
                    this.label.setIcon(XissWebUI.getIcon(ERR_ICON));
                }
            }
        }
        String stringValue = tree.convertValueToText(data, sel, expanded, leaf, row, hasFocus);
        this.label.setText(stringValue);
        this.label.setFont(this.plainTextFont);
        this.panel.setBackground(sel ? LabelCellRenderer.selectedBackgroundColor : EditorErrorComponent.backgroundColor);
        return this.panel;
    }
}

