/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.content.links;

import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.xissweb.data.layout.SlideShowLayoutInfo;
import org.xissweb.gui.util.tree.TreeModel;
import org.xissweb.i18n.TextDisplayer;
import org.xissweb.project.links.LinkedSlideshow;

public class LinkedSlideshowTreeModel
extends TreeModel {
    private static final long serialVersionUID = 1L;

    public LinkedSlideshowTreeModel() {
        super(new DefaultMutableTreeNode(null));
    }

    public LinkedSlideshowTreeModel(LinkedSlideshow linkedSlideshow) {
        super(new DefaultMutableTreeNode(null));
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getRoot();
        if (linkedSlideshow != null) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(linkedSlideshow);
            root.add(node);
            this.createNodes(node, linkedSlideshow);
        } else {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(TextDisplayer.getString("selection.empty", this.getClass()));
            root.add(node);
        }
    }

    public LinkedSlideshowTreeModel(List linkedSlideshows) {
        super(new DefaultMutableTreeNode(null));
        Iterator i = linkedSlideshows.iterator();
        while (i.hasNext()) {
            LinkedSlideshow l = (LinkedSlideshow)i.next();
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getRoot();
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(l);
            root.add(node);
            this.createNodes(node, l);
        }
        if (linkedSlideshows.isEmpty()) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(TextDisplayer.getString("links.empty", this.getClass()));
            ((DefaultMutableTreeNode)this.getRoot()).add(node);
        }
    }

    private void createNodes(DefaultMutableTreeNode node, LinkedSlideshow linkedSlideshow) {
        Set s = linkedSlideshow.getSlideshows4layout().keySet();
        Object[] lInfos = s.toArray(new Object[s.size()]);
        Arrays.sort(lInfos, new Comparator(){

            public int compare(Object o1, Object o2) {
                File f1 = ((SlideShowLayoutInfo)o1).getFile();
                File f2 = ((SlideShowLayoutInfo)o2).getFile();
                return f1.compareTo(f2);
            }
        });
        for (int i = 0; i < lInfos.length; ++i) {
            node.add(this.createLayoutNode((SlideShowLayoutInfo)lInfos[i], linkedSlideshow));
        }
    }

    private MutableTreeNode createLayoutNode(SlideShowLayoutInfo lInfo, LinkedSlideshow linkedSlideshow) {
        DefaultMutableTreeNode n = new DefaultMutableTreeNode(lInfo);
        Set s = (Set)linkedSlideshow.getSlideshows4layout().get(lInfo);
        Object[] slideshows = s.toArray(new Object[s.size()]);
        Arrays.sort(slideshows);
        for (int i = 0; i < slideshows.length; ++i) {
            n.add(new DefaultMutableTreeNode(slideshows[i]));
        }
        return n;
    }
}

