/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.content;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import org.xissweb.data.content.ImageInfo;
import org.xissweb.data.content.SlideShowContentInfo;
import org.xissweb.gui.XissWebUI;
import org.xissweb.gui.content.ContentEditor;
import org.xissweb.gui.content.ContentEditorHelper;
import org.xissweb.gui.util.LabelCellRenderer;
import org.xissweb.i18n.TextDisplayer;

public class ContentTreeCellRenderer
implements TreeCellRenderer {
    private static final long serialVersionUID = 8123702601371232802L;
    ContentEditor editor;
    private Font plainTextFont = XissWebUI.plainFont;
    private JPanel panel;
    private JLabel label;

    public ContentTreeCellRenderer(ContentEditor editor) {
        this.editor = editor;
        FlowLayout layout = new FlowLayout();
        layout.setHgap(1);
        layout.setVgap(1);
        layout.setAlignment(0);
        this.panel = new JPanel(layout);
        this.label = new JLabel();
        this.panel.add(this.label);
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        String data;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        Object userObject = node.getUserObject();
        if (ContentEditorHelper.isRootElement(node)) {
            data = userObject instanceof SlideShowContentInfo ? ((SlideShowContentInfo)userObject).getName() : userObject.toString();
        } else if (ContentEditorHelper.isInfoElement(node)) {
            data = TextDisplayer.getString("content.info", this.getClass());
        } else if (ContentEditorHelper.isTitleElement(node)) {
            data = TextDisplayer.getString("content.info.title", this.getClass()) + " = \"" + ((SlideShowContentInfo.Title)userObject).getValue() + '\"';
        } else if (ContentEditorHelper.isDescriptionElement(node)) {
            String s = ContentEditorHelper.getDescriptionValue((SlideShowContentInfo.Description)node.getUserObject(), this.editor.getTextEncoding(), true);
            data = TextDisplayer.getString("content.info.description", this.getClass()) + " = \"" + s + '\"';
        } else if (ContentEditorHelper.isImageInfoElement(node)) {
            ImageInfo iInfo = (ImageInfo)node.getUserObject();
            data = ContentEditor.imageInfoToString(iInfo) + " \"" + ContentEditorHelper.getCommentValue(iInfo, this.editor.getTextEncoding(), true) + '\"';
        } else {
            data = userObject.toString();
        }
        String stringValue = tree.convertValueToText(data, sel, expanded, leaf, row, hasFocus);
        this.label.setText(stringValue);
        this.label.setIcon(this.getElementIcon(node));
        this.label.setFont(this.plainTextFont);
        this.panel.setBackground(sel ? LabelCellRenderer.selectedBackgroundColor : Color.white);
        return this.panel;
    }

    public ImageIcon getElementIcon(DefaultMutableTreeNode node) {
        if (ContentEditorHelper.isImageInfoElement(node)) {
            return this.getImage((ImageInfo)node.getUserObject());
        }
        return ContentEditorHelper.getContentElementIcon(node);
    }

    private ImageIcon getImage(ImageInfo iInfo) {
        return this.editor.getImageThumbnail(iInfo);
    }
}

