/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.content;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import org.xissweb.data.content.ImageInfo;
import org.xissweb.data.content.ImageMetaData;
import org.xissweb.data.content.SectionInfo;
import org.xissweb.data.content.SlideShowContentInfo;
import org.xissweb.data.content.SlideShowRefInfo;
import org.xissweb.data.content.xml.ContentDeserializer;
import org.xissweb.data.content.xml.ContentSerializer;
import org.xissweb.data.imetadata.ImageMetadataHelper;
import org.xissweb.data.layout.ThumbnailsInfoInfo;
import org.xissweb.file.FileHelper;
import org.xissweb.gui.Main;
import org.xissweb.gui.XissWebUI;
import org.xissweb.gui.content.ContentEditorHelper;
import org.xissweb.gui.content.ContentElementEditorObserver;
import org.xissweb.gui.content.ContentTextEditor;
import org.xissweb.gui.content.ContentTreeCellEditor;
import org.xissweb.gui.content.ContentTreeCellRenderer;
import org.xissweb.gui.content.ContentTreeModel;
import org.xissweb.gui.content.ListContentElementTransferHandler;
import org.xissweb.gui.content.MetaDataTableCellEditor;
import org.xissweb.gui.content.MetaDataTableModel;
import org.xissweb.gui.content.MetaDataTableRenderer;
import org.xissweb.gui.editor.DocumentException;
import org.xissweb.gui.editor.Editor;
import org.xissweb.gui.editor.EditorsContainer;
import org.xissweb.gui.editor.ValidProcessHandler;
import org.xissweb.gui.file.FileManager;
import org.xissweb.gui.image.ImageDisplayer;
import org.xissweb.gui.image.ImageDisplayerObsever;
import org.xissweb.gui.util.ShowHelper;
import org.xissweb.gui.util.tree.TreeHelper;
import org.xissweb.gui.worker.SwingWorker;
import org.xissweb.i18n.LangChangedOberver;
import org.xissweb.i18n.TextDisplayManager;
import org.xissweb.i18n.TextDisplayer;
import org.xissweb.image.ImageData;
import org.xissweb.image.ImageHelper;
import org.xissweb.prefs.ui.SplitPaneConfigurator;
import org.xissweb.produce.SlideShowDirectory;
import org.xissweb.produce.build.Builder;
import org.xissweb.project.SlideShowProject;

public class ContentEditor
extends JSplitPane
implements Editor,
LangChangedOberver,
ContentElementEditorObserver,
TreeSelectionListener,
ImageDisplayerObsever {
    private static final long serialVersionUID = 8328476134329576418L;
    private static final String CONTENT_NOT_FOUND_THUMBNAIL = "/images/content/notFoundThumbnail.png";
    static final String[] IMAGE_TYPE_KEYS = new String[]{"P", "F", "C", "U"};
    private static final String KEY_BUILD_PAGES = "B";
    private static final String KEY_SHOW_SLIDE_SHOW = "D";
    private static final String IMAGE_DISPLAYER_FULL_SIZE = "image.displayer.full.size";
    private static final String META_DATA_DIVIDER_POSITION = "meta.data.divider.position";
    private static final String IMAGE_PART_PANEL_DIVIDER_POSITION = "image.part.panel.divider.position";
    private static final int linkNodeOffset = 1;
    private Builder builder;
    private SlideShowProject project;
    File contentFile = null;
    private File imageDir = null;
    private ImageHelper thumbnailCreator = new ImageHelper();
    SlideShowContentInfo contentInfo = null;
    private HashMap thumbnails = new HashMap();
    private HashMap imageLastModified = new HashMap();
    private EditorsContainer editorsContainer;
    ContentDeserializer reader = new ContentDeserializer();
    private ContentSerializer writer = new ContentSerializer();
    boolean isModified = false;
    private ContentTextEditor contentTextEditor = null;
    ContentTreeModel treeModel = null;
    private ThumbnailsInfoInfo thumbnailInfo = null;
    private TextDisplayer textDisplay;
    private DefaultMutableTreeNode currentNodeInAction;
    private JFileChooser fileChooser = null;
    private JScrollPane treeContainer = null;
    JTree contentTree = null;
    private JPopupMenu contentPopupMenu = null;
    private JMenuItem addNextLinkMenuItem = null;
    private JMenuItem addPreviousLinkMenuItem = null;
    private JMenuItem addSectionMenuItem = null;
    private JPopupMenu sectionPopupMenu = null;
    private JMenuItem editSectionTitleMenuItem = null;
    private JMenuItem removeSectionMenuItem = null;
    private JPopupMenu ImagePopupMenu = null;
    private JMenuItem editImageCommentMenuItem = null;
    private JMenuItem showImagePageMenuItem = null;
    private JMenuItem rebuildImagePageMenuItem = null;
    private JPopupMenu linkPopupMenu = null;
    private JMenuItem removeLinkMenuItem = null;
    private JMenuItem editTextLinkMenuItem = null;
    private JMenuItem editRefLinkMenuItem = null;
    private JMenuItem[] menuItems = null;
    private JMenuItem buildContainerMenuItem = null;
    private JMenuItem showContainerMenuItem = null;
    private JPopupMenu InfoPopupMenu = null;
    private JMenuItem editInfoMenuItem = null;
    private JMenuItem insertSectionMenuItem = null;
    private JSplitPane imagePartPanel = null;
    private JScrollPane imageScrollPane = null;
    private ImageDisplayer imageDisplayer = null;
    private JSplitPane leftSideSplitPane = null;
    private JScrollPane metaDataScrollPane = null;
    private JTable metaDataTable = null;
    private JMenuItem filmImageTypeMenuItem = null;
    private JMenuItem processingImageTypeMenuItem = null;
    private JMenuItem unknownImageTypeMenuItem = null;
    private JMenuItem digitalPhotoImageTypeMenuItem = null;
    private JMenuItem restoreImageMetaDataMenuItem = null;
    private JMenuItem resetDefaultImageCommentMenuItem = null;
    private JMenu moveToMenu = null;
    static /* synthetic */ Class class$org$xissweb$gui$content$ContentEditor;
    static /* synthetic */ Class class$java$lang$Object;

    static String imageInfoToString(ImageInfo iInfo) {
        StringBuffer buff = new StringBuffer();
        int iType = iInfo.getMetaData().getImageType();
        buff.append(iInfo.getFileName()).append(" (");
        buff.append(TextDisplayer.getString("numeber.image", class$org$xissweb$gui$content$ContentEditor == null ? (class$org$xissweb$gui$content$ContentEditor = ContentEditor.class$("org.xissweb.gui.content.ContentEditor")) : class$org$xissweb$gui$content$ContentEditor));
        buff.append(iInfo.getNumber()).append(") [");
        buff.append(IMAGE_TYPE_KEYS[iType]).append("] ");
        buff.append(iInfo.getMainImageDesc().getWidth()).append('x');
        buff.append(iInfo.getMainImageDesc().getHeight());
        return buff.toString();
    }

    public ContentEditor() {
        this.project = Main.get().getCurrentProject();
        this.textDisplay = TextDisplayManager.createTextDisplayFor(class$org$xissweb$gui$content$ContentEditor == null ? (class$org$xissweb$gui$content$ContentEditor = ContentEditor.class$("org.xissweb.gui.content.ContentEditor")) : class$org$xissweb$gui$content$ContentEditor);
        this.initialize();
        this.applyPreferences();
        TextDisplayManager.get().addObserver(this);
    }

    private void applyPreferences() {
        String prefsCategory = this.getClass().getName();
        SplitPaneConfigurator.configure((JSplitPane)this, (String)prefsCategory);
        SplitPaneConfigurator.configure((JSplitPane)this.leftSideSplitPane, (String)prefsCategory, (String)META_DATA_DIVIDER_POSITION);
        SplitPaneConfigurator.configure((JSplitPane)this.imagePartPanel, (String)prefsCategory, (String)IMAGE_PART_PANEL_DIVIDER_POSITION);
    }

    void storeImagePartPanelDividerPreferences() {
        Main.preferences.putInt(IMAGE_PART_PANEL_DIVIDER_POSITION, this.getClass(), this.imagePartPanel.getDividerLocation());
    }

    private void storeImageFullSizePreferences() {
        Main.preferences.putBoolean(IMAGE_DISPLAYER_FULL_SIZE, this.getClass(), this.imageDisplayer.isFullSize());
    }

    private Builder getBuilder() {
        if (this.builder == null) {
            this.builder = new Builder();
            this.builder.setProject(this.project);
        }
        return this.builder;
    }

    File getContentFile() {
        return this.contentFile;
    }

    SlideShowContentInfo getContentInfo() {
        return this.contentInfo;
    }

    private File getImageFile(ImageInfo iInfo) {
        File imageFile = new File(this.imageDir, iInfo.mainFileName());
        if (!imageFile.exists()) {
            File dir = FileHelper.fileInTargetDir((File)this.project.getSrcDirectory(), (File)this.contentFile.getParentFile(), (File)this.project.getRepositoryDirectory());
            if ((dir = SlideShowDirectory.imageDirectory(dir, this.project.getProperties())) != null) {
                imageFile = new File(dir, iInfo.originalFileName());
            }
        }
        return imageFile;
    }

    Dimension imageSize(ImageInfo iInfo) {
        return this.getThumbnailsInfo().thumbnailSize(iInfo.getMainImageDesc().getWidth(), iInfo.getMainImageDesc().getHeight());
    }

    private ImageIcon createImageThumbnail(ImageInfo iInfo) {
        ImageIcon thumbnail = null;
        Dimension dim = this.imageSize(iInfo);
        int width = dim.width;
        int height = dim.height;
        int quality = 1;
        File imgFile = this.getImageFile(iInfo);
        if (imgFile != null && imgFile.exists()) {
            try {
                Image img = this.thumbnailCreator.resize(imgFile, width, height, quality);
                thumbnail = new ImageIcon(img);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (thumbnail == null) {
            thumbnail = XissWebUI.getIcon(CONTENT_NOT_FOUND_THUMBNAIL);
        }
        this.thumbnails.put(iInfo.getIdentifier(), thumbnail);
        this.imageLastModified.put(iInfo.getIdentifier(), imgFile == null ? new Long(-1L) : new Long(imgFile.lastModified()));
        return thumbnail;
    }

    ImageIcon getImageThumbnail(ImageInfo iInfo) {
        ImageIcon thumb = (ImageIcon)this.thumbnails.get(iInfo.getIdentifier());
        if (thumb == null) {
            thumb = this.createImageThumbnail(iInfo);
        } else {
            Long lastModified = (Long)this.imageLastModified.get(iInfo.getIdentifier());
            File imageFile = this.getImageFile(iInfo);
            if (lastModified >= 0L && imageFile.lastModified() > lastModified) {
                thumb = this.createImageThumbnail(iInfo);
            }
        }
        return thumb;
    }

    public void valueChanged(TreeSelectionEvent event) {
        try {
            TreePath[] tPaths = this.contentTree.getSelectionPaths();
            DefaultMutableTreeNode node = null;
            if (tPaths != null) {
                ArrayList<Object> listImg = new ArrayList<Object>();
                for (int i = 0; i < tPaths.length; ++i) {
                    DefaultMutableTreeNode n = (DefaultMutableTreeNode)tPaths[i].getLastPathComponent();
                    if (!ContentEditorHelper.isImageInfoElement(n)) continue;
                    if (listImg.isEmpty()) {
                        node = n;
                    }
                    listImg.add(n.getUserObject());
                }
                if (!listImg.isEmpty()) {
                    this.metaDataTable.setModel(new MetaDataTableModel(this, listImg));
                    ImageInfo iInfo = (ImageInfo)listImg.get(0);
                    this.imageDisplayer.setImageFile(this.getImageFile(iInfo));
                    this.contentTextEditor.setEditedDocument(node);
                } else {
                    this.metaDataTable.setModel(new MetaDataTableModel(this, null));
                    this.imageDisplayer.setImageFile(null);
                    node = (DefaultMutableTreeNode)tPaths[0].getLastPathComponent();
                    if (!ContentEditorHelper.isRootElement(node) && !ContentEditorHelper.isInfoElement(node)) {
                        this.contentTextEditor.setEditedDocument(node);
                    } else {
                        this.contentTextEditor.setEditedDocument(null);
                    }
                }
            } else {
                this.metaDataTable.setModel(new MetaDataTableModel(this, null));
                this.imageDisplayer.setImageFile(null);
                this.contentTextEditor.setEditedDocument(null);
            }
            this.contentTextEditor.edit();
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
    }

    private ThumbnailsInfoInfo getThumbnailsInfo() {
        if (this.thumbnailInfo == null) {
            this.thumbnailInfo = ContentEditorHelper.getThumbnailsInfo(this.project, this.contentFile);
        }
        return this.thumbnailInfo;
    }

    public void elementEditionEnd(Object editor, DefaultMutableTreeNode node, boolean modified) {
        if (editor == this.contentTextEditor) {
            if (modified) {
                this.treeModel.nodeChanged(node);
            }
        } else {
            this.contentTree.setEditable(false);
            this.contentTextEditor.reload();
            this.contentTextEditor.setEditionEnabled(true);
        }
        if (modified) {
            this.modified(false);
        }
    }

    public void modified(boolean error) {
        if (!this.isModified) {
            this.isModified = true;
            this.editorsContainer.editorStatusChange(this, 1);
        }
    }

    private JFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser(this.contentFile.getParentFile().getParentFile());
            this.fileChooser.setFileSelectionMode(1);
            this.fileChooser.addChoosableFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory() && new File(file, "slideshow.xml").exists();
                }

                public String getDescription() {
                    return ResourceBundle.getBundle((class$org$xissweb$gui$content$ContentEditor == null ? (class$org$xissweb$gui$content$ContentEditor = ContentEditor.class$("org.xissweb.gui.content.ContentEditor")) : class$org$xissweb$gui$content$ContentEditor).getName()).getString("file.chooser.filter.description");
                }
            });
        }
        return this.fileChooser;
    }

    public void langChanged() {
        this.fileChooser = null;
        this.ImagePopupMenu = null;
    }

    File getSlideShowDirLink() {
        File result = null;
        int returnVal = this.getFileChooser().showOpenDialog(this);
        if (returnVal == 0) {
            result = this.getFileChooser().getSelectedFile();
        }
        return result;
    }

    public void setEditorsContainer(EditorsContainer editorsContainer) {
        this.editorsContainer = editorsContainer;
    }

    public void setEditedDocument(Object document) throws DocumentException {
        File f = (File)document;
        if (!f.exists()) {
            throw new DocumentException(f + " " + this.textDisplay.getString("file.do.not.exist"));
        }
        this.contentFile = f;
        this.imageDir = SlideShowDirectory.imageDirectory(this.contentFile.getParentFile(), this.project.getProperties());
    }

    public Object getEditedDocument() {
        return this.contentFile;
    }

    public String getTextEncoding() {
        return this.contentInfo == null ? null : this.contentInfo.getEncoding();
    }

    public boolean isReadOnly() {
        return !this.contentFile.canWrite();
    }

    public void edit() {
        if (this.contentInfo == null) {
            this.loadAndUpdateGUI();
            this.editorsContainer.editorStatusChange(this, 0);
        }
    }

    public JMenuItem[] getMenuItems() {
        if (this.menuItems == null) {
            this.menuItems = new JMenuItem[2];
            this.menuItems[0] = this.getBuildContainerMenuItem();
            this.menuItems[1] = this.getShowContainerMenuItem();
        }
        this.showContainerMenuItem.setEnabled(ShowHelper.hasHtmlToShow(this.contentFile.getParentFile()));
        return this.menuItems;
    }

    private JMenuItem getBuildContainerMenuItem() {
        if (this.buildContainerMenuItem == null) {
            this.buildContainerMenuItem = new JMenuItem();
            this.textDisplay.register(this.buildContainerMenuItem, "build.container.menu.item");
            this.buildContainerMenuItem.setAccelerator(KeyStroke.getKeyStroke(66, 10));
            this.buildContainerMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ContentEditor.this.performBuildOneSlideShow();
                }
            });
        }
        return this.buildContainerMenuItem;
    }

    private JMenuItem getShowContainerMenuItem() {
        if (this.showContainerMenuItem == null) {
            this.showContainerMenuItem = new JMenuItem();
            this.textDisplay.register(this.showContainerMenuItem, "show.container.menu.item");
            this.showContainerMenuItem.setAccelerator(KeyStroke.getKeyStroke(68, 10));
            this.showContainerMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ContentEditor.this.performShowOneSlideShow();
                }
            });
        }
        return this.showContainerMenuItem;
    }

    private void loadAndUpdateGUI() {
        this.contentInfo = null;
        this.contentInfo = this.reader.deserialize(this.contentFile);
        this.treeModel = new ContentTreeModel(this.contentInfo);
        this.getContentTree().setModel(this.treeModel);
        this.isModified = false;
        TreeHelper.expandAll(this.getContentTree());
        this.getContentTree().setSelectionPath(null);
    }

    public void edit(Object object) {
        this.edit();
        TreeHelper.selectNode(this.contentTree, this.treeModel.getNodeFromUserObject(object), true);
    }

    public void setValidProcessHandler(ValidProcessHandler handler) {
    }

    public ValidProcessHandler getValidProcessHandler() {
        return null;
    }

    public boolean isDocumentValid() {
        return true;
    }

    public int save() {
        this.contentInfo.setEncoding(this.project.getProperties().getSlideshowEncoding());
        this.writer.serialize(this.contentFile, this.contentInfo);
        this.isModified = false;
        TableModel model = this.metaDataTable.getModel();
        if (model instanceof MetaDataTableModel) {
            ((MetaDataTableModel)this.metaDataTable.getModel()).resetEdition();
        }
        this.editorsContainer.editorStatusChange(this, 3);
        return 0;
    }

    public void cancel() {
        this.contentInfo = null;
        this.thumbnailInfo = null;
        this.loadAndUpdateGUI();
        this.editorsContainer.editorStatusChange(this, 2);
    }

    public void reload() {
        if (!this.isModified) {
            this.contentInfo = null;
            this.thumbnailInfo = null;
            this.thumbnails.clear();
            this.loadAndUpdateGUI();
        }
    }

    public String getDocumentName() {
        return FileHelper.relativePath((File)this.project.getSrcDirectory(), (File)this.contentFile);
    }

    public boolean hasDocumentModified() {
        return this.isModified;
    }

    public Component getEditorGuiComponent() {
        return this;
    }

    public Icon getIcon() {
        return FileManager.geFileIcon(this.contentFile);
    }

    private void initialize() {
        this.setContinuousLayout(true);
        this.setSize(new Dimension(328, 365));
        this.setLeftComponent(this.getLeftSideSplitPane());
        this.setRightComponent(this.getImagePartPanel());
    }

    private JScrollPane getTreeContainer() {
        if (this.treeContainer == null) {
            this.treeContainer = new JScrollPane();
            this.treeContainer.setViewportView(this.getContentTree());
        }
        return this.treeContainer;
    }

    JTree getContentTree() {
        if (this.contentTree == null) {
            this.contentTree = new JTree();
            this.contentTree.setModel(new ContentTreeModel());
            this.contentTree.setCellRenderer(new ContentTreeCellRenderer(this));
            this.contentTree.setCellEditor(new ContentTreeCellEditor(this.contentTree, new DefaultTreeCellRenderer(), this));
            this.contentTree.setTransferHandler(new ListContentElementTransferHandler(this));
            this.contentTree.setDragEnabled(true);
            this.contentTree.setRootVisible(true);
            this.contentTree.addTreeSelectionListener(this);
            this.contentTree.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 1 && (e.getModifiers() == 4 || e.getModifiers() == 18)) {
                        ContentEditor.this.onRightClick(e);
                    }
                }
            });
            this.contentTree.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    ContentEditor.this.onKeyPressed(e);
                }

                public void keyTyped(KeyEvent e) {
                    ContentEditor.this.onKeyTyped(e);
                }
            });
        }
        return this.contentTree;
    }

    void onKeyPressed(KeyEvent e) {
        TreePath[] tPaths = this.contentTree.getSelectionPaths();
        String keyTextEvent = KeyEvent.getKeyText(e.getKeyCode());
        if (tPaths != null && (keyTextEvent.equals(IMAGE_TYPE_KEYS[0]) || keyTextEvent.equals(IMAGE_TYPE_KEYS[1]) || keyTextEvent.equals(IMAGE_TYPE_KEYS[2]) || keyTextEvent.equals(IMAGE_TYPE_KEYS[3])) && e.getModifiers() == 8) {
            ArrayList<Object> list = new ArrayList<Object>();
            int imageType = 0;
            if (keyTextEvent.equals(IMAGE_TYPE_KEYS[1])) {
                imageType = 1;
            }
            if (keyTextEvent.equals(IMAGE_TYPE_KEYS[2])) {
                imageType = 2;
            }
            if (keyTextEvent.equals(IMAGE_TYPE_KEYS[3])) {
                imageType = 3;
            }
            for (int i = 0; i < tPaths.length; ++i) {
                this.currentNodeInAction = (DefaultMutableTreeNode)tPaths[i].getLastPathComponent();
                if (!ContentEditorHelper.isImageInfoElement(this.currentNodeInAction)) continue;
                list.add(this.currentNodeInAction.getUserObject());
                this.performSetImageType(imageType);
            }
            this.metaDataTable.setModel(new MetaDataTableModel(this, list));
        }
        if (keyTextEvent.equals(KEY_BUILD_PAGES) && e.getModifiers() == 10) {
            this.performBuildOneSlideShow();
        }
        if (keyTextEvent.equals(KEY_SHOW_SLIDE_SHOW) && e.getModifiers() == 10) {
            this.performShowOneSlideShow();
        }
    }

    void onKeyTyped(KeyEvent e) {
        TreePath[] tPath = this.contentTree.getSelectionPaths();
        if (tPath != null) {
            if (e.getKeyChar() == '\n') {
                this.currentNodeInAction = (DefaultMutableTreeNode)tPath[0].getLastPathComponent();
                this.performStartEditing();
            } else if ((e.getKeyChar() == 'b' || e.getKeyChar() == 'B') && e.getModifiers() == 8) {
                this.setCursor(XissWebUI.waitCursor);
                for (int i = 0; i < tPath.length; ++i) {
                    this.currentNodeInAction = (DefaultMutableTreeNode)tPath[i].getLastPathComponent();
                    if (!ContentEditorHelper.isImageInfoElement(this.currentNodeInAction)) continue;
                    this.performRebuildOnePage();
                }
                this.setCursor(Cursor.getDefaultCursor());
            } else if ((e.getKeyChar() == 'd' || e.getKeyChar() == 'D') && e.getModifiers() == 8) {
                for (int i = 0; i < tPath.length; ++i) {
                    this.currentNodeInAction = (DefaultMutableTreeNode)tPath[i].getLastPathComponent();
                    if (!ContentEditorHelper.isImageInfoElement(this.currentNodeInAction)) continue;
                    this.performShowOnePage();
                    break;
                }
            }
        }
    }

    void performBuildOneSlideShow() {
        boolean ok = true;
        if (this.isModified) {
            ok = Main.get().getEditorManager().querySaveEditor(this, true, this.textDisplay.getString("save.before.page.build"));
        }
        if (ok) {
            Main.get().getXissWeb().performOneSlideShowBuild(this.contentFile.getParentFile());
        }
    }

    void performRebuildOnePage() {
        boolean ok = true;
        if (this.isModified) {
            ok = Main.get().getEditorManager().querySaveEditor(this, true, this.textDisplay.getString("save.before.page.build"));
        }
        if (ok) {
            this.setCursor(XissWebUI.waitCursor);
            ImageInfo iInfo = (ImageInfo)this.currentNodeInAction.getUserObject();
            boolean changed = this.getBuilder().buildOnePage(this.getContentFile(), iInfo);
            this.setCursor(new Cursor(0));
            if (changed) {
                this.loadAndUpdateGUI();
            }
        }
        Main.get().getXissWeb().updateGuiState();
    }

    void onRightClick(MouseEvent e) {
        this.currentNodeInAction = TreeHelper.getNode(this.contentTree, e);
        if (this.currentNodeInAction != null) {
            if (ContentEditorHelper.isRootElement(this.currentNodeInAction)) {
                this.getAddPreviousLinkMenuItem().setEnabled(this.contentInfo.getPrevious() == null);
                this.getAddNextLinkMenuItem().setEnabled(this.contentInfo.getNext() == null);
                this.getContentPopupMenu().show(this.contentTree, e.getX(), e.getY());
            } else if (ContentEditorHelper.isTitleElement(this.currentNodeInAction)) {
                this.getEditInfoMenuItem().setText(TextDisplayer.getString("edit.info.title.menu.item", this.getClass()));
                this.getInfoPopupMenu().show(this.contentTree, e.getX(), e.getY());
            } else if (ContentEditorHelper.isDescriptionElement(this.currentNodeInAction)) {
                this.getEditInfoMenuItem().setText(TextDisplayer.getString("edit.info.description.menu.item", this.getClass()));
                this.getInfoPopupMenu().show(this.contentTree, e.getX(), e.getY());
            } else if (ContentEditorHelper.isSectionElement(this.currentNodeInAction)) {
                SectionInfo sec = (SectionInfo)this.currentNodeInAction.getUserObject();
                this.getRemoveSectionMenuItem().setEnabled(sec.getImages().isEmpty());
                this.getSectionPopupMenu().show(this.contentTree, e.getX(), e.getY());
            } else if (ContentEditorHelper.isImageInfoElement(this.currentNodeInAction)) {
                ImageInfo iInfo = (ImageInfo)this.currentNodeInAction.getUserObject();
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.currentNodeInAction.getParent();
                SectionInfo sec = (SectionInfo)parent.getUserObject();
                this.fillMoveToMenu(sec, iInfo);
                this.getMoveToMenu().setEnabled(this.getMoveToMenu().getItemCount() > 0);
                this.getShowImagePageMenuItem().setEnabled(this.pageFile(iInfo).exists());
                int imageType = iInfo.getMetaData().getImageType();
                this.getDigitalPhotoImageTypeMenuItem().setEnabled(imageType != 0);
                this.getFilmImageTypeMenuItem().setEnabled(imageType != 1);
                this.getProcessingImageTypeMenuItem().setEnabled(imageType != 2);
                this.getUnknownImageTypeMenuItem().setEnabled(imageType != 3);
                this.getImagePopupMenu().show(this.contentTree, e.getX(), e.getY());
            } else if (ContentEditorHelper.isLinkElement(this.currentNodeInAction)) {
                this.getLinkPopupMenu().show(this.contentTree, e.getX(), e.getY());
            }
        }
    }

    private void fillMoveToMenu(final SectionInfo secOrigin, final ImageInfo imageInfo) {
        this.getMoveToMenu().removeAll();
        List secList = this.contentInfo.getSections();
        Iterator i = secList.iterator();
        while (i.hasNext()) {
            final SectionInfo sec = (SectionInfo)i.next();
            if (sec.getImages().contains(imageInfo)) continue;
            JMenuItem item = new JMenuItem();
            item.setText(sec.toString());
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ContentEditor.this.moveImage(imageInfo, secOrigin, sec);
                }
            });
            this.getMoveToMenu().add(item);
        }
    }

    void moveImage(ImageInfo imageInfo, SectionInfo secOrigin, SectionInfo secTacget) {
        DefaultMutableTreeNode sO = this.treeModel.getNodeFromUserObject(secOrigin);
        DefaultMutableTreeNode sT = this.treeModel.getNodeFromUserObject(secTacget);
        DefaultMutableTreeNode node = this.treeModel.getNodeFromUserObject(imageInfo);
        secOrigin.getImages().remove(imageInfo);
        secTacget.addImage(imageInfo);
        this.contentInfo.resetImageNumber();
        sO.remove(node);
        sT.add(node);
        this.treeModel.nodeStructureChanged(sO);
        this.treeModel.nodeStructureChanged(sT);
        this.modified(false);
    }

    void performShowOnePage() {
        ShowHelper.performShowOneFile(this.pageFile((ImageInfo)this.currentNodeInAction.getUserObject()));
    }

    void performShowOneSlideShow() {
        ShowHelper.performShowSlideshowDir(this.contentFile.getParentFile());
    }

    private File pageFile(ImageInfo iInfo) {
        File dir = FileHelper.fileInTargetDir((File)this.project.getSrcDirectory(), (File)this.contentFile.getParentFile(), (File)this.project.getBuildDirectory());
        return new File(dir, iInfo.getFileName() + '.' + "html");
    }

    private JPopupMenu getContentPopupMenu() {
        if (this.contentPopupMenu == null) {
            this.contentPopupMenu = new JPopupMenu();
            this.contentPopupMenu.add(this.getAddPreviousLinkMenuItem());
            this.contentPopupMenu.add(this.getAddNextLinkMenuItem());
            this.contentPopupMenu.add(this.getAddSectionMenuItem());
        }
        return this.contentPopupMenu;
    }

    private JMenuItem getAddNextLinkMenuItem() {
        if (this.addNextLinkMenuItem == null) {
            this.addNextLinkMenuItem = new JMenuItem();
            this.addNextLinkMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ContentEditor.this.performAddNextLink();
                }
            });
            this.textDisplay.register(this.addNextLinkMenuItem, "add.next.link.menu.item");
        }
        return this.addNextLinkMenuItem;
    }

    void performAddNextLink() {
        File slideshow = this.getSlideShowDirLink();
        if (slideshow != null) {
            String text = slideshow.getName();
            String ref = FileHelper.relativeURL((File)this.contentFile.getParentFile(), (File)slideshow);
            this.contentInfo.setNext(ref, text);
            SlideShowRefInfo refInfo = this.contentInfo.getNext();
            DefaultMutableTreeNode contentNode = (DefaultMutableTreeNode)this.treeModel.getRoot();
            DefaultMutableTreeNode nNode = new DefaultMutableTreeNode(refInfo);
            if (this.contentInfo.getPrevious() != null) {
                contentNode.insert(nNode, 2);
            } else {
                contentNode.insert(nNode, 1);
            }
            this.treeModel.nodeStructureChanged(contentNode);
            TreeHelper.expandAll(this.contentTree);
            TreeHelper.selectNode(this.contentTree, nNode, false);
            this.modified(false);
        }
    }

    private JMenuItem getAddPreviousLinkMenuItem() {
        if (this.addPreviousLinkMenuItem == null) {
            this.addPreviousLinkMenuItem = new JMenuItem();
            this.addPreviousLinkMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ContentEditor.this.performAddPreviousLink();
                }
            });
            this.textDisplay.register(this.addPreviousLinkMenuItem, "add.previous.link.menu.item");
        }
        return this.addPreviousLinkMenuItem;
    }

    void performAddPreviousLink() {
        File slideshow = this.getSlideShowDirLink();
        if (slideshow != null) {
            String text = slideshow.getName();
            String ref = FileHelper.relativeURL((File)this.contentFile.getParentFile(), (File)slideshow);
            this.contentInfo.setPrevious(ref, text);
            SlideShowRefInfo refInfo = new SlideShowRefInfo(ref, text);
            this.contentInfo.setPrevious(refInfo);
            DefaultMutableTreeNode contentNode = (DefaultMutableTreeNode)this.treeModel.getRoot();
            DefaultMutableTreeNode pNode = new DefaultMutableTreeNode(refInfo);
            contentNode.insert(pNode, 1);
            this.treeModel.nodeStructureChanged(contentNode);
            TreeHelper.expandAll(this.contentTree);
            TreeHelper.selectNode(this.contentTree, pNode, true);
            this.modified(false);
        }
    }

    private JMenuItem getAddSectionMenuItem() {
        if (this.addSectionMenuItem == null) {
            this.addSectionMenuItem = new JMenuItem();
            this.textDisplay.register(this.addSectionMenuItem, "add.section.menu.item");
            this.addSectionMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ContentEditor.this.performAddSection();
                }
            });
        }
        return this.addSectionMenuItem;
    }

    void performAddSection() {
        SectionInfo section = new SectionInfo();
        DefaultMutableTreeNode sNode = new DefaultMutableTreeNode(section);
        this.contentInfo.addSection(section);
        this.modified(false);
        this.currentNodeInAction.add(sNode);
        this.treeModel.nodeStructureChanged(this.currentNodeInAction);
        TreeHelper.selectNode(this.contentTree, sNode, true);
    }

    void performInsertSection() {
        DefaultMutableTreeNode pNode = (DefaultMutableTreeNode)this.currentNodeInAction.getParent();
        int index = pNode.getIndex(this.currentNodeInAction);
        SectionInfo sectionInfo = new SectionInfo();
        this.contentInfo.insertSectionAt(sectionInfo, index + 1 - ContentEditorHelper.sectionsOffset(this.contentInfo));
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(sectionInfo);
        pNode.insert(node, index + 1);
        this.modified(false);
        this.treeModel.nodeStructureChanged(pNode);
        TreeHelper.expandAll(this.contentTree);
        TreeHelper.selectNode(this.contentTree, node, true);
    }

    void performStartEditing() {
        if (!ContentEditorHelper.isRootElement(this.currentNodeInAction) && !ContentEditorHelper.isInfoElement(this.currentNodeInAction)) {
            this.contentTextEditor.setEditionEnabled(false);
            this.getContentTree().setEditable(true);
            this.contentTree.startEditingAtPath(new TreePath(this.currentNodeInAction.getPath()));
        }
    }

    private JPopupMenu getSectionPopupMenu() {
        if (this.sectionPopupMenu == null) {
            this.sectionPopupMenu = new JPopupMenu();
            this.sectionPopupMenu.add(this.getEditSectionTitleMenuItem());
            this.sectionPopupMenu.add(this.getInsertSectionMenuItem());
            this.sectionPopupMenu.add(this.getRemoveSectionMenuItem());
        }
        return this.sectionPopupMenu;
    }

    private JMenuItem getEditSectionTitleMenuItem() {
        if (this.editSectionTitleMenuItem == null) {
            this.editSectionTitleMenuItem = new JMenuItem();
            this.textDisplay.register(this.editSectionTitleMenuItem, "edit.section.title.menu.item");
            this.editSectionTitleMenuItem.setAccelerator(KeyStroke.getKeyStroke(10, 0));
            this.editSectionTitleMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ContentEditor.this.performStartEditing();
                }
            });
        }
        return this.editSectionTitleMenuItem;
    }

    private JMenuItem getRemoveSectionMenuItem() {
        if (this.removeSectionMenuItem == null) {
            this.removeSectionMenuItem = new JMenuItem();
            this.removeSectionMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ContentEditor.this.performRemoveSection();
                }
            });
            this.textDisplay.register(this.removeSectionMenuItem, "remove.section.menu.item");
        }
        return this.removeSectionMenuItem;
    }

    void performRemoveSection() {
        SectionInfo sec = (SectionInfo)this.currentNodeInAction.getUserObject();
        this.contentInfo.removeSection(sec);
        DefaultMutableTreeNode pNode = (DefaultMutableTreeNode)this.currentNodeInAction.getParent();
        pNode.remove(this.currentNodeInAction);
        this.treeModel.nodeStructureChanged(pNode);
        TreeHelper.expandAll(this.contentTree);
        this.modified(false);
    }

    private JPopupMenu getImagePopupMenu() {
        if (this.ImagePopupMenu == null) {
            JSeparator jSeparator = new JSeparator();
            this.ImagePopupMenu = new JPopupMenu();
            this.ImagePopupMenu.add(this.getEditImageCommentMenuItem());
            this.ImagePopupMenu.add(this.getResetDefaultImageCommentMenuItem());
            this.ImagePopupMenu.add(this.getMoveToMenu());
            this.ImagePopupMenu.add(jSeparator);
            this.ImagePopupMenu.add(this.getDigitalPhotoImageTypeMenuItem());
            this.ImagePopupMenu.add(this.getFilmImageTypeMenuItem());
            this.ImagePopupMenu.add(this.getProcessingImageTypeMenuItem());
            this.ImagePopupMenu.add(this.getUnknownImageTypeMenuItem());
            this.ImagePopupMenu.add(this.getRestoreImageMetaDataMenuItem());
            this.ImagePopupMenu.add(new JSeparator());
            this.ImagePopupMenu.add(this.getRebuildImagePageMenuItem());
            this.ImagePopupMenu.add(this.getShowImagePageMenuItem());
        }
        return this.ImagePopupMenu;
    }

    private JMenuItem getRestoreImageMetaDataMenuItem() {
        if (this.restoreImageMetaDataMenuItem == null) {
            this.restoreImageMetaDataMenuItem = new JMenuItem();
            this.restoreImageMetaDataMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    ContentEditor.this.performRestoreImageMetaData();
                }
            });
        }
        this.textDisplay.register(this.restoreImageMetaDataMenuItem, "restore.meta.data.menu.item");
        return this.restoreImageMetaDataMenuItem;
    }

    void performRestoreImageMetaData() {
        ImageInfo iInfo = (ImageInfo)this.currentNodeInAction.getUserObject();
        int imageType = iInfo.getMetaData().getImageType();
        ImageData imgData = new ImageData(this.getImageFile(iInfo));
        imgData.readMetaData(imageType);
        ImageMetaData iMData = new ImageMetaData(imageType);
        String[] keys = ImageMetadataHelper.getImageMetaDataKeys(imageType);
        String[] values = imgData.getMetaDatas();
        for (int i = 0; i < keys.length; ++i) {
            iMData.put(keys[i], values[i]);
        }
        iInfo.forceSetMetaData(iMData);
        TreePath[] paths = this.contentTree.getSelectionPaths();
        if (paths == null) {
            Object[] nodes = this.currentNodeInAction.getPath();
            this.contentTree.setSelectionPath(new TreePath(nodes));
        }
        this.modified(false);
        ArrayList<ImageInfo> l = new ArrayList<ImageInfo>();
        l.add(iInfo);
        this.metaDataTable.setModel(new MetaDataTableModel(this, l));
    }

    private JMenuItem getUnknownImageTypeMenuItem() {
        if (this.unknownImageTypeMenuItem == null) {
            this.unknownImageTypeMenuItem = new JMenuItem();
            char key = IMAGE_TYPE_KEYS[3].charAt(0);
            this.unknownImageTypeMenuItem.setAccelerator(KeyStroke.getKeyStroke((int)key, 8));
            this.unknownImageTypeMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ContentEditor.this.performSetOneImageType(3);
                }
            });
            this.textDisplay.register(this.unknownImageTypeMenuItem, "unknown.image.type.menu.item");
        }
        return this.unknownImageTypeMenuItem;
    }

    private JMenuItem getDigitalPhotoImageTypeMenuItem() {
        if (this.digitalPhotoImageTypeMenuItem == null) {
            this.digitalPhotoImageTypeMenuItem = new JMenuItem();
            char key = IMAGE_TYPE_KEYS[0].charAt(0);
            this.digitalPhotoImageTypeMenuItem.setAccelerator(KeyStroke.getKeyStroke((int)key, 8));
            this.digitalPhotoImageTypeMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ContentEditor.this.performSetOneImageType(0);
                }
            });
            this.textDisplay.register(this.digitalPhotoImageTypeMenuItem, "digital.image.type.menu.item");
        }
        return this.digitalPhotoImageTypeMenuItem;
    }

    private JMenuItem getEditImageCommentMenuItem() {
        if (this.editImageCommentMenuItem == null) {
            this.editImageCommentMenuItem = new JMenuItem();
            this.textDisplay.register(this.editImageCommentMenuItem, "edit.image.comment.menu.item");
            this.editImageCommentMenuItem.setAccelerator(KeyStroke.getKeyStroke(10, 0));
            this.editImageCommentMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ContentEditor.this.performStartEditing();
                }
            });
        }
        return this.editImageCommentMenuItem;
    }

    private JMenuItem getResetDefaultImageCommentMenuItem() {
        if (this.resetDefaultImageCommentMenuItem == null) {
            this.resetDefaultImageCommentMenuItem = new JMenuItem();
            this.resetDefaultImageCommentMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    ContentEditor.this.performSetDefaultImageComment();
                }
            });
            this.textDisplay.register(this.resetDefaultImageCommentMenuItem, "reset.default.image.comment.menu.item");
        }
        return this.resetDefaultImageCommentMenuItem;
    }

    void performSetDefaultImageComment() {
        ImageInfo imageInfo = (ImageInfo)this.currentNodeInAction.getUserObject();
        ImageData iData = new ImageData(this.getImageFile(imageInfo));
        String comment = iData.getUserComment();
        if (comment == null || comment.length() == 0) {
            comment = Main.get().getCurrentProject().getProperties().getDefaultImageComment();
        }
        imageInfo.setStringValue(comment);
        this.treeModel.nodeChanged(this.currentNodeInAction);
        this.contentTextEditor.reload();
        this.modified(false);
    }

    private JMenuItem getRebuildImagePageMenuItem() {
        if (this.rebuildImagePageMenuItem == null) {
            this.rebuildImagePageMenuItem = new JMenuItem();
            this.textDisplay.register(this.rebuildImagePageMenuItem, "rebuild.image.page.menu.item");
            this.rebuildImagePageMenuItem.setAccelerator(KeyStroke.getKeyStroke(66, 8));
            this.rebuildImagePageMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ContentEditor.this.performRebuildOnePage();
                }
            });
        }
        return this.rebuildImagePageMenuItem;
    }

    private JMenuItem getShowImagePageMenuItem() {
        if (this.showImagePageMenuItem == null) {
            this.showImagePageMenuItem = new JMenuItem();
            this.textDisplay.register(this.showImagePageMenuItem, "show.image.page.menu.item");
            this.showImagePageMenuItem.setAccelerator(KeyStroke.getKeyStroke(68, 8));
            this.showImagePageMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ContentEditor.this.performShowOnePage();
                }
            });
        }
        return this.showImagePageMenuItem;
    }

    private JPopupMenu getLinkPopupMenu() {
        if (this.linkPopupMenu == null) {
            this.linkPopupMenu = new JPopupMenu();
            this.linkPopupMenu.add(this.getEditRefLinkMenuItem());
            this.linkPopupMenu.add(this.getEditTextLinkMenuItem());
            this.linkPopupMenu.add(this.getRemoveLinkMenuItem());
        }
        return this.linkPopupMenu;
    }

    private JMenuItem getRemoveLinkMenuItem() {
        if (this.removeLinkMenuItem == null) {
            this.removeLinkMenuItem = new JMenuItem();
            this.removeLinkMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ContentEditor.this.performRemoveLink();
                }
            });
            this.textDisplay.register(this.removeLinkMenuItem, "remove.link.menu.item");
        }
        return this.removeLinkMenuItem;
    }

    void performRemoveLink() {
        SlideShowRefInfo refInfo = (SlideShowRefInfo)this.currentNodeInAction.getUserObject();
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.currentNodeInAction.getParent();
        this.contentInfo.removeLink(refInfo);
        this.currentNodeInAction.removeFromParent();
        this.treeModel.nodeStructureChanged(parent);
        TreeHelper.expandAll(this.contentTree);
        this.modified(false);
    }

    private JMenuItem getEditTextLinkMenuItem() {
        if (this.editTextLinkMenuItem == null) {
            this.editTextLinkMenuItem = new JMenuItem();
            this.textDisplay.register(this.editTextLinkMenuItem, "edit.text.link.menu.item");
            this.editTextLinkMenuItem.setAccelerator(KeyStroke.getKeyStroke(10, 0));
            this.editTextLinkMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ContentEditor.this.performStartEditing();
                }
            });
        }
        return this.editTextLinkMenuItem;
    }

    private JMenuItem getEditRefLinkMenuItem() {
        if (this.editRefLinkMenuItem == null) {
            this.editRefLinkMenuItem = new JMenuItem();
            this.textDisplay.register(this.editRefLinkMenuItem, "edit.ref.link.menu.item");
            this.editRefLinkMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ContentEditor.this.performChangeLink();
                }
            });
        }
        return this.editRefLinkMenuItem;
    }

    void performChangeLink() {
        File slideshow = this.getSlideShowDirLink();
        SlideShowRefInfo refInfo = (SlideShowRefInfo)this.currentNodeInAction.getUserObject();
        refInfo.setHref(FileHelper.relativeURL((File)this.contentFile.getParentFile(), (File)slideshow));
        this.treeModel.nodeChanged(this.currentNodeInAction);
        this.modified(false);
    }

    private JPopupMenu getInfoPopupMenu() {
        if (this.InfoPopupMenu == null) {
            this.InfoPopupMenu = new JPopupMenu();
            this.InfoPopupMenu.add(this.getEditInfoMenuItem());
        }
        return this.InfoPopupMenu;
    }

    private JMenuItem getEditInfoMenuItem() {
        if (this.editInfoMenuItem == null) {
            this.editInfoMenuItem = new JMenuItem();
            this.editInfoMenuItem.setAccelerator(KeyStroke.getKeyStroke(10, 0));
            this.editInfoMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ContentEditor.this.performStartEditing();
                }
            });
        }
        return this.editInfoMenuItem;
    }

    private JMenuItem getInsertSectionMenuItem() {
        if (this.insertSectionMenuItem == null) {
            this.insertSectionMenuItem = new JMenuItem();
            this.textDisplay.register(this.insertSectionMenuItem, "insert.section.menu.item");
            this.insertSectionMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ContentEditor.this.performInsertSection();
                }
            });
        }
        return this.insertSectionMenuItem;
    }

    private JScrollPane getImageScrollPane() {
        if (this.imageScrollPane == null) {
            this.imageScrollPane = new JScrollPane();
            this.imageScrollPane.setViewportView(this.getImageDisplayer());
        }
        return this.imageScrollPane;
    }

    private JComponent getContentTextEditor() {
        if (this.contentTextEditor == null) {
            this.contentTextEditor = new ContentTextEditor();
            this.contentTextEditor.setEditorObserver(this);
        }
        return this.contentTextEditor;
    }

    private JSplitPane getImagePartPanel() {
        if (this.imagePartPanel == null) {
            this.imagePartPanel = new JSplitPane();
            this.imagePartPanel.setContinuousLayout(true);
            this.imagePartPanel.setOrientation(0);
            this.imagePartPanel.setDividerSize(7);
            this.imagePartPanel.setOneTouchExpandable(true);
            this.imagePartPanel.setDividerLocation(400);
            this.imagePartPanel.setTopComponent(this.getImageScrollPane());
            this.imagePartPanel.setBottomComponent(this.getContentTextEditor());
        }
        return this.imagePartPanel;
    }

    public void imageSizeTypeChanged(ImageDisplayer imageDisplayer) {
        this.storeImageFullSizePreferences();
    }

    public void imageFileReadStart(ImageDisplayer imageDisplayer) {
    }

    public void imageFileReadDone(ImageDisplayer imageDisplayer) {
    }

    private ImageDisplayer getImageDisplayer() {
        if (this.imageDisplayer == null) {
            this.imageDisplayer = new ImageDisplayer();
            this.imageDisplayer.setObserver(this);
        }
        return this.imageDisplayer;
    }

    private JSplitPane getLeftSideSplitPane() {
        if (this.leftSideSplitPane == null) {
            this.leftSideSplitPane = new JSplitPane();
            this.leftSideSplitPane.setContinuousLayout(true);
            this.leftSideSplitPane.setDividerSize(7);
            this.leftSideSplitPane.setOneTouchExpandable(true);
            this.leftSideSplitPane.setDividerLocation(200);
            this.leftSideSplitPane.setOrientation(0);
            this.leftSideSplitPane.setTopComponent(this.getTreeContainer());
            this.leftSideSplitPane.setBottomComponent(this.getMetaDataScrollPane());
        }
        return this.leftSideSplitPane;
    }

    private JScrollPane getMetaDataScrollPane() {
        if (this.metaDataScrollPane == null) {
            this.metaDataScrollPane = new JScrollPane();
            this.metaDataScrollPane.setViewportView(this.getMetaDataTable());
        }
        return this.metaDataScrollPane;
    }

    private JTable getMetaDataTable() {
        if (this.metaDataTable == null) {
            this.metaDataTable = new JTable();
            this.metaDataTable.setEnabled(true);
            this.metaDataTable.setDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = ContentEditor.class$("java.lang.Object")) : class$java$lang$Object, new MetaDataTableRenderer());
            this.metaDataTable.setDefaultEditor(class$java$lang$Object == null ? (class$java$lang$Object = ContentEditor.class$("java.lang.Object")) : class$java$lang$Object, new MetaDataTableCellEditor());
        }
        return this.metaDataTable;
    }

    private JMenuItem getFilmImageTypeMenuItem() {
        if (this.filmImageTypeMenuItem == null) {
            this.filmImageTypeMenuItem = new JMenuItem();
            this.textDisplay.register(this.filmImageTypeMenuItem, "film.image.type.menu.item");
            char key = IMAGE_TYPE_KEYS[1].charAt(0);
            this.filmImageTypeMenuItem.setAccelerator(KeyStroke.getKeyStroke((int)key, 8));
            this.filmImageTypeMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ContentEditor.this.performSetOneImageType(1);
                }
            });
        }
        return this.filmImageTypeMenuItem;
    }

    private JMenuItem getProcessingImageTypeMenuItem() {
        if (this.processingImageTypeMenuItem == null) {
            this.processingImageTypeMenuItem = new JMenuItem();
            this.textDisplay.register(this.processingImageTypeMenuItem, "processing.image.type.menu.item");
            char key = IMAGE_TYPE_KEYS[2].charAt(0);
            this.processingImageTypeMenuItem.setAccelerator(KeyStroke.getKeyStroke((int)key, 8));
            this.processingImageTypeMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ContentEditor.this.performSetOneImageType(2);
                }
            });
        }
        return this.processingImageTypeMenuItem;
    }

    void performSetOneImageType(int imageType) {
        this.performSetImageType(imageType);
        ArrayList<Object> l = new ArrayList<Object>();
        l.add(this.currentNodeInAction.getUserObject());
        this.metaDataTable.setModel(new MetaDataTableModel(this, l));
    }

    void performSetImageType(int imageType) {
        ImageInfo iInfo = (ImageInfo)this.currentNodeInAction.getUserObject();
        if (iInfo.getMetaData().getImageType() != imageType) {
            ImageData imgData = new ImageData(this.getImageFile(iInfo));
            imgData.readMetaData(imageType);
            ImageMetaData iMData = new ImageMetaData(imageType);
            String[] keys = ImageMetadataHelper.getImageMetaDataKeys(imageType);
            String[] values = imgData.getMetaDatas();
            for (int i = 0; i < keys.length; ++i) {
                iMData.put(keys[i], values[i]);
            }
            iInfo.setMetaData(iMData);
            TreePath[] paths = this.contentTree.getSelectionPaths();
            if (paths == null) {
                Object[] nodes = this.currentNodeInAction.getPath();
                this.contentTree.setSelectionPath(new TreePath(nodes));
            }
            this.modified(false);
        }
    }

    private JMenu getMoveToMenu() {
        if (this.moveToMenu == null) {
            this.moveToMenu = new JMenu();
            this.textDisplay.register(this.moveToMenu, "move.to.menu");
        }
        return this.moveToMenu;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class LoaderAndUpdater
    extends SwingWorker {
        LoaderAndUpdater() {
        }

        public boolean construct() {
            ContentEditor.this.contentInfo = null;
            ContentEditor.this.contentInfo = ContentEditor.this.reader.deserialize(ContentEditor.this.contentFile);
            ContentEditor.this.treeModel = new ContentTreeModel(ContentEditor.this.contentInfo);
            ContentEditor.this.getContentTree().setModel(ContentEditor.this.treeModel);
            ContentEditor.this.isModified = false;
            TreeHelper.expandAll(ContentEditor.this.getContentTree());
            ContentEditor.this.getContentTree().setSelectionPath(null);
            return false;
        }
    }
}

