/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SingleSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import org.xissweb.About;
import org.xissweb.data.content.SlideShowContentInfo;
import org.xissweb.file.FileHelper;
import org.xissweb.gui.AboutDialog;
import org.xissweb.gui.Help;
import org.xissweb.gui.Main;
import org.xissweb.gui.ProjectFileTransferHandler;
import org.xissweb.gui.XissEditorManager;
import org.xissweb.gui.XissWebUI;
import org.xissweb.gui.build.BuildLauncher;
import org.xissweb.gui.content.links.LinkedSlideshowDialog;
import org.xissweb.gui.content.links.LinksManagerDialog;
import org.xissweb.gui.content.links.LinksManagerObserver;
import org.xissweb.gui.editor.Editor;
import org.xissweb.gui.editor.ValidProcessHandler;
import org.xissweb.gui.examples.ExamplesInstallerDialog;
import org.xissweb.gui.file.FileManager;
import org.xissweb.gui.file.FileManagerObserver;
import org.xissweb.gui.file.FileSelection;
import org.xissweb.gui.file.FileSelectionObserver;
import org.xissweb.gui.prefs.ConfigurableEditable;
import org.xissweb.gui.prefs.PreferencesEditionManager;
import org.xissweb.gui.prefs.data.PreferenceInfo;
import org.xissweb.gui.project.NewProjectAction;
import org.xissweb.gui.project.NewRepositoryProjectAction;
import org.xissweb.gui.project.ProjectPrefs;
import org.xissweb.gui.sow.SowLauncher;
import org.xissweb.gui.tab.CloseTabbedPane;
import org.xissweb.gui.tab.event.CloseEvent;
import org.xissweb.gui.tab.event.CloseListener;
import org.xissweb.gui.util.ActiveLabel;
import org.xissweb.gui.util.ShowHelper;
import org.xissweb.i18n.LangChangedOberver;
import org.xissweb.i18n.TextDisplayManager;
import org.xissweb.i18n.TextDisplayer;
import org.xissweb.prefs.ui.ComponentConfigurator;
import org.xissweb.prefs.ui.SplitPaneConfigurator;
import org.xissweb.produce.SlideShowDirectory;
import org.xissweb.project.SlideShowProject;
import org.xissweb.project.links.LinkedSlideshow;

public class XissWeb
extends JFrame
implements ConfigurableEditable,
LangChangedOberver,
FileSelectionObserver,
WindowListener,
CloseListener,
MouseListener,
ChangeListener,
FileManagerObserver,
LinksManagerObserver {
    private static final String ICON_XISSWEB = "/images/xissweb.png";
    private static final long serialVersionUID = 8105640497369320133L;
    static final String PREFS_ID = "org.xissweb.gui.XissWeb";
    private static final String ERROR_ICON = "/images/common/error.png";
    private static final String WARNING_ICON = "/images/common/warning.png";
    private static final String DIALOG_ERROR_ICON = "/images/common/dialog-error.png";
    private static final String BANNER_ICON = "/images/common/banner.png";
    private static final String PROCESS_SOW_ICON = "/images/common/process-sow.png";
    private static final String PROCESS_SOW_OVER_ICON = "/images/common/process-sow-over.png";
    private static final String PROCESS_BUILD_ICON = "/images/common/process-build.png";
    private static final String PROCESS_BUILD_OVER_ICON = "/images/common/process-build-over.png";
    private static final String HELP_MENU_ICON = "/images/common/help-menu.png";
    private static final String SHOW_ICON = "/images/common/explorer.png";
    private static final String SHOW_OVER_ICON = "/images/common/explorer-over.png";
    private static final String CLEAN_ICON = "/images/common/clean.png";
    private static final String CLEAN_OVER_ICON = "/images/common/clean-over.png";
    private static final String LINKS_ICON = "/images/links/next-previous.png";
    private static final String LINKS_WARN_ICON = "/images/links/next-previous-warn.png";
    private static final String LINKS_OVER_ICON = "/images/links/next-previous-over.png";
    private static final String LINKS_WARN_OVER_ICON = "/images/links/next-previous-warn-over.png";
    private static final String REPOSITORY_ICON = "/images/file/repository.png";
    private static final String REPOSITORY_SELECTED_ICON = "/images/file/repository-selected.png";
    private static final String REVERSE_ICON = "/images/file/origin.png";
    private static final String REVERSE_SELECTED_ICON = "/images/file/origin-selected.png";
    private static final String RECENT_PROJECT_COUNT_KEY = "recent.project.count";
    private static final String RECENT_PROJECTS_KEY = "recent.projects";
    private static final String RECENT_PROJECT_SEPARATOR = ";";
    private static final String[] examples = new String[]{"projet1-sport-mode", "projet2-sport-mode", "features/links", "features/metadata", "features/page-decoration", "features/html-comment", "features/repository", "features/sections", "features/personal-pages", "features/reverse"};
    private static JFileChooser projectFileChooser;
    private int recentProjectCount;
    private List recentProjectList = new ArrayList();
    XissEditorManager editorManager;
    private SowLauncher sowLauncher;
    private BuildLauncher buildLauncher;
    private TextDisplayer textDisplayer = TextDisplayManager.createTextDisplayFor(class$org$xissweb$gui$XissWeb == null ? (class$org$xissweb$gui$XissWeb = XissWeb.class$("org.xissweb.gui.XissWeb")) : class$org$xissweb$gui$XissWeb);
    private FileManager fileManager;
    private LinkedSlideshow linkedSlideshowSelection = null;
    private LinkedSlideshowDialog linkedSlideshowDialog = null;
    private LinkedSlideshowDialog selectedSlideshowDialog = null;
    private boolean prefsSetting = false;
    NewProjectAction newProjectAction = null;
    NewRepositoryProjectAction newRepositoryProjectAction = null;
    private JPanel jContentPane = null;
    private JPanel headerPanel = null;
    private JSplitPane mainPanel = null;
    private JPanel actionsPanel = null;
    private JMenuBar mainMenuBar = null;
    private JMenu fileMenu = null;
    private JMenuItem exitMenuItem = null;
    private JMenuItem openProjectItem = null;
    private JPanel projectInfoPanel = null;
    private JLabel projectLabel = null;
    private JTextField projectDirTextField = null;
    private ActiveLabel sowButton = null;
    private JComponent buildButton = null;
    private JPopupMenu noSrcDirPopupMenu = null;
    private JMenuItem changeSrcDirMenuItem = null;
    private JMenuItem createSrcDirMenuItem = null;
    private JMenuItem noSrcOpenProjectMenuItem = null;
    private JCheckBox reverseRadioButton = null;
    private JCheckBox repositoryRadioButton = null;
    private JPopupMenu noOriginDirPopupMenu = null;
    private JMenuItem setOriginDirMenuItem = null;
    private JPopupMenu noRepositoryPopupMenu = null;
    private JMenuItem chooseRepositoryMenuItem = null;
    private JComponent showButton = null;
    private JMenuItem helpMenuItem = null;
    private JMenu helpMenu = null;
    private JMenu examplesMenu = null;
    private JMenu optionsMenu = null;
    private JMenuItem projectPropertiesMenuItem = null;
    private JMenuItem webExplorerMenuItem = null;
    private JMenuItem aboutMenuItem = null;
    private JComponent cleanButton = null;
    private CloseTabbedPane editorsTabbedPane = null;
    private JMenuItem installExamplesMenuItem = null;
    private JMenuItem clearRencentProjectsMenuItem = null;
    private JSeparator recentProjectMenuSeparator = null;
    private JMenuItem saveFileMenuItem = null;
    private JMenuItem saveAllFileMenuItem = null;
    private JMenuItem closeFileMenuItem = null;
    private JMenuItem cancelFileMenuItem = null;
    private JMenuItem closeAllFileMenuItem = null;
    private JPanel infoPanel = null;
    private JLabel infoLabel = null;
    private JLabel editorInfoLabel = null;
    private JLabel linksWargingLabel = null;
    private ActiveLabel linksButton = null;
    private JMenuItem newRepositoryProjectMenuItem = null;
    private JMenuItem newProjectMenuItem = null;
    private JMenuItem newVersionMenuItem = null;
    private JMenu recentProjectsMenu = null;
    private JLabel oneLabel = null;
    private JLabel twoLabel = null;
    private JLabel selectionWarningLabel = null;
    private LinksManagerDialog linksManagerDialog;
    private MouseAdapter noSrcAction = new MouseAdapter(){

        public void mouseClicked(MouseEvent e) {
            Component c = (Component)e.getSource();
            XissWeb.this.getNoSrcDirPopupMenu().show(c, e.getX() + 10, e.getY() - 5);
        }
    };
    private MouseAdapter noOriginDirAction = new MouseAdapter(){

        public void mouseClicked(MouseEvent e) {
            Component c = (Component)e.getSource();
            XissWeb.this.getNoOriginDirPopupMenu().show(c, e.getX() + 10, e.getY() - 5);
        }
    };
    private MouseAdapter noRepositoryDirAction = new MouseAdapter(){

        public void mouseClicked(MouseEvent e) {
            Component c = (Component)e.getSource();
            XissWeb.this.getNoRepositoryPopupMenu().show(c, e.getX() + 10, e.getY() - 5);
        }
    };
    private MouseAdapter showEditorErrorsAction = new MouseAdapter(){

        public void mouseClicked(MouseEvent e) {
            XissWeb.this.editorManager.getErrorDialog().open();
        }
    };
    private MouseAdapter linkedSlideshowInconsistency = new MouseAdapter(){

        public void mouseClicked(MouseEvent e) {
            Main.get().getXissWeb().getLinkedSlideshowDialog().open(Main.get().getCurrentProject().getLinkedSlideshows());
        }
    };
    private MouseAdapter selectionWarning = new MouseAdapter(){

        public void mouseClicked(MouseEvent e) {
            Main.get().getXissWeb().getSelectedSlideshowDialog().open(Main.get().getXissWeb().getLinkedSlideshowSelection());
        }
    };
    private JMenu projectMenu;
    private JMenuItem projectSowMenuItem;
    private JMenuItem projectBuildMenuItem;
    private JMenuItem projectLinksCheckMenuItem;
    private JMenuItem projectLinksManageMenuItem;
    private JMenuItem projectCleanMenuItem;
    private JMenuItem projectShowMenuItem;
    private ProjectPrefs projectPrefs;
    static /* synthetic */ Class class$org$xissweb$gui$XissWeb;

    public static JFileChooser getProjectFileChooser() {
        if (projectFileChooser == null) {
            projectFileChooser = new JFileChooser();
            projectFileChooser.setFileSelectionMode(1);
        }
        return projectFileChooser;
    }

    public XissWeb() {
        this.newProjectAction = new NewProjectAction(this);
        this.newRepositoryProjectAction = new NewRepositoryProjectAction(this);
        this.initialize();
        this.disabledAll();
        this.applyPreferences();
    }

    public ProjectPrefs getProjectPrefs() {
        return this.projectPrefs;
    }

    public void setEditorManager(XissEditorManager editorManager) {
        this.editorManager = editorManager;
    }

    public void fileAdded(File file) {
        if (file.getName().equals("layout.xml")) {
            this.checkLinksActionEnabled();
            this.updateLinkedSlideshowConsistencyStatus();
        }
    }

    public void fileRemoved(File file) {
        if (file.getName().equals("layout.xml")) {
            this.checkLinksActionEnabled();
            this.updateLinkedSlideshowConsistencyStatus();
        }
    }

    public LinksManagerDialog getLinksManagerDialog() {
        if (this.linksManagerDialog == null) {
            this.linksManagerDialog = new LinksManagerDialog(this);
            this.linksManagerDialog.setObserver(this);
        }
        return this.linksManagerDialog;
    }

    LinkedSlideshowDialog getLinkedSlideshowDialog() {
        if (this.linkedSlideshowDialog == null) {
            this.linkedSlideshowDialog = new LinkedSlideshowDialog((Frame)this, 0);
            Main.get().getCurrentProject().addObserver(this.linkedSlideshowDialog);
        }
        return this.linkedSlideshowDialog;
    }

    LinkedSlideshowDialog getSelectedSlideshowDialog() {
        if (this.selectedSlideshowDialog == null) {
            this.selectedSlideshowDialog = new LinkedSlideshowDialog((Frame)this, 1);
        }
        return this.selectedSlideshowDialog;
    }

    private void initComponentLocale() {
        if (!JComponent.getDefaultLocale().getLanguage().equals(Locale.getDefault().getLanguage())) {
            JComponent.setDefaultLocale(Locale.getDefault());
            if (projectFileChooser != null) {
                File currentDir = projectFileChooser.getCurrentDirectory();
                projectFileChooser = null;
                XissWeb.getProjectFileChooser().setCurrentDirectory(currentDir);
            }
        }
    }

    private void initialize() {
        this.setDefaultCloseOperation(0);
        this.setIconImage(new ImageIcon((class$org$xissweb$gui$XissWeb == null ? (class$org$xissweb$gui$XissWeb = XissWeb.class$(PREFS_ID)) : class$org$xissweb$gui$XissWeb).getResource(ICON_XISSWEB)).getImage());
        this.setSize(619, 373);
        this.setJMenuBar(this.getMainMenuBar());
        this.setContentPane(this.getJContentPane());
        this.textDisplayer.registerTitle(this, "title");
        this.addWindowListener(this);
    }

    public void windowActivated(WindowEvent arg0) {
    }

    public void windowClosed(WindowEvent arg0) {
    }

    public void windowClosing(WindowEvent arg0) {
        this.performExitXissWeb();
    }

    public void windowDeactivated(WindowEvent arg0) {
    }

    public void windowDeiconified(WindowEvent arg0) {
    }

    public void windowIconified(WindowEvent arg0) {
    }

    public void windowOpened(WindowEvent arg0) {
    }

    void performExitXissWeb() {
        if (Main.get().hasCurrentProject()) {
            if (this.closeProject(Main.get().getCurrentProject())) {
                System.exit(0);
            }
        } else {
            System.exit(0);
        }
    }

    public void langChanged() {
        this.initComponentLocale();
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getHeaderPanel(), "North");
            this.jContentPane.add((Component)this.getMainPanel(), "Center");
            this.jContentPane.add((Component)this.getInfoPanel(), "South");
        }
        return this.jContentPane;
    }

    private JPanel getHeaderPanel() {
        if (this.headerPanel == null) {
            GridLayout gridLayout = new GridLayout();
            gridLayout.setRows(1);
            gridLayout.setColumns(2);
            this.headerPanel = new JPanel();
            this.headerPanel.setLayout(new GridBagLayout());
            GridBagConstraints projectLabelConstraints = new GridBagConstraints();
            projectLabelConstraints.gridx = 0;
            projectLabelConstraints.gridy = 1;
            projectLabelConstraints.insets = new Insets(2, 5, 5, 5);
            projectLabelConstraints.anchor = 17;
            GridBagConstraints projectTextFieldConstraints = new GridBagConstraints();
            projectTextFieldConstraints.gridx = 1;
            projectTextFieldConstraints.gridy = 1;
            projectTextFieldConstraints.weightx = 2.0;
            projectTextFieldConstraints.anchor = 17;
            projectTextFieldConstraints.fill = 2;
            projectTextFieldConstraints.insets = new Insets(0, 0, 0, 5);
            GridBagConstraints actionPanelConstraints = new GridBagConstraints();
            actionPanelConstraints.gridx = 0;
            actionPanelConstraints.gridy = 0;
            actionPanelConstraints.gridwidth = 2;
            actionPanelConstraints.anchor = 17;
            actionPanelConstraints.fill = 1;
            this.getProjectInfoPanel();
            this.getProjectDirTextField();
            this.headerPanel.add((Component)this.projectLabel, projectLabelConstraints);
            this.headerPanel.add((Component)this.projectDirTextField, projectTextFieldConstraints);
            this.headerPanel.add((Component)this.getActionsPanel(), actionPanelConstraints);
        }
        return this.headerPanel;
    }

    void performCloseCurrentEditor() {
        this.editorManager.closeCurrentEditor();
    }

    private JSplitPane getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JSplitPane();
            this.mainPanel.setDividerLocation(200);
            this.mainPanel.setRightComponent(this.getEditorsTabbedPane());
            this.mainPanel.setLeftComponent(this.getFileManager());
        }
        return this.mainPanel;
    }

    public FileManager getFileManager() {
        if (this.fileManager == null) {
            this.fileManager = new FileManager();
            this.fileManager.getFileSelection().addObserver(this);
        }
        return this.fileManager;
    }

    private JPanel getActionsPanel() {
        if (this.actionsPanel == null) {
            JLabel bannerLabel = new JLabel();
            bannerLabel.setIcon(XissWebUI.getIcon(BANNER_ICON));
            GridBagConstraints bannerLabelConstraints = new GridBagConstraints();
            bannerLabelConstraints.gridx = 8;
            bannerLabelConstraints.gridy = 0;
            bannerLabelConstraints.insets = new Insets(0, 5, 0, 2);
            bannerLabelConstraints.anchor = 13;
            this.oneLabel = new JLabel();
            this.oneLabel.setIcon(XissWebUI.getIcon("/images/common/1.png"));
            this.oneLabel.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    Help.open("sow");
                }
            });
            this.textDisplayer.registerToolTip(this.oneLabel, "help.sow.tooltip");
            this.twoLabel = new JLabel();
            this.twoLabel.setIcon(XissWebUI.getIcon("/images/common/2.png"));
            this.twoLabel.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    Help.open("build");
                }
            });
            this.textDisplayer.registerToolTip(this.twoLabel, "help.build.tooltip");
            GridBagConstraints oneLabelCtrs = new GridBagConstraints();
            oneLabelCtrs.anchor = 18;
            oneLabelCtrs.gridy = 0;
            oneLabelCtrs.gridx = 0;
            oneLabelCtrs.insets = new Insets(0, 5, 5, 0);
            GridBagConstraints twoLabelCtrs = new GridBagConstraints();
            twoLabelCtrs.anchor = 18;
            twoLabelCtrs.gridx = 4;
            twoLabelCtrs.gridy = 0;
            twoLabelCtrs.insets = new Insets(0, 45, 5, 0);
            GridBagConstraints cleanButtonCtrs = new GridBagConstraints();
            cleanButtonCtrs.insets = new Insets(5, 5, 5, 5);
            cleanButtonCtrs.gridx = 7;
            cleanButtonCtrs.gridy = 0;
            cleanButtonCtrs.weightx = 1000.0;
            cleanButtonCtrs.anchor = 17;
            GridBagConstraints showButtonCtrs = new GridBagConstraints();
            showButtonCtrs.insets = new Insets(5, 5, 5, 5);
            showButtonCtrs.gridx = 6;
            showButtonCtrs.gridy = 0;
            showButtonCtrs.anchor = 17;
            GridBagConstraints buildButtonCtrs = new GridBagConstraints();
            buildButtonCtrs.insets = new Insets(5, 0, 5, 5);
            buildButtonCtrs.gridx = 5;
            buildButtonCtrs.gridy = 0;
            buildButtonCtrs.anchor = 17;
            GridBagConstraints linksButtonCtrs = new GridBagConstraints();
            linksButtonCtrs.insets = new Insets(5, 5, 5, 5);
            linksButtonCtrs.gridy = 0;
            linksButtonCtrs.gridx = 3;
            linksButtonCtrs.anchor = 17;
            GridBagConstraints reverseCheckBoxCtrs = new GridBagConstraints();
            reverseCheckBoxCtrs.gridx = 2;
            reverseCheckBoxCtrs.gridy = 0;
            reverseCheckBoxCtrs.anchor = 17;
            reverseCheckBoxCtrs.insets = new Insets(5, 5, 5, 5);
            GridBagConstraints repositoryCheckBoxCtrs = new GridBagConstraints();
            repositoryCheckBoxCtrs.gridx = 2;
            repositoryCheckBoxCtrs.gridy = 0;
            repositoryCheckBoxCtrs.insets = new Insets(5, 5, 5, 5);
            repositoryCheckBoxCtrs.anchor = 17;
            GridBagConstraints sowButtonCtrs = new GridBagConstraints();
            sowButtonCtrs.gridx = 1;
            sowButtonCtrs.gridy = 0;
            sowButtonCtrs.insets = new Insets(5, 0, 5, 5);
            sowButtonCtrs.anchor = 17;
            this.actionsPanel = new JPanel();
            this.actionsPanel.setLayout(new GridBagLayout());
            this.actionsPanel.add((Component)this.oneLabel, oneLabelCtrs);
            this.actionsPanel.add((Component)this.getSowButton(), sowButtonCtrs);
            this.actionsPanel.add((Component)this.getRepositoryRadioButton(), repositoryCheckBoxCtrs);
            this.actionsPanel.add((Component)this.getReverseRadioButton(), reverseCheckBoxCtrs);
            this.actionsPanel.add((Component)this.getLinksButton(), linksButtonCtrs);
            this.actionsPanel.add((Component)this.twoLabel, twoLabelCtrs);
            this.actionsPanel.add((Component)this.getBuildButton(), buildButtonCtrs);
            this.actionsPanel.add((Component)this.getShowButton(), showButtonCtrs);
            this.actionsPanel.add((Component)this.getCleanButton(), cleanButtonCtrs);
            this.actionsPanel.add((Component)bannerLabel, bannerLabelConstraints);
        }
        return this.actionsPanel;
    }

    private JMenuBar getMainMenuBar() {
        if (this.mainMenuBar == null) {
            this.mainMenuBar = new JMenuBar();
            this.mainMenuBar.add(this.getFileMenu());
            this.mainMenuBar.add(this.getProjectMenu());
            this.mainMenuBar.add(this.getOptionsMenu());
            this.mainMenuBar.add(this.getHelpMenu());
        }
        return this.mainMenuBar;
    }

    private JMenu getProjectMenu() {
        if (this.projectMenu == null) {
            this.projectMenu = new JMenu();
            this.projectMenu.add(this.getProjectSowMenuItem());
            this.projectMenu.add(this.getProjectLinksCheckMenuItem());
            this.projectMenu.add(this.getProjectLinksManageMenuItem());
            this.projectMenu.add(new JSeparator());
            this.projectMenu.add(this.getProjectBuildMenuItem());
            this.projectMenu.add(this.getProjectShowMenuItem());
            this.projectMenu.add(this.getProjectCleanMenuItem());
            this.textDisplayer.register(this.projectMenu, "menu.project.title");
        }
        return this.projectMenu;
    }

    private JMenuItem getProjectCleanMenuItem() {
        if (this.projectCleanMenuItem == null) {
            this.projectCleanMenuItem = new JMenuItem();
            this.projectCleanMenuItem.setIcon(XissWebUI.getIcon(CLEAN_ICON));
            this.textDisplayer.register(this.projectCleanMenuItem, "menu.project.clean");
            this.projectCleanMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    XissWeb.this.performClean();
                }
            });
        }
        return this.projectCleanMenuItem;
    }

    private JMenuItem getProjectShowMenuItem() {
        if (this.projectShowMenuItem == null) {
            this.projectShowMenuItem = new JMenuItem();
            this.projectShowMenuItem.setAccelerator(KeyStroke.getKeyStroke(68, 2));
            this.projectShowMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ShowHelper.performShow();
                }
            });
            this.projectShowMenuItem.setIcon(XissWebUI.getIcon(SHOW_ICON));
            this.textDisplayer.register(this.projectShowMenuItem, "menu.project.show");
        }
        return this.projectShowMenuItem;
    }

    private JMenuItem getProjectLinksCheckMenuItem() {
        if (this.projectLinksCheckMenuItem == null) {
            this.projectLinksCheckMenuItem = new JMenuItem();
            this.projectLinksCheckMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    XissWeb.this.performOpenLinksCheckDialog();
                }
            });
            this.projectLinksCheckMenuItem.setIcon(XissWebUI.getIcon(LINKS_ICON));
            this.textDisplayer.register(this.projectLinksCheckMenuItem, "menu.project.links.check");
        }
        return this.projectLinksCheckMenuItem;
    }

    void performOpenLinksCheckDialog() {
        this.getLinkedSlideshowDialog().open(Main.get().getCurrentProject().getLinkedSlideshows());
    }

    private JMenuItem getProjectLinksManageMenuItem() {
        if (this.projectLinksManageMenuItem == null) {
            this.projectLinksManageMenuItem = new JMenuItem();
            this.projectLinksManageMenuItem.setAccelerator(KeyStroke.getKeyStroke(76, 2));
            this.projectLinksManageMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    XissWeb.this.performOpenLinkManagesDialog();
                }
            });
            this.projectLinksManageMenuItem.setIcon(XissWebUI.getIcon(LINKS_ICON));
            this.textDisplayer.register(this.projectLinksManageMenuItem, "menu.project.links.manage");
        }
        return this.projectLinksManageMenuItem;
    }

    private JMenuItem getProjectBuildMenuItem() {
        if (this.projectBuildMenuItem == null) {
            this.projectBuildMenuItem = new JMenuItem();
            this.projectBuildMenuItem.setAccelerator(KeyStroke.getKeyStroke(66, 2));
            this.projectBuildMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    XissWeb.this.performBuild();
                }
            });
            this.projectBuildMenuItem.setIcon(XissWebUI.getIcon(PROCESS_BUILD_ICON));
            this.textDisplayer.register(this.projectBuildMenuItem, "menu.project.build");
        }
        return this.projectBuildMenuItem;
    }

    private JMenuItem getProjectSowMenuItem() {
        if (this.projectSowMenuItem == null) {
            this.projectSowMenuItem = new JMenuItem();
            this.projectSowMenuItem.setAccelerator(KeyStroke.getKeyStroke(73, 2));
            this.projectSowMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    XissWeb.this.performSow();
                }
            });
            this.projectSowMenuItem.setIcon(XissWebUI.getIcon(PROCESS_SOW_ICON));
            this.textDisplayer.register(this.projectSowMenuItem, "menu.project.sow");
        }
        return this.projectSowMenuItem;
    }

    private JMenu getFileMenu() {
        if (this.fileMenu == null) {
            this.fileMenu = new JMenu();
            this.fileMenu.add(this.getNewProjectMenuItem());
            this.fileMenu.add(this.getNewRepositoryProjectMenuItem());
            this.fileMenu.add(this.getOpenProjectItem());
            this.fileMenu.add(this.getRecentProjectsMenu());
            this.fileMenu.add(new JSeparator());
            this.fileMenu.add(this.getSaveFileMenuItem());
            this.fileMenu.add(this.getSaveAllFileMenuItem());
            this.fileMenu.add(this.getCancelFileMenuItem());
            this.fileMenu.add(this.getCloseFileMenuItem());
            this.fileMenu.add(this.getCloseAllFileMenuItem());
            this.fileMenu.add(new JSeparator());
            this.fileMenu.add(this.getExitMenuItem());
            this.textDisplayer.register(this.fileMenu, "menu.file");
        }
        return this.fileMenu;
    }

    private JMenuItem getExitMenuItem() {
        if (this.exitMenuItem == null) {
            this.exitMenuItem = new JMenuItem();
            this.exitMenuItem.setAccelerator(KeyStroke.getKeyStroke(81, 2));
            this.exitMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    XissWeb.this.performExitXissWeb();
                }
            });
            this.textDisplayer.register(this.exitMenuItem, "menu.file.exit");
        }
        return this.exitMenuItem;
    }

    private JMenuItem getOpenProjectItem() {
        if (this.openProjectItem == null) {
            this.openProjectItem = new JMenuItem();
            this.openProjectItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
            this.openProjectItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    XissWeb.this.performOpenProject();
                }
            });
            this.textDisplayer.register(this.openProjectItem, "menu.file.open.project");
        }
        return this.openProjectItem;
    }

    void performOpenProject() {
        XissWeb.getProjectFileChooser().setFileSelectionMode(1);
        int choosStatus = XissWeb.getProjectFileChooser().showDialog(this, this.textDisplayer.getString("open.project.file.chosser"));
        if (choosStatus == 0) {
            this.openProject(XissWeb.getProjectFileChooser().getSelectedFile());
        }
    }

    public void openProject(File location) {
        SlideShowProject project = new SlideShowProject(location);
        this.openProject(project);
    }

    public void openProject(SlideShowProject project) {
        if (project.isProject()) {
            String oldPath;
            String string = oldPath = Main.get().hasCurrentProject() ? Main.get().getCurrentProject().getLocation().getAbsolutePath() : null;
            if (!Main.get().hasCurrentProject() || this.closeProject(Main.get().getCurrentProject())) {
                this.projectPrefs = new ProjectPrefs(project.getLocation());
                Main.get().setCurrentProject(project);
                String path = project.getLocation().getAbsolutePath();
                this.projectDirTextField.setText(path);
                this.initComponentLocale();
                this.textDisplayer.resetAllText();
                JComponent.setDefaultLocale(Locale.getDefault());
                this.recentProjectList.remove(path);
                if (oldPath != null && !this.recentProjectList.contains(oldPath)) {
                    if (this.recentProjectList.size() == this.recentProjectCount) {
                        this.recentProjectList.remove(this.recentProjectCount - 1);
                    }
                    this.recentProjectList.add(0, oldPath);
                }
                this.storeRencetsProjectPreferences();
                this.updateRecentProjectsMenu();
                if (this.linkedSlideshowDialog != null) {
                    this.linkedSlideshowDialog.setVisible(false);
                    this.linkedSlideshowDialog = null;
                }
                this.updateGuiState();
                this.restoreRepositoryAndReverseOptions();
                this.fileManager.setShowFiles(this.projectPrefs.getFilterShowAllFiles());
                this.fileManager.setShowImageInSlideShows(this.projectPrefs.getFilterShowImageInSlideShow());
                this.fileManager.initFileTree(project);
                this.fileManager.applySelection(this.projectPrefs.getFileSelection());
                this.editorManager.applyPreferences(this.projectPrefs.getCurrentDocument(), this.projectPrefs.getDocuments());
            }
        } else {
            StringBuffer buff = new StringBuffer();
            buff.append(this.textDisplayer.getString("open.project.no.project.location")).append(" \"");
            buff.append(project.getLocation().getAbsolutePath()).append("\" ");
            buff.append(this.textDisplayer.getString("open.project.no.project")).append("\n\n");
            buff.append(this.textDisplayer.getString("open.project.create.project"));
            Object[] options = new Object[]{this.textDisplayer.getString("open.option.new.project"), this.textDisplayer.getString("open.option.new.repository.project"), this.textDisplayer.getString("open.option.new.no")};
            int option = JOptionPane.showOptionDialog(this, buff, this.textDisplayer.getString("open.project.title"), 1, 0, XissWebUI.getIcon(DIALOG_ERROR_ICON), options, options[2]);
            if (option == 0) {
                this.newProjectAction.actionPerformed(project.getLocation());
            } else if (option == 1) {
                this.newRepositoryProjectAction.actionPerformed(project.getLocation(), 0);
            }
        }
    }

    private boolean closeProject(SlideShowProject project) {
        boolean saved = this.editorManager.querySaveAllEditor(false);
        if (saved) {
            this.projectPrefs.store();
            this.projectPrefs = null;
            Main.get().setCurrentProject(null);
            this.editorManager.forceCloseAllEditor();
            this.getFileManager().unselectAll();
            String path = project.getLocation().getAbsolutePath();
            if (this.recentProjectList.contains(path) && !path.equals(this.recentProjectList.get(0))) {
                this.recentProjectList.remove(path);
                this.recentProjectList.add(0, path);
                this.updateRecentProjectsMenu();
                this.storeRencetsProjectPreferences();
            } else if (this.recentProjectList.size() < this.recentProjectCount) {
                this.recentProjectList.add(0, path);
                this.updateRecentProjectsMenu();
                this.storeRencetsProjectPreferences();
            }
        }
        return saved;
    }

    public void performNewProject() {
        this.newProjectAction.actionPerformed((ActionEvent)null);
    }

    public void performNewRepositoryProject() {
        this.newRepositoryProjectAction.actionPerformed(null);
    }

    public void performNewRepositoryProject(File diretory, int dirKind) {
        this.newRepositoryProjectAction.actionPerformed(diretory, dirKind);
    }

    private void disabledAll() {
        this.getProjectPropertiesMenuItem().setEnabled(false);
        this.setSowActionEnabled(false);
        this.setBuildActionEnabled(false);
        this.setShowActionEnabled(false);
        this.setCleanActionEnabled(false);
        this.setLinksActionEnabled(false, false);
    }

    private void applyPreferences() {
        ComponentConfigurator.configure((Component)this);
        SplitPaneConfigurator.configure((JSplitPane)this.mainPanel, (String)this.getClass().getName());
        PreferenceInfo pInfo = PreferencesEditionManager.get().getPreferenceInfo(RECENT_PROJECT_COUNT_KEY, PREFS_ID);
        this.recentProjectCount = Main.preferences.getInt(RECENT_PROJECT_COUNT_KEY, PREFS_ID, Integer.parseInt(pInfo.getDefaultValue()));
        String recents = Main.preferences.get(RECENT_PROJECTS_KEY, PREFS_ID, null);
        if (recents != null && recents.length() > 0) {
            String[] projects = recents.split(RECENT_PROJECT_SEPARATOR);
            for (int i = 0; i < projects.length; ++i) {
                this.recentProjectList.add(projects[i]);
            }
            this.updateRecentProjectsMenu();
        }
        PreferencesEditionManager.get().registerConfigurable(this);
    }

    private void storeRencetsProjectPreferences() {
        Main.preferences.putInt(RECENT_PROJECT_COUNT_KEY, PREFS_ID, this.recentProjectCount);
        StringBuffer buff = new StringBuffer();
        Iterator i = this.recentProjectList.iterator();
        while (i.hasNext()) {
            String e = (String)i.next();
            buff.append(e);
            if (!i.hasNext()) continue;
            buff.append(RECENT_PROJECT_SEPARATOR);
        }
        Main.preferences.put(RECENT_PROJECTS_KEY, PREFS_ID, buff.toString());
    }

    private void storeRepositorySelected(boolean selected) {
        this.projectPrefs.storeRepositirySelected(selected);
    }

    private void storeReverseSelected(boolean selected) {
        this.projectPrefs.storeReverseSelected(selected);
    }

    public void prefrerenceEdited(PreferenceInfo prefInfo, Object value) {
        if (prefInfo.getKey().equals(RECENT_PROJECT_COUNT_KEY)) {
            this.recentProjectCount = Integer.parseInt((String)value);
            int nbRecents = this.recentProjectList.size();
            for (int i = nbRecents - 1; i >= this.recentProjectCount; --i) {
                this.recentProjectList.remove(i);
            }
            this.updateRecentProjectsMenu();
            this.storeRencetsProjectPreferences();
        }
    }

    public String getDefaultValue(PreferenceInfo prefInfo) {
        return null;
    }

    public void resetFileTree() {
        this.fileManager.initFileTree(Main.get().getCurrentProject());
    }

    private void restoreRepositoryAndReverseOptions() {
        this.prefsSetting = true;
        SlideShowProject project = Main.get().getCurrentProject();
        boolean hasSlideShows = project.hasSlildeShowDirectory();
        boolean repSel = project.isRepositoryProject() && !hasSlideShows;
        boolean revSel = project.isReverseProject() && !hasSlideShows;
        this.getRepositoryRadioButton().setSelected(this.projectPrefs.getRepositorySelected(repSel));
        this.getReverseRadioButton().setSelected(this.projectPrefs.getReverseSelected(revSel));
        if (this.getRepositoryRadioButton().isSelected() || this.getReverseRadioButton().isSelected()) {
            this.setSowActionEnabled(this.sowEnabled());
        }
        this.prefsSetting = false;
    }

    private void setSowActionEnabled(boolean enabled) {
        this.getSowButton().setEnabled(enabled);
        this.getProjectSowMenuItem().setEnabled(enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkLinksActionEnabled() {
        SlideShowProject project = Main.get().getCurrentProject();
        FileSelection selection = this.getFileManager().getFileSelection();
        boolean moreThanOne = selection.getSlideShowSelectionCount() > 1;
        ArrayList<File> l = new ArrayList<File>();
        XissWeb xissWeb = this;
        synchronized (xissWeb) {
            Iterator i = selection.getSlideShowSelection().iterator();
            while (i.hasNext()) {
                l.add(((File)i.next()).getParentFile());
            }
        }
        this.linkedSlideshowSelection = l.isEmpty() ? null : project.checkSlideshowLinksConsistency(l);
        if (this.linkedSlideshowSelection == null || this.linkedSlideshowSelection.isConsistent()) {
            this.clearSelectionWarningMessage();
        } else {
            this.displaySelectionWarningMessage();
        }
        this.setLinksActionEnabled(moreThanOne, moreThanOne && !this.linkedSlideshowSelection.isConsistent());
    }

    private void setLinksActionEnabled(boolean enabled, boolean warning) {
        this.getLinksButton().setEnabled(enabled);
        this.getLinksButton().setIcon(XissWebUI.getIcon(warning ? LINKS_WARN_ICON : LINKS_ICON), XissWebUI.getIcon(warning ? LINKS_WARN_OVER_ICON : LINKS_OVER_ICON));
        this.getProjectLinksManageMenuItem().setEnabled(enabled);
        this.getProjectLinksManageMenuItem().setIcon(XissWebUI.getIcon(warning ? LINKS_WARN_ICON : LINKS_ICON));
    }

    private void setBuildActionEnabled(boolean enabled) {
        this.getBuildButton().setEnabled(enabled);
        this.getProjectBuildMenuItem().setEnabled(enabled);
    }

    private void setShowActionEnabled(boolean enabled) {
        this.getShowButton().setEnabled(enabled);
        this.getProjectShowMenuItem().setEnabled(enabled);
    }

    private void setCleanActionEnabled(boolean enabled) {
        this.getProjectCleanMenuItem().setEnabled(enabled);
        this.getCleanButton().setEnabled(enabled);
    }

    public synchronized void updateGuiState() {
        SlideShowProject project = Main.get().getCurrentProject();
        this.getProjectPropertiesMenuItem().setEnabled(true);
        this.getRepositoryRadioButton().setVisible(project.isRepositoryProject());
        this.getReverseRadioButton().setVisible(project.isReverseProject());
        boolean srcExists = Main.get().getCurrentProject().getSrcDirectory().exists();
        boolean hasContent = SlideShowDirectory.hasSlideshowDescription(project.getSrcDirectory());
        this.setBuildActionEnabled(hasContent);
        this.setLinksActionEnabled(false, false);
        this.setCleanActionEnabled(this.isCleanEnabled());
        this.setShowActionEnabled(ShowHelper.hasHtmlToShow());
        if (!(srcExists || project.isRepositoryProject() || project.isReverseProject())) {
            this.displayInfoMessage("no.src.dir", this.noSrcAction);
        } else {
            this.unsetPropertiesInfoErrors();
        }
        if (project.isRepositoryProject()) {
            File repDir = project.getRepositoryDirectory();
            if (!repDir.exists()) {
                this.displayInfoMessage("no.repository.exist", this.noRepositoryDirAction);
            } else {
                this.unsetPropertiesInfoErrors();
            }
        }
        if (project.isReverseProject()) {
            File oDir = project.getOriginDiretory();
            if (!oDir.exists()) {
                this.displayInfoMessage("no.reverse.exist", this.noOriginDirAction);
            } else {
                this.unsetPropertiesInfoErrors();
            }
        }
        this.updateLinkedSlideshowConsistencyStatus();
        this.setSowActionEnabled(this.sowEnabled());
    }

    public void linksChanged(SlideShowContentInfo[] slideshow) {
        this.updateLinkedSlideshowConsistencyStatus();
    }

    void updateLinkedSlideshowConsistencyStatus() {
        SlideShowProject project = Main.get().getCurrentProject();
        project.buildSetsOfLinkedSlideShow();
        this.getProjectLinksCheckMenuItem().setEnabled(project.hasLinkedSlideshows());
        if (project.isLinkedSlideshowsConsistent()) {
            this.getProjectLinksCheckMenuItem().setIcon(XissWebUI.getIcon(LINKS_ICON));
            this.clearLinkWarningMessage();
        } else {
            this.getProjectLinksCheckMenuItem().setIcon(XissWebUI.getIcon(LINKS_WARN_ICON));
            this.displayLinkWarningMessage();
        }
    }

    private boolean sowEnabled() {
        SlideShowProject project = Main.get().getCurrentProject();
        boolean srcExists = project.getSrcDirectory().exists();
        return srcExists && !project.isRepositoryProject() && !project.isReverseProject() || project.isRepositoryProject() && project.getRepositoryDirectory().exists() && this.getRepositoryRadioButton().isSelected() || srcExists && Main.get().getCurrentProject().getProperties().isImportImage() || project.isReverseProject() && project.getOriginDiretory().exists() && this.getReverseRadioButton().isSelected() || srcExists;
    }

    private boolean isCleanEnabled() {
        boolean enabled = false;
        File build = Main.get().getCurrentProject().getBuildDirectory();
        if (build.exists()) {
            if (!this.getFileManager().getFileSelection().hasCheckedNode()) {
                File[] files = build.listFiles();
                enabled = files != null && files.length > 0;
            } else {
                Set selection = this.getFileManager().getFileSelection().getChechedNodes();
                File src = Main.get().getCurrentProject().getSrcDirectory();
                Iterator i = selection.iterator();
                while (i.hasNext()) {
                    File dir = (File)((DefaultMutableTreeNode)i.next()).getUserObject();
                    File buildDir = FileHelper.fileInTargetDir((File)src, (File)dir, (File)build);
                    if (!buildDir.exists()) continue;
                    enabled = true;
                    break;
                }
            }
        }
        return enabled;
    }

    private void unsetPropertiesInfoErrors() {
        this.clearInfoMessage();
    }

    private JPanel getProjectInfoPanel() {
        if (this.projectInfoPanel == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setAlignment(0);
            this.projectLabel = new JLabel();
            this.projectLabel.setText("project.label");
            this.textDisplayer.register(this.projectLabel, "project.label");
            this.projectLabel.setForeground(XissWebUI.darkColor);
            this.projectInfoPanel = new JPanel();
            this.projectInfoPanel.setLayout(flowLayout);
        }
        return this.projectInfoPanel;
    }

    private JTextField getProjectDirTextField() {
        if (this.projectDirTextField == null) {
            this.projectDirTextField = new JTextField();
            this.projectDirTextField.setEditable(false);
            this.projectDirTextField.setDisabledTextColor(XissWebUI.paleColor);
            this.projectDirTextField.setText("-");
            this.projectDirTextField.setBackground(XissWebUI.paleColor);
            this.projectDirTextField.setColumns(40);
            this.projectDirTextField.setFont(XissWebUI.textAreaFont);
            this.projectDirTextField.setEnabled(true);
            this.projectDirTextField.setTransferHandler(new ProjectFileTransferHandler(this));
        }
        return this.projectDirTextField;
    }

    private ActiveLabel getSowButton() {
        if (this.sowButton == null) {
            this.sowButton = new ActiveLabel();
            this.sowButton.setIcon(XissWebUI.getIcon(PROCESS_SOW_ICON), XissWebUI.getIcon(PROCESS_SOW_OVER_ICON));
            this.textDisplayer.registerToolTip(this.sowButton, "sow.tooltip");
            this.sowButton.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (((JComponent)e.getSource()).isEnabled() && e.getButton() == 1 && e.getClickCount() == 1) {
                        XissWeb.this.performSow();
                    }
                }
            });
        }
        return this.sowButton;
    }

    private SowLauncher getSowProcessing() {
        if (this.sowLauncher == null) {
            this.sowLauncher = new SowLauncher(this);
        }
        return this.sowLauncher;
    }

    private String getSowMode() {
        String mode = "no.mode";
        if (this.isRervseMode()) {
            mode = "reverse.mode";
        }
        if (this.isRepositoryMode()) {
            mode = "repository.mode";
        }
        return mode;
    }

    void performSow() {
        if (this.editorManager.querySaveAllEditor(true)) {
            FileSelection fileSelection = this.getFileManager().getFileSelection();
            Set selection = Main.get().getCurrentProject().isRepositoryProject() ? fileSelection.getRepositoryDircetorySelection() : fileSelection.getDircetorySelection();
            this.getSowProcessing().openPrecessor(Main.get().getCurrentProject(), this.getSowMode(), selection.isEmpty() ? null : selection);
            this.updateGuiState();
        }
    }

    public void performSow(File slideshowDir) {
        HashSet<File> selection = new HashSet<File>();
        selection.add(slideshowDir);
        this.getSowProcessing().openPrecessor(Main.get().getCurrentProject(), this.getSowMode(), selection);
        this.updateGuiState();
    }

    private JComponent getBuildButton() {
        if (this.buildButton == null) {
            ActiveLabel label = new ActiveLabel();
            label.setIcon(XissWebUI.getIcon(PROCESS_BUILD_ICON), XissWebUI.getIcon(PROCESS_BUILD_OVER_ICON));
            label.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (((JComponent)e.getSource()).isEnabled() && e.getButton() == 1 && e.getClickCount() == 1) {
                        XissWeb.this.performBuild();
                    }
                }
            });
            this.textDisplayer.registerToolTip(label, "build.tooltip");
            this.buildButton = label;
        }
        return this.buildButton;
    }

    private BuildLauncher getBuildLauncher() {
        if (this.buildLauncher == null) {
            this.buildLauncher = new BuildLauncher(this);
        }
        return this.buildLauncher;
    }

    public void performOneSlideShowBuild(File slideShowDir) {
        HashSet<File> selection = new HashSet<File>();
        selection.add(slideShowDir);
        this.performBuild(selection);
    }

    void performBuild() {
        if (this.editorManager.querySaveAllEditor(true)) {
            this.performBuild(this.getFileManager().getFileSelection().getDircetorySelection());
        }
    }

    private void performBuild(Set selection) {
        this.getBuildLauncher().openPrecessor(Main.get().getCurrentProject(), selection.isEmpty() ? null : selection);
        this.updateGuiState();
    }

    public JPopupMenu getNoSrcDirPopupMenu() {
        if (this.noSrcDirPopupMenu == null) {
            this.noSrcDirPopupMenu = new JPopupMenu();
            this.noSrcDirPopupMenu.setBackground(XissWebUI.paleColor);
            this.noSrcDirPopupMenu.setBorderPainted(true);
            this.noSrcDirPopupMenu.add(this.getChangeSrcDirMenuItem());
            this.noSrcDirPopupMenu.add(this.getCreateSrcDirMenuItem());
            this.noSrcDirPopupMenu.add(this.getNoSrcOpenProjectMenuItem());
        }
        return this.noSrcDirPopupMenu;
    }

    private JMenuItem getChangeSrcDirMenuItem() {
        if (this.changeSrcDirMenuItem == null) {
            this.changeSrcDirMenuItem = new JMenuItem();
            this.changeSrcDirMenuItem.setBackground(XissWebUI.paleColor);
            this.changeSrcDirMenuItem.setFont(new Font("Arial", 0, 10));
            this.textDisplayer.register(this.changeSrcDirMenuItem, "no.src.popup.change");
            this.changeSrcDirMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Main.get().editProperties("src.root.dir");
                }
            });
        }
        return this.changeSrcDirMenuItem;
    }

    private JMenuItem getCreateSrcDirMenuItem() {
        if (this.createSrcDirMenuItem == null) {
            this.createSrcDirMenuItem = new JMenuItem();
            this.createSrcDirMenuItem.setFont(new Font("Arial", 0, 10));
            this.textDisplayer.register(this.createSrcDirMenuItem, "no.src.popup.create");
            this.createSrcDirMenuItem.setBackground(XissWebUI.paleColor);
            this.createSrcDirMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    File dir = Main.get().getCurrentProject().getSrcDirectory();
                    dir.mkdirs();
                    XissWeb.this.updateGuiState();
                }
            });
        }
        return this.createSrcDirMenuItem;
    }

    private JMenuItem getNoSrcOpenProjectMenuItem() {
        if (this.noSrcOpenProjectMenuItem == null) {
            this.noSrcOpenProjectMenuItem = new JMenuItem();
            this.noSrcOpenProjectMenuItem.setBackground(XissWebUI.paleColor);
            this.textDisplayer.register(this.noSrcOpenProjectMenuItem, "no.src.popup.open.project");
            this.noSrcOpenProjectMenuItem.setFont(new Font("Arial", 0, 10));
            this.noSrcOpenProjectMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    XissWeb.this.performOpenProject();
                }
            });
        }
        return this.noSrcOpenProjectMenuItem;
    }

    JCheckBox getReverseRadioButton() {
        if (this.reverseRadioButton == null) {
            this.reverseRadioButton = new JCheckBox();
            this.reverseRadioButton.setVisible(false);
            this.reverseRadioButton.setIcon(XissWebUI.getIcon(REVERSE_ICON));
            this.reverseRadioButton.setSelectedIcon(XissWebUI.getIcon(REVERSE_SELECTED_ICON));
            this.textDisplayer.registerToolTip(this.reverseRadioButton, "reverse.label");
            this.reverseRadioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    XissWeb.this.selectReverseMode();
                }
            });
        }
        return this.reverseRadioButton;
    }

    void selectReverseMode() {
        if (!this.prefsSetting) {
            this.storeReverseSelected(this.getReverseRadioButton().isSelected());
            this.updateGuiState();
            this.fileManager.getFileTreeModel().originNodeChanged();
        }
    }

    public boolean isRervseMode() {
        return Main.get().getCurrentProject().isReverseProject() && this.getReverseRadioButton().isSelected();
    }

    public boolean isRepositoryMode() {
        return Main.get().getCurrentProject().isRepositoryProject() && this.getRepositoryRadioButton().isSelected();
    }

    private JCheckBox getRepositoryRadioButton() {
        if (this.repositoryRadioButton == null) {
            this.repositoryRadioButton = new JCheckBox();
            this.repositoryRadioButton.setVisible(false);
            this.repositoryRadioButton.setIcon(XissWebUI.getIcon(REPOSITORY_ICON));
            this.repositoryRadioButton.setSelectedIcon(XissWebUI.getIcon(REPOSITORY_SELECTED_ICON));
            this.textDisplayer.registerToolTip(this.repositoryRadioButton, "repository.label");
            this.repositoryRadioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    XissWeb.this.selectRepositoryMode();
                }
            });
        }
        return this.repositoryRadioButton;
    }

    void selectRepositoryMode() {
        if (!this.prefsSetting) {
            this.storeRepositorySelected(this.getRepositoryRadioButton().isSelected());
            this.fileManager.getFileTreeModel().repositoryNodesChanged();
            this.updateGuiState();
        }
    }

    public JPopupMenu getNoOriginDirPopupMenu() {
        if (this.noOriginDirPopupMenu == null) {
            this.noOriginDirPopupMenu = new JPopupMenu();
            this.noOriginDirPopupMenu.add(this.getSetOriginDirMenuItem());
        }
        return this.noOriginDirPopupMenu;
    }

    private JMenuItem getSetOriginDirMenuItem() {
        if (this.setOriginDirMenuItem == null) {
            this.setOriginDirMenuItem = new JMenuItem();
            this.textDisplayer.register(this.setOriginDirMenuItem, "no.origin.popup.set");
            this.setOriginDirMenuItem.setFont(new Font("Arial", 0, 10));
            this.setOriginDirMenuItem.setBackground(XissWebUI.paleColor);
            this.setOriginDirMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Main.get().editProperties("origin.root.dir");
                }
            });
        }
        return this.setOriginDirMenuItem;
    }

    public JPopupMenu getNoRepositoryPopupMenu() {
        if (this.noRepositoryPopupMenu == null) {
            this.noRepositoryPopupMenu = new JPopupMenu();
            this.noRepositoryPopupMenu.add(this.getChooseRepositoryMenuItem());
        }
        return this.noRepositoryPopupMenu;
    }

    private JMenuItem getChooseRepositoryMenuItem() {
        if (this.chooseRepositoryMenuItem == null) {
            this.chooseRepositoryMenuItem = new JMenuItem();
            this.textDisplayer.register(this.chooseRepositoryMenuItem, "no.repository.popup.set");
            this.chooseRepositoryMenuItem.setBackground(XissWebUI.paleColor);
            this.chooseRepositoryMenuItem.setFont(new Font("Arial", 0, 10));
            this.chooseRepositoryMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Main.get().editProperties("repository.root.dir");
                }
            });
        }
        return this.chooseRepositoryMenuItem;
    }

    private JComponent getShowButton() {
        if (this.showButton == null) {
            ActiveLabel label = new ActiveLabel();
            label.setIcon(XissWebUI.getIcon(SHOW_ICON), XissWebUI.getIcon(SHOW_OVER_ICON));
            label.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (((JComponent)e.getSource()).isEnabled() && e.getButton() == 1 && e.getClickCount() == 1) {
                        ShowHelper.performShow();
                    }
                }
            });
            this.textDisplayer.registerToolTip(label, "project.show.tooltip");
            this.showButton = label;
        }
        return this.showButton;
    }

    private JMenuItem getHelpMenuItem() {
        if (this.helpMenuItem == null) {
            this.helpMenuItem = new JMenuItem();
            this.textDisplayer.register(this.helpMenuItem, "menu.help.help");
            this.helpMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Help.open();
                }
            });
        }
        return this.helpMenuItem;
    }

    private JMenu getHelpMenu() {
        if (this.helpMenu == null) {
            this.helpMenu = new JMenu();
            this.helpMenu.setIcon(XissWebUI.getIcon(HELP_MENU_ICON));
            this.helpMenu.add(this.getExamplesMenu());
            this.helpMenu.add(new JSeparator());
            this.helpMenu.add(this.getHelpMenuItem());
            this.helpMenu.add(this.getAboutMenuItem());
            this.helpMenu.add(this.getNewVersionMenuItem());
        }
        return this.helpMenu;
    }

    private JMenu getExamplesMenu() {
        if (this.examplesMenu == null) {
            this.examplesMenu = new JMenu();
            this.textDisplayer.register(this.examplesMenu, "menu.help.examples");
            for (int i = 0; i < examples.length; ++i) {
                this.getExamplesMenu().add(this.makeExampleMenuItem(examples[i]));
            }
            this.getExamplesMenu().add(new JSeparator());
            this.getExamplesMenu().add(this.getInstallExamplesMenuItem());
        }
        this.updateExamplesMenu();
        return this.examplesMenu;
    }

    private void updateExamplesMenu() {
        File exDir = new File("examples");
        boolean noExamples = !exDir.exists() || !exDir.isDirectory();
        for (int i = 0; i < this.examplesMenu.getMenuComponentCount(); ++i) {
            Component c = this.examplesMenu.getMenuComponent(i);
            if (!(c instanceof JMenuItem)) continue;
            JMenuItem item = (JMenuItem)c;
            if (i < examples.length) {
                item.setEnabled(!noExamples);
                continue;
            }
            item.setEnabled(noExamples);
        }
    }

    private JMenuItem getInstallExamplesMenuItem() {
        if (this.installExamplesMenuItem == null) {
            this.installExamplesMenuItem = new JMenuItem();
            this.textDisplayer.register(this.installExamplesMenuItem, "menu.help.examples.install");
            this.installExamplesMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    XissWeb.this.installExamples();
                }
            });
        }
        return this.installExamplesMenuItem;
    }

    void installExamples() {
        ExamplesInstallerDialog installer = new ExamplesInstallerDialog(this);
        installer.showDialog();
        if (installer.isComplete()) {
            this.updateExamplesMenu();
        }
    }

    private JMenuItem makeExampleMenuItem(String sampleName) {
        JMenuItem menuItem = new JMenuItem();
        menuItem.setText(sampleName);
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                XissWeb.this.performOpenExample(((JMenuItem)e.getSource()).getText());
            }
        });
        return menuItem;
    }

    void performOpenExample(String sampleName) {
        File file = Main.getExemplesDir();
        this.openProject(new File(file, sampleName));
    }

    private JMenu getOptionsMenu() {
        if (this.optionsMenu == null) {
            this.optionsMenu = new JMenu();
            this.textDisplayer.register(this.optionsMenu, "menu.options");
            this.optionsMenu.add(this.getProjectPropertiesMenuItem());
            this.optionsMenu.add(new JSeparator());
            this.optionsMenu.add(this.getWebExplorerMenuItem());
        }
        return this.optionsMenu;
    }

    private JMenuItem getProjectPropertiesMenuItem() {
        if (this.projectPropertiesMenuItem == null) {
            this.projectPropertiesMenuItem = new JMenuItem();
            this.textDisplayer.register(this.projectPropertiesMenuItem, "menu.options.properties");
            this.projectPropertiesMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Main.get().editProperties();
                }
            });
        }
        return this.projectPropertiesMenuItem;
    }

    private JMenuItem getWebExplorerMenuItem() {
        if (this.webExplorerMenuItem == null) {
            this.webExplorerMenuItem = new JMenuItem();
            this.textDisplayer.register(this.webExplorerMenuItem, "menu.options.preferences");
            this.webExplorerMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Main.get().editPreferences();
                }
            });
        }
        return this.webExplorerMenuItem;
    }

    private JMenuItem getAboutMenuItem() {
        if (this.aboutMenuItem == null) {
            this.aboutMenuItem = new JMenuItem();
            this.textDisplayer.register(this.aboutMenuItem, "menu.help.about");
            this.aboutMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    XissWeb.this.performShowAboutDialog();
                }
            });
        }
        return this.aboutMenuItem;
    }

    void performShowAboutDialog() {
        new AboutDialog(this).setVisible(true);
    }

    private JComponent getCleanButton() {
        if (this.cleanButton == null) {
            ActiveLabel label = new ActiveLabel();
            label.setIcon(XissWebUI.getIcon(CLEAN_ICON), XissWebUI.getIcon(CLEAN_OVER_ICON));
            label.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (((JComponent)e.getSource()).isEnabled() && e.getButton() == 1 && e.getClickCount() == 1) {
                        XissWeb.this.performClean();
                    }
                }
            });
            this.textDisplayer.registerToolTip(label, "clean.tooltip");
            this.cleanButton = label;
        }
        return this.cleanButton;
    }

    void performClean() {
        if (!this.fileManager.getFileSelection().hasCheckedNode()) {
            FileHelper.recursDelete((File)Main.get().getCurrentProject().getBuildDirectory());
        } else {
            HashSet selection = new HashSet(this.fileManager.getFileSelection().getDircetorySelection());
            File buildDir = Main.get().getCurrentProject().getBuildDirectory();
            File srcDir = Main.get().getCurrentProject().getSrcDirectory();
            Iterator i = selection.iterator();
            while (i.hasNext()) {
                File f;
                File d = (File)i.next();
                if (d.equals(Main.get().getCurrentProject().getLocation()) || !(f = new File(buildDir, FileHelper.relativePath((File)srcDir, (File)d))).exists()) continue;
                FileHelper.recursDelete((File)f);
            }
        }
        this.updateGuiState();
    }

    public void fileSelectionChanged(FileSelection selection) {
        if (Main.get().hasCurrentProject()) {
            this.checkLinksActionEnabled();
            this.setCleanActionEnabled(this.isCleanEnabled());
            this.updateSelectedSlideshowDialog();
        }
    }

    void updateSelectedSlideshowDialog() {
        if (this.selectedSlideshowDialog != null) {
            this.selectedSlideshowDialog.dataChanged(this.linkedSlideshowSelection);
        }
    }

    CloseTabbedPane getEditorsTabbedPane() {
        if (this.editorsTabbedPane == null) {
            this.editorsTabbedPane = new CloseTabbedPane();
            this.editorsTabbedPane.setTabLayoutPolicy(1);
            this.editorsTabbedPane.addCloseListener(this);
            this.editorsTabbedPane.addMouseListener(this);
            this.editorsTabbedPane.setFont(new Font("Arial", 0, 11));
            SingleSelectionModel selectM = this.editorsTabbedPane.getModel();
            selectM.addChangeListener(this);
        }
        return this.editorsTabbedPane;
    }

    public void performClose(CloseEvent e) {
        this.editorManager.closeEditorAt(e.getTabIndex());
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 3 && e.getClickCount() == 1) {
            this.showEditorsContainerPopupMenu(e);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void stateChanged(ChangeEvent e) {
        this.editorManager.updateCurrentDocPreferences();
    }

    void performCloseAllEditors() {
        this.editorManager.closeAllEditor();
    }

    void editorsAdded() {
        this.editorsTabbedPane.validate();
    }

    void removeEditorInternal(Editor editor) {
        this.editorsTabbedPane.remove(editor.getEditorGuiComponent());
    }

    private void showEditorsContainerPopupMenu(MouseEvent e) {
        this.editorManager.getEditorsContainer().getPopupMenu().show(this.editorsTabbedPane, e.getX(), e.getY());
    }

    JMenuItem getSaveFileMenuItem() {
        if (this.saveFileMenuItem == null) {
            this.saveFileMenuItem = new JMenuItem();
            this.saveFileMenuItem.setEnabled(false);
            this.saveFileMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
            this.textDisplayer.register(this.saveFileMenuItem, "menu.file.save");
            this.saveFileMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    XissWeb.this.editorManager.saveCurrentEditor();
                }
            });
        }
        return this.saveFileMenuItem;
    }

    JMenuItem getSaveAllFileMenuItem() {
        if (this.saveAllFileMenuItem == null) {
            this.saveAllFileMenuItem = new JMenuItem();
            this.saveAllFileMenuItem.setEnabled(false);
            this.saveAllFileMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 3));
            this.textDisplayer.register(this.saveAllFileMenuItem, "menu.file.save.all");
            this.saveAllFileMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    XissWeb.this.editorManager.saveAllEditors();
                }
            });
        }
        return this.saveAllFileMenuItem;
    }

    JMenuItem getCancelFileMenuItem() {
        if (this.cancelFileMenuItem == null) {
            this.cancelFileMenuItem = new JMenuItem();
            this.cancelFileMenuItem.setEnabled(false);
            this.textDisplayer.register(this.cancelFileMenuItem, "menu.file.cancel");
            this.cancelFileMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    XissWeb.this.editorManager.cancelCurrentEditor();
                }
            });
        }
        return this.cancelFileMenuItem;
    }

    JMenuItem getCloseFileMenuItem() {
        if (this.closeFileMenuItem == null) {
            this.closeFileMenuItem = new JMenuItem();
            this.closeFileMenuItem.setEnabled(false);
            this.closeFileMenuItem.setAccelerator(KeyStroke.getKeyStroke(87, 2));
            this.textDisplayer.register(this.closeFileMenuItem, "menu.file.close");
            this.closeFileMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    XissWeb.this.performCloseCurrentEditor();
                }
            });
        }
        return this.closeFileMenuItem;
    }

    JMenuItem getCloseAllFileMenuItem() {
        if (this.closeAllFileMenuItem == null) {
            this.closeAllFileMenuItem = new JMenuItem();
            this.closeAllFileMenuItem.setEnabled(false);
            this.closeAllFileMenuItem.setAccelerator(KeyStroke.getKeyStroke(87, 3));
            this.textDisplayer.register(this.closeAllFileMenuItem, "menu.file.close.all");
            this.closeAllFileMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    XissWeb.this.performCloseAllEditors();
                }
            });
        }
        return this.closeAllFileMenuItem;
    }

    private JPanel getInfoPanel() {
        if (this.infoPanel == null) {
            this.infoPanel = new JPanel();
            this.infoPanel.setLayout(new GridBagLayout());
            this.infoPanel.setBorder(BorderFactory.createEtchedBorder(0));
            GridBagConstraints constraints = new GridBagConstraints();
            int y = 0;
            constraints.anchor = 10;
            constraints.insets = new Insets(1, 0, 1, 0);
            constraints.weightx = 1.0;
            constraints.gridx = 0;
            constraints.gridy = y++;
            this.infoPanel.add((Component)this.getInfoLabel(), constraints);
            constraints.gridy = y++;
            this.infoPanel.add((Component)this.getEditorInfoLabel(), constraints);
            constraints.gridy = y++;
            this.infoPanel.add((Component)this.getLinksWargingLabel(), constraints);
            constraints.gridy = y++;
            this.infoPanel.add((Component)this.getSelectionWarningLabel(), constraints);
        }
        return this.infoPanel;
    }

    private JLabel getEditorInfoLabel() {
        if (this.editorInfoLabel == null) {
            this.editorInfoLabel = new JLabel();
            this.editorInfoLabel.setText("");
            this.editorInfoLabel.setVisible(false);
            this.editorInfoLabel.setFont(XissWebUI.boldItalicFont);
        }
        return this.editorInfoLabel;
    }

    private JLabel getInfoLabel() {
        if (this.infoLabel == null) {
            this.infoLabel = new JLabel();
            this.infoLabel.setText("");
            this.infoLabel.setVisible(false);
            this.infoLabel.setFont(XissWebUI.boldItalicFont);
        }
        return this.infoLabel;
    }

    private JLabel getLinksWargingLabel() {
        if (this.linksWargingLabel == null) {
            this.linksWargingLabel = new JLabel();
            this.linksWargingLabel.setText("");
            this.linksWargingLabel.setVisible(false);
            this.linksWargingLabel.setFont(XissWebUI.boldItalicFont);
        }
        return this.linksWargingLabel;
    }

    public LinkedSlideshow getLinkedSlideshowSelection() {
        return this.linkedSlideshowSelection;
    }

    private JLabel getSelectionWarningLabel() {
        if (this.selectionWarningLabel == null) {
            this.selectionWarningLabel = new JLabel();
            this.selectionWarningLabel.setText("");
            this.selectionWarningLabel.setVisible(false);
            this.selectionWarningLabel.setFont(XissWebUI.boldItalicFont);
        }
        return this.selectionWarningLabel;
    }

    private void displayInfoMessage(String textKey, MouseListener action) {
        this.displayMessage(this.getInfoLabel(), textKey, action, ERROR_ICON);
    }

    private void clearInfoMessage() {
        this.clearMessage(this.getInfoLabel());
    }

    private void displayLinkWarningMessage() {
        this.displayMessage(this.getLinksWargingLabel(), "links.inconsistency", this.linkedSlideshowInconsistency, WARNING_ICON);
    }

    public void clearLinkWarningMessage() {
        this.clearMessage(this.getLinksWargingLabel());
    }

    private void displaySelectionWarningMessage() {
        this.displayMessage(this.getSelectionWarningLabel(), "selection.warning", this.selectionWarning, WARNING_ICON);
    }

    private void clearSelectionWarningMessage() {
        this.clearMessage(this.getSelectionWarningLabel());
    }

    private void displayEditorInfoMessage(String message, MouseListener action) {
        this.getEditorInfoLabel().setText(message);
        this.getEditorInfoLabel().setIcon(XissWebUI.getIcon(ERROR_ICON));
        if (action != null) {
            this.getEditorInfoLabel().addMouseListener(action);
        }
        this.getEditorInfoLabel().setVisible(true);
    }

    private void clearEditorInfoMessage() {
        this.clearMessage(this.getEditorInfoLabel());
    }

    private void displayMessage(JLabel label, String textKey, MouseListener action, String icon) {
        this.textDisplayer.register(label, textKey);
        label.setIcon(XissWebUI.getIcon(icon));
        if (action != null) {
            label.addMouseListener(action);
        }
        label.setVisible(true);
    }

    private void clearMessage(JLabel label) {
        this.textDisplayer.unregister(label);
        label.setText("");
        label.setIcon(null);
        MouseListener[] listenres = label.getMouseListeners();
        if (listenres.length > 0) {
            label.removeMouseListener(listenres[0]);
        }
        label.setVisible(false);
    }

    void editorOnErrors(List handlers) {
        int nb = handlers.size();
        int problemsCount = 0;
        Iterator i = handlers.iterator();
        while (i.hasNext()) {
            ValidProcessHandler h = (ValidProcessHandler)i.next();
            problemsCount += ((List)h.getValidInfos()).size();
        }
        if (nb == 0) {
            this.clearEditorInfoMessage();
        } else {
            StringBuffer buff = new StringBuffer();
            if (nb == 1) {
                buff.append(this.textDisplayer.getString("editor.save.one"));
                buff.append(" ");
                buff.append(this.textDisplayer.getString("editor.save.error.file"));
                buff.append(" ");
                buff.append(this.textDisplayer.getString("editor.save.error.one"));
                buff.append(" ");
            } else {
                buff.append(nb);
                buff.append(" ");
                buff.append(this.textDisplayer.getString("editor.save.error.file"));
                buff.append("s ");
                buff.append(this.textDisplayer.getString("editor.save.error.some"));
            }
            buff.append(" ").append(this.textDisplayer.getString("editor.save.error.for"));
            buff.append(" ").append(problemsCount);
            buff.append(" ").append(this.textDisplayer.getString("editor.save.error.problems"));
            this.displayEditorInfoMessage(buff.toString(), this.showEditorErrorsAction);
        }
    }

    private ActiveLabel getLinksButton() {
        if (this.linksButton == null) {
            this.linksButton = new ActiveLabel();
            this.linksButton.setIcon(XissWebUI.getIcon(LINKS_ICON), XissWebUI.getIcon(LINKS_OVER_ICON));
            this.textDisplayer.registerToolTip(this.linksButton, "links.tooltip");
            this.linksButton.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (((JComponent)e.getSource()).isEnabled() && e.getButton() == 1 && e.getClickCount() == 1) {
                        XissWeb.this.performOpenLinkManagesDialog();
                    }
                }
            });
        }
        return this.linksButton;
    }

    void performOpenLinkManagesDialog() {
        Collection dirs = this.linkedSlideshowSelection.getSlideshows();
        ArrayList<Editor> list = new ArrayList<Editor>();
        Iterator i = dirs.iterator();
        while (i.hasNext()) {
            File dir = (File)i.next();
            Editor e = this.editorManager.getEditorsContainer().getEditor(new File(dir, "slideshow.xml"));
            if (e == null) continue;
            list.add(e);
        }
        if (list.isEmpty() || this.editorManager.querySaveEditors(list, true)) {
            this.getLinksManagerDialog().open(this.linkedSlideshowSelection);
        }
    }

    private JMenuItem getNewRepositoryProjectMenuItem() {
        if (this.newRepositoryProjectMenuItem == null) {
            this.newRepositoryProjectMenuItem = new JMenuItem();
            this.newRepositoryProjectMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 3));
            this.newRepositoryProjectMenuItem.addActionListener(this.newRepositoryProjectAction);
            this.textDisplayer.register(this.newRepositoryProjectMenuItem, "menu.file.new.project.repository");
        }
        return this.newRepositoryProjectMenuItem;
    }

    private JMenuItem getNewProjectMenuItem() {
        if (this.newProjectMenuItem == null) {
            this.newProjectMenuItem = new JMenuItem();
            this.newProjectMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
            this.textDisplayer.register(this.newProjectMenuItem, "menu.file.new.project.basic");
            this.newProjectMenuItem.addActionListener(this.newProjectAction);
        }
        return this.newProjectMenuItem;
    }

    private JMenuItem getNewVersionMenuItem() {
        if (this.newVersionMenuItem == null) {
            this.newVersionMenuItem = new JMenuItem();
            this.newVersionMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    XissWeb.this.performNewVersion();
                }
            });
            this.textDisplayer.register(this.newVersionMenuItem, "menu.help.new.version");
        }
        return this.newVersionMenuItem;
    }

    void performNewVersion() {
        try {
            int n = Main.get().newVersionDetection(true);
            if (n == 0) {
                XissWebUI.showInfoMessage(this.textDisplayer.getString("up.to.date") + " (V" + About.getVersion() + ", " + About.getBuildDate() + ").", this.textDisplayer.getString("updating.version.title"));
            }
        }
        catch (IOException e) {
            XissWebUI.showWarningMessage(this.textDisplayer.getString("internet.connection.problem.1") + '\n' + this.textDisplayer.getString("internet.connection.problem.2"), this.textDisplayer.getString("updating.version.title"));
        }
    }

    private JMenu getRecentProjectsMenu() {
        if (this.recentProjectsMenu == null) {
            this.recentProjectsMenu = new JMenu();
            this.textDisplayer.register(this.recentProjectsMenu, "menu.file.recent.projects");
        }
        return this.recentProjectsMenu;
    }

    private JMenuItem getClearRencentProjectsMenuItem() {
        if (this.clearRencentProjectsMenuItem == null) {
            this.clearRencentProjectsMenuItem = new JMenuItem();
            this.textDisplayer.register(this.clearRencentProjectsMenuItem, "menu.file.recent.projects.clear");
            this.clearRencentProjectsMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    XissWeb.this.performClearRecentProject();
                }
            });
        }
        return this.clearRencentProjectsMenuItem;
    }

    void performClearRecentProject() {
        this.recentProjectList.clear();
        this.storeRencetsProjectPreferences();
        this.updateRecentProjectsMenu();
    }

    private JSeparator getRecentProjectMenuSeparator() {
        if (this.recentProjectMenuSeparator == null) {
            this.recentProjectMenuSeparator = new JSeparator();
        }
        return this.recentProjectMenuSeparator;
    }

    private void updateRecentProjectsMenu() {
        this.getRecentProjectsMenu().removeAll();
        Iterator i = this.recentProjectList.iterator();
        while (i.hasNext()) {
            final String path = (String)i.next();
            JMenuItem item = new JMenuItem();
            item.setText(path);
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    XissWeb.this.openProject(new File(path));
                }
            });
            this.getRecentProjectsMenu().add(item);
        }
        this.getRecentProjectsMenu().add(this.getRecentProjectMenuSeparator());
        this.getRecentProjectsMenu().add(this.getClearRencentProjectsMenuItem());
        this.getClearRencentProjectsMenuItem().setEnabled(!this.recentProjectList.isEmpty());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

