/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import org.xissweb.file.FileHelper;
import org.xissweb.gui.Main;
import org.xissweb.gui.XissWebUI;
import org.xissweb.gui.editor.DocumentException;
import org.xissweb.gui.editor.Editor;
import org.xissweb.gui.editor.EditorFactory;
import org.xissweb.gui.editor.EditorManager;
import org.xissweb.gui.editor.EditorObserver;
import org.xissweb.gui.editor.EditorsContainer;
import org.xissweb.gui.editor.ValidProcessHandler;
import org.xissweb.gui.editor.valid.EditorErrorComponent;
import org.xissweb.gui.image.ImageEditorFactory;
import org.xissweb.i18n.TextDisplayManager;
import org.xissweb.i18n.TextDisplayer;
import org.xissweb.image.ImageFileHelper;

public class XissEditorManager
implements EditorManager {
    private static final String DIALOG_SAVE_ICON = "/images/common/dialog-save.png";
    private static final String DOCUMENT_PREFS_KEY = "documents";
    private static final String CURRENT_PERFS_KEY = "current";
    private static final String EDITOR_SEPARATOR = ";";
    private static final String DOCUMENT_SEPARATOR = "|";
    public static final String CURRENT_DOC_NULL_VALUE = "null";
    private static final Set textFiles = new HashSet();
    private static final Set markupFiles = new HashSet();
    public static final String EDITOR_TEXT = "editor.text";
    private EditorsContainer container = null;
    private HashMap factories = new HashMap();
    private HashMap factoriesByClass = new HashMap();
    private EditorFactory imageEditorFactory;
    private HashMap editors = new HashMap();
    private EditorErrorComponent errorDialog = null;
    private EditorObserver observer;
    private TextDisplayer displayer = TextDisplayManager.createTextDisplayFor(this.getClass());

    public static boolean isTextFile(File file) {
        return textFiles.contains(FileHelper.fileNameExtention((File)file));
    }

    public static boolean isTextFile(String fileName) {
        return textFiles.contains(FileHelper.fileNameExtention((String)fileName));
    }

    public static boolean isMarkupFiles(File file) {
        return markupFiles.contains(FileHelper.fileNameExtention((File)file));
    }

    public static boolean isMarkupFiles(String fileName) {
        return markupFiles.contains(FileHelper.fileNameExtention((String)fileName));
    }

    public XissEditorManager() {
        this.imageEditorFactory = new ImageEditorFactory();
        this.factoriesByClass.put(this.imageEditorFactory.getClass(), this.imageEditorFactory);
    }

    EditorErrorComponent getErrorDialog() {
        if (this.errorDialog == null) {
            this.errorDialog = new EditorErrorComponent(Main.get().getXissWeb());
        }
        return this.errorDialog;
    }

    public void setObserver(EditorObserver observer) {
        this.observer = observer;
    }

    public void setEditorsContainer(EditorsContainer container) {
        this.container = container;
    }

    public EditorsContainer getEditorsContainer() {
        return this.container;
    }

    public void registerEditorFactory(Object key, EditorFactory factory) {
        this.factories.put(key, factory);
        this.factoriesByClass.put(factory.getClass(), factory);
    }

    public boolean isEditable(Object key) {
        return this.getEditorFactory(key) != null;
    }

    private EditorFactory getTextEditorFactory(Object key) {
        if (key instanceof String && XissEditorManager.isTextFile((String)key)) {
            return (EditorFactory)this.factories.get(EDITOR_TEXT);
        }
        return null;
    }

    public EditorFactory getEditorFactory(Object key) {
        EditorFactory factory = (EditorFactory)this.factories.get(key);
        if (factory == null && ImageFileHelper.isImageFile((String)key)) {
            factory = this.imageEditorFactory;
        }
        return factory == null ? this.getTextEditorFactory(key) : factory;
    }

    public EditorFactory getEditorFactory(Class fClass) {
        return (EditorFactory)this.factoriesByClass.get(fClass);
    }

    public void openEditor(Object key, Object document) {
        this.openEditor(this.getEditorFactory(key), document);
    }

    public void openEditor(Class factoryClass, Object document) {
        this.openEditor(this.getEditorFactory(factoryClass), document);
    }

    public void openEditor(Class factoryClass, String document) {
        this.openEditor(this.getEditorFactory(factoryClass), document);
    }

    public boolean closeDocumentEditor(Object document) {
        Editor editor = this.container.getEditor(document);
        if (editor != null) {
            return this.closeEditor(editor);
        }
        return true;
    }

    public boolean querySaveEditor(Editor editor) {
        return this.querySaveEditor(editor, false);
    }

    public boolean querySaveEditor(Editor editor, boolean force) {
        return this.querySaveEditor(editor, force, this.displayer.getString("save.one.modified.question.end"));
    }

    public boolean querySaveEditor(Editor editor, boolean force, String reason) {
        boolean result = true;
        if (editor.hasDocumentModified()) {
            String question = this.displayer.getString("save.one.modified.question");
            question = question + " \"" + editor.getDocumentName() + "\" ";
            question = question + reason;
            Object[] options = force ? new String[2] : new String[3];
            options[0] = this.displayer.getString("save.modified.yes");
            String string = options[1] = force ? this.displayer.getString("save.modified.cancel") : this.displayer.getString("save.modified.no");
            if (!force) {
                options[2] = this.displayer.getString("save.modified.cancel");
            }
            int n = JOptionPane.showOptionDialog(this.container.getGuiComponent(), question, this.displayer.getString("save.modified.title"), force ? 1 : 0, 3, XissWebUI.getIcon(DIALOG_SAVE_ICON), options, force ? options[1] : options[2]);
            switch (n) {
                case 0: {
                    if (editor.save() == 0) break;
                    result = false;
                    break;
                }
                case 1: {
                    if (!force) {
                        editor.cancel();
                        break;
                    }
                }
                case 2: {
                    result = false;
                }
            }
        }
        return result;
    }

    public boolean closeEditor(Editor editor) {
        return this.closeEditor(editor, false);
    }

    public boolean closeEditor(Editor editor, boolean force) {
        if (force || this.querySaveEditor(editor)) {
            this.removeEditor(editor);
            this.container.editorStatusChange(editor, 4);
            this.updatePreferences();
            return true;
        }
        return false;
    }

    public boolean closeCurrentEditor() {
        return this.closeEditor(this.container.getCurrentEditor());
    }

    public boolean closeEditorAt(int index) {
        return this.closeEditor(this.container.getEditorAt(index));
    }

    public boolean forceCloseAllEditor() {
        Iterator i = new ArrayList(this.container.getEditors()).iterator();
        while (i.hasNext()) {
            this.removeEditor((Editor)i.next());
        }
        return this.closeEditors(new ArrayList(this.container.getEditors()));
    }

    public boolean closeAllEditor() {
        return this.closeEditors(new ArrayList(this.container.getEditors()));
    }

    public boolean closeEditors(List lEditors) {
        boolean result = this.saveOpennedEditors(lEditors, false);
        if (result) {
            Iterator i = lEditors.iterator();
            while (i.hasNext()) {
                Editor e = (Editor)i.next();
                e.cancel();
                this.removeEditor(e);
            }
            this.updatePreferences();
        }
        return result;
    }

    public boolean closeOtherEditors() {
        ArrayList editors = new ArrayList(this.container.getEditors());
        editors.remove(this.container.getCurrentEditor());
        return this.closeEditors(editors);
    }

    public boolean querySaveAllEditor(boolean forceSave) {
        return this.saveOpennedEditors(new ArrayList(this.container.getEditors()), forceSave);
    }

    public boolean querySaveEditors(List lEditors, boolean forceSave) {
        return this.saveOpennedEditors(lEditors, forceSave);
    }

    public void saveEditor(Editor editor) {
        editor.save();
    }

    public void saveEditors(List editors) {
        Iterator i = editors.iterator();
        while (i.hasNext()) {
            ((Editor)i.next()).save();
        }
    }

    public void saveCurrentEditor() {
        Editor editor = this.container.getCurrentEditor();
        if (editor != null) {
            this.saveEditor(editor);
        }
    }

    public void saveAllEditors() {
        Iterator i = this.container.getEditors().iterator();
        while (i.hasNext()) {
            Editor e = (Editor)i.next();
            if (!e.hasDocumentModified()) continue;
            e.save();
        }
    }

    public void cancelEditor(Editor e) {
        Editor editor = this.container.getCurrentEditor();
        if (editor != null) {
            editor.cancel();
        }
    }

    public void cancelCurrentEditor() {
        this.cancelEditor(this.container.getCurrentEditor());
    }

    private void openEditor(EditorFactory eFactory, String docString) {
        this.openEditor(eFactory, eFactory.getDocumentObject(docString));
    }

    private void openEditor(EditorFactory eFactory, Object document) {
        Editor e = this.container.getEditor(document);
        if (e == null) {
            try {
                e = eFactory.makeEditor();
                e.setEditorsContainer(this.container);
                e.setEditedDocument(document);
                this.addEditor(eFactory, e);
                e.edit();
                this.container.setCurrentEditor(e);
                this.updatePreferences();
            }
            catch (DocumentException ex) {
                XissWebUI.showErrorMessage(ex.getMessage(), this.displayer.getString("unable.open.editor"));
                e = null;
            }
            catch (Exception ex) {
                System.out.println("Editor Manager : OpenEditor " + eFactory + " " + document);
                ex.printStackTrace();
                e = null;
            }
        } else {
            this.container.setCurrentEditor(e);
            this.updatePreferences();
        }
    }

    private void addEditor(EditorFactory f, Editor e) {
        this.container.addEditor(e);
        this.editors.put(e, f.getClass());
        if (this.observer != null) {
            this.observer.editorOpenned(e);
        }
    }

    private void removeEditor(Editor e) {
        this.container.removeEditor(e);
        this.editors.remove(e);
        if (this.observer != null) {
            this.observer.editorClosed(e);
        }
    }

    void displayErrorMessage() {
        ArrayList<ValidProcessHandler> handlers = new ArrayList<ValidProcessHandler>();
        Iterator i = this.container.getEditors().iterator();
        while (i.hasNext()) {
            ValidProcessHandler handler;
            Editor e = (Editor)i.next();
            if (e.isDocumentValid() || (handler = e.getValidProcessHandler()) == null) continue;
            handlers.add(handler);
        }
        Main.get().getXissWeb().editorOnErrors(handlers);
        this.getErrorDialog().setInfo(handlers);
        if (handlers.size() > 0) {
            this.getErrorDialog().open();
        } else {
            this.getErrorDialog().setVisible(false);
        }
    }

    private boolean saveOpennedEditors(List lEditors, boolean forceSave) {
        boolean savedOrIgnred = true;
        ArrayList<Editor> modified = new ArrayList<Editor>();
        Iterator i = lEditors.iterator();
        while (i.hasNext()) {
            Editor editor = (Editor)i.next();
            if (!editor.hasDocumentModified()) continue;
            modified.add(editor);
        }
        if (!modified.isEmpty()) {
            StringBuffer question = new StringBuffer();
            question.append("<html>");
            question.append(this.displayer.getString("save.modified.question"));
            question.append("<ul>");
            Iterator i2 = modified.iterator();
            while (i2.hasNext()) {
                question.append("<li>").append(((Editor)i2.next()).getDocumentName()).append("</li>");
            }
            question.append("</ul></html>");
            Object[] options = !forceSave ? new String[]{this.displayer.getString("save.modified.yes"), this.displayer.getString("save.modified.no"), this.displayer.getString("save.modified.cancel")} : new String[]{this.displayer.getString("save.modified.yes"), this.displayer.getString("save.modified.cancel")};
            int option = 1;
            if (forceSave) {
                option = 0;
            }
            int n = JOptionPane.showOptionDialog(this.container.getGuiComponent(), question, this.displayer.getString("save.modified.title"), option, 3, XissWebUI.getIcon(DIALOG_SAVE_ICON), options, options[0]);
            switch (n) {
                case 0: {
                    Iterator i3 = modified.iterator();
                    while (i3.hasNext()) {
                        Editor e = (Editor)i3.next();
                        int status = e.save();
                        if (status == 0) continue;
                        savedOrIgnred = false;
                    }
                    break;
                }
                case 1: {
                    if (!forceSave) break;
                    savedOrIgnred = false;
                    break;
                }
                case 2: {
                    savedOrIgnred = false;
                }
            }
        }
        return savedOrIgnred;
    }

    public void applyPreferences(String currentDoc, String documents) {
        String str = Main.preferences.get(CURRENT_PERFS_KEY, this.getClass(), null);
        if (str != null) {
            Main.get().getXissWeb().getProjectPrefs().storeCurrentDocument(str);
            Main.preferences.remove(CURRENT_PERFS_KEY, this.getClass());
        }
        if ((str = Main.preferences.get(DOCUMENT_PREFS_KEY, this.getClass(), null)) != null) {
            Main.get().getXissWeb().getProjectPrefs().storeDocuments(str);
            Main.preferences.remove(DOCUMENT_PREFS_KEY, this.getClass());
        }
        Main.preferences.put(CURRENT_PERFS_KEY, this.getClass(), CURRENT_DOC_NULL_VALUE);
        Main.preferences.put(DOCUMENT_PREFS_KEY, this.getClass(), "");
        if (!currentDoc.equals(CURRENT_DOC_NULL_VALUE)) {
            StringTokenizer token = new StringTokenizer(documents, EDITOR_SEPARATOR);
            while (token.hasMoreTokens()) {
                String edDoc = token.nextToken();
                int index = edDoc.indexOf(DOCUMENT_SEPARATOR);
                try {
                    String cName = edDoc.substring(0, index);
                    String dName = edDoc.substring(index + 1);
                    Class<?> fClass = Class.forName(cName);
                    this.openEditor(fClass, dName);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
            this.container.setCurrentEditor(this.container.getEditor(new File(currentDoc)));
        }
    }

    void updatePreferences() {
        if (!this.factories.isEmpty() && Main.get().hasCurrentProject()) {
            StringBuffer buff = new StringBuffer();
            Iterator i = this.container.getEditors().iterator();
            while (i.hasNext()) {
                Editor e = (Editor)i.next();
                Class fClass = (Class)this.editors.get(e);
                buff.append(fClass.getName()).append(DOCUMENT_SEPARATOR).append(e.getEditedDocument().toString());
                if (!i.hasNext()) continue;
                buff.append(EDITOR_SEPARATOR);
            }
            Main.get().getXissWeb().getProjectPrefs().storeDocuments(buff.toString());
            this.updateCurrentDocPreferences();
        }
    }

    void updateCurrentDocPreferences() {
        if (Main.get().hasCurrentProject()) {
            Editor e = this.container.getCurrentEditor();
            if (e == null) {
                Main.get().getXissWeb().getProjectPrefs().storeCurrentDocument(CURRENT_DOC_NULL_VALUE);
            } else {
                Main.get().getXissWeb().getProjectPrefs().storeCurrentDocument(e.getEditedDocument().toString());
            }
        }
    }

    static {
        textFiles.add("html");
        textFiles.add("css");
        textFiles.add("xml");
        textFiles.add("txt");
        textFiles.add("text");
        textFiles.add("php");
        textFiles.add("js");
        markupFiles.add("html");
        markupFiles.add("xml");
    }
}

