/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.data.layout;

import java.io.File;
import org.xissweb.data.layout.AnimationInfo;
import org.xissweb.data.layout.ArrangementInfo;
import org.xissweb.data.layout.GoogleMapsInfo;
import org.xissweb.data.layout.ImageAreaInfo;
import org.xissweb.data.layout.LocalIndexInfo;
import org.xissweb.data.layout.NavigationBarInfo;
import org.xissweb.data.layout.PageDecorationInfo;
import org.xissweb.data.layout.SkinInfo;
import org.xissweb.data.layout.ThumbnailsInfo;
import org.xissweb.data.layout.ThumbnailsInfoInfo;

public class SlideShowLayoutInfo {
    private String comment;
    private int pageWidth = -1;
    private File file;
    private SkinInfo skin;
    private AnimationInfo animation;
    private ThumbnailsInfoInfo thumbnailsInfo;
    private LocalIndexInfo localIndexInfo;
    private GoogleMapsInfo imageLocationOnMap;
    private PageDecorationInfo header;
    private PageDecorationInfo footer;
    private PageDecorationInfo leftMargin;
    private PageDecorationInfo rightMargin;
    private ArrangementInfo arrangement;

    public static SlideShowLayoutInfo emptyLayout() {
        SlideShowLayoutInfo layout = new SlideShowLayoutInfo();
        layout.setThumbnailsInfo(new ThumbnailsInfoInfo());
        layout.getThumbnailsInfo().setSize(70);
        layout.getThumbnailsInfo().setUnit("px");
        layout.getThumbnailsInfo().setShape("rectangle");
        layout.getThumbnailsInfo().setQuality("high");
        layout.setArrangement(new ArrangementInfo());
        layout.getArrangement().setOrientation("vertical");
        ThumbnailsInfo thumb = new ThumbnailsInfo();
        thumb.setRange(1);
        layout.getArrangement().getComponents().add(thumb);
        NavigationBarInfo nav = new NavigationBarInfo();
        nav.setBackward(true);
        nav.setInit(true);
        nav.setForward(true);
        layout.getArrangement().getComponents().add(nav);
        ImageAreaInfo image = new ImageAreaInfo();
        image.setWidth(600);
        image.setHeight(550);
        image.setCommentPosition("bottom");
        image.setNumberFormat("@#/%+");
        layout.arrangement.getComponents().add(image);
        return layout;
    }

    public int hashCode() {
        return this.getFile().hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof SlideShowLayoutInfo) {
            SlideShowLayoutInfo lInfo = (SlideShowLayoutInfo)o;
            return this.getFile().equals(lInfo.getFile());
        }
        return false;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public boolean hasImageArea() {
        return this.getArrangement().hasImageArea();
    }

    public AnimationInfo getAnimation() {
        return this.animation;
    }

    public void setAnimation(AnimationInfo animation) {
        this.animation = animation;
    }

    public GoogleMapsInfo getImageLocationOnMap() {
        return this.imageLocationOnMap;
    }

    public void setImageLocationOnMap(GoogleMapsInfo imageLocationOnMap) {
        this.imageLocationOnMap = imageLocationOnMap;
    }

    public void setLocalIndexInfo(LocalIndexInfo localIndexInfo) {
        this.localIndexInfo = localIndexInfo;
    }

    public String getLocalIndex() {
        LocalIndexInfo localIInfo = this.getArrangement() != null ? this.getArrangement().getLocalIndexInfo() : this.localIndexInfo;
        return localIInfo != null ? localIInfo.getType() : null;
    }

    public LocalIndexInfo getLocalIndexInfo() {
        LocalIndexInfo localIInfo = this.getArrangement() != null ? this.getArrangement().getLocalIndexInfo() : this.localIndexInfo;
        return localIInfo != null ? localIInfo : null;
    }

    public boolean hasNavigationBar() {
        return this.getArrangement().hasNavigationBar();
    }

    public String toString() {
        return '\"' + this.comment + '\"';
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public int getPageWidth() {
        return this.pageWidth;
    }

    public void setPageWidth(int pageWidth) {
        this.pageWidth = pageWidth;
    }

    public boolean hasPageWidth() {
        return this.pageWidth > 0;
    }

    public SkinInfo getSkin() {
        return this.skin;
    }

    public void setSkin(SkinInfo skin) {
        this.skin = skin;
    }

    public ThumbnailsInfoInfo getThumbnailsInfo() {
        return this.thumbnailsInfo;
    }

    public void setThumbnailsInfo(ThumbnailsInfoInfo thumbnailsSize) {
        this.thumbnailsInfo = thumbnailsSize;
    }

    public ArrangementInfo getArrangement() {
        return this.arrangement;
    }

    public void setArrangement(ArrangementInfo agencement) {
        this.arrangement = agencement;
    }

    public void unsetPageDecoration(PageDecorationInfo deco) {
        if (deco.getDecorationType().equals("Header")) {
            this.header = null;
        } else if (deco.getDecorationType().equals("Left Margin")) {
            this.leftMargin = null;
        } else if (deco.getDecorationType().equals("Right Margin")) {
            this.rightMargin = null;
        } else if (deco.getDecorationType().equals("Footer")) {
            this.footer = null;
        }
    }

    public void setPageDecoration(PageDecorationInfo deco) {
        if (deco.getDecorationType().equals("Header")) {
            this.header = deco;
        } else if (deco.getDecorationType().equals("Left Margin")) {
            this.leftMargin = deco;
        } else if (deco.getDecorationType().equals("Right Margin")) {
            this.rightMargin = deco;
        } else if (deco.getDecorationType().equals("Footer")) {
            this.footer = deco;
        }
    }

    public PageDecorationInfo getFooter() {
        return this.footer;
    }

    public void setFooter(PageDecorationInfo footer) {
        this.footer = footer;
    }

    public boolean hasFooter() {
        return this.footer != null;
    }

    public PageDecorationInfo getHeader() {
        return this.header;
    }

    public void setHeader(PageDecorationInfo header) {
        this.header = header;
    }

    public boolean hasHeader() {
        return this.header != null;
    }

    public PageDecorationInfo getLeftMargin() {
        return this.leftMargin;
    }

    public void setLeftMargin(PageDecorationInfo leftMargin) {
        this.leftMargin = leftMargin;
    }

    public boolean hasLeftMargin() {
        return this.leftMargin != null;
    }

    public PageDecorationInfo getRightMargin() {
        return this.rightMargin;
    }

    public void setRightMargin(PageDecorationInfo rightMargin) {
        this.rightMargin = rightMargin;
    }

    public boolean hasRightMargin() {
        return this.rightMargin != null;
    }
}

