/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.data.layout;

import org.xissweb.data.layout.Arrangeable;

public class NavigationBarInfo
implements Arrangeable {
    public static final String PREVIOUS = "Previous";
    public static final String BACKWARD = "Backward";
    public static final String INIT = "Init";
    public static final String FORWARD = "Forward";
    public static final String NEXT = "Next";
    public static final String TYPE_BASIC = "basic";
    public static final String TYPE_CIRCULAR = "circular";
    public static final String TYPE_LINKS = "links";
    public static final String TYPE_NEXT = "next";
    public static final String TYPE_PREVIOUS = "previous";
    private String type;
    private String previous = null;
    private String backward = null;
    private String init = null;
    private String forward = null;
    private String next = null;

    public boolean hasWidth() {
        return false;
    }

    public Object clone() {
        NavigationBarInfo nav = new NavigationBarInfo();
        nav.setPrevious(this.hasPrevious());
        nav.setBackward(this.hasBackward());
        nav.setInit(this.hasInit());
        nav.setForward(this.hasForward());
        nav.setNext(this.hasNext());
        nav.setType(this.getType());
        return nav;
    }

    public String toString() {
        return "Navigation Bar";
    }

    public void setNavigationElement(String elt) {
        if (elt.equals(BACKWARD)) {
            this.setBackward(true);
        } else if (elt.equals(FORWARD)) {
            this.setForward(true);
        } else if (elt.equals(PREVIOUS)) {
            this.setPrevious(true);
        } else if (elt.equals(NEXT)) {
            this.setNext(true);
        } else if (elt.equals(INIT)) {
            this.setInit(true);
        }
    }

    public void unsetNavigationElement(String elt) {
        if (elt.equals(BACKWARD)) {
            this.setBackward(false);
        } else if (elt.equals(FORWARD)) {
            this.setForward(false);
        } else if (elt.equals(PREVIOUS)) {
            this.setPrevious(false);
        } else if (elt.equals(NEXT)) {
            this.setNext(false);
        } else if (elt.equals(INIT)) {
            this.setInit(false);
        }
    }

    public boolean hasBackward() {
        return this.backward != null;
    }

    public void setBackward(boolean backward) {
        this.backward = backward ? BACKWARD : null;
    }

    public boolean hasForward() {
        return this.forward != null;
    }

    public void setForward(boolean foreward) {
        this.forward = foreward ? FORWARD : null;
    }

    public boolean hasInit() {
        return this.init != null;
    }

    public void setInit(boolean init) {
        this.init = init ? INIT : null;
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public void setNext(boolean next) {
        this.next = next ? NEXT : null;
    }

    public boolean hasPrevious() {
        return this.previous != null;
    }

    public void setPrevious(boolean previous) {
        this.previous = previous ? PREVIOUS : null;
    }

    public String getType() {
        if (this.type == null) {
            this.type = TYPE_BASIC;
        }
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }
}

