/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.prefs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PreferencesManager {
    private static final String PREFERENCES_ROOT_ELEMENT = "root-preferences";
    private static final String PREFERENCES_ROOT_KIND_ATTR = "kind";
    private static final String CONFIGURABLE_ELEMENT = "configurable";
    private static final String CONFIGURABLE_ID_ATTR = "id";
    private static final String ENTRY_ELEMENT = "entry";
    private static final String ENTRY_KEY_ATTR = "key";
    private static final String ENTRY_VALUE_ATTR = "value";
    Document prefsDoc;
    private String kind;
    private File file;

    public PreferencesManager() {
        this(null, null);
    }

    public PreferencesManager(String kind) {
        this(kind, null);
    }

    public PreferencesManager(File f) {
        this(null, f);
    }

    private PreferencesManager(String kind, File f) {
        this.kind = kind;
        this.file = f;
    }

    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
        if (this.prefsDoc != null) {
            if (this.kind != null) {
                this.prefsDoc.getDocumentElement().setAttribute(PREFERENCES_ROOT_KIND_ATTR, this.kind);
            } else {
                this.prefsDoc.getDocumentElement().removeAttribute(PREFERENCES_ROOT_KIND_ATTR);
            }
        }
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    Document getPrefsDoc() {
        if (this.prefsDoc == null) {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
                this.prefsDoc = docBuilder.newDocument();
                Element e = this.prefsDoc.createElement(PREFERENCES_ROOT_ELEMENT);
                if (this.kind != null) {
                    e.setAttribute(PREFERENCES_ROOT_KIND_ATTR, this.kind);
                }
                this.prefsDoc.appendChild(e);
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
        }
        return this.prefsDoc;
    }

    Element getConfigurableElement(String category) {
        if (this.prefsDoc != null) {
            NodeList list = this.prefsDoc.getDocumentElement().getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                Element e;
                if (!(list.item(i) instanceof Element) || !(e = (Element)list.item(i)).getAttribute(CONFIGURABLE_ID_ATTR).equals(category)) continue;
                return e;
            }
        }
        return null;
    }

    Element getEntryElement(String key, String category) {
        Element e = this.getConfigurableElement(category);
        if (e != null) {
            return this.getEntryElement(key, e);
        }
        return null;
    }

    Element getEntryElement(String key, Element e) {
        NodeList list = e.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Element item;
            if (!(list.item(i) instanceof Element) || !(item = (Element)list.item(i)).getAttribute(ENTRY_KEY_ATTR).equals(key)) continue;
            return item;
        }
        return null;
    }

    public String get(String key, String category, String defaultValue) {
        Element e = this.getEntryElement(key, category);
        if (e != null) {
            return e.getAttribute(ENTRY_VALUE_ATTR);
        }
        return defaultValue;
    }

    public String get(String key, Class configurable, String defaultValue) {
        return this.get(key, configurable.getName(), defaultValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String key, String category, String value) {
        Element e = this.getConfigurableElement(category);
        PreferencesManager preferencesManager = this;
        synchronized (preferencesManager) {
            if (e == null) {
                e = this.getPrefsDoc().createElement(CONFIGURABLE_ELEMENT);
                e.setAttribute(CONFIGURABLE_ID_ATTR, category);
                this.prefsDoc.getDocumentElement().appendChild(e);
                Element entry = this.prefsDoc.createElement(ENTRY_ELEMENT);
                entry.setAttribute(ENTRY_KEY_ATTR, key);
                entry.setAttribute(ENTRY_VALUE_ATTR, value);
                PreferencesManager preferencesManager2 = this;
                synchronized (preferencesManager2) {
                    e.appendChild(entry);
                }
            }
            Element entry = this.getEntryElement(key, e);
            if (entry == null) {
                entry = this.prefsDoc.createElement(ENTRY_ELEMENT);
                PreferencesManager preferencesManager3 = this;
                synchronized (preferencesManager3) {
                    e.appendChild(entry);
                }
            }
            entry.setAttribute(ENTRY_KEY_ATTR, key);
            entry.setAttribute(ENTRY_VALUE_ATTR, value);
        }
    }

    public void put(String key, Class configurable, String value) {
        this.put(key, configurable.getName(), value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String key, String category) {
        Element e = this.getEntryElement(key, category);
        if (e != null) {
            Node n = e.getParentNode();
            PreferencesManager preferencesManager = this;
            synchronized (preferencesManager) {
                n.removeChild(e);
            }
        }
    }

    public void remove(String key, Class configurable) {
        this.remove(key, configurable.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String category) {
        Element e = this.getConfigurableElement(category);
        if (e != null) {
            Node n = e.getParentNode();
            PreferencesManager preferencesManager = this;
            synchronized (preferencesManager) {
                n.removeChild(e);
            }
        }
    }

    public void remove(Class configurable) {
        this.remove(configurable.getName());
    }

    public int getInt(String key, String category, int defaultValue) {
        String sValue = this.get(key, category, null);
        if (sValue != null) {
            return Integer.parseInt(sValue);
        }
        return defaultValue;
    }

    public int getInt(String key, Class configurable, int defaultValue) {
        return this.getInt(key, configurable.getName(), defaultValue);
    }

    public double getDouble(String key, String category, double defaultValue) {
        String sValue = this.get(key, category, null);
        if (sValue != null) {
            return Double.parseDouble(sValue);
        }
        return defaultValue;
    }

    public double getDouble(String key, Class configurable, double defaultValue) {
        return this.getDouble(key, configurable.getName(), defaultValue);
    }

    public float getFloat(String key, String category, float defaultValue) {
        String sValue = this.get(key, category, null);
        if (sValue != null) {
            return Float.parseFloat(sValue);
        }
        return defaultValue;
    }

    public float getFloat(String key, Class configurable, float defaultValue) {
        return this.getFloat(key, configurable.getName(), defaultValue);
    }

    public boolean getBoolean(String key, String category, boolean defaultValue) {
        String sValue = this.get(key, category, null);
        if (sValue != null) {
            return sValue.equals("true");
        }
        return defaultValue;
    }

    public boolean getBoolean(String key, Class configurable, boolean defaultValue) {
        return this.getBoolean(key, configurable.getName(), defaultValue);
    }

    public void putInt(String key, String category, int value) {
        this.put(key, category, Integer.toString(value));
    }

    public void putInt(String key, Class configurable, int value) {
        this.put(key, configurable, Integer.toString(value));
    }

    public void putDouble(String key, String category, double value) {
        this.put(key, category, Double.toString(value));
    }

    public void putDouble(String key, Class configurable, double value) {
        this.put(key, configurable, Double.toString(value));
    }

    public void putFloat(String key, String category, float value) {
        this.put(key, category, Float.toString(value));
    }

    public void putFloat(String key, Class configurable, float value) {
        this.put(key, configurable, Float.toString(value));
    }

    public void putBoolean(String key, String category, boolean value) {
        this.put(key, category, Boolean.toString(value));
    }

    public void putBoolean(String key, Class configurable, boolean value) {
        this.put(key, configurable.getName(), Boolean.toString(value));
    }

    public void load() throws IOException {
        this.load(this.file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(File f) throws IOException {
        InputStream in = null;
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            in = new FileInputStream(f);
            this.prefsDoc = docBuilder.parse(in);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public void store() throws IOException {
        this.store(this.file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(File f) throws IOException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        OutputStream out = null;
        try {
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(this.getPrefsDoc());
            out = new FileOutputStream(f);
            StreamResult result = new StreamResult(out);
            transformer.transform(source, result);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }
}

