/*
 * Decompiled with CFR 0.152.
 */
package xnap.util;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;
import xnap.io.Repository;
import xnap.io.ResumeRepository;
import xnap.io.ThrottledInputStream;
import xnap.io.ThrottledOutputStream;
import xnap.net.ProxySupport;
import xnap.user.UserManager;
import xnap.util.Debug;
import xnap.util.DownloadQueue;
import xnap.util.Preferences;
import xnap.util.SearchManager;
import xnap.util.UploadQueue;
import xnap.util.VersionParser;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Updater
implements PropertyChangeListener {
    private static Updater singleton = new Updater();
    private static boolean zigaDllLoaded = false;
    private static Logger logger;
    private Preferences prefs;
    static /* synthetic */ Class class$xnap$util$Updater;

    public static synchronized void start() {
        singleton.init();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        logger.debug("Preferences.propertyChange: " + string + ' ' + propertyChangeEvent.getOldValue() + " -> " + propertyChangeEvent.getNewValue());
        if (string.equals("useSocksProxy") || string.equals("socksProxyHost") || string.equals("socksProxyPort")) {
            this.updateSocksProxy();
        } else if (string.equals("useHttpProxy") || string.equals("httpProxyHost") || string.equals("httpProxyPort")) {
            this.updateHttpProxy();
        } else if (string.equals("downloadThrottle") || string.equals("uploadThrottle") || string.equals("throttleDownloads") || string.equals("throttleUploads")) {
            this.updateThrottle();
        }
    }

    private final void init() {
        this.updateSocksProxy();
        this.updateHttpProxy();
        this.updateThrottle();
        Repository.getInstance();
        ResumeRepository.getInstance();
        UserManager.getInstance();
        this.prefs.addPropertyChangeListener(this);
        DownloadQueue.getInstance();
        UploadQueue.getInstance();
        SearchManager.getInstance();
        int n = Preferences.getInstance().getUpdaterInterval() * 1000;
        Timer timer = new Timer();
        timer.schedule((TimerTask)new UpdateTask(), n, (long)n);
    }

    public static boolean hasMacOSXModalDialogBug() {
        if (Updater.isMacOSX()) {
            String string = System.getProperty("os.version", "");
            boolean bl = false;
            if (VersionParser.compare(string, "10.2.0") < 0) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public static boolean hasMacOSXToolTipsBug() {
        if (Updater.isMacOSX()) {
            String string = System.getProperty("java.version", "");
            boolean bl = false;
            if (VersionParser.compare(string, "1.4.0") < 0) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public static boolean isMacOSX() {
        return "Mac OS X".equals(System.getProperty("os.name"));
    }

    public static boolean isZigaDllLoaded() {
        return zigaDllLoaded;
    }

    private final void updateHttpProxy() {
        ProxySupport.removeHttp();
        if (this.prefs.getUseHttpProxy()) {
            ProxySupport.putHttp(this.prefs.getHttpProxyHost(), this.prefs.getHttpProxyPort());
        }
    }

    private final void updateSocksProxy() {
        ProxySupport.removeSocks();
        if (this.prefs.getUseSocksProxy()) {
            ProxySupport.putSocks(this.prefs.getSocksProxyHost(), this.prefs.getSocksProxyPort());
        }
    }

    private final void updateThrottle() {
        boolean bl = this.prefs.getThrottleDownloads();
        long l = this.prefs.getDownloadThrottle() * 1024;
        ThrottledInputStream.setBandwidth(bl ? l : 0L);
        bl = this.prefs.getThrottleUploads();
        l = this.prefs.getUploadThrottle() * 1024;
        ThrottledOutputStream.setBandwidth(bl ? l : 0L);
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.prefs = Preferences.getInstance();
    }

    private Updater() {
        this.this();
    }

    static {
        Class clazz = class$xnap$util$Updater;
        if (clazz == null) {
            clazz = class$xnap$util$Updater = Updater.class$("[Lxnap.util.Updater;", false);
        }
        logger = Logger.getLogger(clazz);
        if (Preferences.isWindowsOS) {
            try {
                System.loadLibrary("ziga");
                zigaDllLoaded = true;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                logger.warn("could not load ziga.dll", unsatisfiedLinkError);
            }
        }
    }

    private class UpdateTask
    extends TimerTask {
        public void run() {
            Debug.log("Updater: running update");
            Repository.getInstance().updateLater();
        }

        private UpdateTask() {
        }
    }
}

