/*
 * Decompiled with CFR 0.152.
 */
package xnap.plugin.nap.net;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import xnap.net.AbstractSearch;
import xnap.plugin.nap.net.SearchResult;
import xnap.plugin.nap.net.Server;
import xnap.plugin.nap.net.User;
import xnap.plugin.nap.net.msg.ExceptionListener;
import xnap.plugin.nap.net.msg.MessageHandler;
import xnap.plugin.nap.net.msg.client.SearchRequestMessage;
import xnap.plugin.nap.net.msg.server.SearchResponseMessage;
import xnap.util.Debug;
import xnap.util.SearchFilter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Search
extends AbstractSearch
implements ExceptionListener {
    protected LinkedList results;
    protected Server server;
    protected String failedMsg;
    protected SearchRequestMessage requestMsg;
    protected LinkedList peers;
    protected Object peerLock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void add(SearchResponseMessage searchResponseMessage) {
        User user = this.server.getUser(searchResponseMessage.nick);
        SearchResult searchResult = new SearchResult(searchResponseMessage.filesize, searchResponseMessage.bitrate, searchResponseMessage.frequency, searchResponseMessage.length, user, searchResponseMessage.filename, searchResponseMessage.md5);
        this.results.add(searchResult);
        this.add(searchResult);
        Object object = this.peerLock;
        synchronized (object) {
            Iterator iterator = this.peers.iterator();
            while (iterator.hasNext()) {
                ((Search)iterator.next()).add(searchResponseMessage);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void addPeer(Search search) {
        Object object = this.peerLock;
        synchronized (object) {
            this.peers.add(search);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void failed(String string) {
        this.failedMsg = string;
        Object object = this.peerLock;
        synchronized (object) {
            Iterator iterator = this.peers.iterator();
            while (iterator.hasNext()) {
                ((Search)iterator.next()).failed(string);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void finished() {
        this.finished = true;
        Object object = this.peerLock;
        synchronized (object) {
            Iterator iterator = this.peers.iterator();
            while (iterator.hasNext()) {
                ((Search)iterator.next()).finished();
            }
            return;
        }
    }

    public Server getServer() {
        return this.server;
    }

    void start() {
        this.requestMsg.setExceptionListener(this);
        MessageHandler.send(this.server, this.requestMsg);
    }

    public synchronized int available() throws IOException {
        if (this.failedMsg != null) {
            throw new IOException(this.failedMsg);
        }
        return super.available();
    }

    public void close() {
        if (!this.finished) {
            Debug.log("nap search: aborted");
            this.server.removeSearch(this);
        }
        this.finished = true;
    }

    public void connect() throws IOException {
        this.server.addSearch(this);
    }

    public void exceptionThrown(Exception exception) {
        this.failed(exception.getMessage());
    }

    public LinkedList getResults() {
        return this.results;
    }

    public String getRequest() {
        return this.requestMsg.getData(this.server.getVersion());
    }

    public boolean equals(Object object) {
        if (object instanceof Search) {
            Search search = (Search)object;
            boolean bl = false;
            if (this.getRequest().equals(search.getRequest()) && this.getServer().equals(search.getServer())) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    private final /* synthetic */ void this() {
        this.results = new LinkedList();
        this.failedMsg = null;
        this.peers = new LinkedList();
        this.peerLock = new Object();
    }

    public Search(SearchFilter searchFilter, int n, int n2, Server server) {
        super(searchFilter, n, n2);
        this.this();
        this.server = server;
        this.requestMsg = new SearchRequestMessage(searchFilter, n2);
    }
}

