/*
 * Decompiled with CFR 0.152.
 */
package xnap.net;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import xnap.XNap;
import xnap.io.ResumeFile3;
import xnap.net.AbstractTransferContainer;
import xnap.net.IDownload;
import xnap.net.IDownloadContainer;
import xnap.net.IUser;
import xnap.net.UserContainer;
import xnap.util.FileHelper;
import xnap.util.FiniteStateMachine;
import xnap.util.Preferences;
import xnap.util.SearchFilterData;
import xnap.util.State;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MultiDownload
extends AbstractTransferContainer
implements IDownloadContainer {
    public static final String XNAP3_RESUME_FILENAME_PREFIX = ".xnap-openap-resume";
    public static final int WAKEUP_INTERVAL = 30000;
    public static final int MAX_TRIES = Preferences.getInstance().getDownloadMaxTries();
    private static Hashtable stateTable = new Hashtable();
    private LinkedList dlQueue;
    private LinkedList runQueue;
    private UserContainer users;
    private HashSet queued;
    private IDownload download;
    private ResumeFile3 resumeFile;
    private Object lock;
    private int maxDownloads;
    private long offset;
    private FileOutputStream out;
    private long nextWakeUp;
    private File xnap3ResumeFile;
    private FiniteStateMachine fsm;

    public void die() {
        this.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean add(IDownload iDownload) {
        if (iDownload == null) {
            return false;
        }
        if (iDownload.getUser().getMaxDownloads() == 0) {
            logger.debug("not adding because is blocked: " + iDownload);
            return false;
        }
        Object object = this.lock;
        synchronized (object) {
            if (!this.dlQueue.contains(iDownload) && !this.runQueue.contains(iDownload) && iDownload.getTryCount() < MAX_TRIES) {
                logger.debug("add " + this.file.getName());
                this.dlQueue.addLast(iDownload);
                this.users.add(iDownload.getUser());
                this.wakeup();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.dlQueue.clear();
            this.runQueue.clear();
            this.users.clear();
            return;
        }
    }

    public void delete() {
        super.delete();
        if (this.xnap3ResumeFile != null && this.xnap3ResumeFile.exists()) {
            this.xnap3ResumeFile.delete();
            this.xnap3ResumeFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start(IDownload iDownload) {
        Object object = this.lock;
        synchronized (object) {
            this.dlQueue.remove(iDownload);
            this.runQueue.addLast(iDownload);
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl7 : MonitorExitStatement: MONITOREXIT : var2_2
            this.wakeup();
            return;
        }
    }

    public void setQueuePos(IDownload iDownload, int n) {
        if (n <= 0) {
            this.queued.remove(iDownload);
        } else {
            logger.debug(this + " queued " + iDownload + " at pos " + n);
            this.queued.add(iDownload);
            this.wakeup();
        }
    }

    public void setFile(File file) {
        if (this.resumeFile != null) {
            this.resumeFile = new ResumeFile3(file, this.resumeFile.getFinalSize(), this.resumeFile.getFilterData());
            super.setFile(this.resumeFile);
        } else {
            super.setFile(file);
        }
    }

    public String getFilename() {
        return this.resumeFile != null ? this.resumeFile.getFinalFilename() : "";
    }

    public long getFilesize() {
        return this.resumeFile != null ? this.resumeFile.getFinalSize() : (long)-1;
    }

    public ResumeFile3 getResumeFile() {
        return this.resumeFile;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setResumeFile(ResumeFile3 resumeFile3) {
        this.setFile(resumeFile3);
        this.resumeFile = resumeFile3;
        this.totalBytesTransferred = this.resumeFile.length();
        this.xnap3ResumeFile = new File(Preferences.getInstance().getIncompleteDir() + ".xnap-openap-resume." + resumeFile3.getName() + ".xnap2");
        if (this.xnap3ResumeFile.exists()) return;
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.xnap3ResumeFile));
            try {
                Properties properties = new Properties();
                properties.setProperty("filename", resumeFile3.getFinalFilename());
                properties.setProperty("filesize", "" + resumeFile3.getFinalSize());
                SearchFilterData searchFilterData = resumeFile3.getFilterData();
                if (searchFilterData != null && searchFilterData.searchText != null) {
                    properties.setProperty("searchText", searchFilterData.searchText);
                }
                properties.setProperty("segment.0.filename", resumeFile3.getAbsolutePath());
                properties.setProperty("segment.0.start", "0");
                properties.setProperty("segment.0.mergeFailCount", "0");
                properties.store(bufferedOutputStream, "Automatically generated XNap 2.5 OpenNap resume file - do not modify");
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                try {
                    ((OutputStream)bufferedOutputStream).close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            {
                Object var4_8 = null;
                try {}
                catch (IOException iOException) {
                    return;
                }
                ((OutputStream)bufferedOutputStream).close();
                return;
            }
        }
        catch (IOException iOException) {
            logger.warn("Could not write XNap 3 resume file", iOException);
        }
    }

    public long getTotalBytesTransferred() {
        return this.totalBytesTransferred;
    }

    public IUser getUser() {
        this.users.show(this.download != null ? this.download.getUser() : null);
        return this.users;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getQueueSize() {
        Object object = this.lock;
        synchronized (object) {
            return this.dlQueue.size() + this.runQueue.size();
        }
    }

    public String getStatusText() {
        long l;
        if (this.getStatus() == 11 && (l = (this.nextWakeUp - System.currentTimeMillis()) / 1000L) > 0L) {
            return MessageFormat.format(XNap.tr("retrying in {0} s"), new Long(l));
        }
        return super.getStatusText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isBusy() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            if (this.runQueue.size() <= 0) return bl;
            return true;
        }
    }

    public boolean isFinished() {
        boolean bl = false;
        if (this.totalBytesTransferred == this.getFilesize()) {
            bl = true;
        }
        return bl;
    }

    public void merge(MultiDownload multiDownload) {
        Iterator iterator = multiDownload.dlQueue.iterator();
        while (iterator.hasNext()) {
            this.add((IDownload)iterator.next());
        }
        multiDownload.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void remove(IDownload iDownload) {
        iDownload.dequeue();
        this.queued.remove(iDownload);
        Object object = this.lock;
        synchronized (object) {
            this.dlQueue.remove(iDownload);
            this.users.remove(iDownload.getUser());
        }
        logger.debug("removed download: " + iDownload);
        this.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void reset() {
        Object object = this.lock;
        synchronized (object) {
            Iterator iterator = this.dlQueue.iterator();
            while (iterator.hasNext()) {
                IDownload iDownload = (IDownload)iterator.next();
                iDownload.reset();
            }
            return;
        }
    }

    public void skip() {
        if (this.download != null) {
            this.download.close();
        }
    }

    public void run() {
        if (this.resumeFile.length() < this.resumeFile.getFinalSize()) {
            FileHelper.shorten(this.resumeFile, 1L);
            this.totalBytesTransferred = this.resumeFile.length();
        }
        try {
            this.out = new FileOutputStream(this.file.getAbsolutePath(), true);
        }
        catch (IOException iOException) {
            this.setStatus(7, "Could not write file " + this.file.getName());
            return;
        }
        this.download();
        try {
            this.out.flush();
            this.out.close();
            if (!this.die) {
                if (this.isFinished()) {
                    try {
                        String string = FileHelper.getDownloadDirFromExtension(this.resumeFile.getFinalFilename());
                        File file = FileHelper.moveUnique(this.file, string, this.resumeFile.getFinalFilename());
                        this.setFile(file);
                        if (this.xnap3ResumeFile != null && this.xnap3ResumeFile.exists()) {
                            this.xnap3ResumeFile.delete();
                            this.xnap3ResumeFile = null;
                        }
                        this.setStatus(6);
                    }
                    catch (IOException iOException) {
                        logger.debug("could not rename finished file", iOException);
                        this.setStatus(7, XNap.tr("Could not create file (check download dir)"));
                    }
                } else {
                    this.setStatus(7, XNap.tr("incomplete"));
                }
            }
        }
        catch (IOException iOException) {
            this.setStatus(7, XNap.tr("Could not close file"));
        }
        this.died();
    }

    public String toString() {
        return "MultiDownload " + this.getFilename();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private final void download() {
        while (!this.die && !this.isFinished()) {
            var1_1 = 0L;
            var3_2 = this.lock;
            // MONITORENTER : var3_2
            var5_4 = this.dlQueue.iterator();
            while (true) {
                block22: {
                    if (var5_4.hasNext()) break block22;
                    // MONITOREXIT : var3_2
                    if (!this.die && !this.isFinished()) {
                        this.waitForAdd(var1_1);
                    }
                    var5_3 = false;
                    if (true) ** GOTO lbl62
                }
                var6_5 = (IDownload)var5_4.next();
                if (this.canStart((IDownload)var6_5)) {
                    var6_5.enqueue(this);
                } else {
                    var7_6 = System.currentTimeMillis() - var6_5.getLastTry();
                    var1_1 = Math.max(var1_1, var7_6);
                }
                this.setQueuePos((IDownload)var6_5, var6_5.getQueuePos());
            }
            do {
                block21: {
                    block20: {
                        var6_5 = this.lock;
                        // MONITORENTER : var6_5
                        {
                            if (this.runQueue.size() == 0) {
                                var5_3 = true;
                            } else {
                                this.download = (IDownload)this.runQueue.getFirst();
                                MultiDownload.logger.debug("MultiDownload: start " + this.download);
                            }
                            // MONITOREXIT : var6_5
                            if (var5_3) continue;
                            this.startDownload();
                        }
                        var8_7 = this.lock;
                        // MONITORENTER : var8_7
                        this.runQueue.removeFirst();
                        // MONITOREXIT : var8_7
                        if (!this.isFinished()) break block20;
                        this.add(this.download);
                        break block21;
                    }
                    var10_8 = this.lock;
                    // MONITORENTER : var10_8
                    this.download = null;
                    // MONITOREXIT : var10_8
                }
                var1_1 = 30000L;
lbl62:
                // 3 sources

            } while (!this.die && !this.isFinished() && !var5_3);
        }
        this.dequeueAll();
        MultiDownload.logger.debug("finished");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void dequeueAll() {
        Object object = this.lock;
        synchronized (object) {
            Iterator iterator = this.dlQueue.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    // MONITOREXIT @DISABLED, blocks:[1, 3, 4] lbl11 : MonitorExitStatement: MONITOREXIT : var1_1
                    this.queued.clear();
                    return;
                }
                IDownload iDownload = (IDownload)iterator.next();
                iDownload.dequeue();
            }
        }
    }

    private final boolean canStart(IDownload iDownload) {
        boolean bl = false;
        if (System.currentTimeMillis() - iDownload.getLastTry() > 30000L) {
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void startDownload() {
        block8: {
            logger.debug("starting download:" + this.download);
            this.totalRate = -1;
            this.offset = Math.max(this.totalBytesTransferred - 100L, 0L);
            this.download.getUser().modifyLocalDownloadCount(1);
            this.setStatus(1);
            try {
                if (this.download.connect(this.offset)) {
                    boolean bl = this.writeFile();
                    this.download.close();
                    this.totalRate = this.getAverageRate();
                    boolean bl2 = false;
                    if (!this.isFinished() && bl) {
                        bl2 = true;
                    }
                    this.stopDownload(bl2);
                    break block8;
                }
                if (this.download.getTryCount() >= MAX_TRIES) {
                    this.remove(this.download);
                    break block8;
                }
                Object object = this.lock;
                synchronized (object) {
                    this.dlQueue.addLast(this.download);
                }
            }
            catch (IOException iOException) {
                this.remove(this.download);
                logger.warn("connect failed: " + iOException.getMessage());
            }
        }
        this.download.getUser().modifyLocalDownloadCount(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void stopDownload(boolean bl) {
        Object object = this.lock;
        synchronized (object) {
            block5: {
                block4: {
                    if (!bl) break block4;
                    if (!this.dlQueue.contains(this.download) && this.download.getTryCount() < MAX_TRIES) {
                        this.dlQueue.addLast(this.download);
                    }
                    break block5;
                }
                this.remove(this.download);
            }
            return;
        }
    }

    public boolean writeFile() {
        this.setStatus(4);
        byte[] byArray = new byte[512];
        this.startTransfer();
        try {
            while (this.offset + this.bytesTransferred < this.getFilesize()) {
                int n;
                long l;
                int n2 = 0;
                long l2 = System.currentTimeMillis();
                while (n2 == 0) {
                    if (this.die) {
                        throw new InterruptedException();
                    }
                    if (System.currentTimeMillis() - l2 > 120000L) {
                        throw new IOException(XNap.tr("socket timeout"));
                    }
                    try {
                        l = this.getFilesize() - this.offset - this.bytesTransferred;
                        n = (int)Math.min(l, (long)byArray.length);
                        n2 = this.download.read(byArray, 0, n);
                    }
                    catch (InterruptedIOException interruptedIOException) {
                        // empty catch block
                    }
                }
                if (n2 != -1) {
                    if (this.offset + this.bytesTransferred < this.totalBytesTransferred) {
                        l = this.totalBytesTransferred - this.bytesTransferred;
                        n = (int)Math.min((long)n2, l - this.offset);
                        if (!this.checkFile(byArray, n)) {
                            logger.warn("resume failed");
                            return false;
                        }
                        if (n < n2) {
                            int n3 = (int)Math.min((long)(n2 - n), this.getFilesize() - this.totalBytesTransferred);
                            this.out.write(byArray, n, n3);
                            this.totalBytesTransferred += (long)n3;
                        }
                    } else {
                        int n4 = (int)Math.min((long)n2, this.getFilesize() - this.totalBytesTransferred);
                        this.out.write(byArray, 0, n4);
                        this.totalBytesTransferred += (long)n4;
                    }
                    this.bytesTransferred += (long)n2;
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            logger.warn("download failed " + iOException.getMessage());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean checkFile(byte[] var1_1, int var2_2) {
        block14: {
            try {
                var3_3 = new RandomAccessFile(this.file, "r");
            }
            catch (IOException var4_4) {
                MultiDownload.logger.debug("file not found");
                return false;
            }
            try {
                var8_6 = new byte[var2_2];
                try {
                    var3_3.seek(this.offset + this.bytesTransferred);
                    var3_3.readFully(var8_6);
                }
                catch (IOException var9_7) {
                    MultiDownload.logger.debug("wrong number of bytes");
                    var6_9 = false;
                    var5_12 = null;
                    try {
                        var3_3.close();
                        return var6_9;
                    }
                    catch (IOException var7_16) {
                        // empty catch block
                    }
                    return var6_9;
                }
                var9_8 = 0;
                while (true) {
                    if (var9_8 >= var2_2) {
                        var6_11 = true;
                        break block14;
                    }
                    if (var1_1[var9_8] != var8_6[var9_8]) {
                        MultiDownload.logger.debug("resume failed at " + (this.offset + this.bytesTransferred + (long)var9_8));
                        var6_10 = false;
                        var5_13 = null;
                        break;
                    }
                    ++var9_8;
                }
            }
            catch (Throwable var4_5) {
                var5_15 = null;
                try {}
                catch (IOException var7_19) {
                    throw var4_5;
                }
                var3_3.close();
                throw var4_5;
            }
            ** try [egrp 3[TRYBLOCK] [6 : 168->175)] { 
lbl48:
            // 1 sources

            var3_3.close();
            return var6_10;
lbl50:
            // 1 sources

            catch (IOException var7_17) {
                // empty catch block
            }
            return var6_10;
        }
        var5_14 = null;
        ** try [egrp 3[TRYBLOCK] [6 : 168->175)] { 
lbl56:
        // 1 sources

        var3_3.close();
        return var6_11;
lbl58:
        // 1 sources

        catch (IOException var7_18) {
            // empty catch block
        }
        return var6_11;
    }

    public boolean equals(Object object) {
        if (object instanceof MultiDownload) {
            MultiDownload multiDownload = (MultiDownload)object;
            if (multiDownload.getResumeFile() == null || this.getResumeFile() == null) {
                boolean bl = false;
                if (this == object) {
                    bl = true;
                }
                return bl;
            }
            boolean bl = false;
            if (multiDownload.getResumeFile().getFinalSize() == this.getResumeFile().getFinalSize() && multiDownload.getResumeFile().getFilterData().searchText.equals(this.getResumeFile().getFilterData().searchText)) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    private final void setWaitStatus(long l) {
        if (this.runQueue.size() == 0) {
            if (this.dlQueue.size() == 0) {
                if (this.getStatus() != 10) {
                    this.setStatus(11);
                }
            } else if (this.queued.size() > 0) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(MessageFormat.format(XNap.tr("{0} queued"), new Integer(this.queued.size())));
                stringBuffer.append(": ");
                Iterator iterator = this.queued.iterator();
                while (iterator.hasNext()) {
                    IDownload iDownload = (IDownload)iterator.next();
                    stringBuffer.append(iDownload.getUser().getName());
                    stringBuffer.append("@");
                    stringBuffer.append(iDownload.getQueuePos());
                    if (!iterator.hasNext()) continue;
                    stringBuffer.append(", ");
                }
                this.nextWakeUp = 0L;
                this.setStatus(11, stringBuffer.toString());
            } else {
                this.nextWakeUp = System.currentTimeMillis() + (30000L - l);
                this.setStatus(11);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void waitForAdd(long l) {
        this.setWaitStatus(l);
        Object object = this.lock;
        synchronized (object) {
            block3: {
                block4: {
                    if (this.runQueue.size() != 0) break block3;
                    if (this.dlQueue.size() != 0) break block4;
                    logger.debug("waiting for add");
                    this.nextWakeUp = 0L;
                    this.waitLock();
                    break block3;
                }
                logger.debug("waiting " + (30000L - l));
                this.waitLock(30000L - l);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void waitLock(long l) {
        if (l <= 0L) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            try {
                this.lock.wait(l);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void waitLock() {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.lock.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void wakeup() {
        Object object = this.lock;
        synchronized (object) {
            this.lock.notify();
            return;
        }
    }

    private final /* synthetic */ void this() {
        this.dlQueue = new LinkedList();
        this.runQueue = new LinkedList();
        this.users = new UserContainer();
        this.queued = new HashSet();
        this.lock = new Object();
        this.nextWakeUp = 0L;
        this.fsm = new FiniteStateMachine(State.NOT_STARTED, stateTable);
    }

    public MultiDownload() {
        this.this();
        this.maxDownloads = 1;
    }

    static {
        State[][] stateArray = new State[][]{{State.CONNECTING, State.ABORTING, State.DOWNLOADING, State.FAILED}, {State.LOCALLY_QUEUED, State.ABORTED, State.CONNECTING}, {State.NOT_STARTED, State.CONNECTING, State.LOCALLY_QUEUED, State.NOT_STARTED}};
        stateTable = FiniteStateMachine.createStateTable(stateArray);
    }
}

