/*
 * Decompiled with CFR 0.152.
 */
package xnap.gui.table;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import xnap.XNap;
import xnap.gui.table.AbstractDynamicTableModel;
import xnap.gui.table.Column;
import xnap.gui.table.FilesizeCellRenderer;
import xnap.gui.table.ProgressCellRenderer;
import xnap.gui.table.StringCellRenderer;
import xnap.gui.table.TimeCellRenderer;
import xnap.gui.util.SwingSynchronizedCache;
import xnap.net.ITransferContainer;
import xnap.net.IUser;
import xnap.net.event.StatusChangeEvent;
import xnap.net.event.StatusChangeListener;
import xnap.util.EventVector;
import xnap.util.Preferences;
import xnap.util.Progress;
import xnap.util.TransferQueue;
import xnap.util.event.ListEvent;
import xnap.util.event.ListListener;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TransferTableModel
extends AbstractDynamicTableModel
implements ListListener,
StatusChangeListener {
    public static final int UPDATE_INTERVAL = 1000;
    public static final int FILENAME = 0;
    public static final int FILESIZE = 1;
    public static final int USER = 2;
    public static final int CLIENT_INFO = 3;
    public static final int STATUS = 4;
    public static final int PROGRESS = 5;
    public static final int TIMELEFT = 6;
    public static final int PARTIAL_FILESIZE = 7;
    public static final int QUEUEPOS = 8;
    private static Timer updateTimer = null;
    protected Column[] columns;
    protected ArrayList rows;
    private TransferQueue queue;
    private boolean updateQueue;
    private String tableName;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$xnap$util$Progress;
    static /* synthetic */ Class class$java$lang$Integer;

    public void elementAdded(ListEvent listEvent) {
        ITransferContainer iTransferContainer = (ITransferContainer)listEvent.getElement();
        iTransferContainer.addStatusChangeListener(this);
        this.rows.add(iTransferContainer);
        this.fireTableRowsInserted(this.rows.size() - 1, this.rows.size() - 1);
    }

    public void elementRemoved(ListEvent listEvent) {
        ITransferContainer iTransferContainer = (ITransferContainer)listEvent.getElement();
        iTransferContainer.removeStatusChangeListener(this);
        int n = this.rows.indexOf(iTransferContainer);
        if (n != -1) {
            this.rows.remove(n);
            this.fireTableRowsDeleted(n, n);
        }
    }

    public TransferQueue getQueue() {
        return this.queue;
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public ITransferContainer get(int n) {
        return (ITransferContainer)this.rows.get(this.mapToIndex(n));
    }

    public Object get(int n, int n2) {
        if (this.rows.get(n) instanceof ITransferContainer) {
            ITransferContainer iTransferContainer = (ITransferContainer)this.rows.get(n);
            if (iTransferContainer == null) {
                return null;
            }
            IUser iUser = iTransferContainer.getUser();
            switch (n2) {
                case 0: {
                    return iTransferContainer.getFilename();
                }
                case 1: {
                    return new Long(iTransferContainer.getFilesize());
                }
                case 2: {
                    return iUser != null ? iUser.getName() : "";
                }
                case 3: {
                    return iUser != null ? iUser.getClientInfo() : "";
                }
                case 4: {
                    return iTransferContainer.getStatusText();
                }
                case 5: {
                    return new Progress(iTransferContainer.getTotalBytesTransferred(), iTransferContainer.getFilesize(), iTransferContainer.getCurrentRate());
                }
                case 6: {
                    long l = iTransferContainer.getAverageRate();
                    if (l <= 0L) {
                        return new Integer(-1);
                    }
                    return new Integer((int)((iTransferContainer.getFilesize() - iTransferContainer.getTotalBytesTransferred()) / l));
                }
                case 7: {
                    return new Long(iTransferContainer.getTotalBytesTransferred());
                }
                case 8: {
                    int n3 = this.getQueue().getLocalQueuePos(iTransferContainer);
                    return n3 >= 0 ? new Integer(n3 + 1) : null;
                }
            }
        }
        return null;
    }

    public String getTableName() {
        return this.tableName;
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public void setUpdateQueue(boolean bl) {
        this.updateQueue = bl;
    }

    public void statusChange(StatusChangeEvent statusChangeEvent) {
        ITransferContainer iTransferContainer = (ITransferContainer)statusChangeEvent.getSource();
        if (statusChangeEvent.getNewStatus() != 4 && statusChangeEvent.getNewStatus() != 5) {
            SwingUtilities.invokeLater(new StatusChangeEventHandler(iTransferContainer));
        }
    }

    public void updateTable() {
        long l = 0L;
        int n = 0;
        while (n < this.rows.size()) {
            ITransferContainer iTransferContainer = (ITransferContainer)this.rows.get(n);
            if (iTransferContainer.getStatus() == 4 || iTransferContainer.getStatus() == 5 || iTransferContainer.getStatus() == 11) {
                this.fireTableRowsUpdated(n, n);
                if (iTransferContainer.getStatus() != 11) {
                    l += iTransferContainer.getCurrentRate();
                }
            }
            ++n;
        }
        if (this.updateQueue) {
            this.getQueue().setCurrentRate(l);
        }
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        Column[] columnArray = new Column[9];
        String string = XNap.tr("Filename");
        Class clazz = class$java$lang$String;
        if (clazz == null) {
            clazz = class$java$lang$String = TransferTableModel.class$("[Ljava.lang.String;", false);
        }
        columnArray[0] = new Column(string, clazz, new StringCellRenderer());
        String string2 = XNap.tr("Size");
        Class clazz2 = class$java$lang$Long;
        if (clazz2 == null) {
            clazz2 = class$java$lang$Long = TransferTableModel.class$("[Ljava.lang.Long;", false);
        }
        columnArray[1] = new Column(string2, clazz2, new FilesizeCellRenderer());
        String string3 = XNap.tr("User");
        Class clazz3 = class$java$lang$String;
        if (clazz3 == null) {
            clazz3 = class$java$lang$String = TransferTableModel.class$("[Ljava.lang.String;", false);
        }
        columnArray[2] = new Column(string3, clazz3);
        String string4 = XNap.tr("Client");
        Class clazz4 = class$java$lang$String;
        if (clazz4 == null) {
            clazz4 = class$java$lang$String = TransferTableModel.class$("[Ljava.lang.String;", false);
        }
        columnArray[3] = new Column(string4, clazz4);
        String string5 = XNap.tr("Status");
        Class clazz5 = class$java$lang$String;
        if (clazz5 == null) {
            clazz5 = class$java$lang$String = TransferTableModel.class$("[Ljava.lang.String;", false);
        }
        columnArray[4] = new Column(string5, clazz5, new StringCellRenderer());
        String string6 = XNap.tr("Progress");
        Class clazz6 = class$xnap$util$Progress;
        if (clazz6 == null) {
            clazz6 = class$xnap$util$Progress = TransferTableModel.class$("[Lxnap.util.Progress;", false);
        }
        columnArray[5] = new Column(string6, clazz6, new ProgressCellRenderer());
        String string7 = XNap.tr("Time Left");
        Class clazz7 = class$java$lang$Integer;
        if (clazz7 == null) {
            clazz7 = class$java$lang$Integer = TransferTableModel.class$("[Ljava.lang.Integer;", false);
        }
        columnArray[6] = new Column(string7, clazz7, new TimeCellRenderer());
        String string8 = XNap.tr("Transfered");
        Class clazz8 = class$java$lang$Long;
        if (clazz8 == null) {
            clazz8 = class$java$lang$Long = TransferTableModel.class$("[Ljava.lang.Long;", false);
        }
        columnArray[7] = new Column(string8, clazz8, new FilesizeCellRenderer());
        String string9 = XNap.tr("Position in Queue");
        Class clazz9 = class$java$lang$Integer;
        if (clazz9 == null) {
            clazz9 = class$java$lang$Integer = TransferTableModel.class$("[Ljava.lang.Integer;", false);
        }
        columnArray[8] = new Column(string9, clazz9);
        this.columns = columnArray;
        this.rows = new ArrayList();
        this.updateQueue = false;
    }

    public TransferTableModel(TransferQueue transferQueue, String string, String string2, EventVector eventVector) {
        super(string, Preferences.getInstance());
        this.this();
        this.queue = transferQueue;
        this.tableName = string2;
        SwingSynchronizedCache swingSynchronizedCache = new SwingSynchronizedCache(this);
        eventVector.addListListener(swingSynchronizedCache);
        this.setColumns(this.columns);
        if (updateTimer == null) {
            updateTimer = new Timer(1000, new Updater());
            updateTimer.start();
        } else {
            updateTimer.addActionListener(new Updater());
        }
    }

    public TransferTableModel(TransferQueue transferQueue, String string, String string2) {
        this(transferQueue, string, string2, transferQueue);
        this.setUpdateQueue(true);
    }

    private class Updater
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            TransferTableModel.this.updateTable();
        }

        private Updater() {
        }
    }

    private class StatusChangeEventHandler
    implements Runnable {
        ITransferContainer item;

        public void run() {
            int n = 0;
            while (n < TransferTableModel.this.rows.size()) {
                if (TransferTableModel.this.rows.get(n).equals(this.item)) {
                    TransferTableModel.this.fireTableRowsUpdated(n, n);
                }
                ++n;
            }
        }

        public StatusChangeEventHandler(ITransferContainer iTransferContainer) {
            this.item = iTransferContainer;
        }
    }
}

