/*
 * Decompiled with CFR 0.152.
 */
package xnap.gui.table;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.table.DefaultTableCellRenderer;
import xnap.gui.util.GUIHelper;
import xnap.util.Formatter;
import xnap.util.Preferences;
import xnap.util.Progress;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ProgressCellRenderer
extends DefaultTableCellRenderer {
    protected double progress;
    protected String text;
    private Preferences prefs;
    private Color runningColor;
    private Color finishedColor;

    protected void setValue(Object object) {
        if (object instanceof Progress) {
            Progress progress = (Progress)object;
            this.progress = progress.progress;
            this.text = progress.toString();
            this.setToolTipText(Formatter.formatNumber(this.progress, 2) + '%' + (this.text.length() == 0 ? "" : ", " + this.text));
        }
        super.setValue(null);
    }

    public void paint(Graphics graphics) {
        int n;
        super.paint(graphics);
        graphics.setColor(Color.black);
        graphics.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        graphics.setColor(Color.lightGray);
        graphics.drawRect(1, 1, this.getWidth() - 2, this.getHeight() - 2);
        if (this.progress > 0.0) {
            int n2 = (this.getWidth() - 2) * (int)this.progress / 100;
            n = this.getHeight() - 2;
            graphics.setColor(this.progress < 100.0 ? this.runningColor : this.finishedColor);
            graphics.fillRect(1, 1, n2, n);
        }
        if (this.text != null && this.text.length() > 0) {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            n = fontMetrics.stringWidth(this.text);
            int n3 = (this.getWidth() - n) / 2;
            int n4 = this.getHeight() - 3;
            graphics.setColor(this.getForeground());
            int n5 = 1;
            if (n3 > 1) {
                n5 = n3;
            }
            graphics.drawString(this.text, n5, n4);
        }
    }

    private final /* synthetic */ void this() {
        this.progress = 0.0;
        this.text = "";
        this.prefs = Preferences.getInstance();
        this.runningColor = GUIHelper.getColor("progressRunning");
        this.finishedColor = GUIHelper.getColor("progressFinished");
    }

    public ProgressCellRenderer() {
        this.this();
    }
}

