/*
 * Decompiled with CFR 0.152.
 */
package xnap.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import xnap.XNap;
import xnap.gui.XNapFrame;
import xnap.gui.tree.FileCellRenderer;
import xnap.gui.tree.FileNode;
import xnap.gui.tree.FileTreeModel;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DirectoryChooser
extends JDialog
implements TreeSelectionListener {
    public static final int APPROVE_OPTION = 1;
    public static final int CANCEL_OPTION = 2;
    private OkayAction acOkay;
    private JTree jtDirectories;
    private FileTreeModel dtmDirectories;
    private File selectedDirectory;

    public File getSelectedDirectory() {
        return this.selectedDirectory;
    }

    public void setSelectedDirectory(File file) {
        LinkedList<FileNode> linkedList = new LinkedList<FileNode>();
        File file2 = file;
        while (file2 != null) {
            linkedList.addFirst(new FileNode(file2));
            file2 = file2.getParentFile();
        }
        Object[] objectArray = new Object[linkedList.size() + 1];
        objectArray[0] = this.dtmDirectories.getRoot();
        System.arraycopy(linkedList.toArray(), 0, objectArray, 1, objectArray.length - 1);
        TreePath treePath = new TreePath(objectArray);
        this.jtDirectories.setSelectionPath(treePath);
        this.jtDirectories.scrollPathToVisible(treePath);
    }

    public int showChooseDialog(Component component) {
        if (component != null) {
            this.setLocationRelativeTo(component);
        }
        this.setTitle(XNap.tr("Choose directory"));
        this.setModal(true);
        this.pack();
        this.show();
        int n = 0;
        if (this.selectedDirectory == null) {
            n = 1;
        }
        return n + 1;
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.acOkay.setEnabled(this.jtDirectories.getLastSelectedPathComponent() instanceof File);
    }

    static /* synthetic */ File access$1(DirectoryChooser directoryChooser) {
        return directoryChooser.selectedDirectory;
    }

    private final /* synthetic */ void this() {
        this.acOkay = new OkayAction();
        this.selectedDirectory = null;
    }

    public DirectoryChooser() {
        this.this();
        this.dtmDirectories = new FileTreeModel(XNap.tr("Directories"), File.listRoots());
        this.jtDirectories = new JTree(this.dtmDirectories);
        this.jtDirectories.setRootVisible(false);
        this.jtDirectories.setCellRenderer(new FileCellRenderer());
        this.jtDirectories.putClientProperty("JTree.lineStyle", "Angled");
        this.jtDirectories.addTreeSelectionListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.jtDirectories);
        JPanel jPanel = new JPanel(new FlowLayout(2));
        JButton jButton = new JButton(new HomeAction());
        jPanel.add(jButton);
        JButton jButton2 = new JButton(this.acOkay);
        jPanel.add(jButton2);
        JButton jButton3 = new JButton(new CancelAction());
        jPanel.add(jButton3);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jScrollPane, "Center");
        this.getContentPane().add((Component)jPanel, "South");
        this.pack();
    }

    public class HomeAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            DirectoryChooser.this.setSelectedDirectory(new File(System.getProperty("user.home")));
        }

        public HomeAction() {
            this.putValue("Name", XNap.tr("home"));
            this.putValue("SmallIcon", XNapFrame.getIcon("gohome.png"));
            this.putValue("ShortDescription", XNap.tr("Jump to home directory"));
            this.putValue("MnemonicKey", new Integer(72));
        }
    }

    public class OkayAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = DirectoryChooser.this.jtDirectories.getLastSelectedPathComponent();
            if (object instanceof File) {
                DirectoryChooser.this.selectedDirectory = (File)object;
                DirectoryChooser.this.dispose();
            }
        }

        public OkayAction() {
            this.putValue("Name", XNap.tr("OK"));
            this.putValue("ShortDescription", XNap.tr("Close dialog selecting directory"));
            this.putValue("MnemonicKey", new Integer(79));
            this.setEnabled(false);
        }
    }

    public class CancelAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            DirectoryChooser.this.selectedDirectory = null;
            DirectoryChooser.this.dispose();
        }

        public CancelAction() {
            this.putValue("Name", XNap.tr("Cancel"));
            this.putValue("ShortDescription", XNap.tr("Close dialog discarding changes"));
            this.putValue("MnemonicKey", new Integer(67));
        }
    }
}

