/*
 * Decompiled with CFR 0.152.
 */
package xnap;

import gnu.getopt.Getopt;
import java.io.File;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.log4j.Level;
import xnap.cmdl.CommandLine;
import xnap.gui.SplashWindow;
import xnap.gui.XNapFrame;
import xnap.util.Debug;
import xnap.util.FileHelper;
import xnap.util.JarClassLoader;
import xnap.util.Preferences;
import xnap.util.VersionParser;

public class XNap {
    public static final long RELEASE_NR = 2004071401L;
    public static final String VERSION = "2.5r3";
    public static final String REQUIRED_CMDL_JDK = "1.2.0";
    public static final String REQUIRED_GUI_JDK = "1.3.0";
    public static final Locale[] LANGUAGES = new Locale[]{Locale.CHINESE, Locale.ENGLISH, Locale.FRENCH, Locale.GERMAN, Locale.ITALIAN, Locale.JAPANESE, new Locale("nl", "", ""), new Locale("es", "", "")};
    private static ResourceBundle resources;

    public static void main(String[] stringArray) {
        Object object;
        Object object2;
        int n;
        Level level = Level.OFF;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = true;
        Getopt getopt = new Getopt("xnap", stringArray, "cd::hnv");
        while ((n = getopt.getopt()) != -1) {
            switch (n) {
                case 99: {
                    bl2 = true;
                    break;
                }
                case 100: {
                    bl = true;
                    object2 = getopt.getOptarg();
                    level = object2 != null ? Level.toLevel((String)object2) : Level.ALL;
                    break;
                }
                case 104: {
                    bl3 = true;
                    break;
                }
                case 110: {
                    bl4 = false;
                    break;
                }
                case 118: {
                    System.out.println(VERSION);
                    System.exit(0);
                    break;
                }
                case 63: {
                    System.exit(1);
                }
            }
        }
        object2 = new File(FileHelper.getHomeDir() + "debug.prefs");
        Debug.init((File)object2, level);
        if (!bl) {
            object = new File(FileHelper.getHomeDir() + "error.log");
            Debug.setErrorFile((File)object);
        }
        object = Preferences.getInstance();
        ((Preferences)object).read();
        XNap.initLocale(((Preferences)object).getLanguage());
        if (bl3) {
            XNap.showHelp();
            System.exit(0);
        } else if (bl2) {
            if (bl4) {
                XNap.checkJDK(REQUIRED_CMDL_JDK);
            }
            XNap.init();
            CommandLine commandLine = new CommandLine(stringArray);
            commandLine.run();
        } else {
            if (bl4) {
                XNap.checkJDK(REQUIRED_GUI_JDK);
            }
            XNap.init();
            if (((Preferences)object).getShowSplash()) {
                SplashWindow.showSplashWindow();
            }
            XNapFrame xNapFrame = new XNapFrame();
            xNapFrame.setVisible(true);
            if (((Preferences)object).getShowSplash()) {
                SplashWindow.closeSplashWindow();
            }
        }
    }

    private static final void init() {
        JarClassLoader.getInstance().init();
    }

    public static void initLocale(String string) {
        int n = 0;
        while (n < LANGUAGES.length) {
            if (string.equals(LANGUAGES[n].getLanguage())) {
                Locale.setDefault(LANGUAGES[n]);
                break;
            }
            ++n;
        }
        try {
            resources = ResourceBundle.getBundle("xnap.resources.XNap", Locale.getDefault());
        }
        catch (MissingResourceException missingResourceException) {
            System.err.println("resources/XNap.properties not found");
            System.exit(1);
        }
    }

    public static final ResourceBundle getMessagesBundle() {
        return resources;
    }

    public static final void checkJDK(String string) {
        String string2 = System.getProperty("java.version");
        if (VersionParser.compare(string2, string) < 0) {
            System.out.println(XNap.tr("Your java version") + "\t: " + string2);
            System.out.println(XNap.tr("Required version") + "\t: " + string);
            System.out.println(XNap.tr("If XNap runs fine, you can safely ignore this message.\n") + XNap.tr("Otherwise you probably need to update your jdk from\nhttp://java.sun.com/products/jdk/1.3/jre/index.html."));
            System.out.println(XNap.tr("See http://xnap.sourceforge.net for more information.\n") + '(' + XNap.tr("use -n to suppress this message") + ")\n");
        }
    }

    public static final void showHelp() {
        System.out.println(XNap.tr("Usage: xnap [options]"));
        System.out.println(" -c\t " + XNap.tr("start in commandline mode"));
        System.out.println(" -d[level]\t " + XNap.tr("show debug messages"));
        System.out.println(" -h\t " + XNap.tr("show this help"));
        System.out.println(" -n\t" + XNap.tr("do not check jdk version"));
    }

    public static final String tr(String string) {
        try {
            return XNap.getMessagesBundle().getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            System.err.println("missing translation key: \"" + string + '\"');
            return string;
        }
    }

    public static final String tr(String string, Object object) {
        return MessageFormat.format(XNap.tr(string), object);
    }

    public static final String tr(String string, int n) {
        String string2 = XNap.tr(string);
        if (n <= 0) {
            return string2;
        }
        StringBuffer stringBuffer = new StringBuffer(string2.length() + n * 2);
        XNap.append(stringBuffer, " ", n);
        stringBuffer.append(string2);
        XNap.append(stringBuffer, " ", n);
        return stringBuffer.toString();
    }

    public static final String tr(String string, int n, int n2) {
        String string2 = XNap.tr(string);
        StringBuffer stringBuffer = new StringBuffer(string2.length() + n + n2);
        XNap.append(stringBuffer, " ", n);
        stringBuffer.append(string2);
        XNap.append(stringBuffer, " ", n2);
        return stringBuffer.toString();
    }

    public static final void append(StringBuffer stringBuffer, String string, int n) {
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(string);
            ++n2;
        }
    }
}

